/*
 * Decompiled with CFR 0.152.
 */
package noobanidus.mods.lootr.entity;

import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import net.minecraft.ChatFormatting;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.monster.piglin.PiglinAi;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.entity.vehicle.AbstractMinecartContainer;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ChestMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.network.NetworkHooks;
import noobanidus.mods.lootr.api.LootrAPI;
import noobanidus.mods.lootr.api.entity.ILootCart;
import noobanidus.mods.lootr.block.LootrChestBlock;
import noobanidus.mods.lootr.config.ConfigManager;
import noobanidus.mods.lootr.init.ModBlocks;
import noobanidus.mods.lootr.init.ModEntities;
import noobanidus.mods.lootr.network.OpenCart;
import noobanidus.mods.lootr.network.PacketHandler;
import noobanidus.mods.lootr.util.ChestUtil;
import org.jetbrains.annotations.Nullable;

public class LootrChestMinecartEntity
extends AbstractMinecartContainer
implements ILootCart {
    private Set<UUID> openers = new HashSet<UUID>();
    private boolean opened = false;
    private static BlockState cartNormal = null;

    public LootrChestMinecartEntity(EntityType<LootrChestMinecartEntity> type, Level world) {
        super(type, world);
    }

    public LootrChestMinecartEntity(Level worldIn, double x, double y, double z) {
        super((EntityType)ModEntities.LOOTR_MINECART_ENTITY.get(), x, y, z, worldIn);
    }

    public void m_219949_(@Nullable Player p_219950_) {
    }

    @Override
    public Set<UUID> getOpeners() {
        return this.openers;
    }

    public void addOpener(Player player) {
        this.openers.add(player.m_20148_());
        this.m_6596_();
    }

    public boolean isOpened() {
        return this.opened;
    }

    public void setOpened() {
        this.opened = true;
    }

    public void setClosed() {
        this.opened = false;
    }

    public boolean m_6673_(DamageSource source) {
        if (this.m_20147_() && source.m_269533_(DamageTypeTags.f_268738_)) {
            return true;
        }
        Entity entity = source.m_7639_();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (player instanceof FakePlayer && ((Boolean)ConfigManager.ENABLE_FAKE_PLAYER_BREAK.get()).booleanValue() || ((Boolean)ConfigManager.ENABLE_BREAK.get()).booleanValue()) {
                return false;
            }
            if ((((Boolean)ConfigManager.DISABLE_BREAK.get()).booleanValue() && player.m_7500_() || !((Boolean)ConfigManager.DISABLE_BREAK.get()).booleanValue()) && source.m_7639_().m_6144_()) {
                return false;
            }
        } else {
            return true;
        }
        ((Player)source.m_7639_()).m_5661_((Component)Component.m_237115_((String)"lootr.message.cart_should_sneak").m_6270_(Style.f_131099_.m_131148_(TextColor.m_131270_((ChatFormatting)ChatFormatting.AQUA))), false);
        ((Player)source.m_7639_()).m_5661_((Component)Component.m_237110_((String)"lootr.message.should_sneak2", (Object[])new Object[]{Component.m_237115_((String)"lootr.message.cart_should_sneak3").m_6270_(Style.f_131099_.m_131136_(Boolean.valueOf(true)))}).m_6270_(Style.f_131099_.m_131148_(TextColor.m_131270_((ChatFormatting)ChatFormatting.AQUA))), false);
        return true;
    }

    public void m_7617_(DamageSource source) {
        this.m_142687_(Entity.RemovalReason.KILLED);
        if (this.f_19853_.m_46469_().m_46207_(GameRules.f_46137_)) {
            ItemStack itemstack = new ItemStack((ItemLike)Items.f_42449_);
            ItemStack itemstack2 = new ItemStack((ItemLike)Items.f_42009_);
            if (this.m_8077_()) {
                itemstack.m_41714_(this.m_7770_());
                itemstack2.m_41714_(this.m_7770_());
            }
            this.m_19983_(itemstack);
            this.m_19983_(itemstack2);
        }
    }

    public int m_6643_() {
        return 27;
    }

    public AbstractMinecart.Type m_6064_() {
        return AbstractMinecart.Type.CHEST;
    }

    public BlockState m_6390_() {
        if (cartNormal == null) {
            cartNormal = (BlockState)((LootrChestBlock)((Object)ModBlocks.CHEST.get())).m_49966_().m_61124_((Property)ChestBlock.f_51478_, (Comparable)Direction.NORTH);
        }
        return cartNormal;
    }

    public int m_7144_() {
        return 8;
    }

    public AbstractContainerMenu m_7402_(int id, Inventory playerInventoryIn) {
        return ChestMenu.m_39237_((int)id, (Inventory)playerInventoryIn, (Container)this);
    }

    public void m_142687_(Entity.RemovalReason reason) {
        this.m_142467_(reason);
        if (reason == Entity.RemovalReason.KILLED) {
            this.m_146850_(GameEvent.f_223707_);
        }
        this.invalidateCaps();
    }

    protected void m_7380_(CompoundTag compound) {
        if (this.f_38204_ != null) {
            compound.m_128359_("LootTable", this.f_38204_.toString());
        }
        compound.m_128356_("LootTableSeed", this.f_38205_);
        ListTag list = new ListTag();
        for (UUID opener : this.openers) {
            list.add((Object)NbtUtils.m_129226_((UUID)opener));
        }
        compound.m_128365_("LootrOpeners", (Tag)list);
        super.m_7380_(compound);
    }

    protected void m_7378_(CompoundTag compound) {
        this.f_38204_ = new ResourceLocation(compound.m_128461_("LootTable"));
        this.f_38205_ = compound.m_128454_("LootTableSeed");
        if (compound.m_128425_("LootrOpeners", 9)) {
            ListTag openers = compound.m_128437_("LootrOpeners", 11);
            this.openers.clear();
            for (Tag item : openers) {
                this.openers.add(NbtUtils.m_129233_((Tag)item));
            }
        }
        super.m_7378_(compound);
    }

    public InteractionResult m_6096_(Player player, InteractionHand hand) {
        InteractionResult ret = InteractionResult.PASS;
        if (ret.m_19077_()) {
            return ret;
        }
        if (player.m_6144_()) {
            ChestUtil.handleLootCartSneak(player.f_19853_, this, player);
            if (!player.f_19853_.f_46443_) {
                return InteractionResult.CONSUME;
            }
            return InteractionResult.SUCCESS;
        }
        ChestUtil.handleLootCart(player.f_19853_, this, player);
        if (!player.f_19853_.f_46443_) {
            PiglinAi.m_34873_((Player)player, (boolean)true);
            return InteractionResult.CONSUME;
        }
        return InteractionResult.SUCCESS;
    }

    public void addLoot(@javax.annotation.Nullable Player player, Container inventory, @javax.annotation.Nullable ResourceLocation overrideTable, long seed) {
        if (this.f_38204_ != null && this.f_19853_.m_7654_() != null) {
            LootTable loottable = this.f_19853_.m_7654_().m_129898_().m_79217_(overrideTable != null ? overrideTable : this.f_38204_);
            if (loottable == LootTable.f_79105_) {
                LootrAPI.LOG.error("Unable to fill loot in " + this.f_19853_.m_46472_() + " at " + this.m_20182_() + " as the loot table '" + (overrideTable != null ? overrideTable : this.f_38204_) + "' couldn't be resolved! Please search the loot table in `latest.log` to see if there are errors in loading.");
                if (((Boolean)ConfigManager.REPORT_UNRESOLVED_TABLES.get()).booleanValue() && player != null) {
                    player.m_5661_((Component)Component.m_237110_((String)"lootr.message.invalid_table", (Object[])new Object[]{(overrideTable != null ? overrideTable : this.f_38204_).toString()}).m_6270_(Style.f_131099_.m_131148_(TextColor.m_131270_((ChatFormatting)ChatFormatting.DARK_RED)).m_131136_(Boolean.valueOf(true))), false);
                }
            }
            if (player instanceof ServerPlayer) {
                CriteriaTriggers.f_10563_.m_54597_((ServerPlayer)player, overrideTable != null ? overrideTable : this.f_38204_);
            }
            LootContext.Builder lootcontext$builder = new LootContext.Builder((ServerLevel)this.f_19853_).m_78972_(LootContextParams.f_81460_, (Object)this.m_20182_()).m_78965_((Boolean)ConfigManager.RANDOMISE_SEED.get() != false ? ThreadLocalRandom.current().nextLong() : (seed == Long.MIN_VALUE ? this.f_38205_ : seed));
            lootcontext$builder.m_78972_(LootContextParams.f_81458_, (Object)this);
            if (player != null) {
                lootcontext$builder.m_78963_(player.m_36336_()).m_78972_(LootContextParams.f_81455_, (Object)player);
            }
            loottable.m_79123_(inventory, lootcontext$builder.m_78975_(LootContextParamSets.f_81411_));
        }
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void m_5856_(Player player) {
        if (!player.m_5833_()) {
            OpenCart cart = new OpenCart(this.m_19879_());
            PacketHandler.sendToInternal(cart, (ServerPlayer)player);
        }
    }

    public void m_5785_(Player player) {
        if (!player.m_5833_()) {
            this.addOpener(player);
        }
    }

    public void m_6457_(ServerPlayer pPlayer) {
        super.m_6457_(pPlayer);
        if (this.getOpeners().contains(pPlayer.m_20148_())) {
            OpenCart cart = new OpenCart(this.m_19879_());
            PacketHandler.sendToInternal(cart, pPlayer);
        }
    }

    public Item m_213728_() {
        return Items.f_42519_;
    }
}

