/*
 * Decompiled with CFR 0.152.
 */
package xienaoban.minecraft.bole;

import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1132;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1703;
import net.minecraft.class_2338;
import net.minecraft.class_2540;
import net.minecraft.class_310;
import net.minecraft.class_638;
import net.minecraft.class_746;
import net.minecraft.server.MinecraftServer;
import xienaoban.minecraft.bole.Bole;
import xienaoban.minecraft.bole.client.EntityManager;
import xienaoban.minecraft.bole.client.EventsManager;
import xienaoban.minecraft.bole.client.KeyBindingManager;
import xienaoban.minecraft.bole.client.highlight.HighlightManager;
import xienaoban.minecraft.bole.config.Configs;
import xienaoban.minecraft.bole.gui.ScreenManager;
import xienaoban.minecraft.bole.gui.screen.GenericScreenHandler;
import xienaoban.minecraft.bole.gui.screen.homepage.BoleHomepageScreenState;
import xienaoban.minecraft.bole.network.ClientNetworkManager;
import xienaoban.minecraft.bole.network.ServerNetworkManager;

@Environment(value=EnvType.CLIENT)
public class BoleClient
implements ClientModInitializer {
    private static BoleClient instance;
    private boolean isScreenOpen;
    private class_1297 hitEntity;
    private class_2338 hitBlock;
    private int ticks;
    private int screenTicks;
    private boolean inWorld;
    private class_2540 handlerBufCache = null;
    private BoleHomepageScreenState screenState;
    private HighlightManager highlightManager;

    public static BoleClient getInstance() {
        return instance;
    }

    public void onInitializeClient() {
        instance = this;
        this.isScreenOpen = false;
        this.ticks = -1;
        this.screenTicks = -1;
        this.inWorld = false;
        this.highlightManager = new HighlightManager();
        ScreenManager.init();
        ClientNetworkManager.init();
        KeyBindingManager.init();
        BoleClient.initConfigsSaveListener();
        EventsManager.init();
        EntityManager.init();
        Bole.getInstance().setServerVersion("<unknown>");
        Bole.getInstance().setServerConfigs(Configs.getInstance());
    }

    private static void initConfigsSaveListener() {
        Configs.getHolder().registerSaveListener((configHolder, configs) -> {
            class_1132 server = class_310.method_1551().method_1576();
            if (server != null) {
                ServerNetworkManager.sendServerBoleConfigsToAllPlayers((MinecraftServer)server);
            }
            return class_1269.field_5811;
        });
    }

    public void onJoin() {
        class_638 world = class_310.method_1551().field_1687;
        this.preventMemoryLeak();
        if (world != null) {
            EntityManager.getInstance();
            ClientNetworkManager.requestServerBoleConfigs();
            Bole.LOGGER.info("Joining the world: " + world.method_27983().method_29177());
        } else {
            Bole.LOGGER.info("Joining the world: null?!");
        }
        this.inWorld = world != null;
    }

    public void onDisconnect() {
        this.inWorld = false;
        Bole.getInstance().setServerVersion("<unknown>");
        Bole.getInstance().setServerConfigs(Configs.getInstance());
        this.preventMemoryLeak();
        class_638 world = class_310.method_1551().field_1687;
        if (world != null) {
            Bole.LOGGER.info("Disconnecting from the world: " + world.method_27983().method_29177());
        } else {
            Bole.LOGGER.info("Disconnecting from the world: null");
        }
    }

    public void clientTick() {
        if (!this.inWorld) {
            return;
        }
        if (!class_310.method_1551().method_1493()) {
            ++this.ticks;
        }
        if (this.isScreenOpen) {
            class_1703 class_17032;
            class_310 client = class_310.method_1551();
            class_746 player = client.field_1724;
            if (player != null && (class_17032 = player.field_7512) instanceof GenericScreenHandler) {
                GenericScreenHandler handler = (GenericScreenHandler)class_17032;
                ++this.screenTicks;
                handler.clientTick(this.screenTicks);
            }
        }
        this.highlightManager.tick();
    }

    public boolean isHost() {
        return class_310.method_1551().method_1576() != null;
    }

    public void setScreenOpen(boolean isScreenOpen) {
        this.isScreenOpen = isScreenOpen;
        this.screenTicks = -1;
    }

    public class_1297 getHitEntity() {
        return this.hitEntity;
    }

    public void setHitEntity(class_1297 hitEntity) {
        this.hitEntity = hitEntity;
    }

    public class_2338 getHitBlock() {
        return this.hitBlock;
    }

    public void setHitBlock(class_2338 hitBlock) {
        this.hitBlock = hitBlock;
    }

    public int getTicks() {
        return this.ticks;
    }

    public int getScreenTicks() {
        return this.screenTicks;
    }

    public boolean isInWorld() {
        return this.inWorld;
    }

    public class_2540 getHandlerBufCache() {
        return this.handlerBufCache;
    }

    public void setHandlerBufCache(class_2540 buf) {
        this.handlerBufCache = buf;
    }

    public BoleHomepageScreenState getHomepageScreenState() {
        return this.screenState;
    }

    public void setHomepageScreenState(BoleHomepageScreenState screenState) {
        this.screenState = screenState;
    }

    public HighlightManager getHighlightManager() {
        return this.highlightManager;
    }

    private void preventMemoryLeak() {
        this.setHitEntity(null);
        this.setHitBlock(null);
        this.setHandlerBufCache(null);
        this.setHomepageScreenState(null);
        this.highlightManager.clear();
    }
}

