/*
 * Decompiled with CFR 0.152.
 */
package xienaoban.minecraft.bole.client;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Modifier;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1311;
import net.minecraft.class_1429;
import net.minecraft.class_1480;
import net.minecraft.class_1528;
import net.minecraft.class_1545;
import net.minecraft.class_1548;
import net.minecraft.class_1588;
import net.minecraft.class_1937;
import net.minecraft.class_2378;
import net.minecraft.class_238;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3732;
import net.minecraft.class_3988;
import org.jetbrains.annotations.NotNull;
import xienaoban.minecraft.bole.Bole;
import xienaoban.minecraft.bole.util.Keys;
import xienaoban.minecraft.bole.util.MiscUtil;
import xienaoban.minecraft.bole.util.TreeNodeExecutor;

@Environment(value=EnvType.CLIENT)
public class EntityManager {
    private static EntityManager instance = null;
    private static final String MISC_PATH = "misc/";
    private static final String DEOBFUSCATION_ENTITY_TO_CLASS_PATH = "misc/deobfuscation_entity_to_class.txt";
    private static final String DEOBFUSCATION_INTERFACE_TO_ENTITY_PATH = "misc/deobfuscation_interface_to_entity.txt";
    private static final String DEOBFUSCATION_SUB_TO_SUPER_PATH = "misc/deobfuscation_sub_to_super.txt";
    private static final String ENTITY_SORT_ORDER_PATH = "misc/entity_sort_order.txt";
    private final Map<Class<?>, EntityTreeNode> tree = new HashMap();
    private final Map<class_1299<?>, EntityInfo> infos = new HashMap();
    private final List<EntityInfo> sortedInfos = new ArrayList<EntityInfo>();
    private final Map<String, Integer> entitySortIds = new HashMap<String, Integer>();
    private final Map<Class<?>, String> deobfuscation = new HashMap();
    private final List<TagGroup> tagGroups = new ArrayList<TagGroup>();
    private final TagGroup defaultTags = new TagGroup("tag_group.bole.default");
    private final TagGroup classTags = new TagGroup("tag_group.bole.class");
    private final TagGroup interfaceTags = new TagGroup("tag_group.bole.interface");
    private final TagGroup namespaceTags = new TagGroup("tag_group.bole.namespace");

    public static EntityManager getInstance() {
        if (instance == null) {
            instance = new EntityManager();
            Bole.LOGGER.info("EntityManager of Bole initialized.");
        }
        return instance;
    }

    public static void init() {
        EntityManager.initEntitySortOrderFile();
    }

    public static void initEntitySortOrderFile() {
        Path orderPath = Keys.ENTITY_SORT_ORDER_CONFIG_PATH();
        if (orderPath.toFile().isFile()) {
            return;
        }
        try (BufferedWriter fileWriter = MiscUtil.getFileWriter(orderPath);
             BufferedReader resourceReader = MiscUtil.getResourceReader("/misc/entity_sort_order.txt");){
            String line;
            fileWriter.write("# This file controls the order of entities displayed in bole handbook homepage.");
            fileWriter.newLine();
            while ((line = resourceReader.readLine()) != null) {
                if (line.isEmpty() || line.charAt(0) == '#') continue;
                fileWriter.write(line);
                fileWriter.newLine();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private EntityManager() {
        this.initEntitySortIds();
        this.initEntityInfos();
        this.initDeobfuscation();
        this.initJavaTags();
        this.initDefaultTags();
        this.registerTagGroup(this.defaultTags);
        this.registerTagGroup(this.classTags);
        this.registerTagGroup(this.interfaceTags);
        this.registerTagGroup(this.namespaceTags);
        this.sortAllEntities();
    }

    private void initEntitySortIds() {
        Map<String, Integer> orderMap = this.entitySortIds;
        Path orderPath = Keys.ENTITY_SORT_ORDER_CONFIG_PATH();
        EntityManager.initEntitySortOrderFile();
        try (BufferedReader orderReader = MiscUtil.getFileReader(orderPath);){
            String line;
            if (!orderMap.isEmpty()) {
                orderMap.clear();
            }
            int sid = 0;
            while ((line = orderReader.readLine()) != null) {
                if (line.isEmpty() || line.charAt(0) == '#') continue;
                orderMap.put(line.trim(), sid++);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void initEntityInfos() {
        this.tree.put(class_1297.class, new EntityTreeNode());
        for (class_1299 entityType : class_2378.field_11145) {
            EntityInfo entityInfo;
            try {
                entityInfo = new EntityInfo(entityType);
            }
            catch (Exception e) {
                continue;
            }
            this.infos.put(entityInfo.getType(), entityInfo);
            this.sortedInfos.add(entityInfo);
            this.getEntityTreeNode(entityInfo.getClazz());
        }
        this.initEntityInfoSortIds();
    }

    private void initEntityInfoSortIds() {
        this.sortedInfos.sort((a, b) -> {
            int j;
            class_2960 ia = class_1299.method_5890(a.getType());
            class_2960 ib = class_1299.method_5890(b.getType());
            Integer sortIdA = this.entitySortIds.getOrDefault(ia.toString(), null);
            Integer sortIdB = this.entitySortIds.getOrDefault(ib.toString(), null);
            if (sortIdA != null && sortIdB != null) {
                return sortIdA - sortIdB;
            }
            if (sortIdA != null || sortIdB != null) {
                return sortIdA == null ? 1 : -1;
            }
            int cmp = ia.method_12836().compareTo(ib.method_12836());
            if (cmp != 0) {
                if (ia.method_12836().equals("minecraft")) {
                    return 1;
                }
                return cmp;
            }
            String pa = ia.method_12832();
            String pb = ib.method_12832();
            int i = pa.length() - 1;
            for (j = pb.length() - 1; i >= 0 && j >= 0; --i, --j) {
                cmp = pa.charAt(i) - pb.charAt(j);
                if (cmp == 0) continue;
                return cmp;
            }
            return i - j;
        });
        for (int i = this.sortedInfos.size() - 1; i >= 0; --i) {
            this.sortedInfos.get(i).setSortId(i);
        }
    }

    private void initDeobfuscation() {
        this.readEntityDependencyFile();
    }

    private void initJavaTags() {
        this.dfsEntityTree(true, (root, depth) -> {
            if (!Modifier.isAbstract(root.getClazz().getModifiers())) {
                return false;
            }
            this.classTags.addTag(this.getClassId(root.getClazz()), this.getClassId(root.getFather().getClazz()));
            return true;
        });
        for (EntityInfo entityInfo : this.getEntityInfos()) {
            this.namespaceTags.addToTag(class_1299.method_5890(entityInfo.getType()).method_12836(), entityInfo);
            Class<?> clazz = entityInfo.getClazz();
            Class<class_1297> root2 = class_1297.class;
            while (!root2.equals(clazz)) {
                if (Modifier.isAbstract(clazz.getModifiers())) {
                    this.classTags.addToTag(this.getClassId(clazz), entityInfo);
                }
                for (Class<?> clazz2 : clazz.getInterfaces()) {
                    if (clazz2.getSimpleName().contains("Mixin")) continue;
                    this.interfaceTags.addToTag(this.getClassId(clazz2), entityInfo);
                }
                clazz = clazz.getSuperclass();
            }
        }
    }

    private void initDefaultTags() {
        this.defaultTags.addTag("tag.bole.default.terrestrial_animal", "tag.bole.default.animal");
        this.defaultTags.addTag("tag.bole.default.human", "tag.bole.default.terrestrial_animal");
        this.defaultTags.addTag("tag.bole.default.aquatic_animal", "tag.bole.default.animal");
        this.defaultTags.addTag("tag.bole.default.humanoid", "tag.bole.default.monster");
        this.defaultTags.addTag("tag.bole.default.patrol", "tag.bole.default.monster");
        this.defaultTags.addAllToTag("tag.bole.default.human", this.classTags.getTag(this.getClassId(class_3988.class)).getEntities());
        this.defaultTags.addAllToTag("tag.bole.default.terrestrial_animal", this.classTags.getTag(this.getClassId(class_1429.class)).getEntities());
        this.defaultTags.addAllToTag("tag.bole.default.terrestrial_animal", this.defaultTags.getTag("tag.bole.default.human").getEntities());
        this.defaultTags.addAllToTag("tag.bole.default.terrestrial_animal", List.of(this.getEntityInfo(class_1299.field_6108), this.getEntityInfo(class_1299.field_6079), this.getEntityInfo(class_1299.field_6084), this.getEntityInfo(class_1299.field_6125)));
        this.defaultTags.removeFromTag("tag.bole.default.terrestrial_animal", this.getEntityInfo(class_1299.field_28315));
        this.defaultTags.addAllToTag("tag.bole.default.aquatic_animal", this.classTags.getTag(this.getClassId(class_1480.class)).getEntities());
        this.defaultTags.addToTag("tag.bole.default.aquatic_animal", this.getEntityInfo(class_1299.field_6113));
        this.defaultTags.addToTag("tag.bole.default.aquatic_animal", this.getEntityInfo(class_1299.field_28315));
        this.defaultTags.addAllToTag("tag.bole.default.animal", this.defaultTags.getTag("tag.bole.default.terrestrial_animal").getEntities());
        this.defaultTags.addAllToTag("tag.bole.default.animal", this.defaultTags.getTag("tag.bole.default.aquatic_animal").getEntities());
        List<EntityInfo> cHumanoid = this.getEntityInfos().stream().filter(entityInfo -> {
            if (entityInfo.getInstance() instanceof class_1588) {
                if (entityInfo.getClazz() == class_1548.class || entityInfo.getClazz() == class_1545.class || entityInfo.getClazz() == class_1528.class) {
                    return false;
                }
                class_238 box = entityInfo.getInstance().method_5829();
                return box.method_17939() < 1.0 && box.method_17940() > 1.6;
            }
            return false;
        }).collect(Collectors.toList());
        this.defaultTags.addAllToTag("tag.bole.default.humanoid", cHumanoid);
        this.defaultTags.addAllToTag("tag.bole.default.patrol", this.classTags.getTag(this.getClassId(class_3732.class)).getEntities());
        Stream<EntityInfo> sMonster = this.getEntityInfos().stream().filter(entityInfo -> entityInfo.getType().method_5891() == class_1311.field_6302);
        this.defaultTags.addAllToTag("tag.bole.default.monster", sMonster.collect(Collectors.toSet()));
        HashSet<EntityInfo> tAnimal = new HashSet<EntityInfo>(this.defaultTags.getTag("tag.bole.default.animal").getEntities());
        HashSet<EntityInfo> tMonster = new HashSet<EntityInfo>(this.defaultTags.getTag("tag.bole.default.monster").getEntities());
        List<EntityInfo> other = this.getEntityInfos().stream().filter(entityInfo -> !tAnimal.contains(entityInfo) && !tMonster.contains(entityInfo)).toList();
        this.defaultTags.addAllToTag("tag.bole.default.other", other);
    }

    public void registerTagGroup(TagGroup group) {
        this.tagGroups.add(group);
    }

    private void sortAllEntities() {
        for (TagGroup group : this.getTagGroups()) {
            boolean noSkip;
            boolean bl = noSkip = !group.getName().equals("tag_group.bole.default");
            if (noSkip) {
                if (group.getName().equals("tag_group.bole.interface")) {
                    group.getRootTags().sort((a, b) -> {
                        boolean mcb;
                        boolean mca = a.getName().indexOf("net.minecraft") == 0;
                        boolean bl = mcb = b.getName().indexOf("net.minecraft") == 0;
                        if (mca ^ mcb) {
                            return mca ? -1 : 1;
                        }
                        return a.getName().compareTo(b.getName());
                    });
                } else {
                    Collections.sort(group.getRootTags());
                }
            }
            for (Tag tag : group.getTags()) {
                if (noSkip) {
                    Collections.sort(tag.getSons());
                }
                List<EntityInfo> entities = tag.getEntities();
                Collections.sort(entities);
                for (int i = entities.size() - 2; i >= 0; --i) {
                    if (entities.get(i) != entities.get(i + 1)) continue;
                    entities.remove(i);
                }
            }
        }
        List<Tag> ns = this.namespaceTags.getRootTags();
        Tag mcTag = this.namespaceTags.getTag("minecraft");
        ns.remove(mcTag);
        Collections.sort(ns);
        ns.add(0, mcTag);
    }

    public void reorderAllEntities() {
        this.initEntitySortIds();
        this.initEntityInfoSortIds();
        this.sortAllEntities();
    }

    public List<TagGroup> getTagGroups() {
        return this.tagGroups;
    }

    public EntityTreeNode getEntityTreeNode(Class<?> clazz) {
        EntityTreeNode node = this.tree.getOrDefault(clazz, null);
        if (node == null) {
            node = new EntityTreeNode(clazz, this.getEntityTreeNode(clazz.getSuperclass()));
            this.tree.put(clazz, node);
        }
        return node;
    }

    public EntityInfo getEntityInfo(class_1299<?> entityType) {
        return this.infos.get(entityType);
    }

    public List<EntityInfo> getEntityInfos() {
        return this.sortedInfos;
    }

    public String getClassDeobfuscation(Class<?> clazz) {
        return this.deobfuscation.getOrDefault(clazz, clazz.getName());
    }

    private String getClassId(Class<?> clazz) {
        return this.getClassDeobfuscation(clazz);
    }

    public void dfsEntityTree(boolean skipRoot, TreeNodeExecutor<EntityTreeNode> executor) {
        this.dfsEntityTree(skipRoot, executor, TreeNodeExecutor.empty());
    }

    public void dfsEntityTree(boolean skipRoot, TreeNodeExecutor<EntityTreeNode> frontExecutor, TreeNodeExecutor<EntityTreeNode> rearExecutor) {
        EntityTreeNode root = this.getEntityTreeNode(class_1297.class);
        if (skipRoot) {
            root.getSons().forEach(son -> this.dfsEntityTreePrivate((EntityTreeNode)son, 1, frontExecutor, rearExecutor));
        } else {
            this.dfsEntityTreePrivate(root, 0, frontExecutor, rearExecutor);
        }
    }

    private void dfsEntityTreePrivate(EntityTreeNode root, int depth, TreeNodeExecutor<EntityTreeNode> frontExecutor, TreeNodeExecutor<EntityTreeNode> rearExecutor) {
        if (frontExecutor.execute(root, depth)) {
            int d2 = depth + 1;
            root.getSons().forEach(son -> this.dfsEntityTreePrivate((EntityTreeNode)son, d2, frontExecutor, rearExecutor));
        }
        rearExecutor.execute(root, depth);
    }

    public void generateDeobfuscationFiles() {
        String dir = "tmp";
        System.out.println("Generating " + Path.of(dir, new String[0]).toAbsolutePath());
        try {
            Files.createDirectories(Path.of(dir, new String[0]), new FileAttribute[0]);
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
        try (BufferedWriter ecWriter = Files.newBufferedWriter(Path.of(DEOBFUSCATION_ENTITY_TO_CLASS_PATH, new String[0]), new OpenOption[0]);
             BufferedWriter ieWriter = Files.newBufferedWriter(Path.of(DEOBFUSCATION_INTERFACE_TO_ENTITY_PATH, new String[0]), new OpenOption[0]);
             BufferedWriter ssWriter = Files.newBufferedWriter(Path.of(DEOBFUSCATION_SUB_TO_SUPER_PATH, new String[0]), new OpenOption[0]);){
            for (EntityInfo entityInfo : this.getEntityInfos()) {
                class_2960 id = class_1299.method_5890(entityInfo.getType());
                if (!Objects.equals(id.method_12836(), "minecraft")) continue;
                ecWriter.write(id + " " + entityInfo.getClazz().getName());
                ecWriter.newLine();
            }
            Map<String, List<Class<?>>> entityToInterface = this.calEntityToInterfaceMap();
            for (Map.Entry<String, List<Class<?>>> entry : entityToInterface.entrySet()) {
                for (Class<?> clazz : entry.getValue()) {
                    ieWriter.write(clazz.getName() + " " + entry.getKey());
                    ieWriter.newLine();
                }
            }
            this.dfsEntityTree(true, (cur, depth) -> {
                try {
                    if (cur.getClazz().getName().indexOf("net.minecraft") != 0) {
                        return true;
                    }
                    ssWriter.write(cur.getClazz().getName() + " " + cur.getFather().getClazz().getName());
                    ssWriter.newLine();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return false;
                }
                return true;
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void readEntityDependencyFile() {
        InputStream ecStream = this.getClass().getResourceAsStream("/misc/deobfuscation_entity_to_class.txt");
        InputStream ieStream = this.getClass().getResourceAsStream("/misc/deobfuscation_interface_to_entity.txt");
        InputStream ssStream = this.getClass().getResourceAsStream("/misc/deobfuscation_sub_to_super.txt");
        if (ecStream == null || ieStream == null || ssStream == null) {
            Bole.LOGGER.error("Resource in /misc/ not found.");
            return;
        }
        Map<Class<?>, String> classMap = this.deobfuscation;
        try (BufferedReader ecReader = new BufferedReader(new InputStreamReader(ecStream));
             BufferedReader ieReader = new BufferedReader(new InputStreamReader(ieStream));
             BufferedReader ssReader = new BufferedReader(new InputStreamReader(ssStream));){
            String line;
            while ((line = ecReader.readLine()) != null) {
                String[] tmp = line.split(" ", 2);
                String name = tmp[0];
                String clazz = tmp[1];
                Optional type = class_1299.method_5898((String)name);
                if (type.isEmpty()) {
                    Bole.LOGGER.error("EntityType \"" + name + "\" in entity_classes.txt not found!");
                    continue;
                }
                classMap.put(this.getEntityInfo((class_1299)type.get()).getClazz(), clazz);
            }
            HashMap<String, String> subToSuper = new HashMap<String, String>();
            while ((line = ssReader.readLine()) != null) {
                String[] tmp = line.split(" ", 2);
                String son = tmp[0];
                String father = tmp[1];
                subToSuper.put(son, father);
            }
            this.dfsEntityTree(true, TreeNodeExecutor.empty(), (cur, depth) -> {
                String son = (String)classMap.get(cur.getClazz());
                if (son == null) {
                    return true;
                }
                String father = (String)subToSuper.get(son);
                classMap.put(cur.getFather().getClazz(), father);
                return true;
            });
            Map<String, List<Class<?>>> entityToInterface = this.calEntityToInterfaceMap();
            while ((line = ieReader.readLine()) != null) {
                String[] tmp = line.split(" ", 2);
                String interfaze = tmp[0];
                String entity = tmp[1];
                List<Class<?>> list = entityToInterface.get(entity);
                classMap.put(list.get(0), interfaze);
                list.remove(0);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private Map<String, List<Class<?>>> calEntityToInterfaceMap() {
        HashMap map = new HashMap();
        HashMap<Class, Set> interfaceToEntity = new HashMap<Class, Set>();
        Class<class_1297> root = class_1297.class;
        for (EntityInfo entityInfo : this.getEntityInfos()) {
            Class<?> clazz = entityInfo.getClazz();
            while (!root.equals(clazz)) {
                for (Class<?> interfaze : clazz.getInterfaces()) {
                    if (interfaze.getPackageName().indexOf("net.minecraft") != 0) continue;
                    Set set = interfaceToEntity.computeIfAbsent(interfaze, key -> new HashSet());
                    set.add(class_1299.method_5890(entityInfo.getType()).toString());
                }
                clazz = clazz.getSuperclass();
            }
        }
        for (Map.Entry entry : interfaceToEntity.entrySet()) {
            StringBuilder builder = new StringBuilder();
            ((Set)entry.getValue()).stream().sorted().forEach(s -> builder.append((String)s).append(' '));
            builder.deleteCharAt(builder.length() - 1);
            String entity = builder.substring(0, builder.length() - 1);
            List list = map.computeIfAbsent(entity, key -> new ArrayList());
            list.add((Class)entry.getKey());
        }
        return map;
    }

    public static class TagGroup {
        private final String name;
        private final class_2561 text;
        private final Map<String, Tag> tags;
        private final List<Tag> rootTags;

        public TagGroup(String tagGroupName) {
            this.name = tagGroupName;
            this.text = new class_2588(tagGroupName);
            this.tags = new HashMap<String, Tag>();
            this.rootTags = new ArrayList<Tag>();
        }

        public String getName() {
            return this.name;
        }

        public class_2561 getText() {
            return this.text;
        }

        public Collection<Tag> getTags() {
            return this.tags.values();
        }

        public List<Tag> getRootTags() {
            return this.rootTags;
        }

        public Tag getTag(String tagName) {
            Tag tag = this.tags.getOrDefault(tagName, null);
            if (tag == null) {
                tag = new Tag(tagName);
                this.tags.put(tagName, tag);
                this.rootTags.add(tag);
            }
            return tag;
        }

        public void addTag(String tagName, String fatherTagName) {
            Tag old = this.tags.put(tagName, new Tag(tagName, this.getTag(fatherTagName)));
            if (old != null) {
                throw new RuntimeException("Tag \"" + tagName + "\" already exists.");
            }
        }

        public void addToTag(String tagName, EntityInfo entityInfo) {
            Tag tag = this.getTag(tagName);
            tag.addEntity(entityInfo);
            entityInfo.addTag(tag);
        }

        public void addAllToTag(String tagName, Collection<EntityInfo> entityInfos) {
            Tag tag = this.getTag(tagName);
            tag.addEntities(entityInfos);
            entityInfos.forEach(entityInfo -> entityInfo.addTag(tag));
        }

        public void removeFromTag(String tagName, EntityInfo entityInfo) {
            Tag tag = this.getTag(tagName);
            tag.removeEntity(entityInfo);
            entityInfo.removeTag(tag);
        }

        public void dfsTags(TreeNodeExecutor<Tag> executor) {
            for (Tag root : this.getRootTags()) {
                this.dfsTagsPrivate(root, 0, executor);
            }
        }

        private void dfsTagsPrivate(Tag root, int depth, TreeNodeExecutor<Tag> executor) {
            if (executor.execute(root, depth)) {
                int d2 = depth + 1;
                root.getSons().forEach(son -> this.dfsTagsPrivate((Tag)son, d2, executor));
            }
        }
    }

    public static class EntityTreeNode {
        private final Class<?> clazz;
        private final EntityTreeNode father;
        private final List<EntityTreeNode> sons;

        public EntityTreeNode() {
            this.clazz = class_1297.class;
            this.father = null;
            this.sons = new ArrayList<EntityTreeNode>();
        }

        public EntityTreeNode(Class<?> clazz, EntityTreeNode father) {
            this.clazz = clazz;
            this.father = father;
            this.sons = new ArrayList<EntityTreeNode>();
            father.addSon(this);
        }

        public Class<?> getClazz() {
            return this.clazz;
        }

        public EntityTreeNode getFather() {
            return this.father;
        }

        public List<EntityTreeNode> getSons() {
            return this.sons;
        }

        protected void addSon(EntityTreeNode son) {
            this.sons.add(son);
        }

        public String toString() {
            return this.clazz.getSimpleName();
        }
    }

    public static class EntityInfo
    implements Comparable<EntityInfo> {
        private final class_1299<?> type;
        private final class_1297 instance;
        private final Class<?> clazz;
        private final List<Tag> tags;
        private int sortId;

        public EntityInfo(class_1299<?> type) {
            class_1297 instance;
            this.type = type;
            this.instance = instance = type.method_5883((class_1937)class_310.method_1551().field_1687);
            if (!(instance instanceof class_1309)) {
                throw new RuntimeException();
            }
            this.clazz = instance.getClass();
            this.tags = new ArrayList<Tag>();
        }

        public class_1299<?> getType() {
            return this.type;
        }

        public class_1297 getInstance() {
            return this.instance;
        }

        public Class<?> getClazz() {
            return this.clazz;
        }

        public List<Tag> getTags() {
            return this.tags;
        }

        protected void addTag(Tag tag) {
            this.tags.add(tag);
        }

        protected void removeTag(Tag tag) {
            this.tags.remove(tag);
        }

        public void setSortId(int sortId) {
            this.sortId = sortId;
        }

        public String toString() {
            return this.type.toString();
        }

        @Override
        public int compareTo(@NotNull EntityInfo o) {
            return this.sortId - o.sortId;
        }
    }

    public static class Tag
    implements Comparable<Tag> {
        private final String name;
        private final class_2561 text;
        private final List<EntityInfo> entities;
        private final Tag father;
        private final List<Tag> sons;

        public Tag(String name) {
            this(name, null);
        }

        public Tag(String name, Tag father) {
            this.name = name;
            this.text = new class_2588(name);
            this.entities = new ArrayList<EntityInfo>();
            this.father = father;
            if (father != null) {
                father.addSon(this);
            }
            this.sons = new ArrayList<Tag>();
        }

        public String getName() {
            return this.name;
        }

        public class_2561 getText() {
            return this.text;
        }

        public List<EntityInfo> getEntities() {
            return this.entities;
        }

        protected void addEntity(EntityInfo info) {
            this.entities.add(info);
        }

        protected void addEntities(Collection<EntityInfo> infos) {
            this.entities.addAll(infos);
        }

        protected void removeEntity(EntityInfo info) {
            this.entities.remove(info);
        }

        public Tag getFather() {
            return this.father;
        }

        public void addSon(Tag tag) {
            this.sons.add(tag);
        }

        public List<Tag> getSons() {
            return this.sons;
        }

        public String toString() {
            return this.name;
        }

        @Override
        public int compareTo(@NotNull Tag o) {
            String s1 = this.getName().substring(this.getName().lastIndexOf(46) + 1);
            String s2 = o.getName().substring(o.getName().lastIndexOf(46) + 1);
            return s1.compareTo(s2);
        }
    }
}

