/*
 * Decompiled with CFR 0.152.
 */
package xienaoban.minecraft.bole.client;

import java.util.ArrayList;
import java.util.Optional;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.item.v1.ItemTooltipCallback;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import net.minecraft.class_2741;
import net.minecraft.class_310;
import net.minecraft.class_3417;
import net.minecraft.class_4466;
import net.minecraft.class_746;
import xienaoban.minecraft.bole.config.Configs;
import xienaoban.minecraft.bole.gui.screen.GenericHandledScreen;
import xienaoban.minecraft.bole.mixin.IMixinBlockItem;

@Environment(value=EnvType.CLIENT)
public class EventsManager {
    public static void init() {
        EventsManager.initBeehiveTooltip();
    }

    private static void initBeehiveTooltip() {
        ItemTooltipCallback.EVENT.register((stack, context, lines) -> {
            class_2487 entityNbt;
            class_2487 blockNbt;
            if (!class_1802.field_20416.equals(stack.method_7909()) && !class_1802.field_20415.equals(stack.method_7909())) {
                return;
            }
            class_2487 nbt = stack.method_7969();
            if (nbt == null) {
                return;
            }
            ArrayList<Object> beeLines = new ArrayList<Object>();
            if (nbt.method_10573("BlockStateTag", 10) && (blockNbt = nbt.method_10562("BlockStateTag")).method_10573(class_2741.field_20432.method_11899(), 3)) {
                int honeyLevel = blockNbt.method_10550(class_2741.field_20432.method_11899());
                beeLines.add(new class_2588("text.bole.honey_level", new Object[]{honeyLevel + "/5"}).method_27692(class_124.field_1054));
            }
            if (nbt.method_10573(IMixinBlockItem.getBlockEntityTagKey(), 10) && (entityNbt = nbt.method_10562(IMixinBlockItem.getBlockEntityTagKey())).method_10573("Bees", 9)) {
                class_2499 bees = entityNbt.method_10554("Bees", 10);
                int beeCnt = bees.size();
                beeLines.add(new class_2588("text.bole.bee_count", new Object[]{beeCnt + "/3"}).method_27692(class_124.field_1065));
                if (beeCnt > 0) {
                    beeLines.add(class_2585.field_24366);
                    beeLines.add(new class_2588("text.bole.bee_info").method_27692(class_124.field_1080));
                }
                for (int i = 0; i < beeCnt; ++i) {
                    class_2487 beeNbt = bees.method_10602(i).method_10562("EntityData");
                    class_4466 bee = (class_4466)class_1299.field_20346.method_5883((class_1937)class_310.method_1551().field_1687);
                    if (bee == null) {
                        beeLines.add(new class_2585("[ERROR]").method_27692(class_124.field_1061));
                        continue;
                    }
                    bee.method_5651(beeNbt);
                    beeLines.add(bee.method_5477().method_27662().method_10852((class_2561)new class_2588("text.bole.colon")).method_10852((class_2561)new class_2588(bee.method_6109() ? "text.bole.minor" : "text.bole.adult")).method_27692(class_124.field_1078));
                }
            }
            lines.addAll(1, beeLines);
        });
    }

    public static class ShoulderEntityFirstPersonRenderer {
        private final class_2487[] oldNbts = new class_2487[2];
        private final class_1309[] entities = new class_1309[2];
        private long lastTime = 0L;
        private float rotateX = 0.0f;
        private float rotateY = 0.0f;
        private float entityX = 0.0f;
        private float entityY = 0.0f;

        public void renderShoulderEntity(class_310 client) {
            float flip;
            float y;
            float x;
            class_746 player = client.field_1724;
            if (player == null) {
                if (this.oldNbts[0] != null || this.oldNbts[1] != null || this.entities[0] != null || this.entities[1] != null) {
                    this.oldNbts[1] = null;
                    this.oldNbts[0] = null;
                    this.entities[1] = null;
                    this.entities[0] = null;
                }
                return;
            }
            if (!client.field_1690.method_31044().method_31034() || player != client.field_1719) {
                return;
            }
            int w = client.method_22683().method_4486() >> 1;
            int h = client.method_22683().method_4502() >> 1;
            float r = -18.0f;
            float z = -40.0f;
            switch (Configs.getInstance().getShoulderCreatureHudPosition()) {
                case TOP: {
                    x = w >> 1;
                    y = -96.0f;
                    flip = 140.0f;
                    z = -z;
                    break;
                }
                case BOTTOM: {
                    x = (float)w * 0.7f;
                    y = (h << 1) + 70;
                    flip = 5.0f;
                    break;
                }
                case SIDES: {
                    x = (float)w + 28.5f;
                    y = h + 70;
                    flip = 15.0f;
                    break;
                }
                default: {
                    return;
                }
            }
            long diffTime = System.currentTimeMillis() - this.lastTime;
            float rx = (player.method_36454() - this.rotateX) / (float)diffTime * 0.05f;
            float ry = (player.method_36455() - this.rotateY) / (float)diffTime * 0.05f;
            this.lastTime += diffTime;
            this.rotateX = player.method_36454();
            this.rotateY = player.method_36455();
            this.entityX = this.entityX - this.entityX * 0.01f * (float)diffTime + rx;
            this.entityY = this.entityY - this.entityY * 0.01f * (float)diffTime + ry;
            for (int i = 0; i < 2; ++i) {
                class_2487 entityNbt;
                if (i == 0) {
                    entityNbt = player.method_7356();
                } else {
                    entityNbt = player.method_7308();
                    x = -x;
                    r = -r;
                }
                if (this.oldNbts[i] != entityNbt) {
                    this.oldNbts[i] = entityNbt;
                    if (entityNbt.method_33133()) {
                        this.entities[i] = null;
                        continue;
                    }
                    Optional optionalEntity = class_1299.method_5892((class_2487)entityNbt, (class_1937)player.field_6002);
                    if (optionalEntity.isPresent()) {
                        class_1309 entity = (class_1309)optionalEntity.get();
                        entity.method_36456(0.0f);
                        entity.method_5636(0.0f);
                        entity.method_5847(0.0f);
                        entity.field_6259 = 0.0f;
                        entity.method_36457(0.0f);
                        this.entities[i] = entity;
                    } else {
                        this.entities[i] = null;
                        continue;
                    }
                }
                if (this.entities[i] == null) continue;
                GenericHandledScreen.drawEntityGeneric((class_1297)this.entities[i], 160.0f, (float)w - x, y - (float)Math.atan(this.entityY) * 100.0f, flip, r, (float)Math.atan(this.entityX) * z);
            }
        }
    }

    public static class LeashFallFromPlayerEvent {
        long lastFallTime = 0L;
        int times = 0;

        public void onFall(class_746 player) {
            long curTime = System.currentTimeMillis();
            this.times = curTime - this.lastFallTime > 3000L ? 1 : ++this.times;
            this.lastFallTime = curTime;
            GenericHandledScreen.playScreenSound(class_3417.field_14585, 0.4f, 1.0f);
            player.method_7353((class_2561)new class_2588("text.bole.leash_fall", new Object[]{this.times}).method_27692(class_124.field_1065), true);
        }
    }
}

