/*
 * Decompiled with CFR 0.152.
 */
package xienaoban.minecraft.bole.gui.screen;

import java.util.HashMap;
import java.util.Map;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1661;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_3222;
import net.minecraft.class_3917;
import net.minecraft.class_437;
import org.jetbrains.annotations.Nullable;
import xienaoban.minecraft.bole.Bole;
import xienaoban.minecraft.bole.BoleClient;
import xienaoban.minecraft.bole.config.Configs;
import xienaoban.minecraft.bole.gui.screen.AbstractBoleScreen;
import xienaoban.minecraft.bole.gui.screen.GenericScreenHandler;
import xienaoban.minecraft.bole.network.ClientNetworkManager;
import xienaoban.minecraft.bole.network.ServerNetworkManager;
import xienaoban.minecraft.bole.util.MiscUtil;

public abstract class AbstractBoleScreenHandler<E extends class_1297>
extends GenericScreenHandler {
    public final E entity;
    private final Map<String, EntitySettingsBufHandler> entitySettingsBufHandlers;

    public AbstractBoleScreenHandler(@Nullable class_3917<?> type, int syncId, class_1661 playerInventory, class_1297 entity) {
        super(type, syncId, playerInventory);
        this.entity = (class_1297)MiscUtil.cast(entity);
        this.entitySettingsBufHandlers = new HashMap<String, EntitySettingsBufHandler>();
        if (this.isServer) {
            this.initServer();
        } else {
            this.initClient();
        }
        this.initCustom();
    }

    protected void initServer() {
        class_3222 p = (class_3222)this.player;
        ServerNetworkManager.sendServerEntityData(this, p.field_13995, p);
    }

    @Environment(value=EnvType.CLIENT)
    protected void initClient() {
        class_2540 buf = BoleClient.getInstance().getHandlerBufCache();
        if (buf != null) {
            this.tryReadServerEntityFromBuf(buf);
            BoleClient.getInstance().setHandlerBufCache(null);
        }
    }

    protected abstract void writeServerEntityToBuf(class_2540 var1);

    @Environment(value=EnvType.CLIENT)
    protected abstract void readServerEntityFromBuf(class_2540 var1);

    @Environment(value=EnvType.CLIENT)
    protected abstract void resetClientEntityServerProperties();

    @Environment(value=EnvType.CLIENT)
    public static class_1297 clientEntity() {
        class_1297 entity = BoleClient.getInstance().getHitEntity();
        BoleClient.getInstance().setHitEntity(null);
        return entity;
    }

    public void sendOverlayMessage(class_2561 text) {
        class_3222 player = (class_3222)this.player;
        ServerNetworkManager.sendOverlayMessage(text, player.field_13995, player);
    }

    public final void registerEntitySettingsBufHandler(String settingId, EntitySettingsBufHandler bufHandler) {
        this.entitySettingsBufHandlers.put(settingId, bufHandler);
    }

    @Environment(value=EnvType.CLIENT)
    public final void sendClientEntitySettings(String settingId, Object ... args) {
        class_437 class_4372 = AbstractBoleScreenHandler.getCurScreen();
        if (class_4372 instanceof AbstractBoleScreen) {
            AbstractBoleScreen sc = (AbstractBoleScreen)class_4372;
            if (sc.debugMode) {
                this.player.method_7353((class_2561)new class_2588("text.bole.current_feature_request", new Object[]{settingId}).method_27692(class_124.field_1054), false);
            }
            if (Bole.getInstance().getServerConfigs().isEntitySettingBanned(settingId)) {
                sc.showOverlayMessage((class_2561)new class_2588("text.bole.feature_request_banned_from_server", new Object[]{settingId}));
                return;
            }
        }
        class_2540 buf = PacketByteBufs.create();
        buf.method_10814(settingId);
        try {
            this.entitySettingsBufHandlers.get(settingId).writeToBuf(buf, args);
            ClientNetworkManager.sendClientEntitySettings(buf);
        }
        catch (Exception e) {
            Bole.LOGGER.error("No EntitySettingsBufHandler is registered for settingId \"" + settingId + "\"");
        }
    }

    public final void receiveServerEntitySettings(class_2540 buf) {
        String settingId = buf.method_19772();
        if (Configs.getInstance().isEntitySettingBanned(settingId)) {
            this.sendOverlayMessage((class_2561)new class_2588("text.bole.feature_request_banned_from_server", new Object[]{settingId}));
            return;
        }
        try {
            this.entitySettingsBufHandlers.get(settingId).readFromBuf(buf);
        }
        catch (Exception e) {
            Bole.LOGGER.error("No EntitySettingsBufHandler is registered for settingId \"" + settingId + "\"");
        }
    }

    public final void tryWriteServerEntityFromBuf(class_2540 buf) {
        try {
            this.writeServerEntityToBuf(buf);
        }
        catch (Exception e) {
            Bole.LOGGER.warn((Object)e);
        }
    }

    public final void tryReadServerEntityFromBuf(class_2540 buf) {
        try {
            this.readServerEntityFromBuf(buf);
        }
        catch (Exception e) {
            Bole.LOGGER.warn((Object)e);
        }
    }

    public static interface EntitySettingsBufHandler {
        public void readFromBuf(class_2540 var1);

        public void writeToBuf(class_2540 var1, Object ... var2);
    }
}

