/*
 * Decompiled with CFR 0.152.
 */
package xienaoban.minecraft.bole.gui.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_1158;
import net.minecraft.class_1159;
import net.minecraft.class_1160;
import net.minecraft.class_1297;
import net.minecraft.class_1661;
import net.minecraft.class_238;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_308;
import net.minecraft.class_310;
import net.minecraft.class_3414;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_465;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import net.minecraft.class_5684;
import net.minecraft.class_757;
import net.minecraft.class_898;
import org.jetbrains.annotations.NotNull;
import xienaoban.minecraft.bole.Bole;
import xienaoban.minecraft.bole.BoleClient;
import xienaoban.minecraft.bole.client.KeyBindingManager;
import xienaoban.minecraft.bole.gui.ElementBox;
import xienaoban.minecraft.bole.gui.screen.GenericScreenHandler;

public abstract class GenericHandledScreen<T extends GenericScreenHandler>
extends class_465<T> {
    protected static final boolean DO_NOT_SHOW_REI = true;
    protected boolean debugMode = false;

    public GenericHandledScreen(T handler, class_1661 inventory, class_2561 title) {
        super(handler, inventory, title);
        BoleClient.getInstance().setScreenOpen(true);
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (KeyBindingManager.KEY_BOLE_SCREEN.method_1417(keyCode, scanCode)) {
            this.method_25419();
            return true;
        }
        if (keyCode == 346) {
            this.debugMode = !this.debugMode;
            return true;
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    public void method_25419() {
        BoleClient.getInstance().setScreenOpen(false);
        super.method_25419();
    }

    public boolean isGod() {
        return Bole.isGod(((GenericScreenHandler)this.field_2797).player);
    }

    public boolean isDetached() {
        return Bole.isDetached(((GenericScreenHandler)this.field_2797).player);
    }

    public static <EE extends class_1297> void copyEntityNbtForDisplay(EE from, EE to) {
        class_2487 nbt = from.method_5647(new class_2487());
        nbt.method_10551("Dimension");
        nbt.method_10551("Rotation");
        nbt.method_10551("CustomName");
        nbt.method_10551("CustomNameVisible");
        nbt.method_10551("AngryAt");
        nbt.method_10551("HurtTime");
        nbt.method_10551("Pos");
        try {
            to.method_5651(nbt);
        }
        catch (Exception e) {
            Bole.LOGGER.warn("Cannot copy nbt of [" + from.method_5864().method_5882() + "]: " + e);
        }
    }

    public static void setTexture(class_2960 id) {
        RenderSystem.setShaderTexture((int)0, (class_2960)id);
    }

    public int getTextWidth(class_2561 text) {
        return this.field_22793.method_27525((class_5348)text);
    }

    public static void playScreenSound(class_3414 sound, float volume, float pitch) {
        class_310.method_1551().method_1483().method_4873((class_1113)class_1109.method_4757((class_3414)sound, (float)pitch, (float)volume));
    }

    public static class_4587 matrixScaleOn(float x, float y, float z) {
        class_4587 matrixStack = RenderSystem.getModelViewStack();
        matrixStack.method_22903();
        matrixStack.method_22905(x, y, z);
        RenderSystem.applyModelViewMatrix();
        return matrixStack;
    }

    public static void matrixScaleOff(class_4587 matrixStack) {
        matrixStack.method_22909();
        RenderSystem.applyModelViewMatrix();
    }

    public void drawDebugBox(class_4587 matrices, ElementBox box, int color) {
        if (!this.debugMode) {
            return;
        }
        GenericHandledScreen.drawRectangle(matrices, color, 0.3f, 0.0f, box.left(), box.top(), box.right(), box.bottom());
    }

    public static void drawEntityAuto(class_1297 entity, int x0, int y0, int x1, int y1, float mouseX, float mouseY) {
        double eh;
        class_238 box = entity.method_5830();
        double ew = box.method_17939();
        if (ew > (eh = box.method_17940())) {
            ew = Math.max(ew, 1.0);
        } else {
            eh = Math.max(eh, 1.0);
        }
        int rw = x1 - x0;
        int rh = y1 - y0;
        int size = (int)(Math.min((double)rw / ew, (double)rh / eh) * 0.85);
        GenericHandledScreen.drawEntityBrighter(entity, size, x0 + x1 >> 1, y1, mouseX, mouseY);
    }

    public static void drawEntityByWidth(class_1297 entity, int width, int x, int y, float mouseX, float mouseY) {
        class_238 box = entity.method_5830();
        GenericHandledScreen.drawEntityBrighter(entity, (int)((double)width / box.method_17939()), x, y, mouseX, mouseY);
    }

    public static void drawEntityByHeight(class_1297 entity, int height, int x, int y, float mouseX, float mouseY) {
        class_238 box = entity.method_5830();
        GenericHandledScreen.drawEntityBrighter(entity, (int)((double)height / box.method_17940()), x, y, mouseX, mouseY);
    }

    public static void drawEntityBrighter(class_1297 entity, int size, int x, int y, float mouseX, float mouseY) {
        float f = (float)Math.atan(mouseX / 40.0f);
        float g = (float)Math.atan(mouseY / 40.0f);
        float fSize = -size;
        class_4587 matrixStack = RenderSystem.getModelViewStack();
        matrixStack.method_22903();
        matrixStack.method_22904((double)x, (double)y, 1050.0);
        matrixStack.method_22905(1.0f, 1.0f, -1.0f);
        RenderSystem.applyModelViewMatrix();
        class_4587 matrixStack2 = new class_4587();
        matrixStack2.method_22904(0.0, 0.0, 1000.0);
        matrixStack2.method_22905(fSize, fSize, fSize);
        class_1158 quaternion = class_1160.field_20707.method_23214(0.0f);
        class_1158 quaternion2 = class_1160.field_20703.method_23214(g * 20.0f);
        class_1158 quaternion3 = class_1160.field_20705.method_23214(entity.method_5705(0.0f) - f * 40.0f);
        quaternion.method_4925(quaternion2);
        quaternion.method_4925(quaternion3);
        matrixStack2.method_22907(quaternion);
        class_308.method_34742();
        class_898 entityRenderDispatcher = class_310.method_1551().method_1561();
        quaternion2.method_4926();
        entityRenderDispatcher.method_24196(quaternion2);
        entityRenderDispatcher.method_3948(false);
        class_4597.class_4598 immediate = class_310.method_1551().method_22940().method_23000();
        RenderSystem.runAsFancy(() -> entityRenderDispatcher.method_3954(entity, 0.0, 0.0, 0.0, 0.0f, 1.0f, matrixStack2, (class_4597)immediate, 0xF000F0));
        immediate.method_22993();
        entityRenderDispatcher.method_3948(true);
        matrixStack.method_22909();
        RenderSystem.applyModelViewMatrix();
        class_308.method_24211();
    }

    public static void drawEntityGeneric(class_1297 entity, float size, float x, float y, float rotateX, float rotateY, float rotateZ) {
        class_4587 matrixStack = RenderSystem.getModelViewStack();
        matrixStack.method_22903();
        matrixStack.method_22904((double)x, (double)y, 1010.0);
        matrixStack.method_22905(1.0f, 1.0f, -1.0f);
        RenderSystem.applyModelViewMatrix();
        class_4587 matrixStack2 = new class_4587();
        matrixStack2.method_22904(0.0, 0.0, 1000.0);
        matrixStack2.method_22905(size, size, size);
        class_1158 quaternion = class_1160.field_20707.method_23214(180.0f + rotateZ);
        class_1158 quaternion2 = class_1160.field_20703.method_23214(rotateX);
        class_1158 quaternion3 = class_1160.field_20705.method_23214(rotateY);
        quaternion.method_4925(quaternion2);
        quaternion.method_4925(quaternion3);
        matrixStack2.method_22907(quaternion);
        class_308.method_34742();
        class_898 entityRenderDispatcher = class_310.method_1551().method_1561();
        quaternion3.method_4926();
        entityRenderDispatcher.method_24196(quaternion3);
        entityRenderDispatcher.method_3948(false);
        class_4597.class_4598 immediate = class_310.method_1551().method_22940().method_23000();
        RenderSystem.runAsFancy(() -> entityRenderDispatcher.method_3954(entity, 0.0, 0.0, 0.0, 0.0f, 1.0f, matrixStack2, (class_4597)immediate, 0xF000F0));
        immediate.method_22993();
        entityRenderDispatcher.method_3948(true);
        matrixStack.method_22909();
        RenderSystem.applyModelViewMatrix();
        class_308.method_24211();
    }

    public static void drawRectangle(class_4587 matrices, int color, float z, float x0, float y0, float x1, float y1) {
        GenericHandledScreen.drawQuadrilateral(matrices, color, z, x0, y0, x1, y0, x0, y1, x1, y1);
    }

    public static void drawRectangle(class_4587 matrices, int color, float radius, float z, float x0, float y0, float x1, float y1) {
        GenericHandledScreen.drawHorizontalLine(matrices, color, radius, z, x0, x1, y0);
        GenericHandledScreen.drawHorizontalLine(matrices, color, radius, z, x0, x1, y1);
        GenericHandledScreen.drawVerticalLine(matrices, color, radius, z, x0, y0, y1);
        GenericHandledScreen.drawVerticalLine(matrices, color, radius, z, x1, y0, y1);
    }

    public static void drawHorizontalLine(class_4587 matrices, int color, float radius, float z, float x0, float x1, float y) {
        GenericHandledScreen.drawQuadrilateral(matrices, color, z, x0, y - radius, x1, y - radius, x0, y + radius, x1, y + radius);
    }

    public static void drawVerticalLine(class_4587 matrices, int color, float radius, float z, float x, float y0, float y1) {
        GenericHandledScreen.drawQuadrilateral(matrices, color, z, x - radius, y0, x + radius, y0, x - radius, y1, x + radius, y1);
    }

    public static void drawQuadrilateral(class_4587 matrices, int color, float z, float x0, float y0, float x1, float y1, float x2, float y2, float x3, float y3) {
        class_1159 model = matrices.method_23760().method_23761();
        int a = color >> 24 & 0xFF;
        int r = color >> 16 & 0xFF;
        int g = color >> 8 & 0xFF;
        int b = color & 0xFF;
        class_287 bufferBuilder = class_289.method_1348().method_1349();
        RenderSystem.enableBlend();
        RenderSystem.disableTexture();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader(class_757::method_34540);
        bufferBuilder.method_1328(class_293.class_5596.field_27382, class_290.field_1576);
        bufferBuilder.method_22918(model, x0, y0, z).method_1336(r, g, b, a).method_1344();
        bufferBuilder.method_22918(model, x2, y2, z).method_1336(r, g, b, a).method_1344();
        bufferBuilder.method_22918(model, x3, y3, z).method_1336(r, g, b, a).method_1344();
        bufferBuilder.method_22918(model, x1, y1, z).method_1336(r, g, b, a).method_1344();
        bufferBuilder.method_1326();
        class_286.method_1309((class_287)bufferBuilder);
        RenderSystem.enableTexture();
        RenderSystem.disableBlend();
    }

    public static void drawTextureNormally(class_4587 matrices, float tw, float th, float w, float h, float z, float x, float y, float u, float v) {
        GenericHandledScreen.drawTextureQuadrilateral(matrices, tw, th, z, x, y, x + w, y, x, y + h, x + w, y + h, u, v, u + w, v, u, v + h, u + w, v + h);
    }

    public static void drawTextureNormally(class_4587 matrices, float tw, float th, float z, float x0, float y0, float x1, float y1, float u0, float v0, float u1, float v1) {
        GenericHandledScreen.drawTextureQuadrilateral(matrices, tw, th, z, x0, y0, x1, y0, x0, y1, x1, y1, u0, v0, u1, v0, u0, v1, u1, v1);
    }

    public static void drawTextureFlippedHorizontally(class_4587 matrices, float tw, float th, float w, float h, float z, float x, float y, float u, float v) {
        GenericHandledScreen.drawTextureQuadrilateral(matrices, tw, th, z, x, y, x + w, y, x, y + h, x + w, y + h, u + w, v, u, v, u + w, v + h, u, v + h);
    }

    public static void drawTextureFlippedHorizontally(class_4587 matrices, float tw, float th, float z, float x0, float y0, float x1, float y1, float u0, float v0, float u1, float v1) {
        GenericHandledScreen.drawTextureQuadrilateral(matrices, tw, th, z, x0, y0, x1, y0, x0, y1, x1, y1, u1, v0, u0, v0, u1, v1, u0, v1);
    }

    public static void drawTextureFlippedVertically(class_4587 matrices, float tw, float th, float z, float x0, float y0, float x1, float y1, float u0, float v0, float u1, float v1) {
        GenericHandledScreen.drawTextureQuadrilateral(matrices, tw, th, z, x0, y0, x1, y0, x0, y1, x1, y1, u0, v1, u1, v1, u0, v0, u1, v0);
    }

    public static void drawTextureRotated180(class_4587 matrices, float tw, float th, float w, float h, float z, float x, float y, float u, float v) {
        GenericHandledScreen.drawTextureQuadrilateral(matrices, tw, th, z, x, y, x + w, y, x, y + h, x + w, y + h, u + w, v + h, u, v + h, u + w, v, u, v);
    }

    public static void drawTextureRotated180(class_4587 matrices, float tw, float th, float z, float x0, float y0, float x1, float y1, float u0, float v0, float u1, float v1) {
        GenericHandledScreen.drawTextureQuadrilateral(matrices, tw, th, z, x0, y0, x1, y0, x0, y1, x1, y1, u1, v1, u0, v1, u1, v0, u0, v0);
    }

    public static void drawTextureQuadrilateral(class_4587 matrices, float textureWidth, float textureHeight, float z, float x0, float y0, float x1, float y1, float x2, float y2, float x3, float y3, float u0, float v0, float u1, float v1, float u2, float v2, float u3, float v3) {
        u0 /= textureWidth;
        v0 /= textureHeight;
        u1 /= textureWidth;
        v1 /= textureHeight;
        u2 /= textureWidth;
        v2 /= textureHeight;
        u3 /= textureWidth;
        v3 /= textureHeight;
        class_1159 model = matrices.method_23760().method_23761();
        RenderSystem.setShader(class_757::method_34542);
        class_287 bufferBuilder = class_289.method_1348().method_1349();
        bufferBuilder.method_1328(class_293.class_5596.field_27382, class_290.field_1585);
        bufferBuilder.method_22918(model, x0, y0, z).method_22913(u0, v0).method_1344();
        bufferBuilder.method_22918(model, x2, y2, z).method_22913(u2, v2).method_1344();
        bufferBuilder.method_22918(model, x3, y3, z).method_22913(u3, v3).method_1344();
        bufferBuilder.method_22918(model, x1, y1, z).method_22913(u1, v1).method_1344();
        bufferBuilder.method_1326();
        class_286.method_1309((class_287)bufferBuilder);
    }

    public void drawText(class_4587 matrices, String text, int color, float x, float y) {
        this.field_22793.method_1729(matrices, text, x, y, color);
    }

    public void drawText(class_4587 matrices, class_2561 text, int color, float x, float y) {
        this.field_22793.method_30883(matrices, text, x, y, color);
    }

    public void drawText(class_4587 matrices, String text, int color, float size, float x, float y) {
        class_4587 matrixStack = GenericHandledScreen.matrixScaleOn(size, size, size);
        this.field_22793.method_1729(matrices, text, x / size, y / size, color);
        GenericHandledScreen.matrixScaleOff(matrixStack);
    }

    public void drawText(class_4587 matrices, class_2561 text, int color, float size, float x, float y) {
        class_4587 matrixStack = GenericHandledScreen.matrixScaleOn(size, size, size);
        this.field_22793.method_30883(matrices, text, x / size, y / size, color);
        GenericHandledScreen.matrixScaleOff(matrixStack);
    }

    public void drawTextCenteredX(class_4587 matrices, class_2561 text, int color, float xMid, float y) {
        int w2 = this.field_22793.method_27525((class_5348)text) >> 1;
        this.drawText(matrices, text, color, xMid - (float)w2, y);
    }

    public void drawTextCenteredX(class_4587 matrices, String text, int color, float size, float xMid, float y) {
        float w2 = (float)(this.field_22793.method_1727(text) >> 1) * size;
        this.drawText(matrices, text, color, size, xMid - w2, y);
    }

    public void drawTextCenteredX(class_4587 matrices, class_2561 text, int color, float size, float xMid, float y) {
        float w2 = (float)(this.field_22793.method_27525((class_5348)text) >> 1) * size;
        this.drawText(matrices, text, color, size, xMid - w2, y);
    }

    public void renderTooltip(class_4587 matrices, @NotNull List<class_5481> lines, float size, int x, int y) {
        class_5684 tooltipComponent2;
        int s;
        int k;
        List components = lines.stream().map(class_5684::method_32662).collect(Collectors.toList());
        if (components.isEmpty()) {
            return;
        }
        int i = 0;
        int j = components.size() == 1 ? -2 : 0;
        for (class_5684 tooltipComponent : components) {
            k = tooltipComponent.method_32664(this.field_22793);
            if (k > i) {
                i = k;
            }
            j += tooltipComponent.method_32661();
        }
        int xx = (int)((float)(x + 2) / size);
        int yy = (int)((float)(y + 2) / size);
        k = i;
        int m = j;
        int ww = (int)((float)this.field_22789 / size);
        int hh = (int)((float)this.field_22790 / size);
        if (xx + i + 6 > ww) {
            xx = ww - i - 6;
        }
        class_4587 matrixStack = GenericHandledScreen.matrixScaleOn(size, size, size);
        matrices.method_22903();
        int n = -267386864;
        int o = 0x505000FF;
        int p = 1344798847;
        int q = 400;
        float f = this.field_22788.field_4730;
        this.field_22788.field_4730 = q;
        class_289 tessellator = class_289.method_1348();
        class_287 bufferBuilder = tessellator.method_1349();
        RenderSystem.setShader(class_757::method_34540);
        bufferBuilder.method_1328(class_293.class_5596.field_27382, class_290.field_1576);
        class_1159 matrix4f = matrices.method_23760().method_23761();
        class_437.method_27533((class_1159)matrix4f, (class_287)bufferBuilder, (int)(xx - 3), (int)(yy - 4), (int)(xx + k + 3), (int)(yy - 3), (int)q, (int)n, (int)n);
        class_437.method_27533((class_1159)matrix4f, (class_287)bufferBuilder, (int)(xx - 3), (int)(yy + m + 3), (int)(xx + k + 3), (int)(yy + m + 4), (int)q, (int)n, (int)n);
        class_437.method_27533((class_1159)matrix4f, (class_287)bufferBuilder, (int)(xx - 3), (int)(yy - 3), (int)(xx + k + 3), (int)(yy + m + 3), (int)q, (int)n, (int)n);
        class_437.method_27533((class_1159)matrix4f, (class_287)bufferBuilder, (int)(xx - 4), (int)(yy - 3), (int)(xx - 3), (int)(yy + m + 3), (int)q, (int)n, (int)n);
        class_437.method_27533((class_1159)matrix4f, (class_287)bufferBuilder, (int)(xx + k + 3), (int)(yy - 3), (int)(xx + k + 4), (int)(yy + m + 3), (int)q, (int)n, (int)n);
        class_437.method_27533((class_1159)matrix4f, (class_287)bufferBuilder, (int)(xx - 3), (int)(yy - 3 + 1), (int)(xx - 3 + 1), (int)(yy + m + 3 - 1), (int)q, (int)o, (int)p);
        class_437.method_27533((class_1159)matrix4f, (class_287)bufferBuilder, (int)(xx + k + 2), (int)(yy - 3 + 1), (int)(xx + k + 3), (int)(yy + m + 3 - 1), (int)q, (int)o, (int)p);
        class_437.method_27533((class_1159)matrix4f, (class_287)bufferBuilder, (int)(xx - 3), (int)(yy - 3), (int)(xx + k + 3), (int)(yy - 3 + 1), (int)q, (int)o, (int)o);
        class_437.method_27533((class_1159)matrix4f, (class_287)bufferBuilder, (int)(xx - 3), (int)(yy + m + 2), (int)(xx + k + 3), (int)(yy + m + 3), (int)q, (int)p, (int)p);
        RenderSystem.enableDepthTest();
        RenderSystem.disableTexture();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        bufferBuilder.method_1326();
        class_286.method_1309((class_287)bufferBuilder);
        RenderSystem.disableBlend();
        RenderSystem.enableTexture();
        class_4597.class_4598 immediate = class_4597.method_22991((class_287)class_289.method_1348().method_1349());
        matrices.method_22904(0.0, 0.0, (double)q);
        int r = yy;
        for (s = 0; s < components.size(); ++s) {
            tooltipComponent2 = (class_5684)components.get(s);
            tooltipComponent2.method_32665(this.field_22793, xx, r, matrix4f, immediate);
            r += tooltipComponent2.method_32661() + (s == 0 ? 2 : 0);
        }
        immediate.method_22993();
        matrices.method_22909();
        r = yy;
        for (s = 0; s < components.size(); ++s) {
            tooltipComponent2 = (class_5684)components.get(s);
            tooltipComponent2.method_32666(this.field_22793, xx, r, matrices, this.field_22788, q);
            r += tooltipComponent2.method_32661() + (s == 0 ? 2 : 0);
        }
        this.field_22788.field_4730 = f;
        GenericHandledScreen.matrixScaleOff(matrixStack);
    }
}

