/*
 * Decompiled with CFR 0.152.
 */
package xienaoban.minecraft.bole.gui.screen.entity;

import java.util.Arrays;
import java.util.Objects;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1646;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1743;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1829;
import net.minecraft.class_1835;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2374;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import net.minecraft.class_310;
import net.minecraft.class_3854;
import net.minecraft.class_4208;
import net.minecraft.class_4587;
import net.minecraft.class_638;
import xienaoban.minecraft.bole.BoleClient;
import xienaoban.minecraft.bole.client.highlight.HighlightManager;
import xienaoban.minecraft.bole.gui.screen.AbstractBoleScreen;
import xienaoban.minecraft.bole.gui.screen.GenericHandledScreen;
import xienaoban.minecraft.bole.gui.screen.entity.BoleVillagerEntityScreenHandler;
import xienaoban.minecraft.bole.gui.screen.tree.BoleEntityScreen;
import xienaoban.minecraft.bole.gui.screen.tree.BoleMerchantEntityScreen;
import xienaoban.minecraft.bole.util.MiscUtil;

@Environment(value=EnvType.CLIENT)
public class BoleVillagerEntityScreen<E extends class_1646, H extends BoleVillagerEntityScreenHandler<E>>
extends BoleMerchantEntityScreen<E, H> {
    public BoleVillagerEntityScreen(H handler, class_1661 inventory, class_2561 title) {
        super(handler, inventory, title);
    }

    @Override
    protected void initPages() {
        super.initPages();
        ((AbstractBoleScreen.Page)this.pages.get(1)).addSlotLazyAfter(new ClothingPropertyWidget(), null).addSlotLazy(new JobSitePropertyWidget()).addSlotLazy(new RestockPropertyWidget());
    }

    @Override
    protected void initCustom() {
    }

    @Override
    protected void drawLeftContent(class_4587 matrices, float delta, int x, int y, int mouseX, int mouseY) {
        super.drawLeftContent(matrices, delta, x, y, mouseX, mouseY);
    }

    @Override
    protected void drawRightContent(class_4587 matrices, float delta, int x, int y, int mouseX, int mouseY) {
        super.drawRightContent(matrices, delta, x, y, mouseX, mouseY);
    }

    public class ClothingPropertyWidget
    extends BoleEntityScreen.VariantsPropertyWidget {
        private static final class_3854[] CLOTHES = new class_3854[]{class_3854.field_17073, class_3854.field_17077, class_3854.field_17071, class_3854.field_17072, class_3854.field_17074, class_3854.field_17075, class_3854.field_17076};

        public ClothingPropertyWidget() {
            super(BoleVillagerEntityScreen.this, 4, 3);
        }

        @Override
        protected void initTooltipLines() {
            this.initTooltipTitle("property_widget.bole.villager_clothing");
            this.initTooltipDescription("property_widget.bole.villager_clothing.description");
        }

        @Override
        protected E[] initEntities() {
            class_1646[] entities = new class_1646[CLOTHES.length];
            for (int i = 0; i < CLOTHES.length; ++i) {
                class_1646 entity = (class_1646)((class_1646)((BoleVillagerEntityScreenHandler)((BoleVillagerEntityScreen)BoleVillagerEntityScreen.this).field_2797).entity).method_5864().method_5883((class_1937)class_310.method_1551().field_1687);
                if (entity == null) {
                    throw new RuntimeException("Failed to create a VillagerEntity on the client side.");
                }
                GenericHandledScreen.copyEntityNbtForDisplay((class_1646)((BoleVillagerEntityScreenHandler)((BoleVillagerEntityScreen)BoleVillagerEntityScreen.this).field_2797).entity, entity);
                entity.method_7195(entity.method_7231().method_16922(CLOTHES[i]));
                entities[i] = entity;
            }
            return (class_1646[])MiscUtil.cast(entities);
        }

        @Override
        protected class_2561[] initNames() {
            return (class_2561[])Arrays.stream(CLOTHES).map(type -> new class_2588("entity.minecraft.villager.clothing." + type.toString())).toArray(class_2561[]::new);
        }

        @Override
        protected boolean canChoose() {
            return true;
        }

        @Override
        protected boolean isChosen(E fake) {
            return ((class_1646)((BoleVillagerEntityScreenHandler)((BoleVillagerEntityScreen)BoleVillagerEntityScreen.this).field_2797).entity).method_7231().method_16919() == fake.method_7231().method_16919();
        }

        @Override
        protected void setChosen(E fake) {
            class_3854 type = fake.method_7231().method_16919();
            ((BoleVillagerEntityScreenHandler)BoleVillagerEntityScreen.this.field_2797).sendClientEntitySettings("villager_clothing", type);
        }
    }

    public class JobSitePropertyWidget
    extends AbstractBoleScreen.TemplatePropertyWidget1 {
        private int lastTicks;
        private class_2561 cacheDistance;

        public JobSitePropertyWidget() {
            super(BoleVillagerEntityScreen.this, 2, true, 2);
            this.lastTicks = -123456;
            this.cacheDistance = new class_2585(" - ");
        }

        @Override
        protected void initTooltipLines() {
            this.initTooltipTitle("property_widget.bole.villager_job_site");
            this.initTooltipDescription("property_widget.bole.villager_job_site.description");
            this.initTooltipEmptyLine();
            this.initTooltipButtonDescription("property_widget.bole.villager_job_site.description.button1");
            this.initTooltipButtonDescription("property_widget.bole.villager_job_site.description.button2");
        }

        @Override
        protected void drawContent(class_4587 matrices, int x, int y, int mouseX, int mouseY) {
            class_4208 pos = ((BoleVillagerEntityScreenHandler)((BoleVillagerEntityScreen)BoleVillagerEntityScreen.this).field_2797).entityJobSitePos;
            this.drawIcon(matrices, 170, 0);
            this.drawButton(matrices, 0, 230, 30 - (pos != null ? 0 : 20));
            this.drawButton(matrices, 1, 240, 20);
            int cutTicks = BoleClient.getInstance().getScreenTicks();
            if (cutTicks - this.lastTicks > 10) {
                this.lastTicks = cutTicks;
                if (pos != null) {
                    double dis = pos.method_19446().method_19770((class_2374)((class_1646)((BoleVillagerEntityScreenHandler)((BoleVillagerEntityScreen)BoleVillagerEntityScreen.this).field_2797).entity).method_19538());
                    this.cacheDistance = new class_2585(String.format("%.2fm", Math.sqrt(dis)));
                }
            }
            this.drawBarText(matrices, this.cacheDistance, -1072557550);
        }

        public boolean method_25402(double mouseX, double mouseY, int button) {
            int index = this.calMousePosition(mouseX, mouseY);
            if (index < 2 || button != 0) {
                return false;
            }
            switch (index) {
                case 2: {
                    class_4208 pos = ((BoleVillagerEntityScreenHandler)((BoleVillagerEntityScreen)BoleVillagerEntityScreen.this).field_2797).entityJobSitePos;
                    if (!((BoleVillagerEntityScreenHandler)BoleVillagerEntityScreen.this.field_2797).hasJob()) {
                        BoleVillagerEntityScreen.this.showOverlayMessage("text.hint.bole.no_job");
                        break;
                    }
                    if (pos == null) {
                        BoleVillagerEntityScreen.this.showOverlayMessage("text.hint.bole.no_job_site");
                        break;
                    }
                    if (!Objects.equals(pos.method_19442(), ((class_1646)((BoleVillagerEntityScreenHandler)((BoleVillagerEntityScreen)BoleVillagerEntityScreen.this).field_2797).entity).field_6002.method_27983())) {
                        BoleVillagerEntityScreen.this.showOverlayMessage("text.hint.bole.job_site_different_dimension");
                        break;
                    }
                    HighlightManager hl = BoleClient.getInstance().getHighlightManager();
                    hl.setHighlightedJobSiteOrBeehive(hl.highlight(pos, 120));
                    BoleVillagerEntityScreen.this.method_25419();
                    break;
                }
                case 3: {
                    class_1657 player = ((BoleVillagerEntityScreenHandler)((BoleVillagerEntityScreen)BoleVillagerEntityScreen.this).field_2797).player;
                    class_1792 mainItem = player.method_6047().method_7909();
                    class_1792 offItem = player.method_6079().method_7909();
                    if (mainItem instanceof class_1829 || offItem instanceof class_1829 || mainItem instanceof class_1743 || offItem instanceof class_1743 || mainItem instanceof class_1835 || offItem instanceof class_1835) {
                        BoleVillagerEntityScreen.this.setPopup(new AbstractBoleScreen.PopUpConfirmWindow(BoleVillagerEntityScreen.this, (class_2561)new class_2588("text.warning.bole.villager_reset_job"), () -> {
                            ((BoleVillagerEntityScreenHandler)BoleVillagerEntityScreen.this.field_2797).sendClientEntitySettings("reset_villager_job", new Object[0]);
                            BoleVillagerEntityScreen.this.method_25419();
                        }));
                        break;
                    }
                    BoleVillagerEntityScreen.this.showOverlayMessage("text.hint.bole.refuse_to_reset_job");
                }
            }
            return true;
        }
    }

    public class RestockPropertyWidget
    extends AbstractBoleScreen.TemplatePropertyWidget1 {
        private final class_1799 overTime;

        public RestockPropertyWidget() {
            super(BoleVillagerEntityScreen.this, 2, true, 1);
            this.overTime = new class_1799((class_1935)class_1802.field_8687, this.calOvertime());
        }

        @Override
        protected void initTooltipLines() {
            this.initTooltipTitle("property_widget.bole.villager_restock");
            this.initTooltipDescription("property_widget.bole.villager_restock.description");
            this.initTooltipEmptyLine();
            this.initTooltipButtonDescription("property_widget.bole.villager_restock.description.button1");
        }

        @Override
        protected void drawContent(class_4587 matrices, int x, int y, int mouseX, int mouseY) {
            int restocksToday = ((BoleVillagerEntityScreenHandler)((BoleVillagerEntityScreen)BoleVillagerEntityScreen.this).field_2797).entityRestocksToday;
            this.overTime.method_7939(this.calOvertime());
            this.drawIcon(matrices, 0, 110);
            this.drawBar(matrices, 1.0f, 10, 110);
            this.drawBar(matrices, (float)restocksToday / 3.0f, 50, 110);
            if (this.canRestock()) {
                this.drawButton(matrices, 0, this.overTime);
            } else {
                this.drawButton(matrices, 0, 230, 10);
            }
            this.drawBarText(matrices, restocksToday + "/3", -1140850689);
        }

        public boolean method_25402(double mouseX, double mouseY, int button) {
            int index = this.calMousePosition(mouseX, mouseY);
            if (index != 2 || button != 0) {
                return false;
            }
            if (!((BoleVillagerEntityScreenHandler)BoleVillagerEntityScreen.this.field_2797).hasJob()) {
                BoleVillagerEntityScreen.this.showOverlayMessage("text.hint.bole.no_job");
            } else if (!this.canRestock()) {
                BoleVillagerEntityScreen.this.showOverlayMessage("text.hint.bole.far_from_job_site");
            } else if (!((BoleVillagerEntityScreenHandler)BoleVillagerEntityScreen.this.field_2797).trySpendItems(this.overTime)) {
                BoleVillagerEntityScreen.this.showOverlayMessage("text.hint.bole.not_enough_items");
            } else {
                ((BoleVillagerEntityScreenHandler)BoleVillagerEntityScreen.this.field_2797).sendClientEntitySettings("villager_restock", new Object[0]);
                this.overTime.method_7939(this.calOvertime());
            }
            return true;
        }

        private boolean canRestock() {
            class_4208 jobSite = ((BoleVillagerEntityScreenHandler)((BoleVillagerEntityScreen)BoleVillagerEntityScreen.this).field_2797).entityJobSitePos;
            class_638 world = class_310.method_1551().field_1687;
            if (jobSite == null || world == null) {
                return false;
            }
            return jobSite.method_19442() == world.method_27983() && jobSite.method_19446().method_19769((class_2374)((class_1646)((BoleVillagerEntityScreenHandler)((BoleVillagerEntityScreen)BoleVillagerEntityScreen.this).field_2797).entity).method_19538(), 1.73);
        }

        private int calOvertime() {
            return Math.max(0, ((BoleVillagerEntityScreenHandler)((BoleVillagerEntityScreen)BoleVillagerEntityScreen.this).field_2797).entityRestocksToday - 3 + 1) * 2;
        }
    }
}

