/*
 * Decompiled with CFR 0.152.
 */
package xienaoban.minecraft.bole.gui.screen.entity;

import java.util.Optional;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1297;
import net.minecraft.class_1646;
import net.minecraft.class_1661;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2382;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3852;
import net.minecraft.class_3854;
import net.minecraft.class_3917;
import net.minecraft.class_4140;
import net.minecraft.class_4208;
import net.minecraft.class_5321;
import xienaoban.minecraft.bole.Bole;
import xienaoban.minecraft.bole.gui.screen.AbstractBoleScreenHandler;
import xienaoban.minecraft.bole.gui.screen.tree.BoleMerchantEntityScreenHandler;
import xienaoban.minecraft.bole.mixin.IMixinVillagerEntity;

public class BoleVillagerEntityScreenHandler<E extends class_1646>
extends BoleMerchantEntityScreenHandler<E> {
    public static final class_3917<BoleVillagerEntityScreenHandler<class_1646>> HANDLER = BoleVillagerEntityScreenHandler.register(new class_2960("bole", "villager_entity"), BoleVillagerEntityScreenHandler::new);
    @Environment(value=EnvType.CLIENT)
    protected int entityRestocksToday;
    @Environment(value=EnvType.CLIENT)
    protected class_4208 entityJobSitePos;

    public BoleVillagerEntityScreenHandler(int syncId, class_1661 playerInventory) {
        this(HANDLER, syncId, playerInventory);
    }

    public BoleVillagerEntityScreenHandler(int syncId, class_1661 playerInventory, class_1297 entity) {
        this(HANDLER, syncId, playerInventory, entity);
    }

    public BoleVillagerEntityScreenHandler(class_3917<?> handler, int syncId, class_1661 playerInventory) {
        this(handler, syncId, playerInventory, BoleVillagerEntityScreenHandler.clientEntity());
    }

    public BoleVillagerEntityScreenHandler(class_3917<?> handler, int syncId, class_1661 playerInventory, class_1297 entity) {
        super(handler, syncId, playerInventory, entity);
        this.registerEntitySettingsBufHandlers();
    }

    private void registerEntitySettingsBufHandlers() {
        this.registerEntitySettingsBufHandler("reset_villager_job", new AbstractBoleScreenHandler.EntitySettingsBufHandler(){

            @Override
            public void readFromBuf(class_2540 buf) {
                ((class_1646)BoleVillagerEntityScreenHandler.this.entity).method_16917(null);
                ((class_1646)BoleVillagerEntityScreenHandler.this.entity).method_19625(0);
                ((class_1646)BoleVillagerEntityScreenHandler.this.entity).method_7195(((class_1646)BoleVillagerEntityScreenHandler.this.entity).method_7231().method_16920(1));
                ((class_1646)BoleVillagerEntityScreenHandler.this.entity).method_19179((class_3218)((class_1646)BoleVillagerEntityScreenHandler.this.entity).field_6002);
            }

            @Override
            public void writeToBuf(class_2540 buf, Object ... args) {
            }
        });
        this.registerEntitySettingsBufHandler("villager_restock", new AbstractBoleScreenHandler.EntitySettingsBufHandler(){

            @Override
            public void readFromBuf(class_2540 buf) {
                int cnt = Math.max(0, ((IMixinVillagerEntity)BoleVillagerEntityScreenHandler.this.entity).getRestocksToday() - 3 + 1) * 2;
                class_1799 overTime = new class_1799((class_1935)class_1802.field_8687, cnt);
                if (BoleVillagerEntityScreenHandler.this.trySpendItems(overTime)) {
                    ((class_1646)BoleVillagerEntityScreenHandler.this.entity).method_19183();
                    ((class_1646)BoleVillagerEntityScreenHandler.this.entity).method_19182();
                } else {
                    Bole.LOGGER.error("The player inventory data on the client and server are inconsistent.");
                }
            }

            @Override
            public void writeToBuf(class_2540 buf, Object ... args) {
                ++BoleVillagerEntityScreenHandler.this.entityRestocksToday;
            }
        });
        this.registerEntitySettingsBufHandler("villager_clothing", new AbstractBoleScreenHandler.EntitySettingsBufHandler(){

            @Override
            public void readFromBuf(class_2540 buf) {
                class_3854 type = (class_3854)class_2378.field_17166.method_10223(class_2960.method_12829((String)buf.method_19772()));
                ((class_1646)BoleVillagerEntityScreenHandler.this.entity).method_7195(((class_1646)BoleVillagerEntityScreenHandler.this.entity).method_7231().method_16922(type));
            }

            @Override
            public void writeToBuf(class_2540 buf, Object ... args) {
                class_3854 type = (class_3854)args[0];
                buf.method_10814(type.toString());
                ((class_1646)BoleVillagerEntityScreenHandler.this.entity).method_7195(((class_1646)BoleVillagerEntityScreenHandler.this.entity).method_7231().method_16922(type));
            }
        });
    }

    @Override
    protected void initServer() {
        super.initServer();
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    protected void initClient() {
        super.initClient();
    }

    @Override
    protected void initCustom() {
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void clientTick(int ticks) {
        super.clientTick(ticks);
    }

    @Override
    protected void writeServerEntityToBuf(class_2540 buf) {
        super.writeServerEntityToBuf(buf);
        buf.writeInt(((IMixinVillagerEntity)this.entity).getRestocksToday());
        Optional jobSite = ((class_1646)this.entity).method_18868().method_18904(class_4140.field_18439);
        buf.writeBoolean(jobSite.isPresent());
        if (jobSite.isPresent()) {
            class_4208 pos = (class_4208)jobSite.get();
            buf.method_10812(pos.method_19442().method_29177());
            buf.method_10807(pos.method_19446());
        }
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    protected void readServerEntityFromBuf(class_2540 buf) {
        super.readServerEntityFromBuf(buf);
        this.entityRestocksToday = buf.readInt();
        if (buf.readBoolean()) {
            class_5321 dimension = class_5321.method_29179((class_5321)class_2378.field_25298, (class_2960)buf.method_10810());
            class_2338 blockPos = new class_2338((class_2382)buf.method_10811());
            this.entityJobSitePos = class_4208.method_19443((class_5321)dimension, (class_2338)blockPos);
        } else {
            this.entityJobSitePos = null;
        }
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    protected void resetClientEntityServerProperties() {
        super.resetClientEntityServerProperties();
    }

    protected boolean hasJob() {
        return ((class_1646)this.entity).method_7231().method_16924() != class_3852.field_17051;
    }
}

