/*
 * Decompiled with CFR 0.152.
 */
package xienaoban.minecraft.bole.gui.screen.homepage;

import java.lang.reflect.Field;
import java.nio.file.Path;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import me.shedaniel.autoconfig.annotation.ConfigEntry;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1422;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1799;
import net.minecraft.class_1826;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_310;
import net.minecraft.class_3417;
import net.minecraft.class_3675;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import net.minecraft.class_5575;
import net.minecraft.class_5577;
import xienaoban.minecraft.bole.Bole;
import xienaoban.minecraft.bole.BoleClient;
import xienaoban.minecraft.bole.client.EntityManager;
import xienaoban.minecraft.bole.client.highlight.HighlightManager;
import xienaoban.minecraft.bole.config.Configs;
import xienaoban.minecraft.bole.core.BoleHandbookItem;
import xienaoban.minecraft.bole.gui.ScreenManager;
import xienaoban.minecraft.bole.gui.Textures;
import xienaoban.minecraft.bole.gui.screen.AbstractBoleScreen;
import xienaoban.minecraft.bole.gui.screen.GenericHandledScreen;
import xienaoban.minecraft.bole.gui.screen.homepage.BoleHomepageScreenHandler;
import xienaoban.minecraft.bole.gui.screen.homepage.BoleHomepageScreenState;
import xienaoban.minecraft.bole.mixin.IMixinEntity;
import xienaoban.minecraft.bole.mixin.IMixinWorld;
import xienaoban.minecraft.bole.network.ClientNetworkManager;
import xienaoban.minecraft.bole.util.Keys;

@Environment(value=EnvType.CLIENT)
public final class BoleHomepageScreen
extends AbstractBoleScreen<class_1297, BoleHomepageScreenHandler> {
    public BoleHomepageScreen(BoleHomepageScreenHandler handler, class_1661 inventory, class_2561 title) {
        super(handler, inventory, title);
    }

    @Override
    protected void method_25426() {
        super.method_25426();
        BoleHomepageScreenState state = BoleClient.getInstance().getHomepageScreenState();
        if (state != null && this.field_22787 != null) {
            BoleClient.getInstance().setHomepageScreenState(null);
            class_3675.method_15984((long)this.field_22787.method_22683().method_4490(), (int)212993, (double)state.getMouseX(), (double)state.getMouseY());
            ((class_4185)this.bookmarks.get(state.getBookmarkIndex())).method_25306();
            this.setPageIndex(state.getPageIndex());
            this.debugMode = state.isDebugMode();
        }
    }

    @Override
    protected void initPages() {
        this.initCatalog(EntityManager.getInstance().getTagGroups().get(0));
    }

    @Override
    protected void initCustom() {
    }

    @Override
    protected void initButtons() {
        super.initButtons();
        int cnt = 0;
        for (EntityManager.TagGroup tags : EntityManager.getInstance().getTagGroups()) {
            this.addBookmark(cnt, tags.getText(), button -> this.initCatalog(tags));
            ++cnt;
        }
        this.addBookmark(8, (class_2561)new class_2588("text.bole.settings"), button -> {
            this.resetPages();
            BoleClient boleClient = BoleClient.getInstance();
            AbstractBoleScreen.Page page = (AbstractBoleScreen.Page)this.pages.get(0);
            String setConfigKey = boleClient.isHost() ? "text.bole.set_configs_local_is_remote" : "text.bole.set_configs_local_is_not_remote";
            page.addSlot(new AbstractBoleScreen.LeftTextPropertyWidget(this, 4, 1, (class_2561)new class_2588(setConfigKey), -1072557550, 0.5f));
            page.addSlot(new OpenLocalConfigsPropertyWidget());
            page.addSlot(new AbstractBoleScreen.EmptyPropertyWidget(this, 4, 1));
            page.addSlot(new AbstractBoleScreen.LeftTextPropertyWidget(this, 4, 1, (class_2561)new class_2588("text.bole.other_client_configs"), -1072557550, 0.5f));
            page.addSlot(new CustomEntityOrderPropertyWidget());
            page = new AbstractBoleScreen.Page(this);
            this.pages.add(page);
            String curConfigKey = boleClient.isHost() ? "text.bole.get_configs_local_is_remote" : "text.bole.get_configs_local_is_not_remote";
            page.addSlot(new AbstractBoleScreen.LeftTextPropertyWidget(this, 4, 1, (class_2561)new class_2588("text.bole.server_mod_version", new Object[]{Bole.getInstance().getServerVersion()}), -1072557550, 0.5f));
            page.addSlot(new AbstractBoleScreen.LeftTextPropertyWidget(this, 4, 1, (class_2561)new class_2588(curConfigKey), -1072557550, 0.5f));
            for (Field field : Configs.class.getDeclaredFields()) {
                String name;
                boolean success;
                if (field.isAnnotationPresent(ConfigEntry.Gui.Excluded.class) || "default".equals(field.getAnnotation(ConfigEntry.Category.class).value()) || (success = page.addSlot(new ConfigItemPropertyWidget(name = field.getName())))) continue;
                page = new AbstractBoleScreen.Page(this);
                this.pages.add(page);
                page.addSlot(new ConfigItemPropertyWidget(name));
            }
            this.setPageIndex(0);
        });
        this.addBookmark(9, (class_2561)new class_2588("text.bole.about"), button -> {
            this.resetPages();
            this.pages.add(new AbstractBoleScreen.Page(this));
            AbstractBoleScreen.Page page0 = (AbstractBoleScreen.Page)this.pages.get(0);
            AbstractBoleScreen.Page page1 = (AbstractBoleScreen.Page)this.pages.get(1);
            page0.addSlot(new AbstractBoleScreen.CenteredTextPropertyWidget(this, 4, 1, (class_2561)new class_2588("text.bole.mod_name_is", new Object[]{new class_2588("bole")}), -1072557550, 0.5f));
            page0.addSlot(new AbstractBoleScreen.CenteredTextPropertyWidget(this, 4, 1, (class_2561)new class_2588("text.bole.mod_author_is", new Object[]{new class_2588("xienaoban.trans")}), -1072557550, 0.5f));
            FabricLoader.getInstance().getModContainer("bole").ifPresent(modContainer -> page0.addSlot(new AbstractBoleScreen.CenteredTextPropertyWidget(this, 4, 1, (class_2561)new class_2588("text.bole.mod_version_is", new Object[]{modContainer.getMetadata().getVersion()}), -1072557550, 0.5f)));
            page1.addSlot(new OpenDebugPropertyWidget());
            page1.addSlot(new GiveBookPropertyWidget());
            page1.addSlot(new ReorderPropertyWidget());
            page1.addSlot(new CrashClientPropertyWidget());
            this.setPageIndex(0);
        });
    }

    @Override
    protected void drawLeftContent(class_4587 matrices, float delta, int x, int y, int mouseX, int mouseY) {
        super.drawLeftContent(matrices, delta, x, y, mouseX, mouseY);
    }

    @Override
    protected void drawRightContent(class_4587 matrices, float delta, int x, int y, int mouseX, int mouseY) {
        super.drawRightContent(matrices, delta, x, y, mouseX, mouseY);
    }

    private void initCatalog(EntityManager.TagGroup group) {
        this.resetPages();
        ((AbstractBoleScreen.Page)this.pages.get(0)).addSlot(new AbstractBoleScreen.LeftTextPropertyWidget(this, 4, 1, (class_2561)new class_2588(group.getName() + ".description"), -1072557550, 0.5f));
        group.dfsTags((root, depth) -> {
            int index = 0;
            while (!((AbstractBoleScreen.Page)this.pages.get(index)).addSlot(new TagItemPropertyWidget(depth, (EntityManager.Tag)root))) {
                if (this.pages.size() != ++index) continue;
                this.pages.add(new AbstractBoleScreen.Page(this));
            }
            return true;
        });
        this.setPageIndex(0);
    }

    public class TagItemPropertyWidget
    extends AbstractBoleScreen.AbstractPropertyWidget {
        private static final int TAB = 5;
        private final int sub;
        private final EntityManager.Tag tag;
        private final class_2561 text;

        public TagItemPropertyWidget(int sub, EntityManager.Tag tag) {
            super(BoleHomepageScreen.this, 4, 1);
            this.sub = sub;
            this.tag = tag;
            this.text = new class_2588(tag.getName()).method_27693(" (" + tag.getEntities().size() + ")");
        }

        @Override
        protected void initTooltipLines() {
        }

        @Override
        protected void drawContent(class_4587 matrices, int x, int y, int mouseX, int mouseY) {
            GenericHandledScreen.setTexture(Textures.ICONS);
            int xBase = x + this.sub * 5;
            GenericHandledScreen.drawTextureNormally(matrices, 256.0f, 256.0f, 10.0f, 10.0f, BoleHomepageScreen.this.method_25305(), xBase, y, 220.0f, 40.0f);
            GenericHandledScreen.drawTextureNormally(matrices, 256.0f, 256.0f, 30.0f, 10.0f, BoleHomepageScreen.this.method_25305(), xBase + 10, y, 0.0f, 200.0f);
            this.drawName(matrices, -1339940318);
        }

        @Override
        public void drawHovered(class_4587 matrices, int mouseX, int mouseY) {
            super.drawHovered(matrices, mouseX, mouseY);
            this.drawName(matrices, -16777216);
        }

        private void drawName(class_4587 matrices, int color) {
            if (this.sub < 0) {
                BoleHomepageScreen.this.drawText(matrices, this.text, color, 1.0f, (float)(this.box.left() + 12 - this.sub * 5), (float)(this.box.top() + 1));
            } else {
                BoleHomepageScreen.this.drawText(matrices, this.text, color, 0.5f, (float)(this.box.left() + 12 + this.sub * 5), (float)this.box.top() + 3.25f);
            }
        }

        public boolean method_25402(double mouseX, double mouseY, int button) {
            BoleHomepageScreen.this.resetPages();
            int index = 0;
            for (EntityManager.EntityInfo entityInfo : this.tag.getEntities()) {
                while (!((AbstractBoleScreen.Page)BoleHomepageScreen.this.pages.get(index)).addSlot(new LivingEntityPropertyWidget(entityInfo.getType()))) {
                    if (BoleHomepageScreen.this.pages.size() != ++index) continue;
                    BoleHomepageScreen.this.pages.add(new AbstractBoleScreen.Page(BoleHomepageScreen.this));
                }
            }
            BoleHomepageScreen.this.setPageIndex(0);
            GenericHandledScreen.playScreenSound(class_3417.field_15105, 0.5f, 1.5f);
            return true;
        }
    }

    public class OpenDebugPropertyWidget
    extends AbstractBoleScreen.AbstractPropertyWidget {
        public OpenDebugPropertyWidget() {
            super(BoleHomepageScreen.this, 4, 1);
        }

        @Override
        protected void initTooltipLines() {
        }

        @Override
        protected void drawContent(class_4587 matrices, int x, int y, int mouseX, int mouseY) {
            BoleHomepageScreen.this.drawTextCenteredX(matrices, "-= Bole Debug Mode (Press R-ALT) =-", -3399134, 0.5f, (float)(this.box.left() + this.box.right() >> 1), (float)this.box.top() + 3.0f);
        }

        public boolean method_25402(double mouseX, double mouseY, int button) {
            BoleHomepageScreen.this.debugMode = !BoleHomepageScreen.this.debugMode;
            GenericHandledScreen.playScreenSound(class_3417.field_15015, 0.5f, 1.0f);
            return true;
        }
    }

    public class GiveBookPropertyWidget
    extends DebugPropertyWidget {
        public GiveBookPropertyWidget() {
            super("-= Get a Bole Handbook =-");
        }

        @Override
        protected boolean onMouseClick() {
            if (BoleHomepageScreen.this.isGod()) {
                if (BoleHomepageScreen.this.field_22787 != null && ((BoleHomepageScreen)BoleHomepageScreen.this).field_22787.field_1724 != null) {
                    ((BoleHomepageScreen)BoleHomepageScreen.this).field_22787.field_1724.method_31548().method_7394(BoleHandbookItem.createBook());
                }
                ClientNetworkManager.requestBoleHandbook();
                GenericHandledScreen.playScreenSound(class_3417.field_15197, 1.0f, 1.0f);
            } else {
                BoleHomepageScreen.this.showOverlayMessage("text.hint.bole.only_in_god_mode");
            }
            return true;
        }
    }

    public class ReorderPropertyWidget
    extends DebugPropertyWidget {
        public ReorderPropertyWidget() {
            super("-= Reorder Entities In Homepage =-");
        }

        @Override
        public boolean onMouseClick() {
            EntityManager.getInstance().reorderAllEntities();
            return true;
        }
    }

    public class CrashClientPropertyWidget
    extends DebugPropertyWidget {
        public CrashClientPropertyWidget() {
            super("-= Crash the Client =-");
        }

        @Override
        public boolean onMouseClick() {
            throw new NullPointerException("Surprise~~");
        }
    }

    public class OpenLocalConfigsPropertyWidget
    extends AbstractBoleScreen.AbstractPropertyWidget {
        private final class_2561 title;

        public OpenLocalConfigsPropertyWidget() {
            super(BoleHomepageScreen.this, 4, 1);
            this.title = new class_2588("text.bole.open_local_configs");
        }

        protected OpenLocalConfigsPropertyWidget(class_2561 title) {
            super(BoleHomepageScreen.this, 4, 1);
            this.title = title;
        }

        @Override
        protected void initTooltipLines() {
        }

        @Override
        protected void drawContent(class_4587 matrices, int x, int y, int mouseX, int mouseY) {
            GenericHandledScreen.setTexture(Textures.ICONS);
            int v = this.isHovered() ? 220 : 230;
            GenericHandledScreen.drawTextureNormally(matrices, 256.0f, 256.0f, 30.0f, 10.0f, BoleHomepageScreen.this.method_25305(), x, y, 0.0f, v);
            GenericHandledScreen.drawTextureRotated180(matrices, 256.0f, 256.0f, 30.0f, 10.0f, BoleHomepageScreen.this.method_25305(), x + this.box.width() - 30, y, 0.0f, v);
            BoleHomepageScreen.this.drawTextCenteredX(matrices, this.title, -1072557550, 0.5f, (float)(this.box.left() + this.box.right() >> 1), (float)this.box.top() + 3.0f);
        }

        public boolean method_25402(double mouseX, double mouseY, int button) {
            BoleHomepageScreen.this.setHovered(null);
            assert (BoleHomepageScreen.this.field_22787 != null);
            GenericHandledScreen.playScreenSound(class_3417.field_15105, 0.5f, 1.5f);
            BoleHomepageScreen.this.field_22787.method_1507(ScreenManager.getConfigScreen((class_437)BoleHomepageScreen.this));
            return true;
        }
    }

    public class CustomEntityOrderPropertyWidget
    extends OpenLocalConfigsPropertyWidget {
        public CustomEntityOrderPropertyWidget() {
            super((class_2561)new class_2588("text.bole.custom_entity_order_config"));
        }

        @Override
        protected void initTooltipLines() {
            Path orderPath = Keys.ENTITY_SORT_ORDER_CONFIG_PATH();
            class_5250 text = new class_2588("text.bole.custom_entity_order_config.description", new Object[]{orderPath.toAbsolutePath().toString()}).method_27692(class_124.field_1080);
            List lines = class_310.method_1551().field_1772.method_1728((class_5348)text, 6000);
            this.tooltipLines.addAll(lines);
        }

        @Override
        public boolean method_25402(double mouseX, double mouseY, int button) {
            EntityManager.getInstance().reorderAllEntities();
            GenericHandledScreen.playScreenSound(class_3417.field_15105, 0.5f, 1.5f);
            return true;
        }
    }

    public class ConfigItemPropertyWidget
    extends AbstractBoleScreen.AbstractPropertyWidget {
        private final Field field;
        private final class_2561 name;

        public ConfigItemPropertyWidget(String attr) {
            super(BoleHomepageScreen.this, 4, 1);
            try {
                this.field = Configs.class.getDeclaredField(attr);
                this.field.setAccessible(true);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            this.name = new class_2588("text.autoconfig.bole.option." + attr);
            this.initTooltipDescription("text.autoconfig.bole.option." + attr + ".@Tooltip");
        }

        @Override
        protected void initTooltipLines() {
        }

        @Override
        protected void drawContent(class_4587 matrices, int x, int y, int mouseX, int mouseY) {
            class_2588 valueText;
            try {
                if (List.class.isAssignableFrom(this.field.getType())) {
                    int value = ((List)this.field.get(Bole.getInstance().getServerConfigs())).size();
                    valueText = new class_2588("text.bole.number_of_elements", new Object[]{value});
                } else {
                    String value = this.field.get(Bole.getInstance().getServerConfigs()).toString();
                    valueText = new class_2588(value);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                valueText = new class_2588("text.error.bole.data_load");
            }
            GenericHandledScreen.setTexture(Textures.ICONS);
            GenericHandledScreen.drawTextureNormally(matrices, 256.0f, 256.0f, 30.0f, 10.0f, BoleHomepageScreen.this.method_25305(), x, y, 0.0f, 210.0f);
            GenericHandledScreen.drawTextureRotated180(matrices, 256.0f, 256.0f, 30.0f, 10.0f, BoleHomepageScreen.this.method_25305(), x + this.box.width() - 30, y, 0.0f, 210.0f);
            BoleHomepageScreen.this.drawText(matrices, this.name, -16761238, 0.5f, (float)(this.box.left() + 2), (float)this.box.top() + 3.0f);
            BoleHomepageScreen.this.drawText(matrices, (class_2561)valueText, -16686426, 0.5f, (float)(this.box.right() - (BoleHomepageScreen.this.field_22793.method_27525((class_5348)valueText) >> 1) - 3), (float)this.box.top() + 3.0f);
        }
    }

    public abstract class DebugPropertyWidget
    extends AbstractBoleScreen.AbstractPropertyWidget {
        private final String text;

        public DebugPropertyWidget(String text) {
            super(BoleHomepageScreen.this, 4, 1);
            this.text = text;
        }

        @Override
        protected void initTooltipLines() {
        }

        @Override
        protected void drawContent(class_4587 matrices, int x, int y, int mouseX, int mouseY) {
            if (!BoleHomepageScreen.this.debugMode) {
                return;
            }
            BoleHomepageScreen.this.drawTextCenteredX(matrices, this.text, -14496734, 0.5f, (float)(this.box.left() + this.box.right() >> 1), (float)this.box.top() + 3.0f);
        }

        public boolean method_25402(double mouseX, double mouseY, int button) {
            if (!BoleHomepageScreen.this.debugMode || button != 0) {
                return false;
            }
            boolean ret = this.onMouseClick();
            GenericHandledScreen.playScreenSound(class_3417.field_15015, 0.6f, 1.0f);
            return ret;
        }

        protected abstract boolean onMouseClick();
    }

    public class LivingEntityPropertyWidget
    extends AbstractBoleScreen.AbstractPropertyWidget {
        private static final int BUTTONS_CUT = 20;
        private final class_1309 entity;
        private final class_1799 spawnEgg;
        private final class_2561 entityName;
        private final float entitySize;
        private long hoverTime;

        public LivingEntityPropertyWidget(class_1299<?> entityType) {
            super(BoleHomepageScreen.this, 1, 3);
            class_1309 tmp = (class_1309)entityType.method_5883((class_1937)class_310.method_1551().field_1687);
            if (tmp == null) {
                tmp = (class_1309)class_1299.field_6131.method_5883((class_1937)class_310.method_1551().field_1687);
            }
            if (tmp instanceof class_1422) {
                ((IMixinEntity)tmp).setTouchingWater(true);
            }
            this.entity = tmp;
            this.spawnEgg = new class_1799((class_1935)class_1826.method_8019(entityType));
            this.entityName = entityType.method_5897();
            this.entitySize = this.calEntitySize();
            this.hoverTime = -1L;
        }

        private float calEntitySize() {
            class_238 bound = this.entity.method_5829();
            float maxH = (float)(bound.method_17941() + bound.method_17940()) / 1.414f;
            float maxW = (float)(bound.method_17939() + bound.method_17941()) / 1.414f;
            float scale = Math.max(maxH / (float)(this.box.height() - 4) * (float)this.box.width(), maxW);
            return 16.0f / scale * (0.7f + 0.5f / (1.0f + (float)Math.pow(2.71828, -(scale - 1.0f) * 3.0f)));
        }

        @Override
        protected void initTooltipLines() {
            this.initTooltipButtonDescription("property_widget.bole.handbook_entity.description.button1");
            this.initTooltipButtonDescription("property_widget.bole.handbook_entity.description.button2");
        }

        @Override
        protected void drawTooltip(class_4587 matrices) {
            boolean d = BoleHomepageScreen.this.debugMode;
            if (d) {
                this.tooltipLines.add(new class_2588(class_1299.method_5890((class_1299)this.entity.method_5864()).toString()).method_27692(class_124.field_1080).method_30937());
                this.tooltipLines.add(this.widgetClassText);
            }
            int maxWidth = 0;
            for (class_5481 line : this.tooltipLines) {
                maxWidth = Math.max(maxWidth, BoleHomepageScreen.this.field_22793.method_30880(line));
            }
            BoleHomepageScreen.this.renderTooltip(matrices, this.tooltipLines, 0.5f, (this.box.left() + this.box.right() >> 1) - (maxWidth >> 2), this.box.bottom());
            if (d) {
                this.tooltipLines.remove(this.tooltipLines.size() - 1);
                this.tooltipLines.remove(this.tooltipLines.size() - 1);
            }
        }

        @Override
        protected void drawContent(class_4587 matrices, int x, int y, int mouseX, int mouseY) {
            this.drawEntity();
            BoleHomepageScreen.this.drawTextCenteredX(matrices, this.entityName, -1072557550, 0.5f, (float)(this.box.left() + (this.box.width() >> 1)), (float)(this.box.bottom() - 5));
            if (this.isHovered()) {
                long diff;
                if (this.hoverTime == -1L) {
                    this.hoverTime = System.currentTimeMillis();
                }
                int u = (diff = System.currentTimeMillis() - this.hoverTime) < 150L || diff % 2400L < 100L ? 240 : (diff < 300L ? 230 : 220);
                GenericHandledScreen.drawRectangle(matrices, 2004436224, BoleHomepageScreen.this.method_25305(), this.box.left(), this.box.top(), this.box.right(), this.box.bottom());
                BoleHomepageScreen.this.drawTextCenteredX(matrices, this.entityName, -1, 0.5f, (float)(this.box.left() + (this.box.width() >> 1)), (float)(this.box.bottom() - 5));
                boolean whichButton = mouseY >= this.box.top() + 20;
                GenericHandledScreen.drawRectangle(matrices, !whichButton ? -721420289 : -1426063361, BoleHomepageScreen.this.method_25305(), this.box.left() + 1, this.box.top() + 1, this.box.right() - 1, this.box.top() + 20);
                GenericHandledScreen.drawRectangle(matrices, whichButton ? -721420289 : -1426063361, BoleHomepageScreen.this.method_25305(), this.box.left() + 1, this.box.top() + 20, this.box.right() - 1, this.box.bottom() - 6);
                int mid = this.box.left() + this.box.right() >> 1;
                float size = 2.0f;
                class_4587 matrixStack = GenericHandledScreen.matrixScaleOn(size, size, size);
                GenericHandledScreen.setTexture(Textures.ICONS);
                GenericHandledScreen.drawTextureNormally(matrices, 256.0f, 256.0f, 10.0f, 10.0f, BoleHomepageScreen.this.method_25305(), (float)mid / size - 5.0f, (float)this.box.top() / size, u, 0.0f);
                GenericHandledScreen.matrixScaleOff(matrixStack);
                size = 0.5f;
                matrixStack = GenericHandledScreen.matrixScaleOn(size, size, size);
                BoleHomepageScreen.this.field_22788.method_27953(this.spawnEgg, (int)((float)(mid - 4) / size), (int)((float)(this.box.top() + 21) / size));
                GenericHandledScreen.matrixScaleOff(matrixStack);
            } else {
                this.hoverTime = -1L;
            }
        }

        public boolean method_25402(double mouseX, double mouseY, int button) {
            if (button != 0) {
                return true;
            }
            if (mouseY < (double)(this.box.top() + 20)) {
                class_1657 player = ((BoleHomepageScreenHandler)((BoleHomepageScreen)BoleHomepageScreen.this).field_2797).player;
                String settingId = "highlight_entities";
                if (BoleHomepageScreen.this.debugMode) {
                    player.method_7353((class_2561)new class_2588("text.bole.current_feature_request", new Object[]{settingId}).method_27692(class_124.field_1054), false);
                }
                if (Bole.getInstance().getServerConfigs().isEntitySettingBanned(settingId)) {
                    BoleHomepageScreen.this.showOverlayMessage((class_2561)new class_2588("text.bole.feature_request_banned_from_server", new Object[]{settingId}));
                    return true;
                }
                if (!BoleHomepageScreen.this.isDetached() && player.field_7495 < 2) {
                    BoleHomepageScreen.this.showOverlayMessage((class_2561)new class_2588("text.hint.bole.highlight_not_enough_experience"));
                    return true;
                }
                class_1299 entityType = this.entity.method_5864();
                HighlightManager hl = BoleClient.getInstance().getHighlightManager();
                assert (class_310.method_1551().field_1687 != null);
                class_5577<class_1297> lookup = ((IMixinWorld)class_310.method_1551().field_1687).callGetEntityLookup();
                AtomicInteger cnt = new AtomicInteger();
                double d = this.entity.method_5829().method_995();
                if (Double.isNaN(d)) {
                    d = 1.0;
                }
                double dis2 = (d *= 64.0 * class_1297.method_5824()) * d;
                lookup.method_31806((class_5575)entityType, entity -> {
                    if (entity.method_5858((class_1297)player) < dis2) {
                        hl.highlight((class_1297)entity, 160);
                        cnt.incrementAndGet();
                    }
                });
                GenericHandledScreen.playScreenSound(class_3417.field_14550, 0.6f, -10.0f);
                player.method_7353((class_2561)new class_2588("text.bole.highlight", new Object[]{cnt.get(), new class_2588(entityType.method_5882()), (int)Math.sqrt(dis2)}).method_27695(new class_124[]{class_124.field_1077, class_124.field_1067}), true);
                ClientNetworkManager.sendHighlightEvent(Configs.getInstance().getHighlightEntitiesBlindnessTime());
                BoleHomepageScreen.this.method_25419();
                return true;
            }
            if (mouseY < (double)(this.box.bottom() - 6)) {
                if (BoleHomepageScreen.this.isGod()) {
                    BoleHomepageScreen.this.showOverlayMessage((class_2561)new class_2588("text.hint.bole.offer_or_drop", new Object[]{new class_2588(this.spawnEgg.method_7922())}));
                    ((BoleHomepageScreenHandler)BoleHomepageScreen.this.field_2797).sendClientEntitySettings("offer_or_drop", new class_1799((class_1935)this.spawnEgg.method_7909()));
                } else {
                    BoleHomepageScreen.this.showOverlayMessage((class_2561)new class_2588("text.hint.bole.only_in_god_mode"));
                }
                return true;
            }
            return false;
        }

        private void drawEntity() {
            float x = this.box.left() + (this.box.width() >> 1);
            float y = (float)(this.box.bottom() - 3) - this.entitySize * (float)this.entity.method_5829().method_17939();
            int t = (int)(System.currentTimeMillis() % 8000L);
            t = t > 4000 ? 6000 - t : t - 2000;
            float f = (float)Math.atan((float)t / 420.0f) * 6.0f;
            float g = -45.0f;
            this.entity.field_6283 = 180.0f + f * 2.0f;
            this.entity.method_36456(180.0f - f);
            this.entity.method_36457(g);
            this.entity.field_6241 = this.entity.method_36454();
            this.entity.field_6259 = this.entity.method_36454();
            GenericHandledScreen.drawEntityGeneric((class_1297)this.entity, this.entitySize, x, y, g, 0.0f, 0.0f);
        }
    }
}

