/*
 * Decompiled with CFR 0.152.
 */
package xienaoban.minecraft.bole.gui.screen.tree;

import com.mojang.authlib.GameProfile;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1422;
import net.minecraft.class_1661;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_5348;
import net.minecraft.class_742;
import net.minecraft.class_745;
import xienaoban.minecraft.bole.Bole;
import xienaoban.minecraft.bole.BoleClient;
import xienaoban.minecraft.bole.gui.Textures;
import xienaoban.minecraft.bole.gui.screen.AbstractBoleScreen;
import xienaoban.minecraft.bole.gui.screen.GenericHandledScreen;
import xienaoban.minecraft.bole.gui.screen.homepage.BoleHomepageScreenState;
import xienaoban.minecraft.bole.gui.screen.tree.BoleEntityScreenHandler;
import xienaoban.minecraft.bole.mixin.IMixinEntity;
import xienaoban.minecraft.bole.network.ClientNetworkManager;

@Environment(value=EnvType.CLIENT)
public class BoleEntityScreen<E extends class_1297, H extends BoleEntityScreenHandler<E>>
extends AbstractBoleScreen<E, H> {
    protected int entityDisplayPlan;
    protected DisplayedEntityPropertyWidget targetDisplayedEntityPropertyWidget;

    public BoleEntityScreen(H handler, class_1661 inventory, class_2561 title) {
        super(handler, inventory, title);
    }

    @Override
    protected void initPages() {
        this.entityDisplayPlan = this.chooseEntityDisplayPlan((AbstractBoleScreen.Page)this.pages.get(0));
        ((AbstractBoleScreen.Page)this.pages.get(0)).addSlotLazy(new AirPropertyWidget()).addSlotLazy(new BoundingBoxPropertyWidget());
        ((AbstractBoleScreen.Page)this.pages.get(1)).addSlotLazy(new InvulnerablePropertyWidget()).addSlotLazy(new SilentPropertyWidget()).addSlotLazy(new CustomNamePropertyWidget()).addSlotLazy(new NetherPortalCooldownPropertyWidget());
    }

    @Override
    protected void initCustom() {
        ((AbstractBoleScreen.Page)this.pages.get(1)).setSlot(0, 5, new AbstractBoleScreen.CenteredTextPropertyWidget(this, 4, 2, (class_2561)new class_2588("text.bole.unsupported_entity"), -1436129690, 1.0f));
    }

    @Override
    protected void initButtons() {
        super.initButtons();
        this.addBookmark(0, (class_2561)new class_2588("text.bole.return_to_homepage"), button -> {
            BoleClient.getInstance().setHomepageScreenState(new BoleHomepageScreenState(0, 0, this.debugMode));
            ClientNetworkManager.requestBoleScreen();
        });
        this.addBookmark(8, (class_2561)new class_2588("text.bole.settings"), button -> {
            BoleClient.getInstance().setHomepageScreenState(new BoleHomepageScreenState(8, 0, this.debugMode));
            ClientNetworkManager.requestBoleScreen();
        });
        this.addBookmark(9, (class_2561)new class_2588("text.bole.about"), button -> {
            BoleClient.getInstance().setHomepageScreenState(new BoleHomepageScreenState(9, 0, this.debugMode));
            ClientNetworkManager.requestBoleScreen();
        });
    }

    @Override
    protected void drawLeftContent(class_4587 matrices, float delta, int x, int y, int mouseX, int mouseY) {
        BoleEntityScreen.setTexture(Textures.ILLUSTRATIONS);
        BoleEntityScreen.drawTextureNormally(matrices, 64.0f, 64.0f, 32.0f, 32.0f, this.method_25305(), x + 75, y + 102, ((BoleEntityScreenHandler)this.field_2797).isMonster ? 32.0f : 0.0f, 0.0f);
        super.drawLeftContent(matrices, delta, x, y, mouseX, mouseY);
    }

    @Override
    protected void drawRightContent(class_4587 matrices, float delta, int x, int y, int mouseX, int mouseY) {
        BoleEntityScreen.setTexture(Textures.ILLUSTRATIONS);
        BoleEntityScreen.drawTextureNormally(matrices, 64.0f, 64.0f, 16.0f, 16.0f, this.method_25305(), x + 94, y - 12, ((BoleEntityScreenHandler)this.field_2797).isMonster ? 16.0f : 0.0f, 32.0f);
        super.drawRightContent(matrices, delta, x, y, mouseX, mouseY);
    }

    protected int chooseEntityDisplayPlan(AbstractBoleScreen.Page page) {
        int width;
        int top;
        int left;
        class_238 box = ((BoleEntityScreenHandler)this.field_2797).entity.method_5830();
        double x = box.method_17939();
        double y = box.method_17940();
        double area = x * y;
        double ratio = y / x;
        int plan = ratio < 0.45454545454545453 ? (area < 0.4 ? 1 : 3) : (area < 0.5 ? 1 : (ratio > 2.5 ? 4 : 2));
        this.targetDisplayedEntityPropertyWidget = new DisplayedEntityPropertyWidget(width, switch (plan) {
            case 1 -> {
                left = 2;
                top = 0;
                width = 2;
                yield 4;
            }
            case 2 -> {
                left = 0;
                top = 0;
                width = 2;
                yield 5;
            }
            case 3 -> {
                left = 0;
                top = 3;
                width = 4;
                yield 2;
            }
            case 4 -> {
                left = 0;
                top = 0;
                width = 2;
                yield 7;
            }
            default -> {
                left = 0;
                top = 0;
                width = 4;
                yield 6;
            }
        }, ((BoleEntityScreenHandler)this.field_2797).entity);
        page.setSlot(left, top, this.targetDisplayedEntityPropertyWidget);
        return plan;
    }

    public class AirPropertyWidget
    extends AbstractBoleScreen.TemplatePropertyWidget1 {
        public AirPropertyWidget() {
            super(BoleEntityScreen.this, 2, true, 0);
        }

        @Override
        protected void initTooltipLines() {
            this.initTooltipTitle("property_widget.bole.air");
            this.initTooltipDescription("property_widget.bole.air.description");
        }

        @Override
        protected void drawContent(class_4587 matrices, int x, int y, int mouseX, int mouseY) {
            this.drawIcon(matrices, 0, 20);
            this.drawBar(matrices, 1.0f, 10, 20);
            this.drawBar(matrices, (float)((BoleEntityScreenHandler)((BoleEntityScreen)BoleEntityScreen.this).field_2797).entity.method_5669() / (float)((BoleEntityScreenHandler)((BoleEntityScreen)BoleEntityScreen.this).field_2797).entity.method_5748(), 50, 20);
            String text = BoleEntityScreen.this.debugMode ? ((BoleEntityScreenHandler)((BoleEntityScreen)BoleEntityScreen.this).field_2797).entity.method_5669() + "t/" + ((BoleEntityScreenHandler)((BoleEntityScreen)BoleEntityScreen.this).field_2797).entity.method_5748() + "t" : ((BoleEntityScreenHandler)((BoleEntityScreen)BoleEntityScreen.this).field_2797).entity.method_5669() / 20 + "s/" + ((BoleEntityScreenHandler)((BoleEntityScreen)BoleEntityScreen.this).field_2797).entity.method_5748() / 20 + "s";
            this.drawBarText(matrices, text, -1140850689);
        }
    }

    public class BoundingBoxPropertyWidget
    extends AbstractBoleScreen.TemplatePropertyWidget1 {
        public BoundingBoxPropertyWidget() {
            super(BoleEntityScreen.this, 2, true, 0);
        }

        @Override
        protected void initTooltipLines() {
            this.initTooltipTitle("property_widget.bole.bounding_box");
            this.initTooltipDescription("property_widget.bole.bounding_box.description");
        }

        @Override
        protected void drawContent(class_4587 matrices, int x, int y, int mouseX, int mouseY) {
            class_1297 entity = ((BoleEntityScreenHandler)((BoleEntityScreen)BoleEntityScreen.this).field_2797).entity;
            class_238 box = entity.method_5829();
            this.drawIcon(matrices, 0, 50);
            this.drawBar(matrices, 1.0f, 10, 50);
            BoleEntityScreen.this.drawText(matrices, String.format("%.2f", box.method_17939()), -1163971, 0.5f, (float)(x + 11 + 2), (float)y + 3.25f);
            BoleEntityScreen.this.drawText(matrices, String.format("%.2f", box.method_17940()), -16467708, 0.5f, (float)(x + 11 + 2 + 13), (float)y + 3.25f);
            BoleEntityScreen.this.drawText(matrices, String.format("%.2f", box.method_17941()), -15245340, 0.5f, (float)(x + 11 + 2 + 26), (float)y + 3.25f);
        }

        public boolean method_25402(double mouseX, double mouseY, int button) {
            return false;
        }
    }

    public class InvulnerablePropertyWidget
    extends AbstractBoleScreen.TemplatePropertyWidget1 {
        public InvulnerablePropertyWidget() {
            super(BoleEntityScreen.this, 1, false, 1);
        }

        @Override
        protected void initTooltipLines() {
            this.initTooltipTitle("property_widget.bole.invulnerable");
            this.initTooltipButtonDescription("property_widget.bole.invulnerable.description.button1");
        }

        @Override
        protected void drawContent(class_4587 matrices, int x, int y, int mouseX, int mouseY) {
            this.drawIcon(matrices, 100, 10);
            this.drawButton(matrices, 0, 200 + (this.isCurrentInvulnerable() ? 10 : 0), 0);
        }

        public boolean method_25402(double mouseX, double mouseY, int button) {
            int index = this.calMousePosition(mouseX, mouseY);
            if (index != 2 || button != 0) {
                return false;
            }
            if (BoleEntityScreen.this.isGod()) {
                boolean newState = !this.isCurrentInvulnerable();
                ((BoleEntityScreenHandler)BoleEntityScreen.this.field_2797).sendClientEntitySettings("invulnerable", newState);
            } else {
                BoleEntityScreen.this.showOverlayMessage("text.hint.bole.only_in_god_mode");
            }
            return true;
        }

        private boolean isCurrentInvulnerable() {
            return ((BoleEntityScreenHandler)((BoleEntityScreen)BoleEntityScreen.this).field_2797).entity.method_5655();
        }
    }

    public class SilentPropertyWidget
    extends AbstractBoleScreen.TemplatePropertyWidget1 {
        public SilentPropertyWidget() {
            super(BoleEntityScreen.this, 1, false, 1);
        }

        @Override
        protected void initTooltipLines() {
            this.initTooltipTitle("property_widget.bole.silent");
            this.initTooltipButtonDescription("property_widget.bole.silent.description.button1");
        }

        @Override
        protected void drawContent(class_4587 matrices, int x, int y, int mouseX, int mouseY) {
            this.drawIcon(matrices, 100, 0);
            this.drawButton(matrices, 0, 200 + (this.isCurrentSilent() ? 10 : 0), 10);
        }

        public boolean method_25402(double mouseX, double mouseY, int button) {
            int index = this.calMousePosition(mouseX, mouseY);
            if (index != 2 || button != 0) {
                return false;
            }
            boolean newState = !this.isCurrentSilent();
            ((BoleEntityScreenHandler)BoleEntityScreen.this.field_2797).sendClientEntitySettings("silent", newState);
            return true;
        }

        private boolean isCurrentSilent() {
            return ((BoleEntityScreenHandler)((BoleEntityScreen)BoleEntityScreen.this).field_2797).entity.method_5701();
        }
    }

    public class CustomNamePropertyWidget
    extends AbstractBoleScreen.TemplatePropertyWidget1 {
        private class_2561 lastCustomName;
        private class_2561 cacheText;
        private int cacheColor;

        public CustomNamePropertyWidget() {
            super(BoleEntityScreen.this, 2, true, 1);
            this.lastCustomName = new class_2585("");
            this.cacheText = null;
            this.cacheColor = -16777216;
        }

        @Override
        protected void initTooltipLines() {
            this.initTooltipTitle("property_widget.bole.custom_name");
            this.initTooltipDescription("property_widget.bole.custom_name.description");
            this.initTooltipEmptyLine();
            this.initTooltipButtonDescription("property_widget.bole.custom_name.description.button1");
        }

        @Override
        protected void drawContent(class_4587 matrices, int x, int y, int mouseX, int mouseY) {
            this.drawIcon(matrices, 0, 40);
            this.drawBar(matrices, 1.0f, 10, 40);
            this.drawButton(matrices, 0, 220 + (((BoleEntityScreenHandler)((BoleEntityScreen)BoleEntityScreen.this).field_2797).entity.method_5807() ? 0 : 10), 0);
            this.setCacheText();
            this.drawBarText(matrices, this.cacheText, this.cacheColor);
        }

        public boolean method_25402(double mouseX, double mouseY, int button) {
            int index = this.calMousePosition(mouseX, mouseY);
            if (index != 2 || button != 0) {
                return false;
            }
            class_1297 entity = ((BoleEntityScreenHandler)((BoleEntityScreen)BoleEntityScreen.this).field_2797).entity;
            boolean visible = entity.method_5807();
            ((BoleEntityScreenHandler)BoleEntityScreen.this.field_2797).sendClientEntitySettings("custom_name_visible", !visible);
            return true;
        }

        private void setCacheText() {
            class_2561 customName = ((BoleEntityScreenHandler)((BoleEntityScreen)BoleEntityScreen.this).field_2797).entity.method_5797();
            if (customName == this.lastCustomName) {
                return;
            }
            this.lastCustomName = customName;
            if (customName == null) {
                this.cacheColor = -3361187;
                this.cacheText = new class_2588("text.bole.unnamed");
            } else {
                this.cacheColor = -6719977;
                int maxWidth = 58;
                if (BoleEntityScreen.this.field_22793.method_27525((class_5348)customName) > 58) {
                    String trimmed = BoleEntityScreen.this.field_22793.method_27524(customName.method_10851(), 52, false) + "...";
                    this.cacheText = new class_2585(trimmed);
                } else {
                    this.cacheText = customName;
                }
            }
        }
    }

    public class NetherPortalCooldownPropertyWidget
    extends AbstractBoleScreen.TemplatePropertyWidget1 {
        public NetherPortalCooldownPropertyWidget() {
            super(BoleEntityScreen.this, 2, true, 1);
        }

        @Override
        protected void initTooltipLines() {
            this.initTooltipTitle("property_widget.bole.nether_portal_cooldown");
            this.initTooltipDescription("property_widget.bole.nether_portal_cooldown.description");
            this.initTooltipEmptyLine();
            this.initTooltipButtonDescription("property_widget.bole.nether_portal_cooldown.description.button1");
        }

        @Override
        protected void drawContent(class_4587 matrices, int x, int y, int mouseX, int mouseY) {
            int cooldown = ((IMixinEntity)((BoleEntityScreenHandler)((BoleEntityScreen)BoleEntityScreen.this).field_2797).entity).getNetherPortalCooldown();
            boolean lock = cooldown == 1200;
            float p = Math.min(1.0f, (float)cooldown / (float)((BoleEntityScreenHandler)((BoleEntityScreen)BoleEntityScreen.this).field_2797).entity.method_5806());
            this.drawIcon(matrices, 0, 30);
            this.drawBar(matrices, 1.0f, 10, 30);
            this.drawBar(matrices, p, 50, 30);
            this.drawButton(matrices, 0, 200 + (lock ? 10 : 0), 0);
            Object text = BoleEntityScreen.this.debugMode ? ((IMixinEntity)((BoleEntityScreenHandler)((BoleEntityScreen)BoleEntityScreen.this).field_2797).entity).getNetherPortalCooldown() + "t" : (lock ? "\u221e" : ((IMixinEntity)((BoleEntityScreenHandler)((BoleEntityScreen)BoleEntityScreen.this).field_2797).entity).getNetherPortalCooldown() / 20 + "s");
            this.drawBarText(matrices, (String)text, -1140850689);
        }

        public boolean method_25402(double mouseX, double mouseY, int button) {
            int index = this.calMousePosition(mouseX, mouseY);
            if (index != 2 || button != 0) {
                return false;
            }
            if (((BoleEntityScreenHandler)BoleEntityScreen.this.field_2797).isOtherPlayer() && Bole.getInstance().getServerConfigs().isForbidToSetNetherPortalCooldownOfOtherPlayers()) {
                BoleEntityScreen.this.showOverlayMessage((class_2561)new class_2588("text.hint.bole.forbid_to_set_nether_portal_cooldown_of_other_players"));
                return true;
            }
            int cooldown = ((IMixinEntity)((BoleEntityScreenHandler)((BoleEntityScreen)BoleEntityScreen.this).field_2797).entity).getNetherPortalCooldown() == 1200 ? 0 : 1200;
            ((BoleEntityScreenHandler)BoleEntityScreen.this.field_2797).sendClientEntitySettings("nether_portal_cooldown", cooldown);
            return true;
        }
    }

    public class DisplayedEntityPropertyWidget
    extends AbstractBoleScreen.AbstractPropertyWidget {
        private static final int UPDATE_TICKS = 20;
        private class_1297 displayedEntity;
        private class_1297 targetEntity;
        private int nextUpdateTicks;

        public DisplayedEntityPropertyWidget(int colSlots, int rowSlots, class_1297 targetEntity) {
            super(BoleEntityScreen.this, colSlots, rowSlots);
            this.setTargetEntity(targetEntity);
        }

        @Override
        protected void initTooltipLines() {
        }

        @Override
        protected void drawContent(class_4587 matrices, int x, int y, int mouseX, int mouseY) {
            if (BoleClient.getInstance().getScreenTicks() > this.nextUpdateTicks) {
                this.updateDisplayedEntity();
            }
            GenericHandledScreen.drawEntityAuto(this.displayedEntity, x + 2, y, x + this.box.width() - 2, y + this.box.height() - 4, (float)mouseX / 33.0f + 1.0E-4f, (float)mouseY / 53.0f + 5.0f);
        }

        public void updateDisplayedEntity() {
            GenericHandledScreen.copyEntityNbtForDisplay(this.targetEntity, this.displayedEntity);
            this.nextUpdateTicks = BoleClient.getInstance().getScreenTicks() + 20;
        }

        public void setTargetEntity(class_1297 targetEntity) {
            this.targetEntity = targetEntity;
            this.displayedEntity = targetEntity.method_5864().method_5883((class_1937)class_310.method_1551().field_1687);
            if (this.displayedEntity == null) {
                if (targetEntity instanceof class_742) {
                    class_742 clientPlayer = (class_742)targetEntity;
                    GameProfile profile = clientPlayer.method_7334();
                    this.displayedEntity = new class_745(clientPlayer.field_17892, new GameProfile(profile.getId(), profile.getName()));
                    class_243 targetPos = targetEntity.method_19538();
                    this.displayedEntity.method_5814(targetPos.method_10216(), targetPos.method_10214() - 4097.0, targetPos.method_10215());
                } else {
                    this.displayedEntity = class_1299.field_6131.method_5883((class_1937)class_310.method_1551().field_1687);
                }
            }
            if (this.displayedEntity instanceof class_1422) {
                ((IMixinEntity)this.displayedEntity).setTouchingWater(true);
            }
            this.updateDisplayedEntity();
        }
    }

    public abstract class VariantsPropertyWidget
    extends AbstractBoleScreen.AbstractPropertyWidget {
        protected final E[] variants;
        private final class_2561[] names;
        private final int variantsSize;
        private final int eachWidth;
        private final int margin;
        private int lastChosen;

        public VariantsPropertyWidget(int colSlots, int rowSlots) {
            super(BoleEntityScreen.this, colSlots, rowSlots);
            this.variants = this.initEntities();
            this.variantsSize = this.variants.length;
            this.names = this.initNames();
            this.eachWidth = this.box.width() / this.variantsSize;
            this.margin = (this.box.width() % this.variantsSize >> 1) + 1;
            this.lastChosen = -1;
        }

        @Override
        protected void drawContent(class_4587 matrices, int x, int y, int mouseX, int mouseY) {
            int i;
            boolean nothingChosen = true;
            for (i = 0; i < this.variantsSize; ++i) {
                Object entity = this.variants[i];
                int xx = x + this.eachWidth * i + this.margin;
                this.drawEntity(matrices, entity, xx, y, xx + this.eachWidth, this.box.bottom() - 10, mouseX, mouseY);
                this.drawName(matrices, this.names[i], xx + this.eachWidth / 2, this.box.bottom() - 8);
                if (!this.isChosen(this.variants[i])) continue;
                nothingChosen = false;
                if (this.lastChosen != i) {
                    if (this.lastChosen != -1 && BoleEntityScreen.this.targetDisplayedEntityPropertyWidget != null) {
                        BoleEntityScreen.this.targetDisplayedEntityPropertyWidget.updateDisplayedEntity();
                    }
                    this.lastChosen = i;
                }
                this.drawSelectedTick(matrices, i, true);
            }
            if (nothingChosen) {
                this.lastChosen = -2;
            }
            if (this.isHovered() && this.canChoose() && (i = this.calIndex(mouseX, mouseY)) >= 0 && i < this.variantsSize && !this.isChosen(this.variants[i])) {
                this.drawSelectedTick(matrices, i, false);
            }
        }

        private void drawSelectedTick(class_4587 matrices, int index, boolean selected) {
            GenericHandledScreen.setTexture(Textures.ICONS);
            int xx = this.box.left() + this.eachWidth * index + this.margin + this.eachWidth / 2 - 5;
            GenericHandledScreen.drawTextureNormally(matrices, 256.0f, 256.0f, 10.0f, 10.0f, BoleEntityScreen.this.method_25305(), xx, this.box.bottom() - 18, 210 - (selected ? 10 : 0), 20.0f);
        }

        public boolean method_25402(double mouseX, double mouseY, int button) {
            int index = this.calIndex((int)mouseX, (int)mouseY);
            if (index < 0 || index >= this.variantsSize || !this.canChoose()) {
                return false;
            }
            this.setChosen(this.variants[index]);
            return true;
        }

        private int calIndex(int mouseX, int mouseY) {
            if (mouseY < this.box.top() + 4 || mouseY > this.box.bottom() - 4) {
                return -1;
            }
            return (mouseX - this.margin - this.box.left()) / this.eachWidth;
        }

        protected abstract E[] initEntities();

        protected abstract class_2561[] initNames();

        protected abstract boolean canChoose();

        protected abstract boolean isChosen(E var1);

        protected abstract void setChosen(E var1);

        protected void drawEntity(class_4587 matrices, E fake, int x0, int y0, int x1, int y1, int mouseX, int mouseY) {
            GenericHandledScreen.drawEntityAuto(fake, x0, y0, x1, y1, 0.0f, 10.0f);
        }

        protected void drawName(class_4587 matrices, class_2561 text, int xMid, int yTop) {
            BoleEntityScreen.this.drawTextCenteredX(matrices, text, -1440612352, 0.5f, (float)xMid, (float)yTop);
        }
    }
}

