/*
 * Decompiled with CFR 0.152.
 */
package xienaoban.minecraft.bole.gui.screen.tree;

import java.util.Objects;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1496;
import net.minecraft.class_1661;
import net.minecraft.class_2561;
import net.minecraft.class_4587;
import net.minecraft.class_5134;
import xienaoban.minecraft.bole.gui.Textures;
import xienaoban.minecraft.bole.gui.screen.AbstractBoleScreen;
import xienaoban.minecraft.bole.gui.screen.GenericHandledScreen;
import xienaoban.minecraft.bole.gui.screen.tree.BoleAnimalEntityScreen;
import xienaoban.minecraft.bole.gui.screen.tree.BoleEntityScreen;
import xienaoban.minecraft.bole.gui.screen.tree.BoleHorseBaseEntityScreenHandler;
import xienaoban.minecraft.bole.gui.screen.tree.BoleMobEntityScreen;

@Environment(value=EnvType.CLIENT)
public class BoleHorseBaseEntityScreen<E extends class_1496, H extends BoleHorseBaseEntityScreenHandler<E>>
extends BoleAnimalEntityScreen<E, H> {
    public BoleHorseBaseEntityScreen(H handler, class_1661 inventory, class_2561 title) {
        super(handler, inventory, title);
    }

    @Override
    protected void initPages() {
        super.initPages();
        ((AbstractBoleScreen.Page)this.pages.get(0)).addSlotLazyAfter(new HorseRunAndJumpPropertyWidget(), BoleEntityScreen.AirPropertyWidget.class).addSlotLazyAfter(new TamePropertyWidget(), BoleMobEntityScreen.LeashPropertyWidget.class);
    }

    @Override
    protected void initCustom() {
    }

    @Override
    protected void drawLeftContent(class_4587 matrices, float delta, int x, int y, int mouseX, int mouseY) {
        super.drawLeftContent(matrices, delta, x, y, mouseX, mouseY);
    }

    @Override
    protected void drawRightContent(class_4587 matrices, float delta, int x, int y, int mouseX, int mouseY) {
        super.drawRightContent(matrices, delta, x, y, mouseX, mouseY);
    }

    public class HorseRunAndJumpPropertyWidget
    extends AbstractBoleScreen.AbstractPropertyWidget {
        private static final double RUN_LOW = 7.0;
        private static final double RUN_MID = 11.0;
        private static final double JUMP_LOW = 2.0;
        private static final double JUMP_MID = 4.0;
        private final double runningSpeed;
        private final double jumpHeight;
        private final int ru;
        private final int rv;
        private final int ju;
        private final int jv;
        private final int rw;
        private final int jw;

        public HorseRunAndJumpPropertyWidget() {
            super(BoleHorseBaseEntityScreen.this, 2, 2);
            this.runningSpeed = Objects.requireNonNull(((class_1496)((BoleHorseBaseEntityScreenHandler)((BoleHorseBaseEntityScreen)BoleHorseBaseEntityScreen.this).field_2797).entity).method_5996(class_5134.field_23719)).method_6201() * 42.15778732299805;
            this.rw = Math.min((int)(this.runningSpeed / 14.23 * 40.0), 39);
            if (this.runningSpeed < 7.0) {
                this.ru = 10;
                this.rv = 70;
            } else if (this.runningSpeed < 11.0) {
                this.ru = 50;
                this.rv = 70;
            } else {
                this.ru = 10;
                this.rv = 80;
            }
            double jumpStrength = ((class_1496)((BoleHorseBaseEntityScreenHandler)((BoleHorseBaseEntityScreen)BoleHorseBaseEntityScreen.this).field_2797).entity).method_6771();
            this.jumpHeight = (double)-0.1817585f * Math.pow(jumpStrength, 3.0) + 3.689713954925537 * Math.pow(jumpStrength, 2.0) + 2.128599166870117 * jumpStrength - 0.34393036365509033;
            this.jw = Math.min((int)(this.jumpHeight / 5.29 * 40.0), 39);
            if (this.jumpHeight < 2.0) {
                this.ju = 10;
                this.jv = 70;
            } else if (this.jumpHeight < 4.0) {
                this.ju = 50;
                this.jv = 70;
            } else {
                this.ju = 10;
                this.jv = 80;
            }
        }

        @Override
        protected void initTooltipLines() {
            this.initTooltipTitle("property_widget.bole.horse_run_and_jump");
            this.initTooltipDescription("property_widget.bole.horse_run_and_jump.description");
        }

        @Override
        protected void drawContent(class_4587 matrices, int x, int y, int mouseX, int mouseY) {
            int hhh = 13;
            GenericHandledScreen.setTexture(Textures.ICONS);
            GenericHandledScreen.drawTextureNormally(matrices, 256.0f, 256.0f, 10.0f, 10.0f, BoleHorseBaseEntityScreen.this.method_25305(), x, y, 0.0f, 70.0f);
            GenericHandledScreen.drawTextureNormally(matrices, 256.0f, 256.0f, 10.0f, 10.0f, BoleHorseBaseEntityScreen.this.method_25305(), x, y + 13, 0.0f, 80.0f);
            GenericHandledScreen.drawTextureNormally(matrices, 256.0f, 256.0f, this.rw, 10.0f, BoleHorseBaseEntityScreen.this.method_25305(), x + 11, y, this.ru, this.rv);
            GenericHandledScreen.drawTextureNormally(matrices, 256.0f, 256.0f, this.jw, 10.0f, BoleHorseBaseEntityScreen.this.method_25305(), x + 11, y + 13, this.ju, this.jv);
            GenericHandledScreen.drawTextureNormally(matrices, 256.0f, 256.0f, 1.0f, 10.0f, BoleHorseBaseEntityScreen.this.method_25305(), x + 11 + this.rw, y, this.ru + 39, this.rv);
            GenericHandledScreen.drawTextureNormally(matrices, 256.0f, 256.0f, 1.0f, 10.0f, BoleHorseBaseEntityScreen.this.method_25305(), x + 11 + this.jw, y + 13, this.ju + 39, this.jv);
            String run = BoleHorseBaseEntityScreen.this.debugMode ? String.format("%.3f", Objects.requireNonNull(((class_1496)((BoleHorseBaseEntityScreenHandler)((BoleHorseBaseEntityScreen)BoleHorseBaseEntityScreen.this).field_2797).entity).method_5996(class_5134.field_23719)).method_6201()) : String.format("%.2fm/s", this.runningSpeed);
            String jump = BoleHorseBaseEntityScreen.this.debugMode ? String.format("%.3f", ((class_1496)((BoleHorseBaseEntityScreenHandler)((BoleHorseBaseEntityScreen)BoleHorseBaseEntityScreen.this).field_2797).entity).method_6771()) : String.format("%.2fm", this.jumpHeight);
            BoleHorseBaseEntityScreen.this.drawText(matrices, run, -1140850689, 0.5f, (float)(x + 13), (float)y + 3.25f);
            BoleHorseBaseEntityScreen.this.drawText(matrices, jump, -1140850689, 0.5f, (float)(x + 13), (float)(y + 13) + 3.25f);
        }
    }

    public class TamePropertyWidget
    extends AbstractBoleScreen.TemplatePropertyWidget1 {
        public TamePropertyWidget() {
            super(BoleHorseBaseEntityScreen.this, 1, true, 0);
        }

        @Override
        protected void initTooltipLines() {
            this.initTooltipTitle("property_widget.bole.tame");
            this.initTooltipDescription("property_widget.bole.tame.description");
        }

        @Override
        protected void drawContent(class_4587 matrices, int x, int y, int mouseX, int mouseY) {
            this.drawIcon(matrices, 150, 10);
            this.drawBar(matrices, 1.0f, 220 + (((class_1496)((BoleHorseBaseEntityScreenHandler)((BoleHorseBaseEntityScreen)BoleHorseBaseEntityScreen.this).field_2797).entity).method_6727() ? 0 : 10), 20);
        }
    }
}

