/*
 * Decompiled with CFR 0.152.
 */
package xienaoban.minecraft.bole.gui.screen.tree;

import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1058;
import net.minecraft.class_124;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1309;
import net.minecraft.class_1496;
import net.minecraft.class_1661;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_4074;
import net.minecraft.class_4587;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import xienaoban.minecraft.bole.gui.Textures;
import xienaoban.minecraft.bole.gui.screen.AbstractBoleScreen;
import xienaoban.minecraft.bole.gui.screen.GenericHandledScreen;
import xienaoban.minecraft.bole.gui.screen.tree.BoleEntityScreen;
import xienaoban.minecraft.bole.gui.screen.tree.BoleLivingEntityScreenHandler;

@Environment(value=EnvType.CLIENT)
public class BoleLivingEntityScreen<E extends class_1309, H extends BoleLivingEntityScreenHandler<E>>
extends BoleEntityScreen<E, H> {
    public BoleLivingEntityScreen(H handler, class_1661 inventory, class_2561 title) {
        super(handler, inventory, title);
    }

    @Override
    protected void initPages() {
        super.initPages();
        ((AbstractBoleScreen.Page)this.pages.get(0)).addSlotLazyAfter(new HealthPropertyWidget(), null);
        ((AbstractBoleScreen.Page)this.pages.get(0)).addSlotLazyAfter(new StatusEffectsPropertyWidget(), BoleEntityScreen.AirPropertyWidget.class);
    }

    @Override
    protected void initCustom() {
    }

    @Override
    protected void drawLeftContent(class_4587 matrices, float delta, int x, int y, int mouseX, int mouseY) {
        super.drawLeftContent(matrices, delta, x, y, mouseX, mouseY);
    }

    @Override
    protected void drawRightContent(class_4587 matrices, float delta, int x, int y, int mouseX, int mouseY) {
        super.drawRightContent(matrices, delta, x, y, mouseX, mouseY);
    }

    public class HealthPropertyWidget
    extends AbstractBoleScreen.AbstractPropertyWidget {
        private final int[][] barCache;
        private final int lineCnt;

        public HealthPropertyWidget() {
            super(BoleLivingEntityScreen.this, 2, 1);
            this.barCache = new int[3][2];
            int mh = (int)((class_1309)((BoleLivingEntityScreenHandler)((BoleLivingEntityScreen)BoleLivingEntityScreen.this).field_2797).entity).method_6063();
            this.lineCnt = (int)Math.min(Math.ceil((double)mh / 20.0), 3.0);
            this.calBars(0, mh);
        }

        @Override
        protected void initTooltipLines() {
            this.initTooltipTitle("property_widget.bole.health");
            this.initTooltipDescription("property_widget.bole.health.description");
            if (((BoleLivingEntityScreenHandler)((BoleLivingEntityScreen)BoleLivingEntityScreen.this).field_2797).entity instanceof class_1496) {
                this.initTooltipDescription("property_widget.bole.health.description.horse_base");
            }
        }

        @Override
        protected void drawContent(class_4587 matrices, int x, int y, int mouseX, int mouseY) {
            class_1309 entity = (class_1309)((BoleLivingEntityScreenHandler)((BoleLivingEntityScreen)BoleLivingEntityScreen.this).field_2797).entity;
            int health = (int)entity.method_6032();
            int maxHealth = (int)entity.method_6063();
            if (!BoleLivingEntityScreen.this.debugMode && health > maxHealth) {
                health = maxHealth;
            }
            GenericHandledScreen.setTexture(Textures.ICONS);
            GenericHandledScreen.drawTextureNormally(matrices, 256.0f, 256.0f, 10.0f, 10.0f, BoleLivingEntityScreen.this.method_25305(), x, y, 0.0f, this.lineCnt > 2 ? 10.0f : 0.0f);
            this.calBars(1, health);
            float textOffset = 2.25f + (float)this.lineCnt;
            int barOffset = -1 + this.lineCnt;
            if (maxHealth <= 8) {
                this.drawCustomLengthHealthBar(matrices, 8, x + 11, y, 10, 0, true);
                this.drawCustomLengthHealthBar(matrices, 8 * health / maxHealth, x + 11, y, 50, 0, health == maxHealth);
            } else if (maxHealth <= 60) {
                for (int i = this.lineCnt - 1; i >= 0; --i) {
                    this.drawCustomLengthHealthBar(matrices, this.barCache[i][0], x + 11, y + barOffset - (i << 1), 10, 0, true);
                    this.drawCustomLengthHealthBar(matrices, this.barCache[i][1], x + 11, y + barOffset - (i << 1), 50, 0, health >= maxHealth);
                }
            } else {
                this.drawCustomLengthHealthBar(matrices, 20, x + 11, y + barOffset - 4, 10, 10, true);
                this.drawCustomLengthHealthBar(matrices, 20 * this.barCache[2][1] / this.barCache[2][0], x + 11, y + barOffset - 4, 50, 10, health == maxHealth);
                for (int i = 1; i >= 0; --i) {
                    this.drawCustomLengthHealthBar(matrices, this.barCache[i][0], x + 11, y + barOffset - (i << 1), 10, 0, true);
                    this.drawCustomLengthHealthBar(matrices, this.barCache[i][1], x + 11, y + barOffset - (i << 1), 50, 0, health >= maxHealth);
                }
            }
            BoleLivingEntityScreen.this.drawText(matrices, health + "/" + maxHealth, -1140850689, 0.5f, (float)(x + 13), (float)y + textOffset);
        }

        protected void drawCustomLengthHealthBar(class_4587 matrices, int health, int x, int y, int u, int v, boolean close) {
            int w = health << 1;
            if (w > 40) {
                w = 40;
            }
            GenericHandledScreen.drawTextureNormally(matrices, 256.0f, 256.0f, w, 10.0f, BoleLivingEntityScreen.this.method_25305(), x, y, u, v);
            if (close && health < 20) {
                GenericHandledScreen.drawTextureNormally(matrices, 256.0f, 256.0f, 1.0f, 10.0f, BoleLivingEntityScreen.this.method_25305(), x + w, y, u + 39, v);
            }
        }

        private void calBars(int pos, int health) {
            for (int i = 0; i < 3; ++i) {
                int v;
                this.barCache[i][pos] = v = Math.min(20, health);
                health -= v;
            }
            if (health > 0) {
                int[] nArray = this.barCache[2];
                int n = pos;
                nArray[n] = nArray[n] + health;
            }
        }
    }

    public class StatusEffectsPropertyWidget
    extends AbstractBoleScreen.TemplatePropertyWidget1 {
        public StatusEffectsPropertyWidget() {
            super(BoleLivingEntityScreen.this, 2, false, 0);
        }

        @Override
        protected void initTooltipLines() {
            this.initTooltipTitle("property_widget.bole.status_effects");
        }

        @Override
        protected void drawContent(class_4587 matrices, int x, int y, int mouseX, int mouseY) {
            this.drawIcon(matrices, 130, 0);
            this.drawEffects(matrices);
        }

        @Override
        protected void drawTooltip(class_4587 matrices) {
            List<class_1293> effects = ((BoleLivingEntityScreenHandler)((BoleLivingEntityScreen)BoleLivingEntityScreen.this).field_2797).entityStatusEffects;
            if (effects.isEmpty()) {
                this.addTooltipLine("text.bole.empty_with_brackets", class_124.field_1080);
            } else {
                int maxWidth = 0;
                for (class_1293 effect : effects) {
                    class_2588 text = new class_2588(effect.method_5579().method_5567());
                    maxWidth = Math.max(BoleLivingEntityScreen.this.field_22793.method_27525((class_5348)text), maxWidth);
                }
                for (class_1293 effect : effects) {
                    class_5250 text1 = new class_2588(effect.method_5579().method_5567()).method_27693(String.valueOf(effect.method_5578() + 1)).method_27692(class_124.field_1068);
                    class_5250 text2 = new class_2585(effect.method_5584() / 20 + "s").method_27692(class_124.field_1080);
                    int w = BoleLivingEntityScreen.this.field_22793.method_27525((class_5348)text1) + BoleLivingEntityScreen.this.field_22793.method_27525((class_5348)text2);
                    String dot = ".".repeat(Math.max(0, (maxWidth + 40 - w) / 2));
                    this.tooltipLines.add(text1.method_10852((class_2561)new class_2585(dot).method_27692(class_124.field_1063)).method_10852((class_2561)text2).method_30937());
                }
            }
            super.drawTooltip(matrices);
            this.tooltipLines.clear();
            this.initTooltipLines();
        }

        protected void drawEffects(class_4587 matrices) {
            List<class_1293> effects = ((BoleLivingEntityScreenHandler)((BoleLivingEntityScreen)BoleLivingEntityScreen.this).field_2797).entityStatusEffects;
            if (effects == null) {
                this.drawBarText(matrices, (class_2561)new class_2588("text.bole.loading"), -1072557550);
                return;
            }
            if (effects.isEmpty()) {
                this.drawBarText(matrices, (class_2561)new class_2588("text.bole.empty_with_brackets"), -1072557550);
                return;
            }
            float w = Math.min(9.0f, ((float)this.box.width() - 20.0f) / (float)Math.max(1, effects.size() - 1));
            class_310 client = class_310.method_1551();
            class_4074 statusEffectSpriteManager = client.method_18505();
            int i = effects.size() - 1;
            float size = 0.44444445f;
            class_4587 matrixStack = GenericHandledScreen.matrixScaleOn(0.44444445f, 0.44444445f, 0.44444445f);
            for (class_1293 effectInstance : effects) {
                class_1291 effect = effectInstance.method_5579();
                class_1058 sprite = statusEffectSpriteManager.method_18663(effect);
                GenericHandledScreen.setTexture(sprite.method_24119().method_24106());
                class_332.method_25298((class_4587)matrices, (int)((int)(((float)this.box.left() + (float)i * w + 11.0f) / 0.44444445f)), (int)((int)((float)(this.box.top() + 1) / 0.44444445f)), (int)BoleLivingEntityScreen.this.method_25305(), (int)18, (int)18, (class_1058)sprite);
                --i;
            }
            GenericHandledScreen.matrixScaleOff(matrixStack);
        }
    }
}

