/*
 * Decompiled with CFR 0.152.
 */
package xienaoban.minecraft.bole.gui.screen.tree;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1296;
import net.minecraft.class_1661;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_4587;
import xienaoban.minecraft.bole.gui.screen.AbstractBoleScreen;
import xienaoban.minecraft.bole.gui.screen.tree.BoleEntityScreen;
import xienaoban.minecraft.bole.gui.screen.tree.BolePassiveEntityScreenHandler;
import xienaoban.minecraft.bole.gui.screen.tree.BolePathAwareEntityScreen;

@Environment(value=EnvType.CLIENT)
public class BolePassiveEntityScreen<E extends class_1296, H extends BolePassiveEntityScreenHandler<E>>
extends BolePathAwareEntityScreen<E, H> {
    public BolePassiveEntityScreen(H handler, class_1661 inventory, class_2561 title) {
        super(handler, inventory, title);
    }

    @Override
    protected void initPages() {
        super.initPages();
        ((AbstractBoleScreen.Page)this.pages.get(1)).addSlotLazyAfter(new BabyPropertyWidget(), BoleEntityScreen.NetherPortalCooldownPropertyWidget.class);
    }

    @Override
    protected void initCustom() {
    }

    @Override
    protected void drawLeftContent(class_4587 matrices, float delta, int x, int y, int mouseX, int mouseY) {
        super.drawLeftContent(matrices, delta, x, y, mouseX, mouseY);
    }

    @Override
    protected void drawRightContent(class_4587 matrices, float delta, int x, int y, int mouseX, int mouseY) {
        super.drawRightContent(matrices, delta, x, y, mouseX, mouseY);
    }

    public class BabyPropertyWidget
    extends AbstractBoleScreen.TemplatePropertyWidget1 {
        public static final int BABY_MIN_AGE = -24000;

        public BabyPropertyWidget() {
            super(BolePassiveEntityScreen.this, 2, true, 1);
        }

        @Override
        protected void initTooltipLines() {
            this.initTooltipTitle("property_widget.bole.baby");
            this.initTooltipDescription("property_widget.bole.baby.description");
            this.initTooltipEmptyLine();
            this.initTooltipButtonDescription("property_widget.bole.baby.description.button1");
        }

        @Override
        protected void drawContent(class_4587 matrices, int x, int y, int mouseX, int mouseY) {
            int age = ((BolePassiveEntityScreenHandler)((BolePassiveEntityScreen)BolePassiveEntityScreen.this).field_2797).entityBreedingAge;
            this.drawIcon(matrices, 0, 60);
            this.drawBar(matrices, 1.0f, 10, 60);
            this.drawBar(matrices, 1.0f * (float)(age - -24000) / 24000.0f, 50, 60);
            this.drawButton(matrices, 0, 200 + (age < -24000 ? 10 : 0), 0);
            if (BolePassiveEntityScreen.this.debugMode) {
                this.drawBarText(matrices, age + "t", -1140850689);
            } else if (age >= 0) {
                this.drawBarText(matrices, (class_2561)new class_2588("text.bole.grown_up"), -1140850689);
            } else if (age < -24000) {
                this.drawBarText(matrices, (class_2561)new class_2588("text.bole.never_grow_up"), -1140850689);
            } else {
                this.drawBarText(matrices, String.format("%.2f%%", Float.valueOf(100.0f - 100.0f * (float)age / -24000.0f)), -1140850689);
            }
        }

        public boolean method_25402(double mouseX, double mouseY, int button) {
            int index = this.calMousePosition(mouseX, mouseY);
            if (index != 2 || button != 0) {
                return false;
            }
            int age = ((BolePassiveEntityScreenHandler)((BolePassiveEntityScreen)BolePassiveEntityScreen.this).field_2797).entityBreedingAge;
            if (age >= 0) {
                BolePassiveEntityScreen.this.showOverlayMessage("text.hint.bole.not_baby");
                return true;
            }
            age = age >= -24000 ? -1879048192 : -24000;
            ((BolePassiveEntityScreenHandler)BolePassiveEntityScreen.this.field_2797).sendClientEntitySettings("baby", age);
            return true;
        }
    }
}

