/*
 * Decompiled with CFR 0.152.
 */
package xienaoban.minecraft.bole.gui.screen.tree;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1296;
import net.minecraft.class_1297;
import net.minecraft.class_1661;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3917;
import xienaoban.minecraft.bole.gui.screen.AbstractBoleScreenHandler;
import xienaoban.minecraft.bole.gui.screen.tree.BolePathAwareEntityScreenHandler;
import xienaoban.minecraft.bole.mixin.IMixinPassiveEntity;

public class BolePassiveEntityScreenHandler<E extends class_1296>
extends BolePathAwareEntityScreenHandler<E> {
    public static final class_3917<BolePassiveEntityScreenHandler<class_1296>> HANDLER = BolePassiveEntityScreenHandler.register(new class_2960("bole", "passive_entity"), BolePassiveEntityScreenHandler::new);
    public static final int BABY_LOCK = -1879048192;
    @Environment(value=EnvType.CLIENT)
    protected int entityBreedingAge;

    public BolePassiveEntityScreenHandler(int syncId, class_1661 playerInventory) {
        this(HANDLER, syncId, playerInventory);
    }

    public BolePassiveEntityScreenHandler(int syncId, class_1661 playerInventory, class_1297 entity) {
        this(HANDLER, syncId, playerInventory, entity);
    }

    public BolePassiveEntityScreenHandler(class_3917<?> handler, int syncId, class_1661 playerInventory) {
        this(handler, syncId, playerInventory, BolePassiveEntityScreenHandler.clientEntity());
    }

    public BolePassiveEntityScreenHandler(class_3917<?> handler, int syncId, class_1661 playerInventory, class_1297 entity) {
        super(handler, syncId, playerInventory, entity);
        this.registerEntitySettingsBufHandlers();
    }

    private void registerEntitySettingsBufHandlers() {
        this.registerEntitySettingsBufHandler("baby", new AbstractBoleScreenHandler.EntitySettingsBufHandler(){

            @Override
            public void readFromBuf(class_2540 buf) {
                ((class_1296)BolePassiveEntityScreenHandler.this.entity).method_5614(buf.readInt());
            }

            @Override
            public void writeToBuf(class_2540 buf, Object ... args) {
                int age;
                BolePassiveEntityScreenHandler.this.entityBreedingAge = age = ((Integer)args[0]).intValue();
                buf.writeInt(age);
            }
        });
    }

    @Override
    protected void initServer() {
        super.initServer();
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    protected void initClient() {
        super.initClient();
    }

    @Override
    protected void initCustom() {
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void clientTick(int ticks) {
        super.clientTick(ticks);
        this.calculateClientEntityBreedingAge();
    }

    @Override
    protected void writeServerEntityToBuf(class_2540 buf) {
        super.writeServerEntityToBuf(buf);
        buf.writeInt(((IMixinPassiveEntity)this.entity).getBreedingAgeValue());
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    protected void readServerEntityFromBuf(class_2540 buf) {
        super.readServerEntityFromBuf(buf);
        this.entityBreedingAge = buf.readInt();
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    protected void resetClientEntityServerProperties() {
        super.resetClientEntityServerProperties();
    }

    @Environment(value=EnvType.CLIENT)
    private void calculateClientEntityBreedingAge() {
        int age = this.entityBreedingAge;
        if (age == Integer.MIN_VALUE || age >= 0) {
            return;
        }
        this.entityBreedingAge = age + 1;
    }
}

