/*
 * Decompiled with CFR 0.152.
 */
package xienaoban.minecraft.bole.network;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import io.netty.buffer.ByteBuf;
import java.util.Objects;
import java.util.Queue;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1703;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3988;
import net.minecraft.class_437;
import net.minecraft.class_638;
import xienaoban.minecraft.bole.Bole;
import xienaoban.minecraft.bole.BoleClient;
import xienaoban.minecraft.bole.config.Configs;
import xienaoban.minecraft.bole.gui.screen.AbstractBoleScreen;
import xienaoban.minecraft.bole.gui.screen.AbstractBoleScreenHandler;
import xienaoban.minecraft.bole.gui.screen.misc.BeehiveScreenHandler;
import xienaoban.minecraft.bole.mixin.IMixinEntity;
import xienaoban.minecraft.bole.network.Channels;

@Environment(value=EnvType.CLIENT)
public class ClientNetworkManager {
    public static void init() {
        ClientNetworkManager.registerSendServerBoleConfigs();
        ClientNetworkManager.registerSendServerEntityData();
        ClientNetworkManager.registerSendServerEntitiesGlowing();
        ClientNetworkManager.registerSendWanderingTraderSpawnMessage();
        ClientNetworkManager.registerSendBeehiveInfo();
        ClientNetworkManager.registerSendOverlayMessage();
    }

    private static void registerSendServerBoleConfigs() {
        ClientPlayNetworking.registerGlobalReceiver((class_2960)Channels.SEND_SERVER_BOLE_CONFIGS, (client, handler, buf, responseSender) -> {
            String version = buf.method_19772();
            String conf = buf.method_19772();
            Bole.LOGGER.info("New Bole configs from the server: " + conf);
            client.execute(() -> {
                block2: {
                    Bole bole = Bole.getInstance();
                    bole.setServerVersion(version);
                    try {
                        Gson gson = new GsonBuilder().setPrettyPrinting().create();
                        Configs configs = (Configs)gson.fromJson(conf, Configs.class);
                        configs.onUpdate();
                        bole.setServerConfigs(configs);
                    }
                    catch (Exception e) {
                        Bole.LOGGER.error("The mod version of the client does not match the mod version of the server!");
                        if (client.field_1724 == null) break block2;
                        client.field_1724.method_7353((class_2561)new class_2588("text.error.bole.client_server_mod_version_not_match"), false);
                    }
                }
            });
        });
    }

    private static void registerSendServerEntityData() {
        ClientPlayNetworking.registerGlobalReceiver((class_2960)Channels.SEND_SERVER_ENTITY_DATA, (client, handler, buf, responseSender) -> {
            class_2540 bufCopy = PacketByteBufs.copy((ByteBuf)buf);
            AbstractBoleScreenHandler<?> boleScreenHandler = ClientNetworkManager.getBoleScreenHandler(client);
            if (boleScreenHandler == null) {
                BoleClient.getInstance().setHandlerBufCache(bufCopy);
                return;
            }
            client.execute(() -> boleScreenHandler.tryReadServerEntityFromBuf(bufCopy));
        });
    }

    private static void registerSendServerEntitiesGlowing() {
        ClientPlayNetworking.registerGlobalReceiver((class_2960)Channels.SEND_SERVER_ENTITIES_GLOWING, (client, handler, buf, responseSender) -> {
            int size = buf.readInt();
            class_2960 worldId = buf.method_10810();
            class_638 world = client.field_1687;
            if (world == null || !Objects.equals(world.method_27983().method_29177(), worldId)) {
                return;
            }
            int[] entityIds = new int[size];
            boolean[] entityGlowing = new boolean[size];
            for (int i = 0; i < size; ++i) {
                entityIds[i] = buf.readInt();
                entityGlowing[i] = buf.readBoolean();
            }
            client.execute(() -> ClientNetworkManager.lambda$registerSendServerEntitiesGlowing$4(size, (class_1937)world, entityIds, entityGlowing));
        });
    }

    private static void registerSendWanderingTraderSpawnMessage() {
        ClientPlayNetworking.registerGlobalReceiver((class_2960)Channels.SEND_WANDERING_TRADER_SPAWN_MESSAGE, (client, handler, buf, responseSender) -> {
            Object playerName = buf.readBoolean() ? buf.method_10808() : new class_2588("text.bole.unknown_player");
            client.execute(() -> ClientNetworkManager.lambda$registerSendWanderingTraderSpawnMessage$6(client, (class_2561)playerName));
        });
    }

    private static void registerSendBeehiveInfo() {
        ClientPlayNetworking.registerGlobalReceiver((class_2960)Channels.SEND_BEEHIVE_INFO, (client, handler, buf, responseSender) -> {
            class_1703 patt5849$temp;
            class_2540 bufCopy = PacketByteBufs.copy((ByteBuf)buf);
            if (client.field_1724 != null && (patt5849$temp = client.field_1724.field_7512) instanceof BeehiveScreenHandler) {
                BeehiveScreenHandler beehiveScreenHandler = (BeehiveScreenHandler)patt5849$temp;
                client.execute(() -> beehiveScreenHandler.readBeehiveInfo(bufCopy));
            } else {
                BoleClient.getInstance().setHandlerBufCache(bufCopy);
            }
        });
    }

    private static void registerSendOverlayMessage() {
        ClientPlayNetworking.registerGlobalReceiver((class_2960)Channels.SEND_OVERLAY_MESSAGE, (client, handler, buf, responseSender) -> {
            class_2561 text = buf.method_10808();
            client.execute(() -> {
                class_437 patt6437$temp = client.field_1755;
                if (patt6437$temp instanceof AbstractBoleScreen) {
                    AbstractBoleScreen boleScreen = (AbstractBoleScreen)patt6437$temp;
                    boleScreen.showOverlayMessage(text);
                }
            });
        });
    }

    public static void requestServerBoleConfigs() {
        ClientPlayNetworking.send((class_2960)Channels.REQUEST_SERVER_BOLE_CONFIGS, (class_2540)PacketByteBufs.empty());
    }

    public static void requestBoleScreen() {
        ClientPlayNetworking.send((class_2960)Channels.REQUEST_BOLE_SCREEN, (class_2540)PacketByteBufs.empty());
    }

    public static void requestBoleScreen(class_1297 entity) {
        class_2540 buf = PacketByteBufs.create();
        buf.writeInt(entity.method_5628());
        ClientPlayNetworking.send((class_2960)Channels.REQUEST_BOLE_SCREEN, (class_2540)buf);
    }

    public static void requestBoleHandbook() {
        ClientPlayNetworking.send((class_2960)Channels.REQUEST_BOLE_HANDBOOK_ITEM, (class_2540)PacketByteBufs.empty());
    }

    public static void requestServerEntityData() {
        ClientPlayNetworking.send((class_2960)Channels.REQUEST_SERVER_ENTITY_DATA, (class_2540)PacketByteBufs.empty());
    }

    public static void sendClientEntitySettings(class_2540 buf) {
        ClientPlayNetworking.send((class_2960)Channels.SEND_CLIENT_ENTITY_SETTINGS, (class_2540)buf);
    }

    public static void requestServerEntitiesGlowing(Queue<class_1297> que) {
        class_1297 entity;
        if (que.isEmpty()) {
            return;
        }
        class_2540 buf = PacketByteBufs.create();
        buf.writeInt(que.size());
        assert (que.peek() != null);
        buf.method_10812(que.peek().field_6002.method_27983().method_29177());
        while ((entity = que.poll()) != null) {
            buf.writeInt(entity.method_5628());
        }
        ClientPlayNetworking.send((class_2960)Channels.REQUEST_SERVER_ENTITIES_GLOWING, (class_2540)buf);
    }

    public static void sendHighlightEvent(int ticks) {
        class_2540 buf = PacketByteBufs.create();
        buf.writeInt(ticks);
        ClientPlayNetworking.send((class_2960)Channels.SEND_HIGHLIGHT_EVENT, (class_2540)buf);
    }

    public static void requestBeehiveScreen(class_2338 beehivePos) {
        class_2540 buf = PacketByteBufs.create();
        buf.method_10807(beehivePos);
        ClientPlayNetworking.send((class_2960)Channels.REQUEST_BEEHIVE_SCREEN, (class_2540)buf);
    }

    public static void requestMerchantInventoryScreen(class_3988 merchantEntity) {
        class_2540 buf = PacketByteBufs.create();
        buf.writeInt(merchantEntity.method_5628());
        ClientPlayNetworking.send((class_2960)Channels.REQUEST_MERCHANT_INVENTORY_SCREEN, (class_2540)buf);
    }

    public static void requestBeehiveInfo() {
        ClientPlayNetworking.send((class_2960)Channels.REQUEST_BEEHIVE_INFO, (class_2540)PacketByteBufs.empty());
    }

    public static AbstractBoleScreenHandler<?> getBoleScreenHandler(class_310 client) {
        class_1703 class_17032;
        if (client.field_1724 != null && (class_17032 = client.field_1724.field_7512) instanceof AbstractBoleScreenHandler) {
            AbstractBoleScreenHandler boleScreenHandler = (AbstractBoleScreenHandler)class_17032;
            return boleScreenHandler;
        }
        return null;
    }

    private static /* synthetic */ void lambda$registerSendWanderingTraderSpawnMessage$6(class_310 client, class_2561 playerName) {
        assert (client.field_1724 != null);
        if (Configs.getInstance().isReceiveWanderingTraderSpawnBroadcasts()) {
            client.field_1724.method_7353((class_2561)new class_2588("text.bole.wandering_trader_spawn_message", new Object[]{playerName}).method_27692(class_124.field_1080), false);
        }
    }

    private static /* synthetic */ void lambda$registerSendServerEntitiesGlowing$4(int size, class_1937 world, int[] entityIds, boolean[] entityGlowing) {
        Bole.LOGGER.debug("Request entity glowing size: " + size);
        for (int i = 0; i < size; ++i) {
            class_1297 entity = world.method_8469(entityIds[i]);
            if (entity == null) continue;
            ((IMixinEntity)entity).callSetFlag(IMixinEntity.getGlowingFlagIndex(), entityGlowing[i]);
            Bole.LOGGER.debug(entity.method_5864().method_5882() + ", " + entityGlowing[i]);
        }
    }
}

