/*
 * Decompiled with CFR 0.152.
 */
package xienaoban.minecraft.bole.client;

import java.util.ArrayList;
import java.util.Optional;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.item.v1.ItemTooltipCallback;
import net.minecraft.class_1160;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2561;
import net.minecraft.class_2741;
import net.minecraft.class_310;
import net.minecraft.class_3417;
import net.minecraft.class_4466;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5250;
import net.minecraft.class_746;
import net.minecraft.class_898;
import xienaoban.minecraft.bole.config.Configs;
import xienaoban.minecraft.bole.gui.screen.GenericHandledScreen;
import xienaoban.minecraft.bole.mixin.IMixinBlockItem;

@Environment(value=EnvType.CLIENT)
public class EventsManager {
    public static LeashFallFromPlayerEvent LEASH_FALL_FROM_PLAYER_EVENT = new LeashFallFromPlayerEvent();
    public static ShoulderEntityFirstPersonRenderer SHOULDER_ENTITY_FIRST_PERSON_RENDERER = new ShoulderEntityFirstPersonRenderer();

    public static void init() {
        EventsManager.initBeehiveTooltip();
    }

    private static void initBeehiveTooltip() {
        ItemTooltipCallback.EVENT.register((stack, context, lines) -> {
            class_2487 entityNbt;
            class_2487 blockNbt;
            if (!class_1802.field_20416.equals(stack.method_7909()) && !class_1802.field_20415.equals(stack.method_7909())) {
                return;
            }
            class_2487 nbt = stack.method_7969();
            if (nbt == null) {
                return;
            }
            ArrayList<class_5250> beeLines = new ArrayList<class_5250>();
            if (nbt.method_10573("BlockStateTag", 10) && (blockNbt = nbt.method_10562("BlockStateTag")).method_10573(class_2741.field_20432.method_11899(), 3)) {
                int honeyLevel = blockNbt.method_10550(class_2741.field_20432.method_11899());
                beeLines.add(class_2561.method_43469((String)"text.bole.honey_level", (Object[])new Object[]{honeyLevel + "/5"}).method_27692(class_124.field_1054));
            }
            if (nbt.method_10573(IMixinBlockItem.getBlockEntityTagKey(), 10) && (entityNbt = nbt.method_10562(IMixinBlockItem.getBlockEntityTagKey())).method_10573("Bees", 9)) {
                class_2499 bees = entityNbt.method_10554("Bees", 10);
                int beeCnt = bees.size();
                beeLines.add(class_2561.method_43469((String)"text.bole.bee_count", (Object[])new Object[]{beeCnt + "/3"}).method_27692(class_124.field_1065));
                if (beeCnt > 0) {
                    beeLines.add(class_2561.method_43473());
                    beeLines.add(class_2561.method_43471((String)"text.bole.bee_info").method_27692(class_124.field_1080));
                }
                for (int i = 0; i < beeCnt; ++i) {
                    class_2487 beeNbt = bees.method_10602(i).method_10562("EntityData");
                    class_4466 bee = (class_4466)class_1299.field_20346.method_5883((class_1937)class_310.method_1551().field_1687);
                    if (bee == null) {
                        beeLines.add(class_2561.method_43470((String)"[ERROR]").method_27692(class_124.field_1061));
                        continue;
                    }
                    bee.method_5651(beeNbt);
                    beeLines.add(bee.method_5477().method_27661().method_10852((class_2561)class_2561.method_43471((String)"text.bole.colon")).method_10852((class_2561)class_2561.method_43471((String)(bee.method_6109() ? "text.bole.minor" : "text.bole.adult"))).method_27692(class_124.field_1078));
                }
            }
            lines.addAll(1, beeLines);
        });
    }

    public static class LeashFallFromPlayerEvent {
        long lastFallTime = 0L;
        int times = 0;

        public void onFall(class_746 player) {
            long curTime = System.currentTimeMillis();
            this.times = curTime - this.lastFallTime > 3000L ? 1 : ++this.times;
            this.lastFallTime = curTime;
            GenericHandledScreen.playScreenSound(class_3417.field_14585, 0.4f, 1.0f);
            player.method_7353((class_2561)class_2561.method_43469((String)"text.bole.leash_fall", (Object[])new Object[]{this.times}).method_27692(class_124.field_1065), true);
        }
    }

    public static class ShoulderEntityFirstPersonRenderer {
        private static final float HEAD_YAW_SPEED = 0.1f;
        private final class_2487[] oldNbts = new class_2487[2];
        private final class_1309[] entities = new class_1309[2];
        private final float[] nextHeadYaw = new float[2];
        private final long[] nextHeadYawTime = new long[2];
        private long lastTime;

        public void renderShoulderEntity(class_898 entityRenderDispatcher, class_4587 matrices, class_4597 vertexConsumers, class_746 player, int light) {
            double tz;
            double ty;
            double tx;
            float rz;
            float ry;
            float rx;
            switch (Configs.getInstance().getShoulderCreatureHudPosition()) {
                case TOP: {
                    rx = 60.0f;
                    ry = 0.0f;
                    rz = 180.0f;
                    tx = 0.5;
                    ty = 0.0;
                    tz = -1.7;
                    break;
                }
                case BOTTOM: {
                    rx = 0.0f;
                    ry = 180.0f;
                    rz = 0.0f;
                    tx = 0.5;
                    ty = -1.4;
                    tz = 1.3;
                    break;
                }
                case SIDES: {
                    rx = -10.0f;
                    ry = 180.0f;
                    rz = 0.0f;
                    tx = 2.0;
                    ty = -0.2;
                    tz = 1.2;
                    break;
                }
                default: {
                    return;
                }
            }
            long diffTime = System.currentTimeMillis() - this.lastTime;
            this.lastTime += diffTime;
            class_2487[] newNbts = new class_2487[]{player.method_7356(), player.method_7308()};
            for (int i = 0; i < 2; ++i) {
                if (newNbts[i].method_33133()) continue;
                if (this.oldNbts[i] != newNbts[i]) {
                    this.oldNbts[i] = newNbts[i];
                    Optional optionalEntity = class_1299.method_5892((class_2487)newNbts[i], (class_1937)player.field_6002);
                    if (optionalEntity.isEmpty()) continue;
                    class_1309 entity = (class_1309)optionalEntity.get();
                    entity.method_36456(0.0f);
                    entity.method_5636(0.0f);
                    entity.method_5847(0.0f);
                    entity.field_6259 = 0.0f;
                    entity.method_36457(0.0f);
                    this.entities[i] = entity;
                }
                long time = System.currentTimeMillis();
                class_1309 entity = this.entities[i];
                if (this.lastTime > this.nextHeadYawTime[i]) {
                    this.nextHeadYawTime[i] = this.lastTime + 2000L + (long)(Math.random() * 8000.0);
                    this.nextHeadYaw[i] = (float)(Math.random() * 60.0 - 30.0);
                }
                entity.method_5847(entity.method_5791() + 0.1f * (this.nextHeadYaw[i] - entity.method_5791()));
                int pos = i * -2 + 1;
                matrices.method_22903();
                matrices.method_22907(class_1160.field_20703.method_23214(rx));
                matrices.method_22907(class_1160.field_20705.method_23214(ry));
                matrices.method_22907(class_1160.field_20707.method_23214(rz));
                matrices.method_22904((double)pos * tx, ty, tz);
                entityRenderDispatcher.method_3948(false);
                entityRenderDispatcher.method_3954((class_1297)entity, 0.0, 0.0, 0.0, 0.0f, 1.0f, matrices, vertexConsumers, light);
                entityRenderDispatcher.method_3948(true);
                matrices.method_22909();
            }
        }

        public void clearValues() {
            this.oldNbts[1] = null;
            this.oldNbts[0] = null;
            this.entities[1] = null;
            this.entities[0] = null;
        }
    }
}

