/*
 * Decompiled with CFR 0.152.
 */
package xienaoban.minecraft.bole.client;

import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1297;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_5250;
import net.minecraft.class_5577;
import net.minecraft.class_638;
import net.minecraft.class_640;
import net.minecraft.class_746;
import xienaoban.minecraft.bole.mixin.IMixinWorld;
import xienaoban.minecraft.bole.util.MiscUtil;

@Environment(value=EnvType.CLIENT)
public class PlayerDataCacheManager {
    private static final PlayerDataCacheManager INSTANCE = new PlayerDataCacheManager();
    public static final class_2561 TRYING = class_2561.method_43471((String)"text.bole.requesting_mojang_api");
    public static final class_2561 FAILED = class_2561.method_43471((String)"text.bole.fail_to_request_mojang_api");
    public static final class_2561 NOT_GENUINE_PLAYER = class_2561.method_43471((String)"text.bole.not_genuine_player");
    private final ExecutorService pool = Executors.newCachedThreadPool();
    private final Map<UUID, class_2561> uuidToName = new ConcurrentHashMap<UUID, class_2561>();

    public static PlayerDataCacheManager getInstance() {
        return INSTANCE;
    }

    public static boolean isNoPlayerData(class_2561 text) {
        return text == null || text == TRYING || text == FAILED || text == NOT_GENUINE_PLAYER;
    }

    private PlayerDataCacheManager() {
    }

    public class_2561 getPlayerName(UUID uuid) {
        class_640 entry;
        class_5577<class_1297> lookup;
        class_1297 e;
        class_310 client = class_310.method_1551();
        class_638 world = client.field_1687;
        if (world != null && (e = (class_1297)(lookup = ((IMixinWorld)class_310.method_1551().field_1687).callGetEntityLookup()).method_31808(uuid)) != null) {
            this.uuidToName.put(uuid, e.method_5477());
            return e.method_5477();
        }
        class_746 player = client.field_1724;
        if (player != null && (entry = client.field_1724.field_3944.method_2871(uuid)) != null) {
            class_5250 name = class_2561.method_43470((String)entry.method_2966().getName());
            this.uuidToName.put(uuid, (class_2561)name);
            return name;
        }
        class_2561 name = this.uuidToName.get(uuid);
        if (name == null) {
            this.requestMojangApiToGetPlayerName(uuid);
            return TRYING;
        }
        return name;
    }

    private void requestMojangApiToGetPlayerName(UUID uuid) {
        if (this.uuidToName.put(uuid, TRYING) == TRYING) {
            return;
        }
        this.pool.execute(() -> {
            String name = MiscUtil.requestMojangApiGetPlayerName(uuid);
            Object text = name == "text.bole.fail_to_request_mojang_api" ? FAILED : (name == "text.bole.not_genuine_player" ? NOT_GENUINE_PLAYER : class_2561.method_43470((String)name));
            this.uuidToName.put(uuid, (class_2561)text);
        });
    }

    public void debugClear() {
        this.uuidToName.clear();
    }
}

