/*
 * Decompiled with CFR 0.152.
 */
package xienaoban.minecraft.bole.client.highlight;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Queue;
import net.minecraft.class_1297;
import net.minecraft.class_4208;
import xienaoban.minecraft.bole.client.highlight.HighlightedBlockInstance;
import xienaoban.minecraft.bole.client.highlight.HighlightedInstance;
import xienaoban.minecraft.bole.network.ClientNetworkManager;

public class HighlightManager {
    private final PriorityQueue<HighlightedInstance> highlightedQue = new PriorityQueue();
    private final Map<class_1297, HighlightedInstance> highlightedMap = new HashMap<class_1297, HighlightedInstance>();
    private final List<HighlightedBlockInstance> highlightedBlockList = new ArrayList<HighlightedBlockInstance>();
    private HighlightedBlockInstance highlightedJobSiteOrBeehive = null;
    private final Queue<class_1297> toCheckGlowingFromServer = new ArrayDeque<class_1297>(123);

    public void tick() {
        if (!this.highlightedBlockList.isEmpty()) {
            this.highlightedBlockList.removeIf(HighlightedInstance::check);
            if (this.highlightedJobSiteOrBeehive != null && this.highlightedJobSiteOrBeehive.isStopped()) {
                this.highlightedJobSiteOrBeehive = null;
            }
        }
        if (!this.highlightedQue.isEmpty()) {
            HighlightedInstance ins;
            PriorityQueue<HighlightedInstance> que = this.highlightedQue;
            while ((ins = que.peek()) != null && ins.check()) {
                que.poll();
                this.highlightedMap.remove(ins.getEntity());
            }
            ClientNetworkManager.requestServerEntitiesGlowing(this.toCheckGlowingFromServer);
        }
    }

    public HighlightedInstance highlight(class_1297 entity, int ticks) {
        PriorityQueue<HighlightedInstance> que = this.highlightedQue;
        Map<class_1297, HighlightedInstance> map = this.highlightedMap;
        HighlightedInstance old = map.getOrDefault(entity, null);
        if (old != null) {
            que.remove(old);
        }
        HighlightedInstance ins = new HighlightedInstance(entity, ticks);
        map.put(entity, ins);
        que.add(ins);
        return ins;
    }

    public HighlightedBlockInstance highlight(class_4208 pos, int ticks) {
        HighlightedBlockInstance ins = new HighlightedBlockInstance(pos, ticks);
        this.highlightedBlockList.add(ins);
        return ins;
    }

    public void setHighlightedJobSiteOrBeehive(HighlightedBlockInstance highlighted) {
        HighlightedBlockInstance old = this.highlightedJobSiteOrBeehive;
        if (old != null) {
            old.stop();
        }
        this.highlightedJobSiteOrBeehive = highlighted;
    }

    public void clear() {
        this.highlightedQue.clear();
        this.highlightedMap.clear();
        this.highlightedBlockList.forEach(HighlightedInstance::stop);
        this.highlightedBlockList.clear();
        this.highlightedJobSiteOrBeehive = null;
    }

    public void checkServerGlowing(class_1297 entity) {
        this.toCheckGlowingFromServer.add(entity);
    }

    public String toString() {
        return "highlightedQue(" + this.highlightedQue.size() + "), highlightedMap(" + this.highlightedMap.size() + "), highlightedBlockList(" + this.highlightedBlockList.size() + "), highlightedJobSiteOrBeehive(" + (this.highlightedJobSiteOrBeehive != null ? 1 : 0) + ")";
    }
}

