/*
 * Decompiled with CFR 0.152.
 */
package xienaoban.minecraft.bole.client.highlight;

import net.minecraft.class_1297;
import org.jetbrains.annotations.NotNull;
import xienaoban.minecraft.bole.BoleClient;
import xienaoban.minecraft.bole.mixin.IMixinEntity;

public class HighlightedInstance
implements Comparable<HighlightedInstance> {
    protected final class_1297 entity;
    private final int endTicks;
    private boolean stopped;

    public HighlightedInstance(class_1297 entity, int ticks) {
        this.entity = entity;
        this.endTicks = this.getCurrentTicks() + ticks;
        this.stopped = false;
        ((IMixinEntity)entity).callSetFlag(IMixinEntity.getGlowingFlagIndex(), true);
    }

    protected final boolean check() {
        if (this.isStopped()) {
            return true;
        }
        if (this.endTicks < this.getCurrentTicks() || this.shouldStop()) {
            this.stop();
            return true;
        }
        return false;
    }

    public final void stop() {
        if (this.isStopped()) {
            return;
        }
        this.stopped = true;
        this.onStop();
    }

    public final boolean isStopped() {
        return this.stopped;
    }

    protected boolean shouldStop() {
        return false;
    }

    protected void onStop() {
        ((IMixinEntity)this.entity).callSetFlag(IMixinEntity.getGlowingFlagIndex(), false);
        BoleClient.getInstance().getHighlightManager().checkServerGlowing(this.entity);
    }

    public class_1297 getEntity() {
        return this.entity;
    }

    protected int getCurrentTicks() {
        return BoleClient.getInstance().getTicks();
    }

    @Override
    public int compareTo(@NotNull HighlightedInstance that) {
        return this.endTicks - that.endTicks;
    }
}

