/*
 * Decompiled with CFR 0.152.
 */
package xienaoban.minecraft.bole.config;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import me.shedaniel.autoconfig.AutoConfig;
import me.shedaniel.autoconfig.ConfigData;
import me.shedaniel.autoconfig.ConfigHolder;
import me.shedaniel.autoconfig.annotation.Config;
import me.shedaniel.autoconfig.annotation.ConfigEntry;
import me.shedaniel.autoconfig.serializer.GsonConfigSerializer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1269;

@Config(name="bole")
@Config.Gui.CategoryBackgrounds(value={@Config.Gui.CategoryBackground(category="default", background="minecraft:textures/block/moss_block.png"), @Config.Gui.CategoryBackground(category="server", background="minecraft:textures/block/tube_coral_block.png")})
public final class Configs
implements ConfigData {
    @ConfigEntry.Gui.Excluded
    public static final String CLIENT = "default";
    @ConfigEntry.Gui.Excluded
    public static final String SERVER = "server";
    @ConfigEntry.Gui.Excluded
    private static ConfigHolder<Configs> holder;
    @ConfigEntry.Category(value="default")
    @ConfigEntry.Gui.Tooltip
    ShoulderCreatureHudPosition shoulderCreatureHudPosition = ShoulderCreatureHudPosition.NONE;
    @ConfigEntry.Category(value="default")
    @ConfigEntry.Gui.Tooltip
    boolean notifyWhenLeashFallFromPlayer = false;
    @ConfigEntry.Category(value="default")
    @ConfigEntry.Gui.Tooltip
    boolean receiveWanderingTraderSpawnBroadcasts = false;
    @ConfigEntry.Category(value="default")
    @ConfigEntry.Gui.Tooltip
    int highlightEntitiesBlindnessTime = 40;
    @ConfigEntry.Category(value="server")
    @ConfigEntry.Gui.Tooltip
    boolean allowHotKeyToOpenBoleHandbookScreen = false;
    @ConfigEntry.Category(value="server")
    @ConfigEntry.Gui.Tooltip
    boolean blockAccidentalInjuryToPets = false;
    @ConfigEntry.Category(value="server")
    @ConfigEntry.Gui.Tooltip
    boolean petsCanTeleportToMoreBlocks = false;
    @ConfigEntry.Category(value="server")
    @ConfigEntry.Gui.Tooltip
    float fallDistanceToDropShoulderEntities = 0.5f;
    @ConfigEntry.Category(value="server")
    @ConfigEntry.Gui.Tooltip
    boolean forbidToSetNetherPortalCooldownOfOtherPlayers = false;
    @ConfigEntry.Category(value="server")
    @ConfigEntry.Gui.Tooltip
    boolean broadcastWhenWanderingTraderSpawn = false;
    @ConfigEntry.Category(value="server")
    @ConfigEntry.Gui.Tooltip
    List<String> bannedEntitySettings = new ArrayList<String>();
    @ConfigEntry.Gui.Excluded
    private final transient Set<String> bannedEntitySettingsSet = new HashSet<String>();

    public static void init() {
        holder = AutoConfig.register(Configs.class, GsonConfigSerializer::new);
        holder.registerLoadListener((configHolder, configs) -> {
            configs.onUpdate();
            return class_1269.field_5811;
        });
        holder.registerSaveListener((configHolder, configs) -> {
            configs.onUpdate();
            return class_1269.field_5811;
        });
    }

    public static Configs getInstance() {
        return (Configs)holder.getConfig();
    }

    @Environment(value=EnvType.CLIENT)
    public static ConfigHolder<Configs> getHolder() {
        return holder;
    }

    public void onUpdate() {
        this.bannedEntitySettingsSet.clear();
        for (String name : this.bannedEntitySettings) {
            if (name.startsWith("#")) continue;
            this.bannedEntitySettingsSet.add(name);
        }
    }

    public ShoulderCreatureHudPosition getShoulderCreatureHudPosition() {
        return this.shoulderCreatureHudPosition;
    }

    public boolean isNotifyWhenLeashFallFromPlayer() {
        return this.notifyWhenLeashFallFromPlayer;
    }

    public boolean isReceiveWanderingTraderSpawnBroadcasts() {
        return this.receiveWanderingTraderSpawnBroadcasts;
    }

    public int getHighlightEntitiesBlindnessTime() {
        return this.highlightEntitiesBlindnessTime;
    }

    public boolean isAllowHotKeyToOpenBoleHandbookScreen() {
        return this.allowHotKeyToOpenBoleHandbookScreen;
    }

    public boolean isBlockAccidentalInjuryToPets() {
        return this.blockAccidentalInjuryToPets;
    }

    public boolean isPetsCanTeleportToMoreBlocks() {
        return this.petsCanTeleportToMoreBlocks;
    }

    public float getFallDistanceToDropShoulderEntities() {
        return this.fallDistanceToDropShoulderEntities;
    }

    public boolean isForbidToSetNetherPortalCooldownOfOtherPlayers() {
        return this.forbidToSetNetherPortalCooldownOfOtherPlayers;
    }

    public boolean isBroadcastWhenWanderingTraderSpawn() {
        return this.broadcastWhenWanderingTraderSpawn;
    }

    public boolean isEntitySettingBanned(String settingId) {
        return this.bannedEntitySettingsSet.contains(settingId);
    }

    public static enum ShoulderCreatureHudPosition {
        NONE,
        TOP,
        BOTTOM,
        SIDES;

    }
}

