/*
 * Decompiled with CFR 0.152.
 */
package xienaoban.minecraft.bole.gui.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1661;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_4587;
import net.minecraft.class_474;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import net.minecraft.class_757;
import xienaoban.minecraft.bole.Bole;
import xienaoban.minecraft.bole.BoleClient;
import xienaoban.minecraft.bole.client.EntityManager;
import xienaoban.minecraft.bole.gui.ScreenElement;
import xienaoban.minecraft.bole.gui.Textures;
import xienaoban.minecraft.bole.gui.screen.AbstractBoleScreenHandler;
import xienaoban.minecraft.bole.gui.screen.GenericHandledScreen;
import xienaoban.minecraft.bole.mixin.IMixinItemStack;

@Environment(value=EnvType.CLIENT)
public abstract class AbstractBoleScreen<E extends class_1297, H extends AbstractBoleScreenHandler<E>>
extends GenericHandledScreen<H> {
    private static final int BOOK_TEXTURE_CUT = 29;
    public static final int DEFAULT_LINE_HEIGHT = 8;
    public static final int BODY_WIDTH = 326;
    public static final int BODY_HEIGHT = 192;
    public static final int CONTENT_WIDTH = 108;
    public static final int CONTENT_HEIGHT = 130;
    public static final int CONTENT_SPACING_WIDTH = 20;
    public static final int DARK_TEXT_COLOR = -1072557550;
    public static final int LIGHT_TEXT_COLOR = -1140850689;
    private final Page emptyPage;
    private ScreenElement hovered;
    private final OverlayMessageHud overlayMessageHud;
    protected int bodyLeft;
    protected int bodyRight;
    protected int bodyTop;
    protected int bodyBottom;
    protected final int[] contentLeft;
    protected final int[] contentRight;
    protected int contentTop;
    protected int contentBottom;
    protected final Map<Integer, class_4185> bookmarks;
    protected ScreenElement popup;
    protected final List<Page> pages;
    protected Page curLeftPage;
    protected Page curRightPage;
    protected int pageIndex;

    public AbstractBoleScreen(H handler, class_1661 inventory, class_2561 title) {
        super(handler, inventory, title);
        this.field_2792 = this.field_22789;
        this.field_2779 = this.field_22790;
        this.contentLeft = new int[2];
        this.contentRight = new int[2];
        this.overlayMessageHud = new OverlayMessageHud();
        this.bookmarks = new HashMap<Integer, class_4185>();
        this.emptyPage = new Page();
        this.emptyPage.setSlot(0, 4, new CenteredTextPropertyWidget(4, 2, (class_2561)class_2561.method_43471((String)"text.bole.empty_with_brackets"), -1436129690, 1.0f));
        this.pages = new ArrayList<Page>();
        this.pages.add(new Page());
        this.pages.add(new Page());
        this.setPageIndex(0);
        this.initPages();
        for (Page page : this.pages) {
            page.addSlotsFromLazyList();
        }
        this.initCustom();
    }

    protected abstract void initPages();

    protected abstract void initCustom();

    protected void method_25426() {
        super.method_25426();
        this.bodyLeft = (this.field_22789 - 326) / 2;
        this.bodyRight = this.bodyLeft + 326;
        this.bodyTop = this.field_22790 / 2 - 96 - 10;
        this.bodyBottom = this.bodyTop + 192;
        this.contentLeft[0] = (this.field_22789 - 20) / 2 - 108;
        this.contentRight[0] = this.contentLeft[0] + 108;
        this.contentLeft[1] = (this.field_22789 + 20) / 2;
        this.contentRight[1] = this.contentLeft[1] + 108;
        this.contentTop = this.bodyTop + 25;
        this.contentBottom = this.contentTop + 130;
        this.field_2792 = this.field_22789;
        this.field_2779 = this.field_22790;
        this.initButtons();
    }

    protected void initButtons() {
        this.method_37063((class_364)new class_474(this.contentLeft[0] + 1, this.contentBottom, false, buttonWidget -> this.setPageIndex(this.pageIndex - 2), true));
        this.method_37063((class_364)new class_474(this.contentRight[1] - 25, this.contentBottom, true, buttonWidget -> this.setPageIndex(this.pageIndex + 2), true));
    }

    public void method_16014(double mouseX, double mouseY) {
        super.method_16014(mouseX, mouseY);
        ScreenElement pre = null;
        for (ScreenElement cur = this.getScreenElement(mouseX, mouseY); cur != null; cur = cur.getSubScreenElement(mouseX, mouseY)) {
            pre = cur;
        }
        this.setHovered(pre);
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        ScreenElement ele = this.getScreenElement(mouseX, mouseY);
        boolean success = ele != null ? ele.method_25402(mouseX, mouseY, button) : false;
        return success || super.method_25402(mouseX, mouseY, button);
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        return super.method_25403(mouseX, mouseY, button, deltaX, deltaY);
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        return super.method_25406(mouseX, mouseY, button);
    }

    public ScreenElement getScreenElement(double mouseX, double mouseY) {
        if (this.popup != null) {
            return this.popup;
        }
        if (mouseY >= (double)this.contentTop && mouseY <= (double)this.contentBottom) {
            if (mouseX >= (double)this.contentLeft[0] && mouseX <= (double)this.contentRight[0]) {
                return this.curLeftPage;
            }
            if (mouseX >= (double)this.contentLeft[1] && mouseX <= (double)this.contentRight[1]) {
                return this.curRightPage;
            }
        }
        return null;
    }

    @Override
    public void method_25419() {
        ((AbstractBoleScreenHandler)this.field_2797).resetClientEntityServerProperties();
        super.method_25419();
    }

    public void setPageIndex(int pageIndex) {
        int size = this.pages.size() - 1;
        if ((pageIndex &= 0xFFFFFFFE) < 0) {
            pageIndex = 0;
        } else if (pageIndex > size) {
            pageIndex = size & 0xFFFFFFFE;
        }
        this.curLeftPage = pageIndex <= size ? this.pages.get(pageIndex) : this.emptyPage;
        this.curRightPage = pageIndex + 1 <= size ? this.pages.get(pageIndex + 1) : this.emptyPage;
        this.pageIndex = pageIndex;
    }

    public void resetPages() {
        this.pages.clear();
        this.pages.add(new Page());
        this.setHovered(null);
    }

    public void addBookmark(int index, class_2561 title, class_4185.class_4241 onPress) {
        BookmarkButtonWidget bookmark = new BookmarkButtonWidget(this.contentLeft[0] - 30 - 10 + index % 3, this.contentTop - 5 + index * 14, index, title, onPress);
        this.method_37063((class_364)bookmark);
        this.bookmarks.put(index, bookmark);
    }

    protected void method_2389(class_4587 matrices, float delta, int mouseX, int mouseY) {
        this.method_25420(matrices);
        RenderSystem.setShader(class_757::method_34542);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        AbstractBoleScreen.setTexture(Textures.BOOK);
        int x0 = this.bodyLeft;
        int x1 = this.bodyRight;
        int y0 = this.bodyTop;
        int y1 = this.bodyBottom;
        int u0 = 29;
        int u1 = u0 + 163;
        int v0 = 0;
        int v1 = v0 + 192;
        AbstractBoleScreen.drawTextureFlippedHorizontally(matrices, 256.0f, 256.0f, this.method_25305(), x0, y0, this.field_22789 >> 1, y1, u0, v0, u1, v1);
        AbstractBoleScreen.drawTextureNormally(matrices, 256.0f, 256.0f, this.method_25305(), this.field_22789 >> 1, y0, x1, y1, u0, v0, u1, v1);
        if (this.debugMode) {
            this.drawText(matrices, "Ticks: " + BoleClient.getInstance().getScreenTicks(), -1140850689, 0.5f, 1.0f, 10.0f);
            if (((AbstractBoleScreenHandler)this.field_2797).entity != null) {
                String simpleClassName;
                String fullClassName;
                ArrayList<String> entitySuperclasses = new ArrayList<String>();
                Class<?> clazz = ((AbstractBoleScreenHandler)this.field_2797).entity.getClass();
                while (!class_1297.class.equals(clazz)) {
                    fullClassName = EntityManager.getInstance().getClassDeobfuscation(clazz);
                    simpleClassName = fullClassName.substring(fullClassName.lastIndexOf(46) + 1);
                    entitySuperclasses.add(simpleClassName);
                    clazz = clazz.getSuperclass();
                }
                fullClassName = EntityManager.getInstance().getClassDeobfuscation(clazz);
                simpleClassName = fullClassName.substring(fullClassName.lastIndexOf(46) + 1);
                entitySuperclasses.add(simpleClassName);
                Collections.reverse(entitySuperclasses);
                this.drawText(matrices, "Entity: " + String.join((CharSequence)" > ", entitySuperclasses), -1140850689, 0.5f, 1.0f, 15.0f);
                this.drawText(matrices, "Screen: " + ((Object)((Object)this)).getClass().getSimpleName(), -1140850689, 0.5f, 1.0f, 20.0f);
            }
            this.drawText(matrices, "HighlightManager: " + BoleClient.getInstance().getHighlightManager(), -1140850689, 0.5f, 1.0f, (float)(this.field_22790 - 5));
        }
        this.drawText(matrices, this.field_22785, -1719105400, (float)this.contentLeft[0] + 0.7f, (float)(this.contentTop - 12) + 0.7f);
        this.drawText(matrices, this.field_22785, -12303292, (float)this.contentLeft[0], (float)(this.contentTop - 12));
        this.drawLeftContent(matrices, delta, this.contentLeft[0], this.contentTop, mouseX, mouseY);
        this.drawRightContent(matrices, delta, this.contentLeft[1], this.contentTop, mouseX, mouseY);
        int sz = this.pages.size();
        if (this.pageIndex < sz) {
            this.drawTextCenteredX(matrices, "- " + (this.pageIndex + 1) + "/" + sz + " -", Integer.MIN_VALUE, 0.75f, (float)(this.contentLeft[0] + this.contentRight[0] >> 1), (float)(this.contentBottom + 4));
        }
        if (this.pageIndex + 1 < sz) {
            this.drawTextCenteredX(matrices, "- " + (this.pageIndex + 2) + "/" + sz + " -", Integer.MIN_VALUE, 0.75f, (float)(this.contentLeft[1] + this.contentRight[1] >> 1), (float)(this.contentBottom + 4));
        }
        this.overlayMessageHud.draw(matrices, this.field_22789 >> 1, this.bodyBottom - 4, mouseX, mouseY);
    }

    protected void drawLeftContent(class_4587 matrices, float delta, int x, int y, int mouseX, int mouseY) {
        this.curLeftPage.draw(matrices, x, y, mouseX, mouseY);
    }

    protected void drawRightContent(class_4587 matrices, float delta, int x, int y, int mouseX, int mouseY) {
        this.curRightPage.draw(matrices, x, y, mouseX, mouseY);
    }

    protected void method_2388(class_4587 matrices, int mouseX, int mouseY) {
        class_4587 matrixStack = RenderSystem.getModelViewStack();
        matrixStack.method_22904((double)(-this.field_2776), (double)(-this.field_2800), 0.0);
        RenderSystem.applyModelViewMatrix();
        if (this.popup != null) {
            this.popup.draw(matrices, this.field_22789 - this.popup.box.width() >> 1, this.field_22790 - this.popup.box.height() - 32 >> 1, mouseX, mouseY);
        }
        if (this.hovered != null) {
            this.hovered.drawHovered(matrices, mouseX, mouseY);
        }
        matrixStack.method_22904((double)this.field_2776, (double)this.field_2800, 0.0);
        RenderSystem.applyModelViewMatrix();
    }

    public void showOverlayMessage(String translationKey) {
        this.overlayMessageHud.showMessage((class_2561)class_2561.method_43471((String)translationKey));
    }

    public void showOverlayMessage(class_2561 text) {
        this.overlayMessageHud.showMessage(text);
    }

    public ScreenElement getHovered() {
        return this.hovered;
    }

    public void setHovered(ScreenElement hovered) {
        this.hovered = hovered;
    }

    public void setPopup(ScreenElement popup) {
        this.popup = popup;
        this.setHovered(null);
    }

    public final class OverlayMessageHud
    extends ScreenElement {
        private class_2561 overlayMessage;
        private int overlayTicksTo;

        public OverlayMessageHud() {
            super(0, 0);
            this.overlayMessage = null;
            this.overlayTicksTo = -1;
        }

        @Override
        public void draw(class_4587 matrices, int x, int y, int mouseX, int mouseY) {
            int ticks = this.overlayTicksTo - BoleClient.getInstance().getScreenTicks();
            if (this.overlayMessage == null || ticks < 0) {
                return;
            }
            if (ticks == 0) {
                this.clearMessage();
                return;
            }
            if (ticks > 63) {
                ticks = 63;
            }
            AbstractBoleScreen.this.drawTextCenteredX(matrices, this.overlayMessage, 0xFFFFAA | ticks << 26, x, y);
        }

        public void showMessage(class_2561 text) {
            this.overlayMessage = text;
            this.overlayTicksTo = BoleClient.getInstance().getScreenTicks() + 100;
        }

        public void clearMessage() {
            this.overlayMessage = null;
            this.overlayTicksTo = -1;
        }
    }

    public class Page
    extends ScreenElement {
        public static final int PROPERTY_WIDGET_MARGIN_WIDTH = 4;
        public static final int PROPERTY_WIDGET_MARGIN_HEIGHT = 3;
        private static final int COLS = 4;
        public static final int PROPERTY_WIDGET_WIDTH = 24;
        public static final int PROPERTY_WIDGET_HEIGHT = 10;
        private static final int ROWS = 10;
        private final List<List<AbstractPropertyWidget>> widgets;
        private List<AbstractPropertyWidget> lazyList;

        public Page() {
            super(108, 130);
            ArrayList<List<AbstractPropertyWidget>> l1 = new ArrayList<List<AbstractPropertyWidget>>();
            for (int i = 4; i > 0; --i) {
                ArrayList<Object> l2 = new ArrayList<Object>();
                for (int j = 0; j < 10; ++j) {
                    l2.add(null);
                }
                l1.add(l2);
            }
            this.widgets = l1;
            this.lazyList = new ArrayList<AbstractPropertyWidget>();
        }

        @Override
        public void draw(class_4587 matrices, int x, int y, int mouseX, int mouseY) {
            super.draw(matrices, x, y, mouseX, mouseY);
            if (AbstractBoleScreen.this.popup == null) {
                for (int i = 0; i < 4; ++i) {
                    for (int j = 0; j < 10; ++j) {
                        AbstractPropertyWidget w = this.widgets.get(i).get(j);
                        if (w == null) continue;
                        w.draw(matrices, x + i * 28, y + j * 13, mouseX, mouseY);
                    }
                }
            }
            AbstractBoleScreen.this.drawDebugBox(matrices, this.box, 1725759515);
        }

        public boolean setSlot(int col, int row, AbstractPropertyWidget widget) {
            if (col + widget.getColSlots() > 4 || row + widget.getRowSlots() > 10) {
                Bole.LOGGER.error(widget.getClass().getSimpleName() + " cannot be set here! " + widget.getColSlots() + ", " + widget.getRowSlots() + ", " + col + ", " + row);
                return false;
            }
            EmptyPropertyWidget empty = new EmptyPropertyWidget(1, 1, widget);
            for (int i = 0; i < widget.getColSlots(); ++i) {
                for (int j = 0; j < widget.getRowSlots(); ++j) {
                    this.widgets.get(col + i).set(row + j, empty);
                }
            }
            this.widgets.get(col).set(row, widget);
            return true;
        }

        public boolean addSlot(AbstractPropertyWidget widget) {
            int addCnt = widget.getColSlots() == 2 ? 2 : 1;
            for (int i = 0; i < 10 && i + widget.getRowSlots() <= 10; ++i) {
                block1: for (int j = 0; j < 4 && j + widget.getColSlots() <= 4; j += addCnt) {
                    for (int p = 0; p < widget.getRowSlots(); ++p) {
                        for (int q = 0; q < widget.getColSlots(); ++q) {
                            if (this.widgets.get(j + q).get(i + p) != null) continue block1;
                        }
                    }
                    return this.setSlot(j, i, widget);
                }
            }
            return false;
        }

        public Page addSlotLazy(AbstractPropertyWidget widget) {
            this.lazyList.add(widget);
            return this;
        }

        public Page addSlotLazyBefore(AbstractPropertyWidget widget, Class<?> before) {
            int size = this.lazyList.size();
            for (int i = 0; i < size; ++i) {
                if (this.lazyList.get(i).getClass() != before) continue;
                this.lazyList.add(i, widget);
                return this;
            }
            throw new RuntimeException("No " + before.getSimpleName() + " in the lazy list.");
        }

        public Page addSlotLazyAfter(AbstractPropertyWidget widget, Class<?> after) {
            if (after == null) {
                this.lazyList.add(0, widget);
                return this;
            }
            int size = this.lazyList.size();
            for (int i = 0; i < size; ++i) {
                if (this.lazyList.get(i).getClass() != after) continue;
                this.lazyList.add(i + 1, widget);
                return this;
            }
            throw new RuntimeException("No " + after.getSimpleName() + " in the lazy list.");
        }

        protected void addSlotsFromLazyList() {
            int cnt = 0;
            for (AbstractPropertyWidget widget : this.lazyList) {
                if (this.addSlot(widget)) continue;
                ++cnt;
            }
            this.lazyList = new ArrayList<AbstractPropertyWidget>();
            if (cnt > 0) {
                Bole.LOGGER.error(cnt + " widgets failed to be added.");
            }
        }

        @Override
        public ScreenElement getSubScreenElement(double mouseX, double mouseY) {
            int x = (int)mouseX - this.box.left();
            int y = (int)mouseY - this.box.top();
            int w = 28;
            int h = 13;
            int col = x / w;
            int row = y / h;
            if (col >= 4 || row >= 10) {
                return null;
            }
            AbstractPropertyWidget widget = this.widgets.get(col).get(row);
            if (widget instanceof EmptyPropertyWidget) {
                EmptyPropertyWidget emptyWidget = (EmptyPropertyWidget)widget;
                widget = emptyWidget.father;
            }
            if (widget == null || mouseX > (double)widget.box.right() || mouseY > (double)widget.box.bottom()) {
                return null;
            }
            return widget;
        }

        public boolean method_25402(double mouseX, double mouseY, int button) {
            ScreenElement widget = this.getSubScreenElement(mouseX, mouseY);
            if (widget != null) {
                return widget.method_25402(mouseX, mouseY, button);
            }
            return false;
        }
    }

    public class CenteredTextPropertyWidget
    extends AbstractPropertyWidget {
        private class_2561 text;
        private int color;
        private float size;

        public CenteredTextPropertyWidget(int colSlots, int rowSlots, class_2561 text, int color, float size) {
            super(colSlots, rowSlots);
            this.setText(text);
            this.setColor(color);
            this.setSize(size);
        }

        @Override
        protected void initTooltipLines() {
        }

        @Override
        protected void drawContent(class_4587 matrices, int x, int y, int mouseX, int mouseY) {
            AbstractBoleScreen.this.drawText(matrices, this.text, this.color, this.size, (float)(x + (this.box.width() - (int)((float)AbstractBoleScreen.this.field_22793.method_27525((class_5348)this.text) * this.size) >> 1)), (float)(y + (this.box.height() - (int)(8.0f * this.size) >> 1)));
        }

        public void setText(class_2561 text) {
            this.text = text;
        }

        public void setColor(int color) {
            this.color = color;
        }

        public void setSize(float size) {
            this.size = size;
        }
    }

    public abstract class AbstractPropertyWidget
    extends ScreenElement {
        protected final int colSlots;
        protected final int rowSlots;
        protected final List<class_5481> tooltipLines;
        protected final class_5481 widgetClassText;

        public AbstractPropertyWidget(int colSlots, int rowSlots) {
            super(colSlots * 28 - 4, rowSlots * 13 - 3);
            this.colSlots = colSlots;
            this.rowSlots = rowSlots;
            this.tooltipLines = new ArrayList<class_5481>();
            this.initTooltipLines();
            String name = this.getClass().getName();
            name = name.substring(name.lastIndexOf(46) + 1).replaceFirst("\\$", " -> ");
            this.widgetClassText = class_2561.method_43470((String)name).method_27692(class_124.field_1063).method_30937();
        }

        protected abstract void initTooltipLines();

        protected void initTooltipTitle(String translateKey) {
            this.addTooltipLines(translateKey, class_124.field_1054);
        }

        protected void initTooltipDescription(String translateKey) {
            this.addTooltipLines(translateKey, class_124.field_1080);
        }

        protected void initTooltipEmptyLine() {
            this.tooltipLines.add(class_2561.method_43470((String)" ").method_30937());
        }

        protected void initTooltipButtonDescription(String translateKey) {
            this.addTooltipLines(translateKey, class_124.field_1068);
        }

        protected final void addTooltipLine(String translateKey, class_124 color) {
            this.tooltipLines.add(class_2561.method_43471((String)translateKey).method_27692(color).method_30937());
        }

        protected final void addTooltipLines(String translateKey, class_124 color) {
            List lines = class_310.method_1551().field_1772.method_1728((class_5348)class_2561.method_43471((String)translateKey).method_27692(color), 250);
            this.tooltipLines.addAll(lines);
        }

        @Override
        public void draw(class_4587 matrices, int x, int y, int mouseX, int mouseY) {
            super.draw(matrices, x, y, mouseX, mouseY);
            this.drawContent(matrices, x, y, mouseX, mouseY);
            AbstractBoleScreen.this.drawDebugBox(matrices, this.box, this.isHovered() ? -2001097625 : -2000331731);
        }

        protected abstract void drawContent(class_4587 var1, int var2, int var3, int var4, int var5);

        @Override
        public void drawHovered(class_4587 matrices, int mouseX, int mouseY) {
            this.drawTooltip(matrices);
        }

        protected void drawTooltip(class_4587 matrices) {
            if (AbstractBoleScreen.this.debugMode) {
                this.tooltipLines.add(this.widgetClassText);
                AbstractBoleScreen.this.renderTooltip(matrices, this.tooltipLines, 0.5f, this.box.left(), this.box.bottom());
                this.tooltipLines.remove(this.tooltipLines.size() - 1);
            } else {
                AbstractBoleScreen.this.renderTooltip(matrices, this.tooltipLines, 0.5f, this.box.left(), this.box.bottom());
            }
        }

        @Override
        public ScreenElement getSubScreenElement(double mouseX, double mouseY) {
            return null;
        }

        public final int getRowSlots() {
            return this.rowSlots;
        }

        public final int getColSlots() {
            return this.colSlots;
        }

        public final boolean isHovered() {
            return AbstractBoleScreen.this.getHovered() == this;
        }
    }

    public class BookmarkButtonWidget
    extends class_4185 {
        private final int color;
        private final class_2561 title;

        public BookmarkButtonWidget(int x, int y, int color, class_2561 title, class_4185.class_4241 onPress) {
            super(x, y, 30, 10, (class_2561)class_2561.method_43473(), onPress);
            this.color = color % 5;
            this.title = title;
        }

        public void method_25359(class_4587 matrices, int mouseX, int mouseY, float delta) {
            RenderSystem.setShader(class_757::method_34542);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GenericHandledScreen.setTexture(Textures.ICONS);
            int u = this.method_25367() ? 190 : 220;
            int v = 200 + 10 * this.color;
            this.method_25302(matrices, this.field_22760, this.field_22761, u, v, 30, 10);
            AbstractBoleScreen.this.drawText(matrices, this.title, -1140850689, 0.5f, (float)(this.field_22760 + 28) - (float)AbstractBoleScreen.this.field_22793.method_27525((class_5348)this.title) * 0.5f, (float)(this.field_22761 + 3));
        }
    }

    public class LeftTextPropertyWidget
    extends AbstractPropertyWidget {
        private class_2561 text;
        private int color;
        private float size;

        public LeftTextPropertyWidget(int colSlots, int rowSlots, class_2561 text, int color, float size) {
            super(colSlots, rowSlots);
            this.setText(text);
            this.setColor(color);
            this.setSize(size);
        }

        @Override
        protected void initTooltipLines() {
        }

        @Override
        protected void drawContent(class_4587 matrices, int x, int y, int mouseX, int mouseY) {
            AbstractBoleScreen.this.drawText(matrices, this.text, this.color, this.size, (float)(x + 2), (float)(y + (this.box.height() - (int)(8.0f * this.size) >> 1)));
        }

        public void setText(class_2561 text) {
            this.text = text;
        }

        public void setColor(int color) {
            this.color = color;
        }

        public void setSize(float size) {
            this.size = size;
        }
    }

    public final class EmptyPropertyWidget
    extends AbstractPropertyWidget {
        private final AbstractPropertyWidget father;

        public EmptyPropertyWidget(int colSlots, int rowSlots) {
            this(colSlots, rowSlots, null);
        }

        public EmptyPropertyWidget(int colSlots, int rowSlots, AbstractPropertyWidget father) {
            super(colSlots, rowSlots);
            this.father = father;
        }

        @Override
        public void draw(class_4587 matrices, int x, int y, int mouseX, int mouseY) {
            this.box.position(x, y, true);
            if (this.father == null) {
                AbstractBoleScreen.this.drawDebugBox(matrices, this.box, -2000331731);
            }
        }

        @Override
        protected void initTooltipLines() {
        }

        @Override
        protected void drawContent(class_4587 matrices, int x, int y, int mouseX, int mouseY) {
        }
    }

    protected abstract class TemplatePropertyWidget1
    extends AbstractPropertyWidget {
        protected static final int GAP = 1;
        protected static final int ICON_LEFT = 0;
        protected static final int ICON_WIDTH = 10;
        protected static final int BAR_LEFT = 11;
        protected static final int BAR_TEXT_LEFT = 13;
        protected static final int BUTTON_WIDTH = 6;
        protected static final int BUTTON_TEXTURE_OFFSET = 2;
        protected static final float TEXT_HEIGHT = 3.25f;
        protected static final float TEXT_SIZE = 0.5f;
        protected static final int IDX_ICON = 0;
        protected static final int IDX_BAR = 1;
        protected static final int IDX_BUTTON_BEGIN = 2;
        protected final int barWidth;
        protected final int[] buttons;

        public TemplatePropertyWidget1(int colSlots, boolean hasBar, int buttonCnt) {
            super(colSlots, 1);
            this.buttons = new int[buttonCnt];
            this.barWidth = hasBar ? this.box.width() - 11 - 1 - buttonCnt * 7 : -1;
            int buttonLeft = 11 + this.barWidth + 1;
            for (int i = 0; i < buttonCnt; ++i) {
                this.buttons[i] = buttonLeft + i * 7;
            }
        }

        @Override
        public void draw(class_4587 matrices, int x, int y, int mouseX, int mouseY) {
            GenericHandledScreen.setTexture(Textures.ICONS);
            super.draw(matrices, x, y, mouseX, mouseY);
        }

        protected void drawIcon(class_4587 matrices, int u, int v) {
            GenericHandledScreen.drawTextureNormally(matrices, 256.0f, 256.0f, 10.0f, 10.0f, AbstractBoleScreen.this.method_25305(), this.box.left() + 0, this.box.top(), u, v);
        }

        protected void drawBar(class_4587 matrices, float p, int u, int v) {
            if (p < 0.0f) {
                p = 0.0f;
            } else if (p > 1.0f) {
                p = 1.0f;
            }
            GenericHandledScreen.drawTextureNormally(matrices, 256.0f, 256.0f, (float)this.barWidth * p, 10.0f, AbstractBoleScreen.this.method_25305(), this.box.left() + 11, this.box.top(), u, v);
        }

        protected void drawBarText(class_4587 matrices, String text, int color) {
            AbstractBoleScreen.this.drawText(matrices, text, color, 0.5f, (float)(this.box.left() + 13), (float)this.box.top() + 3.25f);
        }

        protected void drawBarText(class_4587 matrices, class_2561 text, int color) {
            AbstractBoleScreen.this.drawText(matrices, text, color, 0.5f, (float)(this.box.left() + 13), (float)this.box.top() + 3.25f);
        }

        protected void drawButton(class_4587 matrices, int index, int u, int v) {
            GenericHandledScreen.drawTextureNormally(matrices, 256.0f, 256.0f, 10.0f, 10.0f, AbstractBoleScreen.this.method_25305(), this.box.left() + this.buttons[index] - 2, this.box.top(), u, v);
        }

        protected void drawButton(class_4587 matrices, int index, class_1799 itemStack) {
            float size = 0.5f;
            int px = (int)((float)(this.box.left() + this.buttons[index] - 2 + 1) / 0.5f);
            int py = (int)((float)(this.box.top() + 1) / 0.5f);
            class_4587 matrixStack = GenericHandledScreen.matrixScaleOn(0.5f, 0.5f, 0.5f);
            class_1799 forDraw = new class_1799((class_1935)((IMixinItemStack)itemStack).getRealItem());
            AbstractBoleScreen.this.field_22788.method_27953(forDraw, px, py);
            AbstractBoleScreen.this.field_22788.method_4022(AbstractBoleScreen.this.field_22793, forDraw, px, py, String.valueOf(itemStack.method_7947()));
            GenericHandledScreen.matrixScaleOff(matrixStack);
        }

        protected int calMousePosition(double mouseX, double mouseY) {
            int index;
            block2: {
                double offsetY;
                double offsetX;
                block3: {
                    block1: {
                        offsetX = mouseX - (double)this.box.left();
                        offsetY = mouseY - (double)this.box.top();
                        index = -1;
                        if (!(offsetX < 10.0)) break block1;
                        if (!(offsetX > 1.0) || !(offsetX < 9.0) || !(offsetY > 1.0) || !(offsetY < 9.0)) break block2;
                        index = 0;
                        break block2;
                    }
                    if (!(offsetX < (double)(11 + this.barWidth))) break block3;
                    if (!(offsetX > 11.0) || !(offsetY > 2.0) || !(offsetY < 8.0)) break block2;
                    index = 1;
                    break block2;
                }
                for (int i = this.buttons.length - 1; i >= 0; --i) {
                    if (!(offsetX > (double)this.buttons[i])) continue;
                    if (!(offsetX < (double)(this.buttons[i] + 6)) || !(offsetY > 1.0) || !(offsetY < 9.0)) break;
                    index = 2 + i;
                    break;
                }
            }
            return index;
        }
    }

    public class PopUpButton
    extends ScreenElement {
        private final class_2561 title;
        private final Runnable onClick;

        public PopUpButton(class_2561 title, Runnable onClick) {
            super(40, 20);
            this.title = title;
            this.onClick = onClick;
        }

        @Override
        public void draw(class_4587 matrices, int x, int y, int mouseX, int mouseY) {
            super.draw(matrices, x, y, mouseX, mouseY);
            GenericHandledScreen.setTexture(Textures.POPUP);
            GenericHandledScreen.drawTextureNormally(matrices, 256.0f, 256.0f, this.box.width(), this.box.height(), AbstractBoleScreen.this.method_25305(), x, y, AbstractBoleScreen.this.getHovered() == this ? (float)this.box.width() : 0.0f, 200.0f);
            AbstractBoleScreen.this.drawTextCenteredX(matrices, this.title, -1072557550, x + (this.box.width() >> 1), y + (this.box.height() - 7 >> 1));
            AbstractBoleScreen.this.drawDebugBox(matrices, this.box, AbstractBoleScreen.this.getHovered() == this ? -2001097625 : -2000331731);
        }

        public boolean method_25402(double mouseX, double mouseY, int button) {
            AbstractBoleScreen.this.setPopup(null);
            this.onClick.run();
            return true;
        }
    }

    public class PopUpConfirmWindow
    extends ScreenElement {
        private final class_2561 title;
        private final List<class_5481> lines;
        private final PopUpButton confirm;
        private final PopUpButton cancel;

        public PopUpConfirmWindow(class_2561 text, Runnable onConfirm) {
            this(text, onConfirm, () -> {});
        }

        public PopUpConfirmWindow(class_2561 text, Runnable onConfirm, Runnable onCancel) {
            super(180, 120);
            this.title = class_2561.method_43471((String)"text.bole.anti_mistouch_warning");
            this.lines = AbstractBoleScreen.this.field_22793.method_1728((class_5348)text, this.box.width() - 24);
            this.confirm = new PopUpButton((class_2561)class_2561.method_43471((String)"gui.ok"), onConfirm);
            this.cancel = new PopUpButton((class_2561)class_2561.method_43471((String)"gui.cancel"), onCancel);
        }

        @Override
        public void draw(class_4587 matrices, int x, int y, int mouseX, int mouseY) {
            super.draw(matrices, x, y, mouseX, mouseY);
            AbstractBoleScreen.this.method_25420(matrices);
            GenericHandledScreen.setTexture(Textures.BOOK);
            int bookRight = 160;
            int bookTop = 7;
            int bookBottom = 175;
            int bookWidth = (this.box.width() >> 1) + 1;
            int bookHeight = (this.box.height() >> 1) + 1;
            GenericHandledScreen.drawTextureNormally(matrices, 256.0f, 256.0f, bookWidth, bookHeight, AbstractBoleScreen.this.method_25305(), this.box.right() - bookWidth, this.box.top(), 160 - bookWidth, 7.0f);
            GenericHandledScreen.drawTextureNormally(matrices, 256.0f, 256.0f, bookWidth, bookHeight, AbstractBoleScreen.this.method_25305(), this.box.right() - bookWidth, this.box.bottom() - bookHeight, 160 - bookWidth, 175 - bookHeight);
            GenericHandledScreen.drawTextureFlippedHorizontally(matrices, 256.0f, 256.0f, bookWidth, bookHeight, AbstractBoleScreen.this.method_25305(), this.box.left(), this.box.top(), 160 - bookWidth, 7.0f);
            GenericHandledScreen.drawTextureFlippedHorizontally(matrices, 256.0f, 256.0f, bookWidth, bookHeight, AbstractBoleScreen.this.method_25305(), this.box.left(), this.box.bottom() - bookHeight, 160 - bookWidth, 175 - bookHeight);
            AbstractBoleScreen.this.field_22793.method_30883(matrices, this.title, (float)x + 12.5f, (float)y + 8.7f, 1726379031);
            AbstractBoleScreen.this.field_22793.method_30883(matrices, this.title, (float)(x + 12), (float)(y + 8), -10408184);
            for (int i = 0; i < this.lines.size(); ++i) {
                AbstractBoleScreen.this.field_22793.method_27528(matrices, this.lines.get(i), (float)(x + 12), (float)(y + 22 + i * 10), -1072557550);
            }
            this.confirm.draw(matrices, this.box.right() - this.confirm.box.width() - this.cancel.box.width() - 25, this.box.bottom() - this.confirm.box.height() - 8, mouseX, mouseY);
            this.cancel.draw(matrices, this.box.right() - this.cancel.box.width() - 20, this.box.bottom() - this.cancel.box.height() - 8, mouseX, mouseY);
            AbstractBoleScreen.this.drawDebugBox(matrices, this.box, 1725759515);
        }

        @Override
        public ScreenElement getSubScreenElement(double mouseX, double mouseY) {
            if (this.confirm.method_25405(mouseX, mouseY)) {
                return this.confirm;
            }
            if (this.cancel.method_25405(mouseX, mouseY)) {
                return this.cancel;
            }
            return null;
        }

        public boolean method_25402(double mouseX, double mouseY, int button) {
            ScreenElement sub = this.getSubScreenElement(mouseX, mouseY);
            if (sub != null) {
                sub.method_25402(mouseX, mouseY, button);
            } else if (!this.method_25405(mouseX, mouseY)) {
                this.cancel.method_25402(mouseX, mouseY, button);
            }
            return true;
        }
    }
}

