/*
 * Decompiled with CFR 0.152.
 */
package xienaoban.minecraft.bole.gui.screen.entity;

import java.util.function.Predicate;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1472;
import net.minecraft.class_1661;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_638;
import xienaoban.minecraft.bole.BoleClient;
import xienaoban.minecraft.bole.gui.screen.AbstractBoleScreen;
import xienaoban.minecraft.bole.gui.screen.entity.BoleSheepEntityScreenHandler;
import xienaoban.minecraft.bole.gui.screen.tree.BoleAnimalEntityScreen;
import xienaoban.minecraft.bole.mixin.IMixinEatGrassGoal;
import xienaoban.minecraft.bole.mixin.IMixinSheepEntity;

@Environment(value=EnvType.CLIENT)
public class BoleSheepEntityScreen<E extends class_1472, H extends BoleSheepEntityScreenHandler<E>>
extends BoleAnimalEntityScreen<E, H> {
    public BoleSheepEntityScreen(H handler, class_1661 inventory, class_2561 title) {
        super(handler, inventory, title);
    }

    @Override
    protected void initPages() {
        super.initPages();
        ((AbstractBoleScreen.Page)this.pages.get(1)).addSlotLazy(new EatGrassPropertyWidget());
    }

    @Override
    protected void initCustom() {
    }

    @Override
    protected void drawLeftContent(class_4587 matrices, float delta, int x, int y, int mouseX, int mouseY) {
        super.drawLeftContent(matrices, delta, x, y, mouseX, mouseY);
    }

    @Override
    protected void drawRightContent(class_4587 matrices, float delta, int x, int y, int mouseX, int mouseY) {
        super.drawRightContent(matrices, delta, x, y, mouseX, mouseY);
    }

    public class EatGrassPropertyWidget
    extends AbstractBoleScreen.TemplatePropertyWidget1 {
        private static final Predicate<class_2680> GRASS_PREDICATE = IMixinEatGrassGoal.getGrassPredicate();
        private int interval;

        public EatGrassPropertyWidget() {
            super(1, false, 1);
            this.interval = -1;
        }

        @Override
        protected void initTooltipLines() {
            this.initTooltipTitle("property_widget.bole.eat_grass");
            this.initTooltipDescription("property_widget.bole.eat_grass.description");
            this.initTooltipEmptyLine();
            this.initTooltipButtonDescription("property_widget.bole.eat_grass.description.button1");
        }

        @Override
        protected void drawContent(class_4587 matrices, int x, int y, int mouseX, int mouseY) {
            this.drawIcon(matrices, 160, 0);
            int u = this.isEating() ? 10 : (this.canEat() ? 0 : 20);
            this.drawButton(matrices, 0, 200 + u, 30);
        }

        public boolean method_25402(double mouseX, double mouseY, int button) {
            int index = this.calMousePosition(mouseX, mouseY);
            if (index != 2 || button != 0) {
                return false;
            }
            if (this.isEating()) {
                BoleSheepEntityScreen.this.showOverlayMessage("text.hint.bole.eating_grass");
            } else if (!this.canEat()) {
                BoleSheepEntityScreen.this.showOverlayMessage("text.hint.bole.far_from_grass");
            } else {
                ((BoleSheepEntityScreenHandler)BoleSheepEntityScreen.this.field_2797).sendClientEntitySettings("sheep_eat_grass", new Object[0]);
                this.interval = BoleClient.getInstance().getScreenTicks() + 10;
            }
            return true;
        }

        private boolean canEat() {
            class_638 world = class_310.method_1551().field_1687;
            if (world == null) {
                return false;
            }
            class_2338 blockPos = ((class_1472)((BoleSheepEntityScreenHandler)((BoleSheepEntityScreen)BoleSheepEntityScreen.this).field_2797).entity).method_24515();
            return GRASS_PREDICATE.test(world.method_8320(blockPos)) || world.method_8320(blockPos.method_10074()).method_27852(class_2246.field_10219);
        }

        private boolean isEating() {
            return ((IMixinSheepEntity)((BoleSheepEntityScreenHandler)((BoleSheepEntityScreen)BoleSheepEntityScreen.this).field_2797).entity).getEatGrassTimer() > 0 || this.interval > BoleClient.getInstance().getScreenTicks();
        }
    }
}

