/*
 * Decompiled with CFR 0.152.
 */
package xienaoban.minecraft.bole.gui.screen.misc;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import java.util.Random;
import net.minecraft.class_124;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1661;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_4587;
import net.minecraft.class_490;
import net.minecraft.class_5250;
import net.minecraft.class_757;
import xienaoban.minecraft.bole.BoleClient;
import xienaoban.minecraft.bole.gui.Textures;
import xienaoban.minecraft.bole.gui.screen.AbstractBoleScreen;
import xienaoban.minecraft.bole.gui.screen.GenericHandledScreen;
import xienaoban.minecraft.bole.gui.screen.misc.BeehiveScreenHandler;

public class BeehiveScreen
extends GenericHandledScreen<BeehiveScreenHandler> {
    private static final int[][] LATTICES = new int[][]{{0, 0}, {32, 0}, {0, 50}, {32, 50}, {16, 25}, {-16, 25}, {48, 25}};
    private static final int MAX_HONEY_CNT = 5;
    private static final int MAX_BEE_CNT = 3;
    private long mills;
    private final BeeAction[] actions;
    private int lastBeeCnt;

    public BeehiveScreen(BeehiveScreenHandler handler, class_1661 inventory, class_2561 title) {
        super(handler, inventory, title);
        this.field_2792 = this.field_22789;
        this.field_2779 = this.field_22790;
        this.mills = System.currentTimeMillis();
        this.actions = new BeeAction[3];
        this.lastBeeCnt = 0;
        for (int i = 0; i < 3; ++i) {
            this.actions[i] = new BeeAction();
        }
        BoleClient.getInstance().setScreenOpen(true);
    }

    protected void method_25426() {
        super.method_25426();
        this.field_2792 = this.field_22789;
        this.field_2779 = this.field_22790;
    }

    protected void method_2389(class_4587 matrices, float delta, int mouseX, int mouseY) {
        long lastMills = this.mills;
        this.mills = System.currentTimeMillis();
        int diff = (int)(this.mills - lastMills);
        this.method_25420(matrices);
        RenderSystem.setShader(class_757::method_34542);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (class_2960)Textures.BEEHIVE);
        int w = this.field_22789 - 128 >> 1;
        int h = this.field_22790 - 128 >> 1;
        int beeCnt = ((BeehiveScreenHandler)this.field_2797).blockBeeCnt;
        int honeyCnt = ((BeehiveScreenHandler)this.field_2797).blockHoneyCnt;
        if (this.lastBeeCnt > beeCnt) {
            this.lastBeeCnt = beeCnt;
            BeeAction tmp = this.actions[0];
            for (int i = 1; i < 3; ++i) {
                this.actions[i - 1] = this.actions[i];
            }
            this.actions[2] = tmp;
        } else {
            this.lastBeeCnt = beeCnt;
        }
        int lw = w + 32;
        int lh = h + 23;
        for (int i = 0; i < 5; ++i) {
            this.drawLattice(matrices, LATTICES[i][0] + lw, LATTICES[i][1] + lh, i < honeyCnt ? 2 : 0);
        }
        this.drawLattice(matrices, LATTICES[5][0] + lw, LATTICES[5][1] + lh, 1);
        this.drawLattice(matrices, LATTICES[6][0] + lw, LATTICES[6][1] + lh, 1);
        this.method_25302(matrices, w, h, 0, 0, 128, 128);
        int color = -1124073473;
        for (int i = 0; i < beeCnt; ++i) {
            int y;
            int x;
            BeeAction action = this.actions[i];
            action.run(diff);
            if (honeyCnt + i < 5) {
                x = LATTICES[honeyCnt + i][0] + lw + 16;
                y = LATTICES[honeyCnt + i][1] + lh + 29;
            } else {
                int p = i + honeyCnt - 5 + 1;
                x = w + p * 32;
                y = h + 24 + ((p & 1) == 0 ? 0 : 8);
            }
            BeehiveScreenHandler.BeeInfo bee = ((BeehiveScreenHandler)this.field_2797).bees[i];
            int beeSize = bee.entity.method_6109() ? 46 : 32;
            float t = 14.0f * (float)Math.min(bee.ticksInHive, bee.minOccupationTicks) / (float)bee.minOccupationTicks;
            BeehiveScreen.drawHorizontalLine(matrices, -12307712, 1.1f, this.method_25305(), (float)x - 7.5f, (float)x + 7.5f, y - 1);
            BeehiveScreen.drawHorizontalLine(matrices, bee.entity.method_21784() ? -17664 : 1694481152, 0.6f, this.method_25305(), x - 7, (float)(x - 7) + t, y - 1);
            class_490.method_2486((int)x, (int)y, (int)beeSize, (float)action.mouseX, (float)action.mouseY, (class_1309)bee.entity);
            class_2561 customName = bee.entity.method_5797();
            if (customName != null) {
                int wHalf = (this.getTextWidth(customName) >> 2) + 1;
                int yyy = y - (bee.entity.method_6109() ? 20 : 25);
                BeehiveScreen.drawHorizontalLine(matrices, 0x55777777, 3.0f, this.method_25305(), x - wHalf, x + wHalf, yyy);
                this.drawTextHalfCenteredX(matrices, bee.entity.method_5797(), color, x, yyy - 2);
            }
            if (mouseX <= x - 10 || mouseX >= x + 10 || mouseY <= y - 20 || mouseY >= y) continue;
            List<class_5250> texts = List.of(bee.entity.method_5477(), class_2561.method_43469((String)"text.bole.has_nectar", (Object[])new Object[]{class_2561.method_43471((String)(bee.entity.method_21784() ? "gui.yes" : "gui.no"))}).method_27692(class_124.field_1080), class_2561.method_43469((String)"text.bole.time_in_beehive", (Object[])new Object[]{bee.ticksInHive / 20 + "s/" + bee.minOccupationTicks / 20 + "s"}).method_27692(class_124.field_1080));
            int maxLength = texts.stream().mapToInt(this::getTextWidth).max().getAsInt() >> 2;
            this.renderTooltip(matrices, texts.stream().map(class_2561::method_30937).toList(), 0.5f, x - maxLength - 2, y);
        }
        this.field_22793.method_1729(matrices, honeyCnt + "/5", (float)(LATTICES[5][0] + lw + 16) - 8.5f, (float)(LATTICES[5][1] + lh + 8), color);
        this.field_22793.method_1729(matrices, beeCnt + "/3", (float)(LATTICES[6][0] + lw + 16) - 8.5f, (float)(LATTICES[6][1] + lh + 8), color);
        this.drawTextCenteredX(matrices, (class_2561)class_2561.method_43471((String)"text.bole.honey"), color, (float)(LATTICES[5][0] + lw) + 16.5f, LATTICES[5][1] + lh + 16);
        this.drawTextCenteredX(matrices, class_1299.field_20346.method_5897(), color, (float)(LATTICES[6][0] + lw) + 16.5f, LATTICES[6][1] + lh + 16);
    }

    protected void method_2388(class_4587 matrices, int mouseX, int mouseY) {
    }

    private void drawLattice(class_4587 matrices, int w, int h, int type) {
        this.method_25302(matrices, w, h, 16 + type * 32, 140, 32, 32);
    }

    private void drawTextHalfCenteredX(class_4587 matrices, class_2561 text, int color, int xMid, int y) {
        int w2 = this.getTextWidth(text) >> 2;
        float size = 0.5f;
        class_4587 matrixStack = AbstractBoleScreen.matrixScaleOn(0.5f, 0.5f, 0.5f);
        this.field_22793.method_30883(matrices, text, (float)(xMid - w2 << 1), (float)(y << 1), color);
        AbstractBoleScreen.matrixScaleOff(matrixStack);
    }

    private static class BeeAction {
        public float mouseX;
        public float mouseY;
        private float speedMouseX;
        private float speedMouseY;
        private int mouseMoveTime;
        private int mouseCooldownTime;
        private final Random random = new Random();

        public BeeAction() {
            this.mouseX = this.random.nextFloat(-50.0f, 50.0f);
            this.mouseY = this.random.nextFloat(-1.0f, 20.0f);
            this.mouseCooldownTime = this.random.nextInt(3000);
        }

        public void run(int mills) {
            if (this.mouseMoveTime > 0) {
                this.mouseMoveTime -= mills;
                this.mouseX += this.speedMouseX * (float)mills;
                this.mouseY += this.speedMouseY * (float)mills;
                if (Math.abs(this.mouseX) > 50.0f) {
                    this.speedMouseX = -0.2f * this.speedMouseX;
                }
                if (this.mouseY > 20.0f || this.mouseY < 2.0f) {
                    this.speedMouseY = -0.2f * this.speedMouseY;
                }
            } else {
                this.mouseCooldownTime -= mills;
                if (this.mouseCooldownTime < 0) {
                    this.mouseCooldownTime = this.random.nextInt(5000);
                    this.mouseMoveTime = this.random.nextInt(1000);
                    this.speedMouseX = this.random.nextFloat(-0.3f, 0.3f);
                    this.speedMouseY = this.random.nextFloat(-0.1f, 0.1f);
                }
            }
        }
    }
}

