/*
 * Decompiled with CFR 0.152.
 */
package xienaoban.minecraft.bole.gui.screen.misc;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1299;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2540;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3917;
import net.minecraft.class_4466;
import net.minecraft.class_4482;
import xienaoban.minecraft.bole.Bole;
import xienaoban.minecraft.bole.BoleClient;
import xienaoban.minecraft.bole.gui.screen.GenericScreenHandler;
import xienaoban.minecraft.bole.network.ClientNetworkManager;
import xienaoban.minecraft.bole.network.ServerNetworkManager;

public class BeehiveScreenHandler
extends GenericScreenHandler {
    public static final class_3917<BeehiveScreenHandler> HANDLER = BeehiveScreenHandler.register(new class_2960("bole", "beehive"), BeehiveScreenHandler::new);
    private final class_2338 pos;
    private final class_1937 world;
    private final class_4482 entity;
    protected final BeeInfo[] bees = new BeeInfo[3];
    protected int blockBeeCnt = 0;
    protected int blockHoneyCnt = 0;

    public BeehiveScreenHandler(int syncId, class_1661 playerInventory) {
        this(syncId, playerInventory, BeehiveScreenHandler.clientBlock());
    }

    public BeehiveScreenHandler(int syncId, class_1661 playerInventory, class_2338 pos) {
        super(HANDLER, syncId, playerInventory);
        for (int i = 0; i < this.bees.length; ++i) {
            this.bees[i] = new BeeInfo(this.player);
        }
        this.pos = pos;
        this.world = this.player.method_37908();
        this.entity = (class_4482)this.world.method_8321(pos);
        class_1657 class_16572 = this.player;
        if (class_16572 instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)class_16572;
            ServerNetworkManager.sendServerBeehiveInfo(this, serverPlayer.field_13995, serverPlayer);
        } else {
            class_2540 buf = BoleClient.getInstance().getHandlerBufCache();
            if (buf != null) {
                this.readBeehiveInfo(buf);
                BoleClient.getInstance().setHandlerBufCache(null);
            }
        }
    }

    @Override
    protected void initCustom() {
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void clientTick(int ticks) {
        if (ticks % 10 == 5) {
            ClientNetworkManager.requestBeehiveInfo();
        }
    }

    public void writeBeehiveInfo(class_2540 buf) {
        buf.writeInt(this.field_7763);
        int honeyCnt = class_4482.method_23902((class_2680)this.world.method_8320(this.pos));
        buf.writeInt(honeyCnt);
        class_2499 beeList = this.entity.method_21859();
        int beeCnt = beeList.size();
        buf.writeInt(beeCnt);
        for (int i = 0; i < beeCnt; ++i) {
            buf.method_10794(beeList.method_10602(i));
        }
    }

    public void readBeehiveInfo(class_2540 buf) {
        if (buf.readInt() != this.field_7763) {
            Bole.LOGGER.warn("BeehiveScreenHandler#readBeehiveInfo(): wrong syncId.");
            return;
        }
        this.blockHoneyCnt = buf.readInt();
        this.blockBeeCnt = buf.readInt();
        for (int i = 0; i < this.blockBeeCnt; ++i) {
            class_2487 nbt = buf.method_10798();
            assert (nbt != null);
            BeeInfo bee = this.bees[i];
            bee.entity.method_5665(null);
            bee.entity.method_5651(nbt.method_10562("EntityData"));
            bee.ticksInHive = nbt.method_10550("TicksInHive");
            bee.minOccupationTicks = nbt.method_10550("MinOccupationTicks");
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static class_2338 clientBlock() {
        class_2338 pos = BoleClient.getInstance().getHitBlock();
        BoleClient.getInstance().setHitBlock(null);
        return pos;
    }

    public static class BeeInfo {
        public final class_4466 entity;
        public int ticksInHive;
        public int minOccupationTicks;

        public BeeInfo(class_1657 player) {
            this.entity = (class_4466)class_1299.field_20346.method_5883(player.method_37908());
            this.ticksInHive = -1;
            this.minOccupationTicks = -1;
        }
    }
}

