/*
 * Decompiled with CFR 0.152.
 */
package xienaoban.minecraft.bole.gui.screen.tree;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3917;
import net.minecraft.class_437;
import net.minecraft.class_638;
import xienaoban.minecraft.bole.Bole;
import xienaoban.minecraft.bole.BoleClient;
import xienaoban.minecraft.bole.config.Configs;
import xienaoban.minecraft.bole.gui.screen.AbstractBoleScreen;
import xienaoban.minecraft.bole.gui.screen.AbstractBoleScreenHandler;
import xienaoban.minecraft.bole.mixin.IMixinEntity;
import xienaoban.minecraft.bole.network.ClientNetworkManager;

public class BoleEntityScreenHandler<E extends class_1297>
extends AbstractBoleScreenHandler<E> {
    public static final class_3917<BoleEntityScreenHandler<class_1297>> HANDLER = BoleEntityScreenHandler.register(new class_2960("bole", "entity"), BoleEntityScreenHandler::new);
    public static final int NETHER_PORTAL_LOCK = 1200;
    private static final int CLOSE_SCREEN_DISTANCE = 10;
    protected final boolean isMonster;

    public BoleEntityScreenHandler(int syncId, class_1661 playerInventory) {
        this(HANDLER, syncId, playerInventory);
    }

    public BoleEntityScreenHandler(int syncId, class_1661 playerInventory, class_1297 entity) {
        this(HANDLER, syncId, playerInventory, entity);
    }

    public BoleEntityScreenHandler(class_3917<?> handler, int syncId, class_1661 playerInventory) {
        this(handler, syncId, playerInventory, BoleEntityScreenHandler.clientEntity());
    }

    public BoleEntityScreenHandler(class_3917<?> handler, int syncId, class_1661 playerInventory, class_1297 entity) {
        super(handler, syncId, playerInventory, entity);
        this.isMonster = Bole.isMonster(this.entity);
        this.registerEntitySettingsBufHandlers();
    }

    private void registerEntitySettingsBufHandlers() {
        this.registerEntitySettingsBufHandler("nether_portal_cooldown", new AbstractBoleScreenHandler.EntitySettingsBufHandler(){

            @Override
            public void readFromBuf(class_2540 buf) {
                if (BoleEntityScreenHandler.this.isOtherPlayer() && Configs.getInstance().isForbidToSetNetherPortalCooldownOfOtherPlayers()) {
                    BoleEntityScreenHandler.this.sendOverlayMessage((class_2561)class_2561.method_43471((String)"text.hint.bole.forbid_to_set_nether_portal_cooldown_of_other_players"));
                    return;
                }
                ((IMixinEntity)BoleEntityScreenHandler.this.entity).setPortalCooldown(buf.readInt());
            }

            @Override
            public void writeToBuf(class_2540 buf, Object ... args) {
                int cooldown = (Integer)args[0];
                ((IMixinEntity)BoleEntityScreenHandler.this.entity).setPortalCooldown(cooldown);
                buf.writeInt(cooldown);
            }
        });
        this.registerEntitySettingsBufHandler("custom_name_visible", new AbstractBoleScreenHandler.EntitySettingsBufHandler(){

            @Override
            public void readFromBuf(class_2540 buf) {
                BoleEntityScreenHandler.this.entity.method_5880(buf.readBoolean());
            }

            @Override
            public void writeToBuf(class_2540 buf, Object ... args) {
                boolean visible = (Boolean)args[0];
                BoleEntityScreenHandler.this.entity.method_5880(visible);
                buf.writeBoolean(visible);
            }
        });
        this.registerEntitySettingsBufHandler("silent", new AbstractBoleScreenHandler.EntitySettingsBufHandler(){

            @Override
            public void readFromBuf(class_2540 buf) {
                BoleEntityScreenHandler.this.entity.method_5803(buf.readBoolean());
            }

            @Override
            public void writeToBuf(class_2540 buf, Object ... args) {
                boolean silent = (Boolean)args[0];
                buf.writeBoolean(silent);
                BoleEntityScreenHandler.this.entity.method_5803(true);
            }
        });
        this.registerEntitySettingsBufHandler("invulnerable", new AbstractBoleScreenHandler.EntitySettingsBufHandler(){

            @Override
            public void readFromBuf(class_2540 buf) {
                if (BoleEntityScreenHandler.this.isGod()) {
                    BoleEntityScreenHandler.this.entity.method_5684(buf.readBoolean());
                }
            }

            @Override
            public void writeToBuf(class_2540 buf, Object ... args) {
                boolean invulnerable = (Boolean)args[0];
                buf.writeBoolean(invulnerable);
                BoleEntityScreenHandler.this.entity.method_5684(invulnerable);
            }
        });
    }

    @Override
    protected void initServer() {
        super.initServer();
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    protected void initClient() {
        super.initClient();
    }

    @Override
    protected void initCustom() {
    }

    @Override
    protected void writeServerEntityToBuf(class_2540 buf) {
        buf.writeInt(this.field_7763);
        buf.writeInt(((IMixinEntity)this.entity).getPortalCooldown());
        buf.writeBoolean(this.entity.method_5655());
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    protected void readServerEntityFromBuf(class_2540 buf) {
        int id = buf.readInt();
        if (this.field_7763 != id) {
            throw new RuntimeException("Expired packet of the server entity.");
        }
        ((IMixinEntity)this.entity).setPortalCooldown(buf.readInt());
        this.entity.method_5684(buf.readBoolean());
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    protected void resetClientEntityServerProperties() {
        ((IMixinEntity)this.entity).setPortalCooldown(0);
        this.entity.method_5684(false);
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void clientTick(int ticks) {
        if (ticks % 20 == 0) {
            class_437 class_4372;
            if (this.player.method_5858(this.entity) > 100.0 && (class_4372 = class_310.method_1551().field_1755) instanceof AbstractBoleScreen) {
                AbstractBoleScreen screen = (AbstractBoleScreen)class_4372;
                BoleClient.getInstance().getHighlightManager().highlight(this.entity, 60);
                screen.method_25419();
                this.player.method_7353((class_2561)class_2561.method_43471((String)"text.bole.target_entity_too_far").method_27692(class_124.field_1054), true);
            }
            ClientNetworkManager.requestServerEntityData();
        }
        this.calculateClientEntityNetherPortalCooldown();
    }

    protected boolean isOtherPlayer() {
        return this.entity instanceof class_1657 && this.entity != this.player;
    }

    @Environment(value=EnvType.CLIENT)
    private void calculateClientEntityNetherPortalCooldown() {
        switch (this.isClientEntityInNetherPortal()) {
            case -1: {
                ((IMixinEntity)this.entity).callTickPortalCooldown();
                break;
            }
            case 1: {
                this.entity.method_30229();
                break;
            }
        }
    }

    @Environment(value=EnvType.CLIENT)
    private int isClientEntityInNetherPortal() {
        class_638 world = class_310.method_1551().field_1687;
        if (world == null || world.method_8469(this.entity.method_5628()) == null) {
            return 0;
        }
        class_243 pos = this.entity.method_19538();
        double x = pos.method_10216();
        double y = pos.method_10214();
        double z = pos.method_10215();
        double r = 0.3;
        return world.method_8320(new class_2338(x, y, z)).method_26204() == class_2246.field_10316 || world.method_8320(new class_2338(x - 0.3, y, z)).method_26204() == class_2246.field_10316 || world.method_8320(new class_2338(x + 0.3, y, z)).method_26204() == class_2246.field_10316 || world.method_8320(new class_2338(x, y, z - 0.3)).method_26204() == class_2246.field_10316 || world.method_8320(new class_2338(x, y, z + 0.3)).method_26204() == class_2246.field_10316 ? 1 : -1;
    }
}

