/*
 * Decompiled with CFR 0.152.
 */
package xienaoban.minecraft.bole.gui.screen.tree;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1661;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3917;
import xienaoban.minecraft.bole.gui.screen.tree.BoleEntityScreenHandler;
import xienaoban.minecraft.bole.mixin.IMixinStatusEffectInstance;

public class BoleLivingEntityScreenHandler<E extends class_1309>
extends BoleEntityScreenHandler<E> {
    public static final class_3917<BoleLivingEntityScreenHandler<class_1309>> HANDLER = BoleLivingEntityScreenHandler.register(new class_2960("bole", "living_entity"), BoleLivingEntityScreenHandler::new);
    @Environment(value=EnvType.CLIENT)
    protected List<class_1293> entityStatusEffects;

    public BoleLivingEntityScreenHandler(int syncId, class_1661 playerInventory) {
        this(HANDLER, syncId, playerInventory);
    }

    public BoleLivingEntityScreenHandler(int syncId, class_1661 playerInventory, class_1297 entity) {
        this(HANDLER, syncId, playerInventory, entity);
    }

    public BoleLivingEntityScreenHandler(class_3917<?> handler, int syncId, class_1661 playerInventory) {
        this(handler, syncId, playerInventory, BoleLivingEntityScreenHandler.clientEntity());
    }

    public BoleLivingEntityScreenHandler(class_3917<?> handler, int syncId, class_1661 playerInventory, class_1297 entity) {
        super(handler, syncId, playerInventory, entity);
    }

    @Override
    protected void initServer() {
        super.initServer();
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    protected void initClient() {
        super.initClient();
    }

    @Override
    protected void initCustom() {
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void clientTick(int ticks) {
        super.clientTick(ticks);
        this.calStatusEffectsDuration();
    }

    @Override
    protected void writeServerEntityToBuf(class_2540 buf) {
        super.writeServerEntityToBuf(buf);
        Collection effects = ((class_1309)this.entity).method_6026();
        buf.writeInt(effects.size());
        for (class_1293 effect : effects) {
            buf.writeInt(class_1291.method_5554((class_1291)effect.method_5579()));
            buf.writeInt(effect.method_5584());
            buf.writeInt(effect.method_5578());
            buf.writeBoolean(effect.method_5591());
            buf.writeBoolean(effect.method_5581());
        }
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    protected void readServerEntityFromBuf(class_2540 buf) {
        super.readServerEntityFromBuf(buf);
        int size = buf.readInt();
        ArrayList<class_1293> effects = new ArrayList<class_1293>();
        for (int i = 0; i < size; ++i) {
            class_1293 effect = new class_1293(class_1291.method_5569((int)buf.readInt()), buf.readInt(), buf.readInt(), buf.readBoolean(), buf.readBoolean());
            effects.add(effect);
        }
        this.entityStatusEffects = effects;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    protected void resetClientEntityServerProperties() {
        super.resetClientEntityServerProperties();
    }

    @Environment(value=EnvType.CLIENT)
    private void calStatusEffectsDuration() {
        if (this.entityStatusEffects != null) {
            for (class_1293 effect : this.entityStatusEffects) {
                ((IMixinStatusEffectInstance)effect).setDuration(Math.max(effect.method_5584() - 1, 0));
            }
        }
    }
}

