/*
 * Decompiled with CFR 0.152.
 */
package xienaoban.minecraft.bole.gui.screen.tree;

import java.util.Arrays;
import java.util.Comparator;
import java.util.Set;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1297;
import net.minecraft.class_1314;
import net.minecraft.class_1352;
import net.minecraft.class_1355;
import net.minecraft.class_1391;
import net.minecraft.class_1661;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_2348;
import net.minecraft.class_2378;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3917;
import net.minecraft.class_4135;
import xienaoban.minecraft.bole.gui.screen.tree.BoleMobEntityScreenHandler;
import xienaoban.minecraft.bole.mixin.IMixinMobEntity;
import xienaoban.minecraft.bole.mixin.IMixinTemptGoal;

public class BolePathAwareEntityScreenHandler<E extends class_1314>
extends BoleMobEntityScreenHandler<E> {
    public static final class_3917<BolePathAwareEntityScreenHandler<class_1314>> HANDLER = BolePathAwareEntityScreenHandler.register(new class_2960("bole", "path_aware_entity"), BolePathAwareEntityScreenHandler::new);
    @Environment(value=EnvType.CLIENT)
    protected class_1792[] entityAttractiveItems;

    public BolePathAwareEntityScreenHandler(int syncId, class_1661 playerInventory) {
        this(HANDLER, syncId, playerInventory);
    }

    public BolePathAwareEntityScreenHandler(int syncId, class_1661 playerInventory, class_1297 entity) {
        this(HANDLER, syncId, playerInventory, entity);
    }

    public BolePathAwareEntityScreenHandler(class_3917<?> handler, int syncId, class_1661 playerInventory) {
        this(handler, syncId, playerInventory, BolePathAwareEntityScreenHandler.clientEntity());
    }

    public BolePathAwareEntityScreenHandler(class_3917<?> handler, int syncId, class_1661 playerInventory, class_1297 entity) {
        super(handler, syncId, playerInventory, entity);
    }

    @Override
    protected void initServer() {
        super.initServer();
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    protected void initClient() {
        super.initClient();
    }

    @Override
    protected void initCustom() {
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void clientTick(int ticks) {
        super.clientTick(ticks);
    }

    @Override
    protected void writeServerEntityToBuf(class_2540 buf) {
        super.writeServerEntityToBuf(buf);
        class_1792[] items = this.getEntityAttractiveItems();
        buf.writeInt(items.length);
        Arrays.stream(items).forEach(item -> buf.method_10814(class_2378.field_11142.method_10221(item).toString()));
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    protected void readServerEntityFromBuf(class_2540 buf) {
        super.readServerEntityFromBuf(buf);
        int len = buf.readInt();
        class_1792[] items = new class_1792[len];
        for (int i = 0; i < len; ++i) {
            items[i] = (class_1792)class_2378.field_11142.method_10223(new class_2960(buf.method_19772()));
        }
        this.entityAttractiveItems = items;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    protected void resetClientEntityServerProperties() {
        super.resetClientEntityServerProperties();
    }

    private class_1792[] getEntityAttractiveItems() {
        if (this.entityAttractiveItems != null) {
            return this.entityAttractiveItems;
        }
        class_1792[] items = null;
        class_1355 goalSelector = ((IMixinMobEntity)this.entity).getGoalSelector();
        Set goals = goalSelector.method_35115();
        for (class_4135 prioritizedGoal : goals) {
            class_1352 goal = prioritizedGoal.method_19058();
            if (!(goal instanceof class_1391)) continue;
            class_1856 foods = ((IMixinTemptGoal)goal).getFood();
            class_1799[] itemStacks = foods.method_8105();
            items = (class_1792[])Arrays.stream(itemStacks).map(class_1799::method_7909).sorted(Comparator.comparing(arg_0 -> ((class_2348)class_2378.field_11142).method_10221(arg_0))).toArray(class_1792[]::new);
            break;
        }
        if (items == null) {
            items = new class_1792[]{};
        }
        this.entityAttractiveItems = items;
        return items;
    }
}

