/*
 * Decompiled with CFR 0.152.
 */
package xienaoban.minecraft.bole.network;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import io.netty.buffer.ByteBuf;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_124;
import net.minecraft.class_1263;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3908;
import net.minecraft.class_3988;
import net.minecraft.class_4481;
import net.minecraft.class_5321;
import net.minecraft.server.MinecraftServer;
import xienaoban.minecraft.bole.Bole;
import xienaoban.minecraft.bole.config.Configs;
import xienaoban.minecraft.bole.core.BoleHandbookItem;
import xienaoban.minecraft.bole.gui.ScreenHandlerManager;
import xienaoban.minecraft.bole.gui.screen.AbstractBoleScreenHandler;
import xienaoban.minecraft.bole.gui.screen.misc.BeehiveScreenHandler;
import xienaoban.minecraft.bole.gui.screen.misc.MerchantInventoryScreenHandler;
import xienaoban.minecraft.bole.gui.screen.tree.BoleMerchantEntityScreenHandler;
import xienaoban.minecraft.bole.network.Channels;

public class ServerNetworkManager {
    public static void init() {
        ServerNetworkManager.registerRequestServerBoleConfigs();
        ServerNetworkManager.registerRequestBoleScreen();
        ServerNetworkManager.registerRequestBoleHandbook();
        ServerNetworkManager.registerRequestServerEntityData();
        ServerNetworkManager.registerSendClientEntitySettings();
        ServerNetworkManager.registerRequestServerEntitiesGlowing();
        ServerNetworkManager.registerSendHighlightEvent();
        ServerNetworkManager.registerRequestBeehiveScreen();
        ServerNetworkManager.registerRequestMerchantInventoryScreen();
        ServerNetworkManager.registerRequestBeehiveInfo();
    }

    private static void registerRequestServerBoleConfigs() {
        ServerPlayNetworking.registerGlobalReceiver((class_2960)Channels.REQUEST_SERVER_BOLE_CONFIGS, (server, player, handler, buf, responseSender) -> ServerNetworkManager.sendServerBoleConfigs(server, player));
    }

    private static void registerRequestBoleScreen() {
        ServerPlayNetworking.registerGlobalReceiver((class_2960)Channels.REQUEST_BOLE_SCREEN, (server, player, handler, buf, responseSender) -> {
            final class_1297 entity = buf.isReadable() ? player.field_6002.method_8469(buf.readInt()) : null;
            server.execute(() -> {
                if (!(Bole.isDetached((class_1657)player) || Configs.getInstance().isAllowHotKeyToOpenBoleHandbookScreen() || Bole.isBoleHandbook(player.method_6047()) || Bole.isBoleHandbook(player.method_6079()))) {
                    player.method_7353((class_2561)class_2561.method_43471((String)"text.bole.server_ban_hotkey").method_27692(class_124.field_1065), false);
                    return;
                }
                player.method_17355(new class_3908(){

                    public class_1703 createMenu(int syncId, class_1661 inv, class_1657 player) {
                        return ScreenHandlerManager.getHandler(syncId, inv, entity);
                    }

                    public class_2561 method_5476() {
                        String titleKey = entity == null ? "title.bole.bole_handbook" : entity.method_5864().method_5882();
                        return class_2561.method_43471((String)titleKey);
                    }
                });
            });
        });
    }

    private static void registerRequestBoleHandbook() {
        ServerPlayNetworking.registerGlobalReceiver((class_2960)Channels.REQUEST_BOLE_HANDBOOK_ITEM, (server, player, handler, buf, responseSender) -> server.execute(() -> {
            if (Bole.isGod((class_1657)player)) {
                player.method_31548().method_7394(BoleHandbookItem.createBook());
            }
        }));
    }

    private static void registerRequestServerEntityData() {
        ServerPlayNetworking.registerGlobalReceiver((class_2960)Channels.REQUEST_SERVER_ENTITY_DATA, (server, player, handler, buf, responseSender) -> {
            AbstractBoleScreenHandler<?> boleScreenHandler = ServerNetworkManager.getBoleScreenHandler(player);
            if (boleScreenHandler == null) {
                return;
            }
            ServerNetworkManager.sendServerEntityData(boleScreenHandler, server, player);
        });
    }

    private static void registerSendClientEntitySettings() {
        ServerPlayNetworking.registerGlobalReceiver((class_2960)Channels.SEND_CLIENT_ENTITY_SETTINGS, (server, player, handler, buf, responseSender) -> {
            AbstractBoleScreenHandler<?> boleScreenHandler = ServerNetworkManager.getBoleScreenHandler(player);
            if (boleScreenHandler == null) {
                return;
            }
            class_2540 bufCopy = PacketByteBufs.copy((ByteBuf)buf);
            server.execute(() -> boleScreenHandler.receiveServerEntitySettings(bufCopy));
        });
    }

    private static void registerRequestServerEntitiesGlowing() {
        ServerPlayNetworking.registerGlobalReceiver((class_2960)Channels.REQUEST_SERVER_ENTITIES_GLOWING, (server, player, handler, buf, responseSender) -> {
            int size = buf.readInt();
            class_2960 worldId = buf.method_10810();
            class_3218 world = server.method_3847(class_5321.method_29179((class_5321)class_2378.field_25298, (class_2960)worldId));
            if (world == null) {
                return;
            }
            int[] entityIds = new int[size];
            for (int i = 0; i < size; ++i) {
                entityIds[i] = buf.readInt();
            }
            server.execute(() -> ServerNetworkManager.lambda$registerRequestServerEntitiesGlowing$8(size, worldId, entityIds, (class_1937)world, player));
        });
    }

    private static void registerSendHighlightEvent() {
        ServerPlayNetworking.registerGlobalReceiver((class_2960)Channels.SEND_HIGHLIGHT_EVENT, (server, player, handler, buf, responseSender) -> {
            int ticks = buf.readInt();
            server.execute(() -> {
                if (ticks > 0) {
                    player.method_6092(new class_1293(class_1294.field_5919, ticks));
                }
                if (!Bole.isDetached((class_1657)player)) {
                    player.method_7255(-2);
                }
            });
        });
    }

    private static void registerRequestBeehiveScreen() {
        ServerPlayNetworking.registerGlobalReceiver((class_2960)Channels.REQUEST_BEEHIVE_SCREEN, (server, player, handler, buf, responseSender) -> {
            final class_2338 pos = buf.method_10811();
            final class_2680 blockState = player.field_6002.method_8320(pos);
            if (blockState.method_26204() instanceof class_4481) {
                server.execute(() -> player.method_17355(new class_3908(){

                    public class_1703 createMenu(int syncId, class_1661 inv, class_1657 player) {
                        return new BeehiveScreenHandler(syncId, inv, pos);
                    }

                    public class_2561 method_5476() {
                        return class_2561.method_43469((String)"text.bole.inventory_of", (Object[])new Object[]{class_2561.method_43471((String)blockState.method_26204().method_9539())});
                    }
                }));
            } else {
                Bole.LOGGER.error("Cannot open BeehiveScreen.");
            }
        });
    }

    private static void registerRequestMerchantInventoryScreen() {
        ServerPlayNetworking.registerGlobalReceiver((class_2960)Channels.REQUEST_MERCHANT_INVENTORY_SCREEN, (server, player, handler, buf, responseSender) -> {
            class_1297 patt8628$temp = player.field_6002.method_8469(buf.readInt());
            if (patt8628$temp instanceof class_3988) {
                final class_3988 merchantEntity = (class_3988)patt8628$temp;
                class_1703 patt8721$temp = player.field_7512;
                if (patt8721$temp instanceof BoleMerchantEntityScreenHandler) {
                    BoleMerchantEntityScreenHandler oldHandler = (BoleMerchantEntityScreenHandler)patt8721$temp;
                    server.execute(() -> {
                        if (oldHandler.isGod() || oldHandler.trySpendItems(BoleMerchantEntityScreenHandler.OPEN_INVENTORY_COST)) {
                            player.method_17355(new class_3908(){

                                public class_1703 createMenu(int syncId, class_1661 inv, class_1657 player) {
                                    return new MerchantInventoryScreenHandler(syncId, inv, (class_1263)merchantEntity.method_35199());
                                }

                                public class_2561 method_5476() {
                                    return class_2561.method_43469((String)"text.bole.inventory_of", (Object[])new Object[]{class_2561.method_43471((String)merchantEntity.method_5864().method_5882())});
                                }
                            });
                        }
                    });
                    return;
                }
            }
            Bole.LOGGER.error("Cannot open BoleMerchantEntityScreen.");
        });
    }

    private static void registerRequestBeehiveInfo() {
        ServerPlayNetworking.registerGlobalReceiver((class_2960)Channels.REQUEST_BEEHIVE_INFO, (server, player, handler, buf, responseSender) -> {
            class_1703 patt10042$temp = player.field_7512;
            if (patt10042$temp instanceof BeehiveScreenHandler) {
                BeehiveScreenHandler beehiveScreenHandler = (BeehiveScreenHandler)patt10042$temp;
                ServerNetworkManager.sendServerBeehiveInfo(beehiveScreenHandler, server, player);
            }
        });
    }

    public static void sendServerBoleConfigs(MinecraftServer server, class_3222 player) {
        server.execute(() -> {
            Gson gson = new GsonBuilder().setPrettyPrinting().create();
            String conf = gson.toJson((Object)Configs.getInstance());
            class_2540 buf = PacketByteBufs.create();
            buf.method_10814(Bole.getModVersion());
            buf.method_10814(conf);
            ServerPlayNetworking.send((class_3222)player, (class_2960)Channels.SEND_SERVER_BOLE_CONFIGS, (class_2540)buf);
        });
    }

    public static void sendServerBoleConfigsToAllPlayers(MinecraftServer server) {
        server.execute(() -> {
            String version = Bole.getModVersion();
            Gson gson = new GsonBuilder().setPrettyPrinting().create();
            String conf = gson.toJson((Object)Configs.getInstance());
            for (class_3222 player : server.method_3760().method_14571()) {
                class_2540 buf = PacketByteBufs.create();
                buf.method_10814(version);
                buf.method_10814(conf);
                ServerPlayNetworking.send((class_3222)player, (class_2960)Channels.SEND_SERVER_BOLE_CONFIGS, (class_2540)buf);
            }
        });
    }

    public static void sendWanderingTraderSpawnMessageToAllPlayers(MinecraftServer server, class_3222 target) {
        server.execute(() -> {
            for (class_3222 player : server.method_3760().method_14571()) {
                class_2540 buf = PacketByteBufs.create();
                buf.writeBoolean(target != null);
                if (target != null) {
                    buf.method_10805(target.method_5477());
                }
                ServerPlayNetworking.send((class_3222)player, (class_2960)Channels.SEND_WANDERING_TRADER_SPAWN_MESSAGE, (class_2540)buf);
            }
        });
    }

    public static void sendServerEntityData(AbstractBoleScreenHandler<?> boleScreenHandler, MinecraftServer server, class_3222 player) {
        server.execute(() -> {
            class_2540 entityBuf = PacketByteBufs.create();
            boleScreenHandler.tryWriteServerEntityFromBuf(entityBuf);
            ServerPlayNetworking.send((class_3222)player, (class_2960)Channels.SEND_SERVER_ENTITY_DATA, (class_2540)entityBuf);
        });
    }

    public static void sendServerBeehiveInfo(BeehiveScreenHandler beehiveScreenHandler, MinecraftServer server, class_3222 player) {
        server.execute(() -> {
            class_2540 buf2 = PacketByteBufs.create();
            beehiveScreenHandler.writeBeehiveInfo(buf2);
            ServerPlayNetworking.send((class_3222)player, (class_2960)Channels.SEND_BEEHIVE_INFO, (class_2540)buf2);
        });
    }

    public static void sendOverlayMessage(class_2561 text, MinecraftServer server, class_3222 player) {
        server.execute(() -> {
            class_2540 buf = PacketByteBufs.create();
            buf.method_10805(text);
            ServerPlayNetworking.send((class_3222)player, (class_2960)Channels.SEND_OVERLAY_MESSAGE, (class_2540)buf);
        });
    }

    private static AbstractBoleScreenHandler<?> getBoleScreenHandler(class_3222 player) {
        if (!(player.field_7512 instanceof AbstractBoleScreenHandler)) {
            Bole.LOGGER.warn("The bole screen may have been closed. Buf ignored.");
            return null;
        }
        return (AbstractBoleScreenHandler)player.field_7512;
    }

    private static /* synthetic */ void lambda$registerRequestServerEntitiesGlowing$8(int size, class_2960 worldId, int[] entityIds, class_1937 world, class_3222 player) {
        class_2540 res = PacketByteBufs.create();
        res.writeInt(size);
        res.method_10812(worldId);
        for (int i = 0; i < size; ++i) {
            int entityId = entityIds[i];
            class_1297 entity = world.method_8469(entityId);
            res.writeInt(entityId);
            res.writeBoolean(entity != null && entity.method_5851());
        }
        ServerPlayNetworking.send((class_3222)player, (class_2960)Channels.SEND_SERVER_ENTITIES_GLOWING, (class_2540)res);
    }
}

