/*
 * Decompiled with CFR 0.152.
 */
package xienaoban.minecraft.bole.util;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.UUID;
import net.fabricmc.loader.api.FabricLoader;
import xienaoban.minecraft.bole.Bole;

public class MiscUtil {
    public static <T> T cast(Object obj) {
        return (T)obj;
    }

    public static Path getConfigPath() {
        return FabricLoader.getInstance().getConfigDir();
    }

    public static BufferedReader getFileReader(Path path) throws IOException {
        return Files.newBufferedReader(path);
    }

    public static BufferedWriter getFileWriter(Path path) throws IOException {
        Files.createDirectories(path.getParent(), new FileAttribute[0]);
        return Files.newBufferedWriter(path, StandardOpenOption.CREATE);
    }

    public static BufferedReader getResourceReader(String path) throws IOException {
        InputStream inputStream = MiscUtil.class.getResourceAsStream(path);
        if (inputStream == null) {
            throw new IOException("Resource not found: " + path);
        }
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
        return new BufferedReader(inputStreamReader);
    }

    public static String requestMojangApiGetPlayerName(UUID uuid) {
        String uuidString = uuid.toString().replaceAll("-", "");
        String url = "https://api.mojang.com/user/profiles/" + uuidString + "/names";
        try {
            String res = MiscUtil.requestHttpToString(url);
            if (res == null) {
                return "text.bole.not_genuine_player";
            }
            JsonArray names = JsonParser.parseString((String)res).getAsJsonArray();
            JsonObject json = names.get(names.size() - 1).getAsJsonObject();
            return json.get("name").getAsString();
        }
        catch (Exception e) {
            Bole.LOGGER.error("Unable to parse mojang api: " + url);
            e.printStackTrace();
            return "text.bole.fail_to_request_mojang_api";
        }
    }

    /*
     * Exception decompiling
     */
    private static String requestHttpToString(String url) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

