/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.paucal.api.contrib;

import at.petrak.paucal.PaucalMod;
import at.petrak.paucal.api.contrib.ContributorType;
import com.electronwill.nightconfig.core.AbstractConfig;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.jetbrains.annotations.Nullable;

public class Contributor {
    private final UUID uuid;
    private final ContributorType contributorType;
    private final Map<String, Object> otherVals;

    public Contributor(UUID uuid, AbstractConfig cfg) {
        this.uuid = uuid;
        this.otherVals = cfg.valueMap();
        int level = (Integer)this.otherVals.get("paucal:contributorLevel");
        boolean isDev = (Boolean)this.otherVals.get("paucal:isDev");
        boolean isCool = (Boolean)this.otherVals.get("paucal:isCool");
        this.contributorType = new ContributorType(level, isDev, isCool);
    }

    public ContributorType getContributorType() {
        return this.contributorType;
    }

    @Nullable
    public String getString(String key) {
        Object value = this.otherVals.get(key);
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            String x = (String)value;
            return x;
        }
        PaucalMod.LOGGER.warn("Tried to get non-string value of key '{}' (contributor {})", (Object)key, (Object)this.uuid);
        return null;
    }

    @Nullable
    public Integer getInt(String key) {
        Object value = this.otherVals.get(key);
        if (value == null) {
            return null;
        }
        if (value instanceof Integer) {
            Integer x = (Integer)value;
            return x;
        }
        PaucalMod.LOGGER.warn("Tried to get non-int value of key '{}' (contributor {})", (Object)key, (Object)this.uuid);
        return null;
    }

    @Nullable
    public Float getFloat(String key) {
        Object value = this.otherVals.get(key);
        if (value == null) {
            return null;
        }
        if (value instanceof Float) {
            Float x = (Float)value;
            return x;
        }
        PaucalMod.LOGGER.warn("Tried to get non-float value of key '{}' (contributor {})", (Object)key, (Object)this.uuid);
        return null;
    }

    @Nullable
    public Object getRaw(String key) {
        return this.otherVals.get(key);
    }

    public UUID getUuid() {
        return this.uuid;
    }

    public Set<String> allKeys() {
        return this.otherVals.keySet();
    }
}

