/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.paucal.api.contrib;

import at.petrak.paucal.PaucalMod;
import at.petrak.paucal.api.contrib.Contributor;
import at.petrak.paucal.common.PaucalConfig;
import com.electronwill.nightconfig.core.AbstractConfig;
import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.UnmodifiableCommentedConfig;
import com.electronwill.nightconfig.toml.TomlParser;
import java.io.IOException;
import java.net.URL;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.DefaultUncaughtExceptionHandler;
import org.jetbrains.annotations.Nullable;

public class Contributors {
    private static final ConcurrentHashMap<UUID, Contributor> CONTRIBUTORS = new ConcurrentHashMap();
    private static boolean startedLoading = false;

    @Nullable
    public static Contributor getContributor(UUID uuid) {
        return CONTRIBUTORS.get(uuid);
    }

    public static void loadContributors() {
        if (!startedLoading) {
            startedLoading = true;
            if (!((Boolean)PaucalConfig.loadContributors.get()).booleanValue()) {
                PaucalMod.LOGGER.info("Contributors disabled in the config!");
                return;
            }
            Thread thread = new Thread(Contributors::fetch);
            thread.setName("PAUCAL Contributors Loading Thread");
            thread.setDaemon(true);
            thread.setUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)new DefaultUncaughtExceptionHandler(PaucalMod.LOGGER));
            thread.start();
        }
    }

    private static void fetch() {
        UnmodifiableCommentedConfig config;
        try {
            URL url = new URL("https://raw.githubusercontent.com/gamma-delta/contributors/main/paucal.toml");
            config = ((CommentedConfig)new TomlParser().parse(url)).unmodifiable();
        }
        catch (IOException exn) {
            PaucalMod.LOGGER.warn("Couldn't load contributors from Github: {}", (Object)exn.getMessage());
            PaucalMod.LOGGER.warn("Oh well :(");
            return;
        }
        Set keys = config.valueMap().keySet();
        for (String key : keys) {
            try {
                AbstractConfig rawEntry = (AbstractConfig)config.get(key);
                UUID uuid = UUID.fromString(key);
                Contributor contributor = new Contributor(uuid, rawEntry);
                CONTRIBUTORS.put(uuid, contributor);
            }
            catch (Exception exn) {
                PaucalMod.LOGGER.warn("Exception when loading contributor '{}': {}", (Object)key, (Object)exn.getMessage());
            }
        }
    }
}

