/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.paucal.api.datagen;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.HashCache;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.LootTables;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;

public abstract class PaucalLootTableProvider
extends LootTableProvider {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    protected final DataGenerator f_124433_;

    public PaucalLootTableProvider(DataGenerator pGenerator) {
        super(pGenerator);
        this.f_124433_ = pGenerator;
    }

    protected abstract void makeLootTables(Map<Block, LootTable.Builder> var1);

    protected LootPool.Builder dropThisPool(ItemLike item, int count) {
        return this.dropThisPool(item, (NumberProvider)ConstantValue.m_165692_((float)count));
    }

    protected LootPool.Builder dropThisPool(ItemLike item, NumberProvider count) {
        return this.dropThisPool(item, count, item.m_5456_().getRegistryName().m_135815_());
    }

    protected LootPool.Builder dropThisPool(ItemLike item, NumberProvider count, String name) {
        return LootPool.m_79043_().name(name).m_165133_(count).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)item));
    }

    @SafeVarargs
    protected final void dropSelf(Map<Block, LootTable.Builder> lootTables, Supplier<? extends Block> ... blocks) {
        for (Supplier<? extends Block> blockSupp : blocks) {
            Block block = blockSupp.get();
            this.dropSelf(block, lootTables);
        }
    }

    protected void dropSelf(Map<Block, LootTable.Builder> lootTables, Block ... blocks) {
        for (Block block : blocks) {
            this.dropSelf(block, lootTables);
        }
    }

    protected void dropSelf(Block block, Map<Block, LootTable.Builder> lootTables) {
        LootTable.Builder table = LootTable.m_79147_().m_79161_(this.dropThisPool((ItemLike)block, 1));
        lootTables.put(block, table);
    }

    protected void dropThis(Block block, ItemLike drop, Map<Block, LootTable.Builder> lootTables) {
        LootTable.Builder table = LootTable.m_79147_().m_79161_(this.dropThisPool(drop, 1));
        lootTables.put(block, table);
    }

    protected void dropThis(Block block, ItemLike drop, NumberProvider count, Map<Block, LootTable.Builder> lootTables) {
        LootTable.Builder table = LootTable.m_79147_().m_79161_(this.dropThisPool(drop, count));
        lootTables.put(block, table);
    }

    public void m_6865_(HashCache cache) {
        HashMap<Block, LootTable.Builder> lootTables = new HashMap<Block, LootTable.Builder>();
        this.makeLootTables(lootTables);
        HashMap<ResourceLocation, LootTable> tables = new HashMap<ResourceLocation, LootTable>();
        for (Map.Entry<Block, LootTable.Builder> entry : lootTables.entrySet()) {
            tables.put(entry.getKey().m_60589_(), entry.getValue().m_79165_(LootContextParamSets.f_81421_).m_79167_());
        }
        Path outputFolder = this.f_124433_.m_123916_();
        tables.forEach((key, lootTable) -> {
            Path path = outputFolder.resolve("data/" + key.m_135827_() + "/loot_tables/" + key.m_135815_() + ".json");
            try {
                DataProvider.m_123920_((Gson)GSON, (HashCache)cache, (JsonElement)LootTables.m_79200_((LootTable)lootTable), (Path)path);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        });
    }
}

