/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.paucal.api.datagen;

import java.util.function.Consumer;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.Nullable;

public abstract class PaucalRecipeProvider
extends RecipeProvider {
    protected final String modid;

    public PaucalRecipeProvider(DataGenerator pGenerator, String modid) {
        super(pGenerator);
        this.modid = modid;
    }

    protected ShapedRecipeBuilder ring(ItemLike out, int count, Ingredient outer, @Nullable Ingredient inner) {
        return this.ringCornered(out, count, outer, outer, inner);
    }

    protected ShapedRecipeBuilder ring(ItemLike out, int count, ItemLike outer, @Nullable ItemLike inner) {
        return this.ring(out, count, Ingredient.m_43929_((ItemLike[])new ItemLike[]{outer}), this.ingredientOf(inner));
    }

    protected ShapedRecipeBuilder ring(ItemLike out, int count, TagKey<Item> outer, @Nullable TagKey<Item> inner) {
        return this.ring(out, count, Ingredient.m_204132_(outer), this.ingredientOf(inner));
    }

    protected ShapedRecipeBuilder ringCornerless(ItemLike out, int count, Ingredient outer, @Nullable Ingredient inner) {
        return this.ringCornered(out, count, outer, null, inner);
    }

    protected ShapedRecipeBuilder ringCornerless(ItemLike out, int count, ItemLike outer, @Nullable ItemLike inner) {
        return this.ringCornerless(out, count, Ingredient.m_43929_((ItemLike[])new ItemLike[]{outer}), this.ingredientOf(inner));
    }

    protected ShapedRecipeBuilder ringCornerless(ItemLike out, int count, TagKey<Item> outer, @Nullable TagKey<Item> inner) {
        return this.ringCornerless(out, count, Ingredient.m_204132_(outer), this.ingredientOf(inner));
    }

    protected ShapedRecipeBuilder ringAll(ItemLike out, int count, Ingredient outer, @Nullable Ingredient inner) {
        return this.ringCornered(out, count, outer, outer, inner);
    }

    protected ShapedRecipeBuilder ringAll(ItemLike out, int count, ItemLike outer, @Nullable ItemLike inner) {
        return this.ringAll(out, count, Ingredient.m_43929_((ItemLike[])new ItemLike[]{outer}), this.ingredientOf(inner));
    }

    protected ShapedRecipeBuilder ringAll(ItemLike out, int count, TagKey<Item> outer, @Nullable TagKey<Item> inner) {
        return this.ringAll(out, count, Ingredient.m_204132_(outer), this.ingredientOf(inner));
    }

    protected ShapedRecipeBuilder ringCornered(ItemLike out, int count, @Nullable Ingredient cardinal, @Nullable Ingredient diagonal, @Nullable Ingredient inner) {
        if (cardinal == null && diagonal == null && inner == null) {
            throw new IllegalArgumentException("at least one ingredient must be non-null");
        }
        if (inner != null && cardinal == null && diagonal == null) {
            throw new IllegalArgumentException("if inner is non-null, either cardinal or diagonal must not be");
        }
        ShapedRecipeBuilder builder = ShapedRecipeBuilder.m_126118_((ItemLike)out, (int)count);
        char C = ' ';
        if (cardinal != null) {
            builder.m_126124_(Character.valueOf('C'), cardinal);
            C = 'C';
        }
        char D = ' ';
        if (diagonal != null) {
            builder.m_126124_(Character.valueOf('D'), diagonal);
            D = 'D';
        }
        char I = ' ';
        if (inner != null) {
            builder.m_126124_(Character.valueOf('I'), inner);
            I = 'I';
        }
        builder.m_126130_(String.format("%c%c%c", Character.valueOf(D), Character.valueOf(C), Character.valueOf(D))).m_126130_(String.format("%c%c%c", Character.valueOf(C), Character.valueOf(I), Character.valueOf(C))).m_126130_(String.format("%c%c%c", Character.valueOf(D), Character.valueOf(C), Character.valueOf(D)));
        return builder;
    }

    protected ShapedRecipeBuilder ringCornered(ItemLike out, int count, @Nullable ItemLike cardinal, @Nullable ItemLike diagonal, @Nullable ItemLike inner) {
        return this.ringCornered(out, count, this.ingredientOf(cardinal), this.ingredientOf(diagonal), this.ingredientOf(inner));
    }

    protected ShapedRecipeBuilder ringCornered(ItemLike out, int count, @Nullable TagKey<Item> cardinal, @Nullable TagKey<Item> diagonal, @Nullable TagKey<Item> inner) {
        return this.ringCornered(out, count, this.ingredientOf(cardinal), this.ingredientOf(diagonal), this.ingredientOf(inner));
    }

    protected ShapedRecipeBuilder stack(ItemLike out, int count, Ingredient top, Ingredient bottom) {
        return ShapedRecipeBuilder.m_126118_((ItemLike)out, (int)count).m_126124_(Character.valueOf('T'), top).m_126124_(Character.valueOf('B'), bottom).m_126130_("T").m_126130_("B");
    }

    protected ShapedRecipeBuilder stack(ItemLike out, int count, ItemLike top, ItemLike bottom) {
        return this.stack(out, count, Ingredient.m_43929_((ItemLike[])new ItemLike[]{top}), Ingredient.m_43929_((ItemLike[])new ItemLike[]{bottom}));
    }

    protected ShapedRecipeBuilder stack(ItemLike out, int count, TagKey<Item> top, TagKey<Item> bottom) {
        return this.stack(out, count, Ingredient.m_204132_(top), Ingredient.m_204132_(bottom));
    }

    protected ShapedRecipeBuilder stick(ItemLike out, int count, Ingredient input) {
        return this.stack(out, count, input, input);
    }

    protected ShapedRecipeBuilder stick(ItemLike out, int count, ItemLike input) {
        return this.stick(out, count, Ingredient.m_43929_((ItemLike[])new ItemLike[]{input}));
    }

    protected ShapedRecipeBuilder stick(ItemLike out, int count, TagKey<Item> input) {
        return this.stick(out, count, Ingredient.m_204132_(input));
    }

    protected void packing(ItemLike free, ItemLike compressed, String freeName, boolean largeSize, Consumer<FinishedRecipe> recipes) {
        ShapedRecipeBuilder pack = ShapedRecipeBuilder.m_126116_((ItemLike)compressed).m_126127_(Character.valueOf('X'), free);
        if (largeSize) {
            pack.m_126130_("XXX").m_126130_("XXX").m_126130_("XXX");
        } else {
            pack.m_126130_("XX").m_126130_("XX");
        }
        pack.m_142284_("has_item", (CriterionTriggerInstance)PaucalRecipeProvider.m_125977_((ItemLike)free)).m_142700_(recipes, this.modLoc(freeName + "_packing"));
        ShapelessRecipeBuilder.m_126191_((ItemLike)free, (int)(largeSize ? 9 : 4)).m_126209_(compressed).m_142284_("has_item", (CriterionTriggerInstance)PaucalRecipeProvider.m_125977_((ItemLike)free)).m_142700_(recipes, this.modLoc(freeName + "_unpacking"));
    }

    protected ResourceLocation modLoc(String path) {
        return new ResourceLocation(this.modid, path);
    }

    @Nullable
    protected Ingredient ingredientOf(@Nullable ItemLike item) {
        return item == null ? null : Ingredient.m_43929_((ItemLike[])new ItemLike[]{item});
    }

    @Nullable
    protected Ingredient ingredientOf(@Nullable TagKey<Item> item) {
        return item == null ? null : Ingredient.m_204132_(item);
    }
}

