/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.biometoasts;

import at.petrak.biometoasts.client.MovementTracker;
import at.petrak.biometoasts.data.BiomeThumbnailManager;
import com.mojang.logging.LogUtils;
import java.io.IOException;
import java.nio.file.Path;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.metadata.MetadataSectionSerializer;
import net.minecraft.server.packs.metadata.pack.PackMetadataSection;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackSource;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraftforge.client.event.RegisterClientReloadListenersEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.AddPackFindersEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.forgespi.locating.IModFile;
import net.minecraftforge.resource.PathResourcePack;
import org.slf4j.Logger;

@Mod(value="biometoasts")
public class BiomeToastsMod {
    public static final String MOD_ID = "biometoasts";
    public static final Logger LOGGER = LogUtils.getLogger();
    public static final BiomeThumbnailManager THUMBNAIL_MANAGER = new BiomeThumbnailManager();

    public BiomeToastsMod() {
        IEventBus modBus = FMLJavaModLoadingContext.get().getModEventBus();
        IEventBus evBus = MinecraftForge.EVENT_BUS;
        modBus.register(BiomeToastsMod.class);
        evBus.register(MovementTracker.class);
    }

    public static ResourceLocation modLoc(String path) {
        return new ResourceLocation(MOD_ID, path);
    }

    @SubscribeEvent
    public static void initResourceListeners(RegisterClientReloadListenersEvent evt) {
        evt.registerReloadListener((PreparableReloadListener)THUMBNAIL_MANAGER);
    }

    @SubscribeEvent
    public static void addPackFinders(AddPackFindersEvent evt) {
        try {
            if (evt.getPackType() == PackType.CLIENT_RESOURCES) {
                IModFile modFile = ModList.get().getModFileById(MOD_ID).getFile();
                Path resourcePath = modFile.findResource(new String[]{"alticons"});
                PathResourcePack pack = new PathResourcePack(modFile.getFileName() + ":" + resourcePath, resourcePath);
                PackMetadataSection metadataSection = (PackMetadataSection)pack.m_5550_((MetadataSectionSerializer)PackMetadataSection.f_10366_);
                if (metadataSection != null) {
                    evt.addRepositorySource((packConsumer, packConstructor) -> packConsumer.accept(packConstructor.create("builtin/biometoasts", (Component)new TranslatableComponent("biometoasts.alticons"), false, () -> pack, metadataSection, Pack.Position.TOP, PackSource.f_10528_, false)));
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

