/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.biometoasts.client.icon;

import at.petrak.biometoasts.BiomeToastsMod;
import at.petrak.biometoasts.client.RenderHelper;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.components.toasts.ToastComponent;
import net.minecraft.commands.arguments.item.ItemArgument;
import net.minecraft.commands.arguments.item.ItemInput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface ThumbnailIcon {
    public void draw(PoseStack var1, ToastComponent var2, long var3);

    public static ThumbnailIcon read(String s) {
        if (s.endsWith(".png")) {
            return new File(new ResourceLocation(s));
        }
        try {
            ItemInput input = ItemArgument.m_120960_().parse(new StringReader(s));
            ItemStack stack = input.m_120980_(1, true);
            return new Item(stack);
        }
        catch (CommandSyntaxException e) {
            BiomeToastsMod.LOGGER.warn("Invalid itemstack string: {}", (Object)e.getMessage());
            return new Blank();
        }
    }

    public record File(ResourceLocation path) implements ThumbnailIcon
    {
        @Override
        public void draw(PoseStack ps, ToastComponent toast, long timeSinceLastVisible) {
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.m_157456_((int)0, (ResourceLocation)this.path);
            GuiComponent.m_93133_((PoseStack)ps, (int)0, (int)0, (float)0.0f, (float)0.0f, (int)16, (int)16, (int)16, (int)16);
        }
    }

    public record Item(ItemStack stack) implements ThumbnailIcon
    {
        @Override
        public void draw(PoseStack ps, ToastComponent toast, long timeSinceLastVisible) {
            RenderHelper.renderItemStackInGui(ps, this.stack, 0, 0);
        }
    }

    public record Blank() implements ThumbnailIcon
    {
        @Override
        public void draw(PoseStack ps, ToastComponent toast, long timeSinceLastVisible) {
        }
    }
}

