/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.biometoasts.data;

import at.petrak.biometoasts.BiomeToastsMod;
import at.petrak.biometoasts.client.BiomeThumbnail;
import at.petrak.biometoasts.client.icon.ThumbnailIcon;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimplePreparableReloadListener;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.level.biome.Biome;

public class BiomeThumbnailManager
extends SimplePreparableReloadListener<Map<ResourceLocation, BiomeThumbnail>> {
    private static final ResourceLocation FILE_LOCATION = BiomeToastsMod.modLoc("thumbnails.json");
    private final Map<ResourceLocation, BiomeThumbnail> thumbnails = new HashMap<ResourceLocation, BiomeThumbnail>();

    public BiomeThumbnail getThumbnail(Biome biome) {
        ResourceLocation id = biome.getRegistryName();
        if (this.thumbnails.containsKey(id)) {
            return this.thumbnails.get(id);
        }
        BiomeToastsMod.LOGGER.warn("Tried to get a thumbnail for {} but one wasn't supplied", (Object)id);
        return new BiomeThumbnail(id, new ThumbnailIcon.Blank());
    }

    protected Map<ResourceLocation, BiomeThumbnail> prepare(ResourceManager recman, ProfilerFiller pProfiler) {
        HashMap<ResourceLocation, BiomeThumbnail> out = new HashMap<ResourceLocation, BiomeThumbnail>();
        try {
            for (Resource resource : recman.m_7396_(FILE_LOCATION)) {
                InputStream stream = resource.m_6679_();
                try (InputStreamReader reader = new InputStreamReader(stream, StandardCharsets.UTF_8);){
                    try {
                        JsonObject json = GsonHelper.m_13859_((Reader)reader);
                        JsonObject thumbnails = GsonHelper.m_13930_((JsonObject)json, (String)"thumbnails");
                        Set thumbResLocs = thumbnails.keySet();
                        for (String reslocStr : thumbResLocs) {
                            ResourceLocation key = new ResourceLocation(reslocStr);
                            BiomeThumbnail thumb = BiomeThumbnailManager.deserializeThumbnail(thumbnails.get(reslocStr), key, reslocStr);
                            out.put(key, thumb);
                        }
                    }
                    catch (RuntimeException exn) {
                        BiomeToastsMod.LOGGER.warn("Invalid biometoasts:thumbnails.json in resourcepack: '{}'", (Object)resource.m_7816_(), (Object)exn);
                    }
                }
                finally {
                    if (stream == null) continue;
                    stream.close();
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return out;
    }

    private static BiomeThumbnail deserializeThumbnail(JsonElement json, ResourceLocation key, String realKey) {
        ThumbnailIcon icon;
        if (GsonHelper.m_13803_((JsonElement)json)) {
            String s = json.getAsString();
            icon = ThumbnailIcon.read(s);
        } else {
            JsonObject jobj = GsonHelper.m_13918_((JsonElement)json, (String)realKey);
            String s = GsonHelper.m_13906_((JsonObject)jobj, (String)"icon");
            icon = ThumbnailIcon.read(s);
        }
        return new BiomeThumbnail(key, icon);
    }

    protected void apply(Map<ResourceLocation, BiomeThumbnail> map, ResourceManager recman, ProfilerFiller pProfiler) {
        this.thumbnails.clear();
        this.thumbnails.putAll(map);
    }
}

