/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.configured.client.screen;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.UnmodifiableCommentedConfig;
import com.electronwill.nightconfig.core.UnmodifiableConfig;
import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mrcrayfish.configured.client.screen.ConfigScreen;
import com.mrcrayfish.configured.client.screen.ConfirmationScreen;
import com.mrcrayfish.configured.client.screen.ListMenuScreen;
import com.mrcrayfish.configured.client.screen.WorldSelectionScreen;
import com.mrcrayfish.configured.client.screen.widget.IconButton;
import com.mrcrayfish.configured.util.ConfigHelper;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.config.ModConfig;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.tuple.Pair;

public class ModConfigSelectionScreen
extends ListMenuScreen {
    private final Map<ModConfig.Type, Set<ModConfig>> configMap;

    public ModConfigSelectionScreen(Screen parent, String displayName, ResourceLocation background, Map<ModConfig.Type, Set<ModConfig>> configMap) {
        super(parent, (Component)new TextComponent(displayName), background, 30);
        this.configMap = configMap;
    }

    @Override
    protected void constructEntries(List<ListMenuScreen.Item> entries) {
        Set<ModConfig> serverConfigs;
        Set<ModConfig> commonConfigs;
        Set<ModConfig> clientConfigs = this.configMap.get(ModConfig.Type.CLIENT);
        if (clientConfigs != null) {
            entries.add((ListMenuScreen)this.new ListMenuScreen.TitleItem(new TranslatableComponent("configured.gui.title.client_configuration").getString()));
            clientConfigs.forEach(config -> entries.add(new FileItem((ModConfig)config)));
        }
        if ((commonConfigs = this.configMap.get(ModConfig.Type.COMMON)) != null) {
            entries.add((ListMenuScreen)this.new ListMenuScreen.TitleItem(new TranslatableComponent("configured.gui.title.common_configuration").getString()));
            commonConfigs.forEach(config -> entries.add(new FileItem((ModConfig)config)));
        }
        if ((serverConfigs = this.configMap.get(ModConfig.Type.SERVER)) != null) {
            entries.add((ListMenuScreen)this.new ListMenuScreen.TitleItem(new TranslatableComponent("configured.gui.title.server_configuration").getString()));
            if (ModConfigSelectionScreen.isPlayingGame()) {
                entries.add((ListMenuScreen)this.new ListMenuScreen.SubTitleItem((Component)new TranslatableComponent("configured.gui.server_config_main_menu")));
            } else {
                serverConfigs.forEach(config -> entries.add(new FileItem((ModConfig)config)));
            }
        }
    }

    @Override
    protected void m_7856_() {
        super.m_7856_();
        this.m_142416_((GuiEventListener)new Button(this.f_96543_ / 2 - 75, this.f_96544_ - 29, 150, 20, CommonComponents.f_130660_, button -> this.f_96541_.m_91152_(this.parent)));
    }

    private static String createLabelFromModConfig(ModConfig config) {
        String fileName = config.getFileName();
        fileName = fileName.replace(config.getModId() + "-", "");
        fileName = fileName.substring(0, fileName.length() - ".toml".length());
        fileName = FilenameUtils.getName((String)fileName);
        fileName = ConfigScreen.createLabel(fileName);
        return fileName;
    }

    @OnlyIn(value=Dist.CLIENT)
    public class FileItem
    extends ListMenuScreen.Item {
        protected final ModConfig config;
        protected final Component title;
        protected final Component fileName;
        protected final Button modifyButton;
        @Nullable
        protected final Button restoreButton;
        private final List<Pair<ForgeConfigSpec.ConfigValue<?>, ForgeConfigSpec.ValueSpec>> allConfigValues;

        public FileItem(ModConfig config) {
            super(ModConfigSelectionScreen.createLabelFromModConfig(config));
            this.config = config;
            this.title = this.createTrimmedFileName(ModConfigSelectionScreen.createLabelFromModConfig(config));
            this.allConfigValues = ConfigHelper.gatherAllConfigValues(config);
            this.fileName = this.createTrimmedFileName(config.getFileName()).m_130940_(ChatFormatting.GRAY);
            this.modifyButton = this.createModifyButton(config);
            boolean bl = this.modifyButton.f_93623_ = !ConfigScreen.isPlayingGame() || this.config.getType() != ModConfig.Type.SERVER;
            if (config.getType() != ModConfig.Type.SERVER || Minecraft.m_91087_().f_91074_ != null) {
                this.restoreButton = new IconButton(0, 0, 0, 0, onPress -> this.showRestoreScreen(), (button, poseStack, mouseX, mouseY) -> {
                    if (button.m_5702_()) {
                        if (this.hasRequiredPermission() && button.f_93623_) {
                            ModConfigSelectionScreen.this.m_96617_(poseStack, Minecraft.m_91087_().f_91062_.m_92923_((FormattedText)new TranslatableComponent("configured.gui.reset_all"), Math.max(ModConfigSelectionScreen.this.f_96543_ / 2 - 43, 170)), mouseX, mouseY);
                        } else if (!this.hasRequiredPermission()) {
                            ModConfigSelectionScreen.this.m_96617_(poseStack, Minecraft.m_91087_().f_91062_.m_92923_((FormattedText)new TranslatableComponent("configured.gui.no_permission").m_130940_(ChatFormatting.RED), Math.max(ModConfigSelectionScreen.this.f_96543_ / 2 - 43, 170)), mouseX, mouseY);
                        }
                    }
                });
                this.restoreButton.f_93623_ = this.hasRequiredPermission();
                this.updateRestoreDefaultButton();
            } else {
                this.restoreButton = null;
            }
        }

        private void showRestoreScreen() {
            ConfirmationScreen confirmScreen = new ConfirmationScreen(ModConfigSelectionScreen.this, (Component)new TranslatableComponent("configured.gui.restore_message"), result -> {
                if (!result.booleanValue() || this.allConfigValues == null) {
                    return true;
                }
                CommentedConfig newConfig = CommentedConfig.copy((UnmodifiableCommentedConfig)this.config.getConfigData());
                this.allConfigValues.forEach(pair -> {
                    ForgeConfigSpec.ConfigValue configValue = (ForgeConfigSpec.ConfigValue)pair.getLeft();
                    ForgeConfigSpec.ValueSpec valueSpec = (ForgeConfigSpec.ValueSpec)pair.getRight();
                    newConfig.set(configValue.getPath(), valueSpec.getDefault());
                });
                this.updateRestoreDefaultButton();
                this.config.getConfigData().putAll((UnmodifiableConfig)newConfig);
                ConfigHelper.resetCache(this.config);
                return true;
            });
            confirmScreen.setBackground(ModConfigSelectionScreen.this.background);
            confirmScreen.setPositiveText((Component)new TranslatableComponent("configured.gui.restore").m_130944_(new ChatFormatting[]{ChatFormatting.GOLD, ChatFormatting.BOLD}));
            confirmScreen.setNegativeText(CommonComponents.f_130656_);
            Minecraft.m_91087_().m_91152_((Screen)confirmScreen);
        }

        private boolean hasRequiredPermission() {
            if (this.config.getType() == ModConfig.Type.SERVER && Minecraft.m_91087_().f_91074_ != null) {
                return Minecraft.m_91087_().f_91074_.m_20310_(2);
            }
            return true;
        }

        private MutableComponent createTrimmedFileName(String fileName) {
            TextComponent trimmedFileName = new TextComponent(fileName);
            if (Minecraft.m_91087_().f_91062_.m_92895_(fileName) > 150) {
                trimmedFileName = new TextComponent(Minecraft.m_91087_().f_91062_.m_92834_(fileName, 140) + "...");
            }
            return trimmedFileName;
        }

        private Button createModifyButton(ModConfig config) {
            boolean serverConfig = config.getType() == ModConfig.Type.SERVER && Minecraft.m_91087_().f_91073_ == null;
            String langKey = serverConfig ? "configured.gui.select_world" : "configured.gui.modify";
            return new IconButton(0, 0, serverConfig ? 44 : 33, 0, serverConfig ? 80 : 60, (Component)new TranslatableComponent(langKey), onPress -> {
                if (ConfigScreen.isPlayingGame() && this.config.getType() == ModConfig.Type.SERVER) {
                    return;
                }
                if (serverConfig) {
                    Minecraft.m_91087_().m_91152_((Screen)new WorldSelectionScreen((Screen)ModConfigSelectionScreen.this, ModConfigSelectionScreen.this.background, config, this.title));
                } else {
                    ModList.get().getModContainerById(config.getModId()).ifPresent(container -> Minecraft.m_91087_().m_91152_((Screen)new ConfigScreen((Screen)ModConfigSelectionScreen.this, (Component)new TextComponent(container.getModInfo().getDisplayName()), config, ModConfigSelectionScreen.this.background)));
                }
            });
        }

        public void m_6311_(PoseStack poseStack, int x, int top, int left, int width, int p_230432_6_, int mouseX, int mouseY, boolean p_230432_9_, float partialTicks) {
            Screen.m_93243_((PoseStack)poseStack, (Font)Minecraft.m_91087_().f_91062_, (Component)this.title, (int)(left + 28), (int)(top + 2), (int)0xFFFFFF);
            Screen.m_93243_((PoseStack)poseStack, (Font)Minecraft.m_91087_().f_91062_, (Component)this.fileName, (int)(left + 28), (int)(top + 12), (int)0xFFFFFF);
            float brightness = 1.0f;
            RenderSystem.m_157456_((int)0, (ResourceLocation)IconButton.ICONS);
            RenderSystem.m_157429_((float)brightness, (float)brightness, (float)brightness, (float)1.0f);
            GuiComponent.m_93160_((PoseStack)poseStack, (int)(left + 4), (int)top, (int)18, (int)22, (float)this.getIconU(), (float)11.0f, (int)9, (int)11, (int)64, (int)64);
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.modifyButton.f_93620_ = left + width - 83;
            this.modifyButton.f_93621_ = top;
            this.modifyButton.m_6305_(poseStack, mouseX, mouseY, partialTicks);
            if (this.restoreButton != null) {
                this.restoreButton.f_93620_ = left + width - 21;
                this.restoreButton.f_93621_ = top;
                this.restoreButton.m_6305_(poseStack, mouseX, mouseY, partialTicks);
            }
        }

        private int getIconU() {
            switch (this.config.getType()) {
                case COMMON: {
                    return 9;
                }
                case SERVER: {
                    return 18;
                }
            }
            return 0;
        }

        @Override
        public List<? extends GuiEventListener> m_6702_() {
            if (this.restoreButton != null) {
                return ImmutableList.of((Object)this.modifyButton, (Object)this.restoreButton);
            }
            return ImmutableList.of((Object)this.modifyButton);
        }

        private void updateRestoreDefaultButton() {
            if (this.config != null && this.restoreButton != null && this.hasRequiredPermission()) {
                this.restoreButton.f_93623_ = ConfigHelper.isModified(this.config);
            }
        }
    }
}

