/*
 * Decompiled with CFR 0.152.
 */
package slimeattack07.naval_warfare;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.mojang.serialization.Codec;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.Registry;
import net.minecraft.data.BuiltinRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.FlatLevelSource;
import net.minecraft.world.level.levelgen.StructureSettings;
import net.minecraft.world.level.levelgen.feature.ConfiguredStructureFeature;
import net.minecraft.world.level.levelgen.feature.StructureFeature;
import net.minecraft.world.level.levelgen.feature.configurations.StructureFeatureConfiguration;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.RegistryObject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import slimeattack07.naval_warfare.config.NavalWarfareConfig;
import slimeattack07.naval_warfare.init.NWBlocks;
import slimeattack07.naval_warfare.init.NWItems;
import slimeattack07.naval_warfare.init.NWSounds;
import slimeattack07.naval_warfare.init.NWStats;
import slimeattack07.naval_warfare.init.NWTileEntityTypes;
import slimeattack07.naval_warfare.init.NWTriggers;
import slimeattack07.naval_warfare.init.NWVillagers;
import slimeattack07.naval_warfare.network.NavalNetwork;
import slimeattack07.naval_warfare.objects.NWStructures;
import slimeattack07.naval_warfare.objects.items.DisappearingBlockItem;
import slimeattack07.naval_warfare.objects.items.ShipItem;
import slimeattack07.naval_warfare.objects.structures.NWCStructures;

@Mod(value="naval_warfare")
@Mod.EventBusSubscriber(modid="naval_warfare", bus=Mod.EventBusSubscriber.Bus.MOD)
public class NavalWarfare {
    public static NavalWarfare instance;
    public static final String MOD_ID = "naval_warfare";
    public static final Logger LOGGER;
    public static final CreativeModeTab NAVAL_WARFARE;
    public static final CreativeModeTab NW_SHIPS;
    public static final CreativeModeTab NW_MISC;
    public static final CreativeModeTab NW_DEPLOYABLES;
    public static final CreativeModeTab NW_ANIMATIONS;

    public NavalWarfare() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        instance = this;
        NWSounds.SOUNDS.register(modEventBus);
        NWItems.NW_ITEMS.register(modEventBus);
        NWBlocks.NW_BLOCKS.register(modEventBus);
        NWBlocks.NW_ANIMATIONS.register(modEventBus);
        NWBlocks.NW_DEPLOYABLES.register(modEventBus);
        NWBlocks.NW_SHIPS.register(modEventBus);
        NWTileEntityTypes.TILE_ENTITY_TYPES.register(modEventBus);
        NWVillagers.PROFESSIONS.register(modEventBus);
        NWVillagers.POI_TYPES.register(modEventBus);
        NWStructures.STRUCTURES.register(modEventBus);
        modEventBus.addListener(this::setup);
        modEventBus.addListener(this::clientRegistries);
        MinecraftForge.EVENT_BUS.addListener(EventPriority.NORMAL, this::lootLoad);
        MinecraftForge.EVENT_BUS.addListener(EventPriority.NORMAL, this::addDimensionalSpacing);
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)NavalWarfareConfig.SPEC, "naval_warfare-common.toml");
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public static void onRegisterItems(RegistryEvent.Register<Item> event) {
        IForgeRegistry registry = event.getRegistry();
        NWBlocks.NW_BLOCKS.getEntries().stream().map(RegistryObject::get).forEach(block -> {
            CreativeModeTab group = block.equals(NWBlocks.SHIP_CLOSE.get()) || block.equals(NWBlocks.SHIP_HERE.get()) ? NW_ANIMATIONS : NAVAL_WARFARE;
            registry.register((IForgeRegistryEntry)((Item)new BlockItem(block, new Item.Properties().m_41491_(group)).setRegistryName(block.getRegistryName())));
        });
        NWBlocks.NW_SHIPS.getEntries().stream().map(RegistryObject::get).forEach(block -> registry.register((IForgeRegistryEntry)((Item)new ShipItem((Block)block, NW_SHIPS, true).setRegistryName(block.getRegistryName()))));
        NWBlocks.NW_DEPLOYABLES.getEntries().stream().map(RegistryObject::get).forEach(block -> registry.register((IForgeRegistryEntry)((Item)new ShipItem((Block)block, NW_DEPLOYABLES, false).setRegistryName(block.getRegistryName()))));
        NWBlocks.NW_ANIMATIONS.getEntries().stream().map(RegistryObject::get).forEach(block -> registry.register((IForgeRegistryEntry)((Item)new DisappearingBlockItem((Block)block).setRegistryName(block.getRegistryName()))));
    }

    private void setup(FMLCommonSetupEvent event) {
        NavalNetwork.init();
        NWVillagers.fillTradeData();
        NWStructures.setupStructures();
        NWCStructures.registerConfiguredStructures();
        NWTriggers.registerTriggers();
        NWStats.createStats();
    }

    private void clientRegistries(FMLClientSetupEvent event) {
        NavalWarfare.setRenderLayers();
    }

    public static void setRenderLayers() {
        NWBlocks.NW_SHIPS.getEntries().stream().map(RegistryObject::get).forEach(block -> ItemBlockRenderTypes.setRenderLayer((Block)block, (RenderType)RenderType.m_110463_()));
        NWBlocks.NW_DEPLOYABLES.getEntries().stream().map(RegistryObject::get).forEach(block -> ItemBlockRenderTypes.setRenderLayer((Block)block, (RenderType)RenderType.m_110463_()));
        NWBlocks.NW_ANIMATIONS.getEntries().stream().map(RegistryObject::get).forEach(block -> ItemBlockRenderTypes.setRenderLayer((Block)block, (RenderType)RenderType.m_110463_()));
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)NWBlocks.TORPEDO_NET.get()), (RenderType)RenderType.m_110463_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)NWBlocks.ANTI_AIR.get()), (RenderType)RenderType.m_110466_());
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)NWBlocks.ENERGY_SHIELD.get()), (RenderType)RenderType.m_110466_());
    }

    public void lootLoad(LootTableLoadEvent event) {
        if (((Boolean)NavalWarfareConfig.modify_dungeon_loot.get()).booleanValue() && this.matchesDungeonLoot(event.getName().toString())) {
            LootPool.Builder pool_builder = LootPool.m_79043_();
            pool_builder.m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f));
            LootPoolSingletonContainer.Builder builder1 = LootItem.m_79579_((ItemLike)((ItemLike)NWItems.HULL_T1.get()));
            builder1.m_79707_(((Integer)NavalWarfareConfig.hull_t1_weight.get()).intValue());
            LootPoolSingletonContainer.Builder builder2 = LootItem.m_79579_((ItemLike)((ItemLike)NWItems.HULL_T2.get()));
            builder2.m_79707_(((Integer)NavalWarfareConfig.hull_t2_weight.get()).intValue());
            LootPoolSingletonContainer.Builder builder3 = LootItem.m_79579_((ItemLike)((ItemLike)NWItems.HULL_T3.get()));
            builder3.m_79707_(((Integer)NavalWarfareConfig.hull_t3_weight.get()).intValue());
            LootPoolSingletonContainer.Builder builder4 = LootItem.m_79579_((ItemLike)((ItemLike)NWItems.HULL_T4.get()));
            builder4.m_79707_(((Integer)NavalWarfareConfig.hull_t4_weight.get()).intValue());
            LootPoolSingletonContainer.Builder builder5 = LootItem.m_79579_((ItemLike)((ItemLike)NWItems.HULL_T5.get()));
            builder5.m_79707_(((Integer)NavalWarfareConfig.hull_t5_weight.get()).intValue());
            LootPoolSingletonContainer.Builder builder6 = LootItem.m_79579_((ItemLike)Items.f_41852_);
            builder6.m_79707_(((Integer)NavalWarfareConfig.air_weight.get()).intValue());
            pool_builder.m_79076_((LootPoolEntryContainer.Builder)builder1);
            pool_builder.m_79076_((LootPoolEntryContainer.Builder)builder2);
            pool_builder.m_79076_((LootPoolEntryContainer.Builder)builder3);
            pool_builder.m_79076_((LootPoolEntryContainer.Builder)builder4);
            pool_builder.m_79076_((LootPoolEntryContainer.Builder)builder5);
            pool_builder.m_79076_((LootPoolEntryContainer.Builder)builder6);
            LootPool pool = pool_builder.m_79082_();
            event.getTable().addPool(pool);
        }
    }

    public boolean matchesDungeonLoot(String event_name) {
        if (event_name.contains("minecraft:chests") && !event_name.contains("village")) {
            return !event_name.contains("igloo") && !event_name.contains("dispenser") && !event_name.contains("pillager") && !event_name.contains("ship") && !event_name.contains("bonus");
        }
        return false;
    }

    public void addDimensionalSpacing(WorldEvent.Load event) {
        if (event.getWorld() instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)event.getWorld();
            ChunkGenerator chunkGenerator = serverLevel.m_7726_().m_8481_();
            if (chunkGenerator instanceof FlatLevelSource && serverLevel.m_46472_().equals((Object)Level.f_46428_)) {
                return;
            }
            StructureSettings worldStructureConfig = chunkGenerator.m_62205_();
            HashMap map = new HashMap();
            for (Map.Entry biomeEntry : serverLevel.m_5962_().m_175512_(Registry.f_122885_).m_6579_()) {
                Biome.BiomeCategory cat = ((Biome)biomeEntry.getValue()).m_47567_();
                if (cat != Biome.BiomeCategory.PLAINS && cat != Biome.BiomeCategory.TAIGA) continue;
                NavalWarfare.associateBiomeToConfiguredStructure(map, NWCStructures.CONFIGURED_CAPTAINS_CABIN, (ResourceKey<Biome>)((ResourceKey)biomeEntry.getKey()));
            }
            ImmutableMap.Builder tempMap = ImmutableMap.builder();
            worldStructureConfig.f_189361_.entrySet().stream().filter(entry -> !map.containsKey(entry.getKey())).forEach(arg_0 -> ((ImmutableMap.Builder)tempMap).put(arg_0));
            map.forEach((key, value) -> tempMap.put(key, (Object)ImmutableMultimap.copyOf((Multimap)value)));
            worldStructureConfig.f_189361_ = tempMap.build();
            try {
                Method method = ObfuscationReflectionHelper.findMethod(ChunkGenerator.class, (String)"codec", (Class[])new Class[0]);
                ResourceLocation cgRL = Registry.f_122890_.m_7981_((Object)((Codec)method.invoke((Object)chunkGenerator, new Object[0])));
                if (cgRL != null && cgRL.m_135827_().equals("terraforged")) {
                    return;
                }
            }
            catch (Exception e) {
                LOGGER.error("Was unable to check if " + serverLevel.m_46472_().m_135782_() + " is using Terraforged's ChunkGenerator.");
            }
            HashMap<StructureFeature, StructureFeatureConfiguration> tempMap_ = new HashMap<StructureFeature, StructureFeatureConfiguration>(worldStructureConfig.m_64590_());
            tempMap_.putIfAbsent((StructureFeature)NWStructures.CAPTAINS_CABIN.get(), (StructureFeatureConfiguration)StructureSettings.f_64580_.get((Object)NWStructures.CAPTAINS_CABIN.get()));
            worldStructureConfig.f_64582_ = tempMap_;
        }
    }

    private static void associateBiomeToConfiguredStructure(Map<StructureFeature<?>, HashMultimap<ConfiguredStructureFeature<?, ?>, ResourceKey<Biome>>> STStructureToMultiMap, ConfiguredStructureFeature<?, ?> configuredStructureFeature, ResourceKey<Biome> biomeRegistryKey) {
        STStructureToMultiMap.putIfAbsent(configuredStructureFeature.f_65403_, HashMultimap.create());
        HashMultimap<ConfiguredStructureFeature<?, ?>, ResourceKey<Biome>> configuredStructureToBiomeMultiMap = STStructureToMultiMap.get(configuredStructureFeature.f_65403_);
        if (configuredStructureToBiomeMultiMap.containsValue(biomeRegistryKey)) {
            LOGGER.error("    Detected 2 ConfiguredStructureFeatures that share the same base StructureFeature trying to be added to same biome. One will be prevented from spawning.\n    This issue happens with vanilla too and is why a Snowy Village and Plains Village cannot spawn in the same biome because they both use the Village base structure.\n    The two conflicting ConfiguredStructures are: {}, {}\n    The biome that is attempting to be shared: {}\n", (Object)BuiltinRegistries.f_123862_.m_7447_(configuredStructureFeature), (Object)BuiltinRegistries.f_123862_.m_7447_((Object)((ConfiguredStructureFeature)configuredStructureToBiomeMultiMap.entries().stream().filter(e -> e.getValue() == biomeRegistryKey).findFirst().get().getKey())), biomeRegistryKey);
        } else {
            configuredStructureToBiomeMultiMap.put(configuredStructureFeature, biomeRegistryKey);
        }
    }

    static {
        LOGGER = LogManager.getLogger((String)MOD_ID);
        NAVAL_WARFARE = new CreativeModeTab(MOD_ID){

            public ItemStack m_6976_() {
                return new ItemStack((ItemLike)NWItems.GAME_INTERACTOR.get());
            }
        };
        NW_SHIPS = new CreativeModeTab("naval_warfare_ships"){

            public ItemStack m_6976_() {
                return new ItemStack((ItemLike)((Block)NWBlocks.BATTLESHIP.get()).m_5456_());
            }
        };
        NW_MISC = new CreativeModeTab("naval_warfare_misc"){

            public ItemStack m_6976_() {
                return new ItemStack((ItemLike)NWItems.SHIP_SUNK_OPPONENT.get());
            }
        };
        NW_DEPLOYABLES = new CreativeModeTab("naval_warfare_deployables"){

            public ItemStack m_6976_() {
                return new ItemStack((ItemLike)((Block)NWBlocks.LANDGUARD_ACTIVE.get()).m_5456_());
            }
        };
        NW_ANIMATIONS = new CreativeModeTab("naval_warfare_animations"){

            public ItemStack m_6976_() {
                return new ItemStack((ItemLike)((Block)NWBlocks.SHIP_HERE.get()).m_5456_());
            }
        };
    }
}

