/*
 * Decompiled with CFR 0.152.
 */
package slimeattack07.naval_warfare.init;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.Random;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import slimeattack07.naval_warfare.init.NWBlocks;
import slimeattack07.naval_warfare.init.NWItems;
import slimeattack07.naval_warfare.util.NWBasicMethods;

public class NWVillagers {
    public static final DeferredRegister<PoiType> POI_TYPES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.POI_TYPES, (String)"naval_warfare");
    public static final DeferredRegister<VillagerProfession> PROFESSIONS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.PROFESSIONS, (String)"naval_warfare");
    public static final RegistryObject<PoiType> DISPLAY_POI = POI_TYPES.register("ship_display", () -> new PoiType("ship_display", PoiType.m_27372_((Block)((Block)NWBlocks.SHIP_DISPLAY.get())), 1, 1));
    public static final RegistryObject<VillagerProfession> RETIRED_CAPTAIN = PROFESSIONS.register("retired_captain", () -> new VillagerProfession("retired_captain", (PoiType)DISPLAY_POI.get(), ImmutableSet.of(), ImmutableSet.of(), SoundEvents.f_12575_));

    public static void fillTradeData() {
        VillagerTrades.ItemListing[] level1 = new VillagerTrades.ItemListing[]{new CustomTrade(CustomTrade.RC.I1B), new CustomTrade(CustomTrade.RC.I1S)};
        VillagerTrades.ItemListing[] level2 = new VillagerTrades.ItemListing[]{new CustomTrade(CustomTrade.RC.I2B), new CustomTrade(CustomTrade.RC.I2S)};
        VillagerTrades.ItemListing[] level3 = new VillagerTrades.ItemListing[]{new CustomTrade(CustomTrade.RC.I3B), new CustomTrade(CustomTrade.RC.I3S)};
        VillagerTrades.ItemListing[] level4 = new VillagerTrades.ItemListing[]{new CustomTrade(CustomTrade.RC.H1B), new CustomTrade(CustomTrade.RC.H2B)};
        VillagerTrades.ItemListing[] level5 = new VillagerTrades.ItemListing[]{new CustomTrade(CustomTrade.RC.S1B), new CustomTrade(CustomTrade.RC.S2B)};
        VillagerTrades.f_35627_.put((VillagerProfession)RETIRED_CAPTAIN.get(), NWVillagers.getAsIntMap((ImmutableMap<Integer, VillagerTrades.ItemListing[]>)ImmutableMap.of((Object)1, (Object)level1, (Object)2, (Object)level2, (Object)3, (Object)level3, (Object)4, (Object)level4, (Object)5, (Object)level5)));
    }

    private static Int2ObjectMap<VillagerTrades.ItemListing[]> getAsIntMap(ImmutableMap<Integer, VillagerTrades.ItemListing[]> map) {
        return new Int2ObjectOpenHashMap(map);
    }

    public static class CustomTrade
    implements VillagerTrades.ItemListing {
        private final RC TYPE;

        public CustomTrade(RC rc) {
            this.TYPE = rc;
        }

        public MerchantOffer m_5670_(Entity trader, Random rand) {
            ItemStack tagged = ItemStack.f_41583_;
            ItemStack emerald = new ItemStack((ItemLike)Items.f_42616_, 1);
            switch (this.TYPE) {
                case I1B: {
                    tagged = NWBasicMethods.getRandomTaggedItem("icons_t1", rand, NWItems.NW_ITEMS);
                    tagged.m_41764_(4);
                    return new MerchantOffer(tagged, emerald, 8, 4, 0.0f);
                }
                case I1S: {
                    tagged = NWBasicMethods.getRandomTaggedItem("icons_t1", rand, NWItems.NW_ITEMS);
                    tagged.m_41764_(3);
                    return new MerchantOffer(emerald, tagged, 8, 3, 0.0f);
                }
                case I2B: {
                    tagged = NWBasicMethods.getRandomTaggedItem("icons_t2", rand, NWItems.NW_ITEMS);
                    tagged.m_41764_(4);
                    emerald.m_41764_(3);
                    return new MerchantOffer(tagged, emerald, 8, 5, 0.0f);
                }
                case I2S: {
                    tagged = NWBasicMethods.getRandomTaggedItem("icons_t2", rand, NWItems.NW_ITEMS);
                    tagged.m_41764_(3);
                    emerald.m_41764_(3);
                    return new MerchantOffer(emerald, tagged, 8, 4, 0.0f);
                }
                case I3B: {
                    tagged = NWBasicMethods.getRandomTaggedItem("icons_t3", rand, NWItems.NW_ITEMS);
                    tagged.m_41764_(4);
                    emerald.m_41764_(5);
                    return new MerchantOffer(tagged, emerald, 8, 6, 0.0f);
                }
                case I3S: {
                    tagged = NWBasicMethods.getRandomTaggedItem("icons_t3", rand, NWItems.NW_ITEMS);
                    tagged.m_41764_(3);
                    emerald.m_41764_(5);
                    return new MerchantOffer(emerald, tagged, 8, 5, 0.0f);
                }
                case H1B: {
                    switch (rand.nextInt(3)) {
                        case 1: {
                            emerald.m_41764_(5);
                            return new MerchantOffer(emerald, new ItemStack((ItemLike)NWItems.HULL_T1.get()), 4, 6, 0.0f);
                        }
                        case 2: {
                            emerald.m_41764_(10);
                            return new MerchantOffer(emerald, new ItemStack((ItemLike)NWItems.HULL_T2.get()), 4, 7, 0.0f);
                        }
                    }
                    emerald.m_41764_(20);
                    return new MerchantOffer(emerald, new ItemStack((ItemLike)NWItems.HULL_T3.get()), 4, 8, 0.0f);
                }
                case H2B: {
                    switch (rand.nextInt(3)) {
                        case 1: {
                            emerald.m_41764_(20);
                            return new MerchantOffer(emerald, new ItemStack((ItemLike)NWItems.HULL_T3.get()), 4, 8, 0.0f);
                        }
                        case 2: {
                            emerald.m_41764_(40);
                            return new MerchantOffer(emerald, new ItemStack((ItemLike)NWItems.HULL_T4.get()), 4, 9, 0.0f);
                        }
                    }
                    emerald.m_41764_(40);
                    return new MerchantOffer(emerald, emerald, new ItemStack((ItemLike)NWItems.HULL_T5.get()), 4, 10, 0.0f);
                }
                case S1B: {
                    switch (rand.nextInt(3)) {
                        case 1: {
                            tagged = this.blockToItem(NWBasicMethods.getRandomTaggedBlock("ships_t1", rand, NWBlocks.NW_SHIPS));
                            return new MerchantOffer(new ItemStack((ItemLike)Items.f_42416_, 32), tagged, 1, 20, 0.0f);
                        }
                        case 2: {
                            tagged = this.blockToItem(NWBasicMethods.getRandomTaggedBlock("ships_t2", rand, NWBlocks.NW_SHIPS));
                            return new MerchantOffer(new ItemStack((ItemLike)Items.f_42417_, 48), tagged, 1, 30, 0.0f);
                        }
                    }
                    tagged = this.blockToItem(NWBasicMethods.getRandomTaggedBlock("ships_t3", rand, NWBlocks.NW_SHIPS));
                    return new MerchantOffer(new ItemStack((ItemLike)Items.f_42415_, 16), tagged, 1, 40, 0.0f);
                }
            }
            switch (rand.nextInt(3)) {
                case 1: {
                    tagged = this.blockToItem(NWBasicMethods.getRandomTaggedBlock("ships_t3", rand, NWBlocks.NW_SHIPS));
                    return new MerchantOffer(new ItemStack((ItemLike)Items.f_42415_, 16), tagged, 1, 40, 0.0f);
                }
                case 2: {
                    tagged = this.blockToItem(NWBasicMethods.getRandomTaggedBlock("ships_t4", rand, NWBlocks.NW_SHIPS));
                    return new MerchantOffer(new ItemStack((ItemLike)Items.f_42418_, 8), tagged, 1, 50, 0.0f);
                }
            }
            tagged = this.blockToItem(NWBasicMethods.getRandomTaggedBlock("ships_t5", rand, NWBlocks.NW_SHIPS));
            return new MerchantOffer(new ItemStack((ItemLike)Items.f_42686_, 2), tagged, 1, 60, 0.0f);
        }

        private ItemStack blockToItem(Block block) {
            return block == null ? ItemStack.f_41583_ : new ItemStack((ItemLike)block);
        }

        public static enum RC {
            I1B,
            I1S,
            I2B,
            I2S,
            I3B,
            I3S,
            H1B,
            H2B,
            S1B,
            S2B;

        }
    }
}

