/*
 * Decompiled with CFR 0.152.
 */
package slimeattack07.naval_warfare.network.message;

import io.netty.handler.codec.EncoderException;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.nbt.TagParser;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;
import slimeattack07.naval_warfare.NavalWarfare;
import slimeattack07.naval_warfare.network.NavalNetwork;
import slimeattack07.naval_warfare.network.message.UpdateBattleLogMessage;
import slimeattack07.naval_warfare.util.NWBasicMethods;

public class BattleLogMessage {
    public CompoundTag log;
    public boolean load;

    public BattleLogMessage() {
    }

    public BattleLogMessage(@Nullable CompoundTag log_in, boolean do_load) {
        this.log = log_in;
        this.load = do_load;
    }

    public static void encode(BattleLogMessage message, FriendlyByteBuf buffer) {
        try {
            buffer.m_130079_(message.log);
            buffer.writeBoolean(message.load);
        }
        catch (EncoderException e) {
            NavalWarfare.LOGGER.warn("Failed to encode message");
            e.printStackTrace();
        }
    }

    public static BattleLogMessage decode(FriendlyByteBuf buffer) {
        try {
            return new BattleLogMessage(buffer.m_130260_(), buffer.readBoolean());
        }
        catch (EncoderException e) {
            NavalWarfare.LOGGER.warn("Failed to decode message");
            e.printStackTrace();
            return new BattleLogMessage();
        }
    }

    public static void handle(BattleLogMessage message, Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context context = supplier.get();
        context.enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> BattleLogMessage.lambda$handle$1(message, (Supplier)supplier)));
        context.setPacketHandled(true);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void clientHandle(BattleLogMessage message, Supplier<NetworkEvent.Context> supplier) {
        Minecraft mc = Minecraft.m_91087_();
        if (message.load) {
            String clipboard = mc.f_91068_.m_90876_();
            CompoundTag tag = BattleLogMessage.jsonToTag((Player)mc.f_91074_, clipboard);
            if (tag.m_128456_()) {
                return;
            }
            NavalNetwork.CHANNEL.sendToServer((Object)new UpdateBattleLogMessage(tag));
            NWBasicMethods.messagePlayerActionbar((Player)mc.f_91074_, "message.naval_warfare.battle_log.paste");
        } else {
            mc.f_91068_.m_90911_(BattleLogMessage.compoundToString(message.log));
            NWBasicMethods.messagePlayerActionbar((Player)mc.f_91074_, "message.naval_warfare.battle_log.copy");
        }
    }

    private static String compoundToString(CompoundTag tag) {
        String s = NbtUtils.m_178057_((Tag)tag);
        s = s.replaceAll("(list\\<TAG_Compound\\>\\[)\\d+(])", "");
        s = s.replaceAll("(list\\<TAG_Int\\>\\[)\\d+(])", "");
        s = s.replace("1 b", "true");
        s = s.replace("0 b", "false");
        s = s.replace("1b", "true");
        s = s.replace("0b", "false");
        s = s.replace("north", "NORTH");
        s = s.replace("east", "EAST");
        s = s.replace("south", "SOUTH");
        s = s.replace("west", "WEST");
        s = s.replace("f,", ",");
        s = s.replaceAll("f\n", "\n");
        return s;
    }

    private static CompoundTag jsonToTag(Player player, String json) {
        try {
            return TagParser.m_129359_((String)json);
        }
        catch (Exception e) {
            NavalWarfare.LOGGER.warn("Failed to load battle log from clipboard: " + e.getMessage());
            NWBasicMethods.messagePlayerActionbar(player, "message.naval_warfare.battle_log.invalid");
            return new CompoundTag();
        }
    }

    private static /* synthetic */ Runnable lambda$handle$1(BattleLogMessage message, Supplier supplier) {
        return () -> BattleLogMessage.lambda$handle$0(message, (Supplier)supplier);
    }

    private static /* synthetic */ void lambda$handle$0(BattleLogMessage message, Supplier supplier) {
        BattleLogMessage.clientHandle(message, supplier);
    }
}

