/*
 * Decompiled with CFR 0.152.
 */
package slimeattack07.naval_warfare.objects.blocks;

import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.registries.ForgeRegistries;
import slimeattack07.naval_warfare.init.NWBlocks;
import slimeattack07.naval_warfare.init.NWTileEntityTypes;
import slimeattack07.naval_warfare.objects.blocks.Board;
import slimeattack07.naval_warfare.objects.blocks.ShipBlock;
import slimeattack07.naval_warfare.tileentity.BattleViewerTE;
import slimeattack07.naval_warfare.tileentity.BoardTE;
import slimeattack07.naval_warfare.util.NWBasicMethods;
import slimeattack07.naval_warfare.util.ViewerState;
import slimeattack07.naval_warfare.util.helpers.ShipSaveHelper;
import slimeattack07.naval_warfare.util.properties.ViewerStateProperty;

public class BattleViewer
extends Block
implements EntityBlock {
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    public static final ViewerStateProperty VIEWER_STATE = ViewerStateProperty.create();

    public BattleViewer() {
        super(BlockBehaviour.Properties.m_60939_((Material)Material.f_76278_).m_60999_().m_60913_(0.8f, 2.0f));
        this.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)VIEWER_STATE, (Comparable)((Object)ViewerState.IDLE)));
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_());
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING});
        builder.m_61104_(new Property[]{VIEWER_STATE});
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return ((BlockEntityType)NWTileEntityTypes.BATTLE_VIEWER.get()).m_155264_(pos, state);
    }

    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        return level.m_5776_() ? null : (l, s, pos, tile) -> ((BattleViewerTE)tile).tick();
    }

    public Direction getFacing(BlockState state) {
        try {
            return (Direction)state.m_61143_((Property)FACING);
        }
        catch (IllegalArgumentException e) {
            return Direction.NORTH;
        }
    }

    public ViewerState getViewerState(BlockState state) {
        try {
            return (ViewerState)((Object)state.m_61143_((Property)VIEWER_STATE));
        }
        catch (IllegalArgumentException e) {
            return ViewerState.IDLE;
        }
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (level.m_5776_()) {
            return InteractionResult.SUCCESS;
        }
        if (player == null || !player.m_21120_(hand).m_41619_()) {
            return InteractionResult.PASS;
        }
        BlockEntity tile = level.m_7702_(pos);
        if (tile instanceof BattleViewerTE) {
            BattleViewerTE te = (BattleViewerTE)tile;
            if (player.m_6047_()) {
                switch ("" + te.speed) {
                    case "0.0": {
                        te.speed = 1.0f;
                        break;
                    }
                    case "0.25": {
                        te.speed = 0.5f;
                        break;
                    }
                    case "0.5": {
                        te.speed = 1.0f;
                        break;
                    }
                    case "1.0": {
                        te.speed = 2.0f;
                        break;
                    }
                    case "2.0": {
                        te.speed = 5.0f;
                        break;
                    }
                    case "5.0": {
                        te.speed = 10.0f;
                        break;
                    }
                    case "10.0": {
                        te.speed = 0.25f;
                    }
                }
                NWBasicMethods.messagePlayerCustom(player, NWBasicMethods.getTranslation("message.naval_warfare.viewer_speed").replace("MARKER1", te.speed + "x"));
            } else {
                te.playing = !te.playing;
                String s = te.playing ? "unpaused" : "paused";
                NWBasicMethods.messagePlayerCustom(player, NWBasicMethods.getTranslation("message.naval_warfare.viewer_status_toggled").replace("MARKER1", s));
                if (!te.playing && state.m_60734_() instanceof BattleViewer) {
                    level.m_46597_(pos, (BlockState)state.m_61124_((Property)VIEWER_STATE, (Comparable)((Object)ViewerState.IDLE)));
                }
            }
        }
        return InteractionResult.SUCCESS;
    }

    private BlockPos nextPosToCheck(Direction dir, BlockPos origin, int x, int z) {
        int y = origin.m_123342_();
        switch (dir) {
            case NORTH: {
                return new BlockPos(origin.m_123341_() - x, y, origin.m_123343_() - z);
            }
            case EAST: {
                return new BlockPos(origin.m_123341_() + z, y, origin.m_123343_() - x);
            }
            case SOUTH: {
                return new BlockPos(origin.m_123341_() + x, y, origin.m_123343_() + z);
            }
            case WEST: {
                return new BlockPos(origin.m_123341_() - z, y, origin.m_123343_() + x);
            }
        }
        return origin;
    }

    private boolean spaceChecker(Level level, Player player, Direction dir, BlockPos origin, int xdim, int zdim) {
        for (int z = -1; z < zdim + 1; ++z) {
            for (int x = -1; x < xdim + 1; ++x) {
                BlockPos pos = this.nextPosToCheck(dir, origin, x, z);
                Block block = level.m_8055_(pos).m_60734_();
                if (block.equals(Blocks.f_50016_) || block.equals(NWBlocks.BATTLE_VIEWER.get())) continue;
                if (player != null) {
                    String translation = NWBasicMethods.getTranslation("message.naval_warfare.board_size_not_clear");
                    translation = translation.replace("MARKER1", "" + pos.m_123341_()).replace("MARKER2", "" + pos.m_123342_()).replace("MARKER3", "" + pos.m_123343_()).replace("MARKER4", block.getRegistryName().toString());
                    NWBasicMethods.messagePlayerCustom(player, translation);
                }
                return false;
            }
        }
        return true;
    }

    private boolean spawnBoard(Level level, Player player, BattleViewerTE te, BlockPos location, int amount, boolean opponent) {
        BlockEntity btile;
        int z;
        double floor;
        Direction dir = this.getFacing(te.m_58900_());
        double root = Math.sqrt(amount);
        double diff = root - (floor = Math.floor(root));
        int zlength = diff == 0.0 ? (int)floor : (int)floor + 1;
        int xlength = diff >= 0.5 ? (int)floor + 1 : (int)floor;
        int current = 0;
        int center = xlength / 2;
        BlockPos cube_origin = this.nextPosToCheck(dir, location, -center, 1);
        if (!this.spaceChecker(level, player, dir, cube_origin, xlength, zlength)) {
            return false;
        }
        BlockState bstate = ((Block)NWBlocks.BOARD.get()).m_49966_();
        BlockState filler = ((Block)NWBlocks.BOARD_FILLER.get()).m_49966_();
        for (z = 0; z < zlength; ++z) {
            for (int x = 0; x < xlength; ++x) {
                BlockPos next = this.nextPosToCheck(dir, cube_origin, x, z);
                if (current < amount) {
                    level.m_46597_(next, bstate);
                    ++current;
                    continue;
                }
                level.m_46597_(next, filler);
            }
        }
        for (int x = -1; x < xlength; ++x) {
            BlockPos next = this.nextPosToCheck(dir, cube_origin, x, -1);
            this.setFillerUnlessViewer(level, next);
            next = this.nextPosToCheck(dir, cube_origin, x, zlength);
            this.setFillerUnlessViewer(level, next);
        }
        for (z = -1; z < zlength; ++z) {
            BlockPos next = this.nextPosToCheck(dir, cube_origin, -1, z);
            this.setFillerUnlessViewer(level, next);
            next = this.nextPosToCheck(dir, cube_origin, xlength, z);
            this.setFillerUnlessViewer(level, next);
        }
        BlockPos next = this.nextPosToCheck(dir, cube_origin, xlength, zlength);
        this.setFillerUnlessViewer(level, next);
        BlockState board = level.m_8055_(cube_origin);
        if (board.m_155947_() && (btile = level.m_7702_(cube_origin)) instanceof BoardTE) {
            BoardTE bte = (BoardTE)btile;
            bte.setControllerAndId(location, 0, dir);
        }
        if (opponent) {
            te.setOpponentZero(cube_origin);
        } else {
            te.setZero(cube_origin);
        }
        return true;
    }

    private void setFillerUnlessViewer(Level level, BlockPos pos) {
        if (!(level.m_8055_(pos).m_60734_() instanceof BattleViewer)) {
            level.m_46597_(pos, ((Block)NWBlocks.BOARD_FILLER.get()).m_49966_());
        }
    }

    private boolean spawnOpponentBoard(Level level, Player player, BattleViewerTE te, int own_size, int opp_size) {
        double sqrt = Math.sqrt(own_size);
        int offset = (int)Math.ceil(sqrt) + 2;
        Direction dir = this.getFacing(te.m_58900_());
        return this.spawnBoard(level, player, te, te.m_58899_().m_5484_(dir, offset), opp_size, true);
    }

    public boolean spawnBoards(Level level, Player player, BattleViewerTE te, int own_size, int opp_size) {
        return this.spawnBoard(level, player, te, te.m_58899_(), own_size, false) ? this.spawnOpponentBoard(level, player, te, own_size, opp_size) : false;
    }

    public void spawnShips(Level level, Direction dir, BlockPos pos, ArrayList<ShipSaveHelper> ships, Direction facing, boolean opponent) {
        for (ShipSaveHelper ssh : ships) {
            boolean success;
            Direction new_facing = NWBasicMethods.rotateToMatch(dir, facing, ssh.getDir());
            Block block = (Block)ForgeRegistries.BLOCKS.getValue(ssh.getShip());
            if (block == null || !(block instanceof ShipBlock)) continue;
            ShipBlock ship = (ShipBlock)block;
            BlockPos spos = this.findBoard(level, pos, ssh.getPos(), opponent);
            if (spos == null || !(success = ship.summonShip(level, spos.m_7494_(), (BlockState)ship.m_49966_().m_61124_((Property)ShipBlock.FACING, (Comparable)new_facing), true, false))) continue;
            ship.propagateAbilityAmount(level, spos.m_7494_(), 0);
        }
    }

    public BlockPos findBoard(Level level, BlockPos pos, int id, boolean opponent) {
        BlockEntity tile = level.m_7702_(pos);
        if (tile instanceof BattleViewerTE) {
            BattleViewerTE te = (BattleViewerTE)tile;
            return te.findBoard(id, opponent);
        }
        return null;
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        if (level.m_5776_()) {
            return;
        }
        if (newState.m_60734_() instanceof BattleViewer) {
            return;
        }
        Direction dir = this.getFacing(state);
        BlockPos board_pos = pos.m_142300_(dir);
        BlockState board = level.m_8055_(board_pos);
        if (board.m_60734_() instanceof Board) {
            level.m_7471_(board_pos, false);
        }
        if (state.m_155947_()) {
            level.m_46747_(pos);
        }
    }
}

