/*
 * Decompiled with CFR 0.152.
 */
package slimeattack07.naval_warfare.objects.blocks;

import java.util.ArrayList;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.material.MaterialColor;
import slimeattack07.naval_warfare.init.NWBlocks;
import slimeattack07.naval_warfare.init.NWItems;
import slimeattack07.naval_warfare.init.NWSounds;
import slimeattack07.naval_warfare.init.NWTileEntityTypes;
import slimeattack07.naval_warfare.objects.blocks.BoardFiller;
import slimeattack07.naval_warfare.objects.blocks.EnergyShieldBlock;
import slimeattack07.naval_warfare.objects.blocks.GameController;
import slimeattack07.naval_warfare.objects.blocks.PassiveAbilityBlock;
import slimeattack07.naval_warfare.objects.blocks.ShipBlock;
import slimeattack07.naval_warfare.objects.blocks.ShipMarkerBlock;
import slimeattack07.naval_warfare.objects.items.GameInteractor;
import slimeattack07.naval_warfare.tileentity.BoardTE;
import slimeattack07.naval_warfare.tileentity.GameControllerTE;
import slimeattack07.naval_warfare.util.BoardState;
import slimeattack07.naval_warfare.util.ControllerState;
import slimeattack07.naval_warfare.util.HitResult;
import slimeattack07.naval_warfare.util.NWBasicMethods;
import slimeattack07.naval_warfare.util.TargetType;
import slimeattack07.naval_warfare.util.helpers.BattleLogHelper;
import slimeattack07.naval_warfare.util.helpers.ControllerActionHelper;
import slimeattack07.naval_warfare.util.helpers.ShipRevealHelper;
import slimeattack07.naval_warfare.util.properties.BoardStateProperty;

public class Board
extends Block
implements EntityBlock {
    public static final BoardStateProperty STATE = BoardStateProperty.create();

    public Board() {
        super(BlockBehaviour.Properties.m_60939_((Material)Material.f_76278_).m_60978_(1000.0f).m_155949_(MaterialColor.f_76361_));
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)STATE, (Comparable)((Object)BoardState.NEUTRAL)));
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_((Property)STATE, (Comparable)((Object)BoardState.NEUTRAL));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{STATE});
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return ((BlockEntityType)NWTileEntityTypes.BOARD.get()).m_155264_(pos, state);
    }

    public void m_6402_(Level level, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        if (level.m_5776_()) {
            return;
        }
        if (placer instanceof Player) {
            Player player = (Player)placer;
            NWBasicMethods.messagePlayer(player, "message.naval_warfare.dont_place");
            level.m_7471_(pos, false);
        }
    }

    public void handleInteraction(BlockState state, Level level, BlockPos pos, Player player, ItemStack stack, BlockPos matching) {
        if (level.m_5776_()) {
            return;
        }
        BlockEntity tile = level.m_7702_(pos);
        if (!(tile instanceof BoardTE)) {
            return;
        }
        BoardTE te = (BoardTE)tile;
        GameInteractor interactor = (GameInteractor)stack.m_41720_();
        switch (interactor.getMode(stack)) {
            case TARGET_TILE: {
                this.targetTile(level, player, state, pos, te, matching, true, 1, TargetType.NORMAL);
                return;
            }
        }
        NWBasicMethods.messagePlayerActionbar(player, "message.naval_warfare.unsupported_operation");
    }

    public void selectTile(Level level, BlockPos pos, BlockPos matching) {
        BlockState state = level.m_8055_(pos);
        BlockState matching_state = level.m_8055_(matching);
        level.m_46597_(pos, (BlockState)state.m_61124_((Property)STATE, (Comparable)((Object)this.getBoardState(state).select())));
        level.m_46597_(matching, (BlockState)matching_state.m_61124_((Property)STATE, (Comparable)((Object)this.getBoardState(matching_state).select())));
    }

    public void deselectTile(Level level, BlockPos pos, BlockPos matching) {
        BlockState state = level.m_8055_(pos);
        BlockState matching_state = level.m_8055_(matching);
        level.m_46597_(pos, (BlockState)state.m_61124_((Property)STATE, (Comparable)((Object)this.getBoardState(state).deselect())));
        level.m_46597_(matching, (BlockState)matching_state.m_61124_((Property)STATE, (Comparable)((Object)this.getBoardState(matching_state).deselect())));
    }

    public ArrayList<BoardTE> matchTiles(Level level, ArrayList<BoardTE> tiles, boolean yours) {
        ArrayList<BoardTE> matching = new ArrayList<BoardTE>();
        GameControllerTE controller = null;
        for (BoardTE tile : tiles) {
            if (controller == null && (controller = this.getController(level, tile.m_58899_())) == null) {
                return matching;
            }
            GameController control = (GameController)controller.m_58900_().m_60734_();
            BoardTE te = control.getOpponentBoardTile(level, controller, tile.getId(), yours);
            if (te == null) continue;
            matching.add(te);
        }
        return matching;
    }

    public void selectTiles(Level level, ArrayList<BoardTE> tiles) {
        ArrayList<BoardTE> matching = this.matchTiles(level, tiles, false);
        if (tiles.size() != matching.size()) {
            return;
        }
        for (int i = 0; i < tiles.size(); ++i) {
            this.selectTile(level, tiles.get(i).m_58899_(), matching.get(i).m_58899_());
        }
    }

    public void deselectTiles(Level level, ArrayList<BoardTE> tiles) {
        ArrayList<BoardTE> matching = this.matchTiles(level, tiles, false);
        if (tiles.size() != matching.size()) {
            return;
        }
        for (int i = 0; i < tiles.size(); ++i) {
            this.deselectTile(level, tiles.get(i).m_58899_(), matching.get(i).m_58899_());
        }
    }

    public void targetTile(Level level, Player player, BlockState state, BlockPos pos, BoardTE te, BlockPos matching, boolean message, int damage, TargetType type) {
        if (this.getBoardState(state).isKnown()) {
            if (message) {
                NWBasicMethods.messagePlayer(player, "message.naval_warfare.already_targeted");
            }
            return;
        }
        String player_uuid = "dummy";
        if (player != null) {
            player_uuid = player.m_20149_();
        }
        ControllerActionHelper cah = ControllerActionHelper.createTargetAction(20, pos, player_uuid, te.m_58899_(), matching, damage, type, false, true, (Block)NWBlocks.SHELL.get());
        this.selectTile(level, pos, matching);
        NWBasicMethods.dropBlock(level, pos, (Block)NWBlocks.SHELL.get());
        NWBasicMethods.dropBlock(level, matching, (Block)NWBlocks.SHELL.get());
        level.m_5594_(null, pos, (SoundEvent)NWSounds.SHOT.get(), SoundSource.MASTER, 1.0f, 1.0f);
        level.m_5594_(null, matching, (SoundEvent)NWSounds.SHOT.get(), SoundSource.MASTER, 1.0f, 1.0f);
        this.recordOnController(level, pos, BattleLogHelper.createSound(te.getId(), false, (SoundEvent)NWSounds.SHOT.get(), 1.0f, 1.0f), damage);
        this.addActionToController(level, matching, cah, te.getId());
    }

    public HitResult targetTileAction(Level level, Player player, BlockState state, BlockPos pos, BoardTE te, BlockPos matching, int damage, TargetType type, boolean multi_ability, int action, @Nullable Block animation, boolean triggers_passives, boolean force) {
        HitResult result;
        if (animation != null) {
            NWBasicMethods.dropBlock(level, pos, 6.0, 30, animation);
            NWBasicMethods.dropBlock(level, matching, 6.0, 30, animation);
            this.recordOnController(level, pos, BattleLogHelper.createDropBlock(te.getId(), false, animation.getRegistryName()), damage);
        }
        if ((result = this.attackBlocked(level, player, pos, matching, te.getController(), type, action, te.getId())).isBlocked()) {
            if (!multi_ability) {
                this.controllerKeepsTurn(level, te.getController(), false);
            }
            this.deselectTile(level, pos, matching);
            return result;
        }
        if (!force && this.getBoardState(state).isKnown()) {
            this.deselectTile(level, pos, matching);
            return HitResult.KNOWN;
        }
        HitResult cont = HitResult.MISS;
        BoardState newstate = null;
        BlockState up = level.m_8055_(pos.m_7494_());
        if (up.m_60734_() instanceof ShipBlock) {
            if (!force && ShipBlock.getState(up).isHit()) {
                this.deselectTile(level, pos, matching);
                return HitResult.KNOWN;
            }
            ShipBlock ship = (ShipBlock)up.m_60734_();
            cont = HitResult.HIT;
            boolean destroyed = ship.damageShip(level, player, pos.m_7494_(), te.getId(), te.getController(), damage, matching, multi_ability, triggers_passives, action);
            if (destroyed) {
                NWBasicMethods.messagePlayerCustomRecord(this.getController(level, te.m_58899_()), player, NWBasicMethods.getOpponentShipDestroyedMessage(NWBasicMethods.getTranslation(ship)), true);
                NWBasicMethods.animateItemUse(player, (Item)NWItems.SHIP_SUNK_OPPONENT.get());
                ShipRevealHelper srh = ship.getBaseState(level, pos.m_7494_());
                if (srh != null) {
                    this.revealShip(level, te.getController(), ship, srh);
                }
            }
        } else {
            newstate = BoardState.EMPTY;
            level.m_5594_(null, pos, (SoundEvent)NWSounds.MISS.get(), SoundSource.MASTER, 1.0f, 1.0f);
            level.m_5594_(null, matching, (SoundEvent)NWSounds.MISS.get(), SoundSource.MASTER, 1.0f, 1.0f);
            this.recordOnController(level, pos, BattleLogHelper.createSound(te.getId(), false, (SoundEvent)NWSounds.MISS.get(), 1.0f, 1.0f), te.getId());
            if (!multi_ability) {
                this.notifyOwnerOfMiss(te.getController(), level, te.getId());
                NWBasicMethods.messagePlayerCustomRecord(this.getController(level, te.m_58899_()), player, NWBasicMethods.getOpponentShipMissedMessage(te.getId()) + " ", true);
            }
        }
        if (newstate != null) {
            level.m_46597_(pos, (BlockState)state.m_61124_((Property)STATE, (Comparable)((Object)newstate)));
            level.m_46597_(matching, (BlockState)level.m_8055_(matching).m_61124_((Property)STATE, (Comparable)((Object)newstate)));
        }
        if (!multi_ability) {
            this.controllerKeepsTurn(level, te.getController(), cont.equals((Object)HitResult.HIT));
        }
        if (level.m_8055_(pos.m_6630_(2)).m_60734_() instanceof ShipMarkerBlock) {
            level.m_46597_(pos.m_6630_(2), Blocks.f_50016_.m_49966_());
            level.m_46597_(matching.m_6630_(2), Blocks.f_50016_.m_49966_());
            this.recordOnController(level, pos, BattleLogHelper.createSetBlock(te.getId(), Blocks.f_50016_.getRegistryName(), 2, false), te.getId());
        }
        return cont;
    }

    public HitResult revealTileAction(Level level, Player player, BlockState state, BlockPos pos, BoardTE te, BlockPos matching, TargetType type, int action) {
        HitResult result = HitResult.MISS;
        if (this.attackBlocked(level, player, pos, matching, te.getController(), type, action, te.getId()).isBlocked()) {
            result = HitResult.BLOCKED;
        } else if (this.getBoardState(state).isKnown()) {
            result = HitResult.KNOWN;
        } else {
            BlockState up = level.m_8055_(pos.m_7494_());
            if (up.m_60734_() instanceof ShipBlock) {
                result = ShipBlock.getState(up).isHit() ? HitResult.KNOWN : HitResult.HIT;
            }
        }
        this.deselectTile(level, pos, matching);
        return result;
    }

    private HitResult attackBlocked(Level level, Player player, BlockPos pos, BlockPos matching, BlockPos owner, TargetType type, int action, int id) {
        switch (type) {
            case NORMAL: {
                if (level.m_8055_(pos.m_6630_(4)).m_60734_().equals(NWBlocks.ENERGY_SHIELD.get())) {
                    NWBasicMethods.messagePlayerCustomRecord(this.getController(level, pos), player, ChatFormatting.DARK_RED + NWBasicMethods.getTranslation("message.naval_warfare.attack_blocked"), true);
                    this.messageOwner(owner, level, "message.naval_warfare.attack_blocked");
                    NWBasicMethods.animateItemUse(player, ((Item)NWItems.ENERGY_SHIELD.get()).m_5456_());
                    this.showOwnerAnimation(owner, level, ((Item)NWItems.ENERGY_SHIELD.get()).m_5456_());
                    boolean result = EnergyShieldBlock.hit(level, pos.m_6630_(4), action, 1);
                    if (result) {
                        level.m_46597_(matching.m_6630_(4), ((Block)NWBlocks.ENERGY_SHIELD.get()).m_49966_());
                        PassiveAbilityBlock.setMatching(level, pos.m_6630_(4), matching.m_6630_(4));
                        this.recordOnController(level, pos, BattleLogHelper.createSound(id, false, (SoundEvent)NWSounds.ENERGY_SHIELD.get(), 1.0f, 1.0f), id);
                        level.m_5594_(null, pos, (SoundEvent)NWSounds.ENERGY_SHIELD.get(), SoundSource.MASTER, 1.0f, 1.0f);
                        level.m_5594_(null, matching, (SoundEvent)NWSounds.ENERGY_SHIELD.get(), SoundSource.MASTER, 1.0f, 1.0f);
                    } else {
                        NWBasicMethods.messagePlayerCustomRecord(this.getController(level, pos), player, ChatFormatting.DARK_RED + NWBasicMethods.getTranslation("ability.naval_warfare.shield_destroyed"), true);
                        this.messageOwner(owner, level, "ability.naval_warfare.shield_destroyed");
                        this.recordOnController(level, pos, BattleLogHelper.createSound(id, false, (SoundEvent)NWSounds.ENERGY_SHIELD.get(), 1.0f, 0.5f), id);
                        level.m_5594_(null, pos, (SoundEvent)NWSounds.ENERGY_SHIELD.get(), SoundSource.MASTER, 1.0f, 0.5f);
                        level.m_5594_(null, matching, (SoundEvent)NWSounds.ENERGY_SHIELD.get(), SoundSource.MASTER, 1.0f, 0.5f);
                    }
                    return HitResult.BLOCKED;
                }
                return HitResult.HIT;
            }
            case TORPEDO: {
                if (level.m_8055_(pos.m_6630_(3)).m_60734_().equals(NWBlocks.TORPEDO_NET.get())) {
                    NWBasicMethods.messagePlayerCustomRecord(this.getController(level, pos), player, ChatFormatting.DARK_RED + NWBasicMethods.getTranslation("message.naval_warfare.torpedo_destroyed"), true);
                    this.messageOwner(owner, level, "message.naval_warfare.torpedo_destroyed");
                    NWBasicMethods.animateItemUse(player, ((Item)NWItems.TORPEDO_NET.get()).m_5456_());
                    this.showOwnerAnimation(owner, level, ((Item)NWItems.TORPEDO_NET.get()).m_5456_());
                    level.m_5594_(null, pos, (SoundEvent)NWSounds.TORPEDO_NET.get(), SoundSource.MASTER, 1.0f, 1.0f);
                    level.m_5594_(null, matching, (SoundEvent)NWSounds.TORPEDO_NET.get(), SoundSource.MASTER, 1.0f, 1.0f);
                    level.m_46597_(matching.m_6630_(3), ((Block)NWBlocks.TORPEDO_NET.get()).m_49966_());
                    PassiveAbilityBlock.setMatching(level, pos.m_6630_(3), matching.m_6630_(3));
                    this.recordOnController(level, pos, BattleLogHelper.createSound(id, false, (SoundEvent)NWSounds.TORPEDO_NET.get(), 1.0f, 1.0f), id);
                    return HitResult.NULLIFIED;
                }
                return HitResult.HIT;
            }
            case OVERLOADER: {
                if (level.m_8055_(pos.m_6630_(4)).m_60734_().equals(NWBlocks.ENERGY_SHIELD.get())) {
                    boolean result = EnergyShieldBlock.hit(level, pos.m_6630_(4), action, 100);
                    if (result) {
                        level.m_46597_(matching.m_6630_(4), ((Block)NWBlocks.ENERGY_SHIELD.get()).m_49966_());
                        PassiveAbilityBlock.setMatching(level, pos.m_6630_(4), matching.m_6630_(4));
                        this.recordOnController(level, pos, BattleLogHelper.createSound(id, false, (SoundEvent)NWSounds.ENERGY_SHIELD.get(), 1.0f, 1.0f), id);
                        level.m_5594_(null, pos, (SoundEvent)NWSounds.ENERGY_SHIELD.get(), SoundSource.MASTER, 1.0f, 1.0f);
                        level.m_5594_(null, matching, (SoundEvent)NWSounds.ENERGY_SHIELD.get(), SoundSource.MASTER, 1.0f, 1.0f);
                    } else {
                        NWBasicMethods.messagePlayerCustomRecord(this.getController(level, pos), player, ChatFormatting.DARK_RED + NWBasicMethods.getTranslation("ability.naval_warfare.shield_destroyed"), true);
                        this.messageOwner(owner, level, "ability.naval_warfare.shield_destroyed");
                        this.recordOnController(level, pos, BattleLogHelper.createSound(id, false, (SoundEvent)NWSounds.ENERGY_SHIELD.get(), 1.0f, 0.5f), id);
                        level.m_5594_(null, pos, (SoundEvent)NWSounds.ENERGY_SHIELD.get(), SoundSource.MASTER, 1.0f, 0.5f);
                        level.m_5594_(null, matching, (SoundEvent)NWSounds.ENERGY_SHIELD.get(), SoundSource.MASTER, 1.0f, 0.5f);
                    }
                }
                return HitResult.HIT;
            }
            case AIRCRAFT: {
                if (level.m_8055_(pos.m_6630_(5)).m_60734_().equals(NWBlocks.ANTI_AIR.get())) {
                    NWBasicMethods.messagePlayerCustomRecord(this.getController(level, pos), player, ChatFormatting.DARK_RED + NWBasicMethods.getTranslation("message.naval_warfare.aircraft_shot_down"), true);
                    this.messageOwner(owner, level, "message.naval_warfare.aircraft_shot_down");
                    NWBasicMethods.animateItemUse(player, ((Item)NWItems.ANTI_AIR.get()).m_5456_());
                    this.showOwnerAnimation(owner, level, ((Item)NWItems.ANTI_AIR.get()).m_5456_());
                    level.m_5594_(null, pos, (SoundEvent)NWSounds.ANTI_AIR.get(), SoundSource.MASTER, 1.0f, 1.0f);
                    level.m_5594_(null, matching, (SoundEvent)NWSounds.ANTI_AIR.get(), SoundSource.MASTER, 1.0f, 1.0f);
                    level.m_46597_(matching.m_6630_(5), ((Block)NWBlocks.ANTI_AIR.get()).m_49966_());
                    PassiveAbilityBlock.setMatching(level, pos.m_6630_(5), matching.m_6630_(5));
                    this.recordOnController(level, pos, BattleLogHelper.createSound(id, false, (SoundEvent)NWSounds.ANTI_AIR.get(), 1.0f, 1.0f), id);
                    return HitResult.NULLIFIED;
                }
                if (level.m_8055_(pos.m_6630_(4)).m_60734_().equals(NWBlocks.ENERGY_SHIELD.get())) {
                    NWBasicMethods.messagePlayerCustomRecord(this.getController(level, pos), player, ChatFormatting.DARK_RED + NWBasicMethods.getTranslation("message.naval_warfare.attack_blocked"), true);
                    this.messageOwner(owner, level, "message.naval_warfare.attack_blocked");
                    NWBasicMethods.animateItemUse(player, ((Item)NWItems.ENERGY_SHIELD.get()).m_5456_());
                    this.showOwnerAnimation(owner, level, ((Item)NWItems.ENERGY_SHIELD.get()).m_5456_());
                    boolean result = EnergyShieldBlock.hit(level, pos.m_6630_(4), action, 1);
                    if (result) {
                        level.m_46597_(matching.m_6630_(4), ((Block)NWBlocks.ENERGY_SHIELD.get()).m_49966_());
                        PassiveAbilityBlock.setMatching(level, pos.m_6630_(4), matching.m_6630_(4));
                        this.recordOnController(level, pos, BattleLogHelper.createSound(id, false, (SoundEvent)NWSounds.ENERGY_SHIELD.get(), 1.0f, 1.0f), id);
                        level.m_5594_(null, pos, (SoundEvent)NWSounds.ENERGY_SHIELD.get(), SoundSource.MASTER, 1.0f, 1.0f);
                        level.m_5594_(null, matching, (SoundEvent)NWSounds.ENERGY_SHIELD.get(), SoundSource.MASTER, 1.0f, 1.0f);
                    } else {
                        NWBasicMethods.messagePlayerCustomRecord(this.getController(level, pos), player, ChatFormatting.DARK_RED + NWBasicMethods.getTranslation("ability.naval_warfare.shield_destroyed"), true);
                        this.messageOwner(owner, level, "ability.naval_warfare.shield_destroyed");
                        this.recordOnController(level, pos, BattleLogHelper.createSound(id, false, (SoundEvent)NWSounds.ENERGY_SHIELD.get(), 1.0f, 0.5f), id);
                        level.m_5594_(null, pos, (SoundEvent)NWSounds.ENERGY_SHIELD.get(), SoundSource.MASTER, 1.0f, 0.5f);
                        level.m_5594_(null, matching, (SoundEvent)NWSounds.ENERGY_SHIELD.get(), SoundSource.MASTER, 1.0f, 0.5f);
                    }
                    return HitResult.BLOCKED;
                }
                return HitResult.HIT;
            }
        }
        return HitResult.HIT;
    }

    private void revealShip(Level level, BlockPos controller, ShipBlock ship, ShipRevealHelper srh) {
        GameControllerTE cte;
        BlockPos opp;
        if (this.validateController(level, controller) && this.validateController(level, opp = (cte = (GameControllerTE)level.m_7702_(controller)).getOpponent())) {
            GameControllerTE ote = (GameControllerTE)level.m_7702_(opp);
            BlockState ostate = level.m_8055_(opp);
            GameController oc = (GameController)ostate.m_60734_();
            BlockPos board = ote.getOpponentZero();
            if (this.validateBoard(level, board)) {
                BoardTE tte = (BoardTE)level.m_7702_(board);
                BlockPos tpos = tte.locateId(board, srh.getID(), oc.getFacing(level.m_8055_(opp)), true);
                Direction facing = NWBasicMethods.rotateToMatch(oc.getFacing(level.m_8055_(controller)), oc.getFacing(ostate), srh.getFacing());
                ship.summonShip(level, tpos.m_7494_(), (BlockState)srh.getState().m_61124_((Property)ShipBlock.FACING, (Comparable)facing), true, false);
            }
        }
    }

    public boolean validateBoard(Level level, BlockPos pos) {
        BlockState state = level.m_8055_(pos);
        if (!(state.m_60734_() instanceof Board)) {
            return false;
        }
        if (state.m_155947_()) {
            BlockEntity tile = level.m_7702_(pos);
            return tile instanceof BoardTE;
        }
        return false;
    }

    private boolean validateController(Level level, BlockPos pos) {
        BlockState state = level.m_8055_(pos);
        if (!(state.m_60734_() instanceof GameController)) {
            return false;
        }
        if (state.m_155947_()) {
            BlockEntity tile = level.m_7702_(pos);
            return tile instanceof GameControllerTE;
        }
        return false;
    }

    @Nullable
    public GameControllerTE getController(Level level, BlockPos pos) {
        if (!this.validateBoard(level, pos)) {
            return null;
        }
        BoardTE board = (BoardTE)level.m_7702_(pos);
        BlockPos cpos = board.getController();
        if (!this.validateController(level, cpos)) {
            return null;
        }
        return (GameControllerTE)level.m_7702_(cpos);
    }

    public Direction getControllerFacing(Level level, BlockPos pos) {
        GameControllerTE te = this.getController(level, pos);
        if (te != null) {
            BlockState state = te.m_58900_();
            GameController controller = (GameController)state.m_60734_();
            return controller.getFacing(state);
        }
        return Direction.NORTH;
    }

    public void addActionToController(Level level, BlockPos pos, ControllerActionHelper cah, int id) {
        GameControllerTE te = this.getController(level, pos);
        if (te != null) {
            te.addAction(cah);
        }
    }

    public void recordOnController(Level level, BlockPos pos, BattleLogHelper blh, int id) {
        GameControllerTE te = this.getController(level, pos);
        if (te != null) {
            te.recordOnRecorders(blh);
        }
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        if (level.m_5776_()) {
            return;
        }
        if (newState.m_60734_() instanceof Board) {
            return;
        }
        this.removeBoardAndShips(level, pos, !isMoving);
        if (state.m_155947_()) {
            level.m_46747_(pos);
        }
    }

    public BoardState getBoardState(BlockState state) {
        try {
            return (BoardState)((Object)state.m_61143_((Property)STATE));
        }
        catch (IllegalArgumentException e) {
            return BoardState.NEUTRAL;
        }
    }

    public boolean ownsBlock(Player player, Level level, BlockPos pos) {
        BlockState blockstate = level.m_8055_(pos);
        Block block = blockstate.m_60734_();
        if (!(block instanceof GameController) || !blockstate.m_155947_()) {
            return false;
        }
        GameController controller = (GameController)block;
        BlockEntity tile = level.m_7702_(pos);
        if (!(tile instanceof GameControllerTE)) {
            return false;
        }
        GameControllerTE te = (GameControllerTE)tile;
        return controller.ownsBlock(player, te.getOwner());
    }

    public boolean hasTurn(Player player, Level level, BlockPos pos) {
        BlockState blockstate = level.m_8055_(pos);
        Block block = blockstate.m_60734_();
        if (!(block instanceof GameController) || !blockstate.m_155947_()) {
            return false;
        }
        BlockEntity tile = level.m_7702_(pos);
        if (!(tile instanceof GameControllerTE)) {
            return false;
        }
        GameControllerTE te = (GameControllerTE)tile;
        return te.hasTurn();
    }

    public boolean canAccept(Player player, Level level, BlockPos pos) {
        BlockState blockstate = level.m_8055_(pos);
        Block block = blockstate.m_60734_();
        if (!(block instanceof GameController) || !blockstate.m_155947_()) {
            return false;
        }
        BlockEntity tile = level.m_7702_(pos);
        if (!(tile instanceof GameControllerTE)) {
            return false;
        }
        GameControllerTE te = (GameControllerTE)tile;
        return te.action_time <= 0;
    }

    public void controllerKeepsTurn(Level level, BlockPos pos, boolean cont) {
        if (!this.validateController(level, pos)) {
            return;
        }
        GameControllerTE te = (GameControllerTE)level.m_7702_(pos);
        if (!this.validateController(level, te.opponent)) {
            return;
        }
        te = (GameControllerTE)level.m_7702_(te.opponent);
        te.notifyResult(cont, false, cont);
    }

    public void notifyOwnerOfMiss(BlockPos pos, Level level, int id) {
        BlockEntity tile;
        if (level.m_8055_(pos).m_155947_() && (tile = level.m_7702_(pos)) instanceof GameControllerTE) {
            GameControllerTE te = (GameControllerTE)tile;
            String owner = te.getOwner();
            if (owner.equals("dummy")) {
                return;
            }
            Player player = level.m_46003_(UUID.fromString(owner));
            if (player != null) {
                NWBasicMethods.messagePlayerCustomRecord(te, player, NWBasicMethods.getOwnShipMissedMessage(id), false);
            }
        }
    }

    public void messageOwner(BlockPos pos, Level level, String message) {
        BlockEntity tile;
        if (level.m_8055_(pos).m_155947_() && (tile = level.m_7702_(pos)) instanceof GameControllerTE) {
            GameControllerTE te = (GameControllerTE)tile;
            String owner = te.getOwner();
            if (owner.equals("dummy")) {
                return;
            }
            Player player = level.m_46003_(UUID.fromString(owner));
            if (player != null) {
                NWBasicMethods.messagePlayerCustomRecord(te, player, ChatFormatting.DARK_RED + NWBasicMethods.getTranslation(message), false);
            }
        }
    }

    public void showOwnerAnimation(BlockPos pos, Level level, Item item) {
        BlockEntity tile;
        if (level.m_8055_(pos).m_155947_() && (tile = level.m_7702_(pos)) instanceof GameControllerTE) {
            GameControllerTE te = (GameControllerTE)tile;
            String owner = te.getOwner();
            if (owner.equals("dummy")) {
                return;
            }
            Player player = level.m_46003_(UUID.fromString(owner));
            if (player != null) {
                NWBasicMethods.animateItemUse(player, item);
            }
        }
    }

    public void removeBoardAndShips(Level level, BlockPos pos, boolean ships) {
        Direction[] dirs;
        BlockPos ship_pos = pos.m_7494_();
        int[] passives = new int[]{3, 4, 5};
        if (ships && level.m_8055_(ship_pos).m_60734_() instanceof ShipBlock) {
            Object ship = (Object)((ShipBlock)level.m_8055_(ship_pos).m_60734_());
            ((ShipBlock)((Object)ship)).removeShip(null, level.m_8055_(ship_pos), level, ship_pos, true, true);
        }
        for (int i : passives) {
            if (!(level.m_8055_(pos.m_6630_(i)).m_60734_() instanceof PassiveAbilityBlock)) continue;
            level.m_7471_(pos.m_6630_(i), false);
        }
        if (level.m_8055_(pos.m_6630_(2)).m_60734_() instanceof ShipMarkerBlock) {
            level.m_7471_(pos.m_6630_(2), false);
        }
        for (Direction dir : dirs = new Direction[]{Direction.NORTH, Direction.EAST, Direction.SOUTH, Direction.WEST}) {
            BlockPos board_pos = pos.m_142300_(dir);
            BlockState board = level.m_8055_(board_pos);
            if (!(board.m_60734_() instanceof Board) && !(board.m_60734_() instanceof BoardFiller)) continue;
            level.m_7471_(board_pos, !ships);
        }
    }

    public void handleShipBroken(Level level, BlockPos pos, String ship, int hp, boolean seaworthy) {
        GameControllerTE te = this.getController(level, pos);
        if (te == null) {
            return;
        }
        GameController c = (GameController)te.m_58900_().m_60734_();
        Player player = null;
        String owner = te.getOwner();
        if (!owner.equals("dummy")) {
            player = level.m_46003_(UUID.fromString(owner));
        }
        if (te.playing_game) {
            c.forfeitGame(level, player, te.m_58899_());
        } else {
            if (c.getState(te.m_58900_()).equals((Object)ControllerState.SEARCHING)) {
                if (GameController.CONTROLLERS.contains(te.m_58899_())) {
                    GameController.CONTROLLERS.remove(te.m_58899_());
                }
                level.m_46597_(te.m_58899_(), (BlockState)te.m_58900_().m_61124_((Property)GameController.STATE, (Comparable)((Object)ControllerState.EDIT_CONFIG)));
            }
            te.deregister(null, ship, hp, seaworthy);
        }
    }
}

