/*
 * Decompiled with CFR 0.152.
 */
package slimeattack07.naval_warfare.objects.blocks;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import slimeattack07.naval_warfare.objects.blocks.ShipBlock;
import slimeattack07.naval_warfare.tileentity.ShipTE;
import slimeattack07.naval_warfare.util.ShipPart;
import slimeattack07.naval_warfare.util.abilities.Ability;
import slimeattack07.naval_warfare.util.properties.ShipPartProperty;

public class DotShip
extends ShipBlock {
    private final boolean loses_hp;
    public static final ShipPartProperty SHIP_PART = ShipPartProperty.createTwo();

    public DotShip(Ability active_ability, Ability passive_ability, int tier) {
        super(active_ability, passive_ability, tier);
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)SHIP_PART, (Comparable)((Object)ShipPart.ONE)));
        this.loses_hp = false;
    }

    public DotShip() {
        super(null, null, 0);
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)SHIP_PART, (Comparable)((Object)ShipPart.ONE)));
        this.loses_hp = true;
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{SHIP_PART});
    }

    @Override
    public boolean canPlace(Level level, BlockPos pos, BlockState state, boolean include_base, boolean display) {
        Direction facing = DotShip.getFacing(state);
        return !include_base || this.spaceValid(level, pos, facing, 0, 0, display);
    }

    @Override
    public boolean summonShip(Level level, BlockPos pos, BlockState state, boolean include_base, boolean display) {
        boolean placeable = this.canPlace(level, pos, state, include_base, display);
        if (placeable) {
            if (include_base) {
                level.m_46597_(pos, state);
            }
        } else if (!include_base) {
            level.m_46597_(pos, Blocks.f_50016_.m_49966_());
        }
        return placeable;
    }

    @Override
    @Nullable
    public BlockPos getNext(ShipTE te) {
        return null;
    }

    @Override
    public boolean isBase(BlockState state) {
        return this.getShipPart(state, SHIP_PART).equals((Object)ShipPart.ONE);
    }

    @Override
    public boolean isMiddle(BlockState state) {
        return this.getShipPart(state, SHIP_PART).equals((Object)ShipPart.ONE);
    }

    @Override
    public int getMaxHP() {
        return this.loses_hp ? 1 : 0;
    }

    @Override
    public String getShapeTranslation() {
        return "dot";
    }

    @Override
    public boolean losesHP() {
        return this.loses_hp;
    }
}

