/*
 * Decompiled with CFR 0.152.
 */
package slimeattack07.naval_warfare.objects.blocks;

import java.util.ArrayList;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stat;
import net.minecraft.stats.StatFormatter;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraftforge.registries.ForgeRegistries;
import slimeattack07.naval_warfare.NavalWarfare;
import slimeattack07.naval_warfare.config.NavalWarfareConfig;
import slimeattack07.naval_warfare.init.NWBlocks;
import slimeattack07.naval_warfare.init.NWItems;
import slimeattack07.naval_warfare.init.NWSounds;
import slimeattack07.naval_warfare.init.NWStats;
import slimeattack07.naval_warfare.init.NWTileEntityTypes;
import slimeattack07.naval_warfare.init.NWTriggers;
import slimeattack07.naval_warfare.objects.blocks.Board;
import slimeattack07.naval_warfare.objects.blocks.ShipBlock;
import slimeattack07.naval_warfare.objects.items.AbilityWand;
import slimeattack07.naval_warfare.objects.items.GameInteractor;
import slimeattack07.naval_warfare.objects.items.ShipConfiguration;
import slimeattack07.naval_warfare.objects.items.SpellWand;
import slimeattack07.naval_warfare.tileentity.BoardTE;
import slimeattack07.naval_warfare.tileentity.GameControllerTE;
import slimeattack07.naval_warfare.util.ControllerState;
import slimeattack07.naval_warfare.util.InteractorMode;
import slimeattack07.naval_warfare.util.NWBasicMethods;
import slimeattack07.naval_warfare.util.abilities.Ability;
import slimeattack07.naval_warfare.util.helpers.ControllerActionHelper;
import slimeattack07.naval_warfare.util.helpers.ShipSaveHelper;
import slimeattack07.naval_warfare.util.properties.ControllerStateProperty;

public class GameController
extends Block
implements EntityBlock {
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    public static final ControllerStateProperty STATE = ControllerStateProperty.create();
    public static final int DEFAULT_BOARD_SIZE = (Integer)NavalWarfareConfig.default_board_size.get();
    public static final ArrayList<BlockPos> CONTROLLERS = new ArrayList();

    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_());
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING});
        builder.m_61104_(new Property[]{STATE});
    }

    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        return level.m_5776_() ? null : (l, s, pos, tile) -> ((GameControllerTE)tile).tick();
    }

    public GameController() {
        super(BlockBehaviour.Properties.m_60939_((Material)Material.f_76278_).m_60999_().m_60913_(0.8f, 2.0f).m_155956_(1000.0f));
        this.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)STATE, (Comparable)((Object)ControllerState.INACTIVE)));
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return ((BlockEntityType)NWTileEntityTypes.GAME_CONTROLLER.get()).m_155264_(pos, state);
    }

    public void handleInteraction(BlockState state, Level level, BlockPos pos, Player player, ItemStack itemstack) {
        GameInteractor interactor = (GameInteractor)itemstack.m_41720_();
        BlockEntity tile = level.m_7702_(pos);
        if (tile instanceof GameControllerTE) {
            GameControllerTE te = (GameControllerTE)tile;
            if (!te.hasOwner() && player == null) {
                te.setOwner("dummy");
            }
            if (!this.ownsBlock(player, te.getOwner())) {
                NWBasicMethods.messagePlayer(player, "message.naval_warfare.not_owner_c");
                return;
            }
            if (te.hasRegInBuffer()) {
                NWBasicMethods.messagePlayer(player, "message.naval_warfare.still_randomizing");
                return;
            }
            InteractorMode mode = interactor.getMode(itemstack);
            ControllerState c_state = this.getState(state);
            switch (mode) {
                case LOAD_SHIP_CONFIG: {
                    if (this.validateInteraction(c_state, player, mode)) {
                        if (te.hasBoard()) {
                            this.removeBoardAndShips(level, te);
                        }
                        level.m_46597_(pos, (BlockState)state.m_61124_((Property)STATE, (Comparable)((Object)ControllerState.EDIT_CONFIG)));
                        te.resetBoardValues();
                        break;
                    }
                    NWBasicMethods.messagePlayerActionbar(player, "message.naval_warfare.controller_wrong_state");
                    break;
                }
                case NEW_SHIP_CONFIG: {
                    if (this.validateInteraction(c_state, player, mode)) {
                        if (te.hasBoard()) {
                            this.removeBoardAndShips(level, te);
                        }
                        te.resetBoardValues();
                        this.spawnBoard(level, player, te, te.m_58899_(), DEFAULT_BOARD_SIZE, false);
                        interactor.setMode(itemstack, InteractorMode.SAVE_CONFIG);
                        level.m_46597_(pos, (BlockState)state.m_61124_((Property)STATE, (Comparable)((Object)ControllerState.EDIT_CONFIG)));
                        break;
                    }
                    NWBasicMethods.messagePlayerActionbar(player, "message.naval_warfare.controller_wrong_state");
                    break;
                }
                case TARGET_TILE: {
                    NWBasicMethods.messagePlayerActionbar(player, "message.naval_warfare.unsupported_operation");
                    break;
                }
                case SAVE_CONFIG: {
                    if (this.validateInteraction(c_state, player, mode)) {
                        ItemStack config = this.saveConfig(level, state, te.getZero(), te.board_size, te.getName(), player);
                        if (config == null) break;
                        interactor.setMode(itemstack, InteractorMode.NEW_SHIP_CONFIG);
                        NWBasicMethods.messagePlayerActionbarBack(player, "message.naval_warfare.config_saved", ": " + config.m_41611_().getString().replace("[", "").replace("]", ""));
                        level.m_46597_(pos, (BlockState)state.m_61124_((Property)STATE, (Comparable)((Object)ControllerState.INACTIVE)));
                        NWBasicMethods.addOrSpawn(player, config, level, pos);
                        this.removeBoardAndShips(level, te);
                        te.resetBoardValues();
                        break;
                    }
                    NWBasicMethods.messagePlayerActionbar(player, "message.naval_warfare.controller_wrong_state");
                    break;
                }
                case REQUEST_GAME: {
                    if (this.validateInteraction(c_state, player, mode) && this.readyForGame(te, player)) {
                        ItemStack config = this.saveConfig(level, state, te.getZero(), te.board_size, te.getName(), player);
                        if (config == null) {
                            return;
                        }
                        if (this.requestGame(level, player, pos)) break;
                        level.m_46597_(pos, (BlockState)state.m_61124_((Property)STATE, (Comparable)((Object)ControllerState.SEARCHING)));
                        break;
                    }
                    NWBasicMethods.messagePlayerActionbar(player, "message.naval_warfare.controller_wrong_state");
                    break;
                }
                case CANCEL_REQUEST_GAME: {
                    if (this.validateInteraction(c_state, player, mode)) {
                        if (!this.requestCancelGame(level, player, pos)) break;
                        level.m_46597_(pos, (BlockState)state.m_61124_((Property)STATE, (Comparable)((Object)ControllerState.EDIT_CONFIG)));
                        break;
                    }
                    NWBasicMethods.messagePlayerActionbar(player, "message.naval_warfare.controller_wrong_state");
                    break;
                }
                case FORFEIT_GAME: {
                    if (this.validateInteraction(c_state, player, mode)) {
                        this.forfeitGame(level, player, pos);
                        break;
                    }
                    NWBasicMethods.messagePlayerActionbar(player, "message.naval_warfare.controller_wrong_state");
                    break;
                }
                default: {
                    NavalWarfare.LOGGER.warn("Ignoring unhandled interactor mode in game controller, report this to the mod author! Mode is: " + mode);
                }
            }
        }
    }

    public boolean activateActiveAbility(Level level, Player player, BlockPos pos, BoardTE board, Ability ability, ItemStack wand, boolean spell) {
        if (this.validateController(level, pos)) {
            GameControllerTE te = (GameControllerTE)level.m_7702_(pos);
            if (!this.ownsBlock(player, te.getOwner())) {
                NWBasicMethods.messagePlayer(player, "message.naval_warfare.not_owner_c");
                return true;
            }
            if (te.action_time > 0) {
                NWBasicMethods.messagePlayer(player, "message.naval_warfare.busy");
                return true;
            }
            if (te.hasGame() && te.hasTurn()) {
                GameControllerTE ote;
                String oowner;
                if (!spell) {
                    AbilityWand awand = (AbilityWand)wand.m_41720_();
                    awand.decreaseActiveAmount(level, wand);
                }
                String translation = spell ? "spell.naval_warfare.activated" : "ability.naval_warfare.activated";
                NWBasicMethods.messagePlayerAbilityUsed(te, player, translation, player.m_7755_().getString(), ability.hoverableInfo());
                NWBasicMethods.messagePlayerTitle(player, level, translation, "dark_green", ability.getTranslation(), "green");
                NWBasicMethods.animateItemUse(player, ability.getAnimationItem());
                BlockPos opos = te.getOpponent();
                if (this.validateController(level, opos) && !(oowner = (ote = (GameControllerTE)level.m_7702_(opos)).getOwner()).equals("dummy")) {
                    UUID uuid = UUID.fromString(oowner);
                    Player opponent = level.m_46003_(uuid);
                    NWBasicMethods.messagePlayerAbilityUsed(null, opponent, translation, player.m_7755_().getString(), ability.hoverableInfo());
                    NWBasicMethods.messagePlayerTitle(opponent, level, translation, "dark_green", ability.getTranslation(), "green");
                    NWBasicMethods.animateItemUse(opponent, ability.getAnimationItem());
                }
                if (!spell) {
                    te.consumeEnergy(ability.energyCost());
                    te.addAction(ControllerActionHelper.createAbility(((AbilityWand)wand.m_41720_()).getShip(wand), board.m_58899_(), player.m_20149_(), true));
                } else {
                    SpellWand swand = (SpellWand)wand.m_41720_();
                    te.addAction(ControllerActionHelper.createSpell(swand.getSpell(wand), board.m_58899_(), player.m_20149_()));
                }
                this.statsAndAdvancements(player, spell);
                return true;
            }
            NWBasicMethods.messagePlayerActionbar(player, "message.naval_warfare.not_turn");
            return true;
        }
        return false;
    }

    private void statsAndAdvancements(Player player, boolean spell) {
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer sp = (ServerPlayer)player;
        if (spell) {
            try {
                sp.m_36220_(NWStats.SPELLS_USED);
                NWTriggers.SPELL.trigger(sp);
                Stat stat = Stats.f_12988_.m_12899_((Object)new ResourceLocation("naval_warfare", "spells_used"), StatFormatter.f_12873_);
                int val = sp.m_8951_().m_13015_(stat);
                if (val >= 10) {
                    NWTriggers.SPELL_10.trigger(sp);
                }
                if (val >= 50) {
                    NWTriggers.SPELL_50.trigger(sp);
                }
            }
            catch (NullPointerException e) {
                NavalWarfare.LOGGER.error("Failed to fetch the spells used statistic.");
            }
        } else {
            try {
                sp.m_36220_(NWStats.ACTIVE_USED);
                NWTriggers.ACTIVE.trigger(sp);
                Stat stat = Stats.f_12988_.m_12899_((Object)new ResourceLocation("naval_warfare", "active_used"), StatFormatter.f_12873_);
                int val = sp.m_8951_().m_13015_(stat);
                if (val >= 50) {
                    NWTriggers.ACTIVE_50.trigger(sp);
                }
                if (val >= 100) {
                    NWTriggers.ACTIVE_100.trigger(sp);
                }
            }
            catch (NullPointerException e) {
                NavalWarfare.LOGGER.error("Failed to fetch the active used statistic.");
            }
        }
    }

    private boolean readyForGame(GameControllerTE te, Player player) {
        if (te.getHP() <= 0 || te.getBoardSize() <= 0) {
            if (player != null) {
                NWBasicMethods.messagePlayer(player, "message.naval_warfare.needs_valid_board");
            }
            return false;
        }
        return true;
    }

    private boolean validateInteraction(ControllerState state, @Nullable Player player, InteractorMode mode) {
        switch (state) {
            case EDIT_CONFIG: {
                return mode.equals((Object)InteractorMode.SAVE_CONFIG) || mode.equals((Object)InteractorMode.NEW_SHIP_CONFIG) || mode.equals((Object)InteractorMode.LOAD_SHIP_CONFIG) || mode.equals((Object)InteractorMode.REQUEST_GAME);
            }
            case INACTIVE: {
                return mode.equals((Object)InteractorMode.NEW_SHIP_CONFIG) || mode.equals((Object)InteractorMode.LOAD_SHIP_CONFIG);
            }
            case PLAYING_GAME: {
                return mode.equals((Object)InteractorMode.FORFEIT_GAME);
            }
            case SEARCHING: {
                return mode.equals((Object)InteractorMode.CANCEL_REQUEST_GAME);
            }
        }
        NWBasicMethods.messagePlayerActionbar(player, "message.naval_warfare.illegal_action");
        return false;
    }

    private boolean spawnOpponentBoard(Level level, Player player, GameControllerTE te, int own_size, int opp_size) {
        double sqrt = Math.sqrt(own_size);
        int offset = (int)Math.ceil(sqrt) + 2;
        Direction dir = this.getFacing(te.m_58900_());
        return this.spawnBoard(level, player, te, te.m_58899_().m_5484_(dir, offset), opp_size, true);
    }

    private void startGame(Level level, GameControllerTE own_te, GameControllerTE opp_te) {
        Player own_p = own_te.getOwner().equals("dummy") ? null : level.m_46003_(UUID.fromString(own_te.owner));
        Player opp_p = opp_te.getOwner().equals("dummy") ? null : level.m_46003_(UUID.fromString(opp_te.owner));
        boolean spawned_own_opp = this.spawnOpponentBoard(level, own_p, own_te, own_te.getBoardSize(), opp_te.getBoardSize());
        boolean spawned_opp_opp = this.spawnOpponentBoard(level, opp_p, opp_te, opp_te.getBoardSize(), own_te.getBoardSize());
        if (!spawned_own_opp || !spawned_opp_opp) {
            if (!spawned_own_opp) {
                NWBasicMethods.messagePlayer(own_p, "message.naval_warfare.game_start_failure_own");
                NWBasicMethods.messagePlayer(opp_p, "message.naval_warfare.game_start_failure_opponent");
            }
            if (!spawned_opp_opp) {
                NWBasicMethods.messagePlayer(own_p, "message.naval_warfare.game_start_failure_opponent");
                NWBasicMethods.messagePlayer(opp_p, "message.naval_warfare.game_start_failure_own");
            }
            this.removeBoardAndShips(level, own_te);
            this.removeBoardAndShips(level, opp_te);
            level.m_46597_(own_te.m_58899_(), (BlockState)own_te.m_58900_().m_61124_((Property)STATE, (Comparable)((Object)ControllerState.EDIT_CONFIG)));
            level.m_46597_(opp_te.m_58899_(), (BlockState)opp_te.m_58900_().m_61124_((Property)STATE, (Comparable)((Object)ControllerState.EDIT_CONFIG)));
            return;
        }
        level.m_46597_(own_te.m_58899_(), (BlockState)own_te.m_58900_().m_61124_((Property)STATE, (Comparable)((Object)ControllerState.PLAYING_GAME)));
        level.m_46597_(opp_te.m_58899_(), (BlockState)opp_te.m_58900_().m_61124_((Property)STATE, (Comparable)((Object)ControllerState.PLAYING_GAME)));
        own_te.setOpponent(opp_te.m_58899_());
        opp_te.setOpponent(own_te.m_58899_());
        own_te.setGame(true);
        opp_te.setGame(true);
        own_te.action_number = 0;
        opp_te.action_number = 0;
        own_te.cons_timeout_times = 0;
        opp_te.cons_timeout_times = 0;
        own_te.timeout_times = 0;
        opp_te.timeout_times = 0;
        own_te.deployStartingPassiveAbilities(level, own_p);
        opp_te.deployStartingPassiveAbilities(level, opp_p);
        int own_hp = own_te.getHP();
        int opp_hp = opp_te.getHP();
        boolean you_start = own_hp <= opp_hp;
        own_te.setEnergy(GameControllerTE.BASE_ENERGY);
        opp_te.setEnergy(GameControllerTE.BASE_ENERGY);
        own_te.setTurn(you_start, false);
        opp_te.setTurn(!you_start, false);
        String energy_own = NWBasicMethods.getTranslation("message.naval_warfare.energy_start_own").replace("MARKER1", "" + GameControllerTE.BASE_ENERGY);
        String energy_opp = NWBasicMethods.getTranslation("message.naval_warfare.energy_start_opponent").replace("MARKER1", "" + GameControllerTE.BASE_ENERGY);
        if (you_start) {
            if (own_p != null) {
                NWBasicMethods.sendGameStatusToPlayer(level, own_te.getOwner(), "message.naval_warfare.game_found", "blue", "message.naval_warfare.your_turn_first", "aqua");
                NWBasicMethods.messagePlayerCustomRecord(own_te, own_p, ChatFormatting.YELLOW + energy_own, false);
                own_p.m_6330_((SoundEvent)NWSounds.GAME_FOUND.get(), SoundSource.MASTER, 1.0f, 1.0f);
            }
            if (opp_p != null) {
                NWBasicMethods.sendGameStatusToPlayer(level, opp_te.getOwner(), "message.naval_warfare.game_found", "blue", "message.naval_warfare.opponent_turn_first", "aqua");
                NWBasicMethods.messagePlayerCustomRecord(opp_te, opp_p, ChatFormatting.YELLOW + energy_opp, false);
                opp_p.m_6330_((SoundEvent)NWSounds.GAME_FOUND.get(), SoundSource.MASTER, 1.0f, 1.0f);
            }
        } else {
            if (own_p != null) {
                NWBasicMethods.sendGameStatusToPlayer(level, own_te.getOwner(), "message.naval_warfare.game_found", "blue", "message.naval_warfare.opponent_turn_first", "aqua");
                own_p.m_6330_((SoundEvent)NWSounds.GAME_FOUND.get(), SoundSource.MASTER, 1.0f, 1.0f);
                NWBasicMethods.messagePlayerCustomRecord(own_te, own_p, ChatFormatting.YELLOW + energy_opp, false);
            }
            if (opp_p != null) {
                NWBasicMethods.sendGameStatusToPlayer(level, opp_te.getOwner(), "message.naval_warfare.game_found", "blue", "message.naval_warfare.your_turn_first", "aqua");
                NWBasicMethods.messagePlayerCustomRecord(opp_te, opp_p, ChatFormatting.YELLOW + energy_own, false);
                opp_p.m_6330_((SoundEvent)NWSounds.GAME_FOUND.get(), SoundSource.MASTER, 1.0f, 1.0f);
            }
        }
        this.recordOnRecorders(level, own_te, opp_te);
    }

    private void recordOnRecorders(Level level, GameControllerTE own_te, GameControllerTE opp_te) {
        ArrayList<ShipSaveHelper> own_ships = this.collectShips(level, own_te.zero);
        ArrayList<ShipSaveHelper> opp_ships = this.collectShips(level, opp_te.zero);
        GameController c = (GameController)own_te.m_58900_().m_60734_();
        own_te.recordOnRecorder(own_ships, opp_ships, own_te.board_size, opp_te.board_size, c.getFacing(own_te.m_58900_()), c.getFacing(opp_te.m_58900_()));
        opp_te.recordOnRecorder(opp_ships, own_ships, opp_te.board_size, own_te.board_size, c.getFacing(opp_te.m_58900_()), c.getFacing(own_te.m_58900_()));
    }

    private ArrayList<ShipSaveHelper> collectShips(Level level, BlockPos zero) {
        BlockEntity tile = level.m_7702_(zero);
        if (tile instanceof BoardTE) {
            BoardTE bte = (BoardTE)tile;
            Board board = (Board)bte.m_58900_().m_60734_();
            return bte.collectShips(level, zero, board.getControllerFacing(level, bte.m_58899_()), null);
        }
        return new ArrayList<ShipSaveHelper>();
    }

    private boolean requestGame(Level level, Player player, BlockPos pos) {
        if (!CONTROLLERS.contains(pos)) {
            CONTROLLERS.add(pos);
        }
        if (player != null) {
            NWBasicMethods.messagePlayer(player, "message.naval_warfare.requested_game");
        }
        if (CONTROLLERS.size() > 1) {
            BlockPos p1 = CONTROLLERS.get(0);
            BlockPos p2 = CONTROLLERS.get(1);
            if (!this.validateController(level, p1)) {
                CONTROLLERS.remove(p1);
                return false;
            }
            if (!this.validateController(level, p2)) {
                CONTROLLERS.remove(p2);
                return false;
            }
            BlockState s1 = level.m_8055_(p1);
            GameControllerTE t1 = (GameControllerTE)level.m_7702_(p1);
            GameControllerTE t2 = (GameControllerTE)level.m_7702_(p2);
            GameController c = (GameController)s1.m_60734_();
            c.startGame(level, t1, t2);
            CONTROLLERS.remove(p1);
            CONTROLLERS.remove(p2);
            return true;
        }
        return false;
    }

    public void forfeitGame(Level level, Player player, BlockPos pos) {
        if (!this.validateController(level, pos)) {
            return;
        }
        GameControllerTE te_own = (GameControllerTE)level.m_7702_(pos);
        BlockPos opponent = te_own.getOpponent();
        if (!this.validateController(level, opponent)) {
            return;
        }
        GameControllerTE te_opp = (GameControllerTE)level.m_7702_(opponent);
        String op_string = te_opp.getOwner();
        Player opp_player = op_string.equals("dummy") ? null : level.m_46003_(UUID.fromString(op_string));
        NWBasicMethods.messagePlayerCustomRecord(te_own, player, NWBasicMethods.getTranslation("message.naval_warfare.forfeit_own"), false);
        NWBasicMethods.messagePlayerCustomRecord(te_opp, player, NWBasicMethods.getTranslation("message.naval_warfare.forfeit_opponent"), false);
        te_own.endGame(level, te_own, false, player, false);
        te_opp.endGame(level, te_opp, true, opp_player, true);
    }

    private void forfeitGame(Level level, Player player, GameControllerTE te_own) {
        BlockPos opponent = te_own.getOpponent();
        if (!this.validateController(level, opponent)) {
            level.m_46747_(te_own.m_58899_());
            return;
        }
        GameControllerTE te_opp = (GameControllerTE)level.m_7702_(opponent);
        String op_string = te_opp.getOwner();
        Player opp_player = op_string.equals("dummy") ? null : level.m_46003_(UUID.fromString(op_string));
        NWBasicMethods.messagePlayer(player, "message.naval_warfare.forfeit_own");
        NWBasicMethods.messagePlayer(opp_player, "message.naval_warfare.forfeit_opponent");
        te_own.endGame(level, te_own, false, player, false, false);
        te_opp.endGame(level, te_opp, true, opp_player, true);
        level.m_46747_(te_own.m_58899_());
    }

    private boolean requestCancelGame(Level level, Player player, BlockPos pos) {
        boolean cancelled;
        boolean bl = cancelled = !CONTROLLERS.contains(pos) || CONTROLLERS.remove(pos);
        if (cancelled) {
            NWBasicMethods.messagePlayer(player, "message.naval_warfare.cancelled_request_game");
        }
        return cancelled;
    }

    public boolean validateController(Level level, BlockPos pos) {
        BlockState state = level.m_8055_(pos);
        if (!(state.m_60734_() instanceof GameController)) {
            return false;
        }
        if (state.m_155947_()) {
            BlockEntity tile = level.m_7702_(pos);
            return tile instanceof GameControllerTE;
        }
        return false;
    }

    public void removeBoardAndShips(Level level, GameControllerTE te) {
        this.removeBoardAndShips(level, te, true);
    }

    public void removeBoardAndShips(Level level, GameControllerTE te, boolean ships) {
        BlockPos pos = te.getZero();
        BlockState state = level.m_8055_(pos);
        if (state.m_60734_() instanceof Board) {
            Board board = (Board)state.m_60734_();
            board.removeBoardAndShips(level, pos, ships);
        }
    }

    public InteractionResult handleShipConfig(BlockState state, Level level, BlockPos pos, Player player, ItemStack itemstack) {
        if (!this.validateController(level, pos)) {
            return InteractionResult.SUCCESS;
        }
        GameControllerTE te = (GameControllerTE)level.m_7702_(pos);
        switch (this.getState(state)) {
            case EDIT_CONFIG: {
                if (te.clear_board) break;
                if (te.hasBoard() && !te.clear_board) {
                    this.removeBoardAndShips(level, te);
                }
                this.handleShipConfigLoad(state, level, pos, player, itemstack, te);
                return InteractionResult.SUCCESS;
            }
        }
        NWBasicMethods.messagePlayerActionbar(player, "message.naval_warfare.config_unavailable");
        return InteractionResult.SUCCESS;
    }

    public void handleShipConfigLoad(BlockState state, Level level, BlockPos pos, Player player, ItemStack itemstack, GameControllerTE te) {
        ShipConfiguration config = (ShipConfiguration)itemstack.m_41720_();
        if (!this.ownsBlock(player, te.getOwner())) {
            NWBasicMethods.messagePlayer(player, "message.naval_warfare.not_owner_c");
            return;
        }
        if (this.getState(state).equals((Object)ControllerState.EDIT_CONFIG) && config.isValid(itemstack)) {
            BlockEntity t;
            CompoundTag nbt = itemstack.m_41784_();
            CompoundTag nw = nbt.m_128469_("naval_warfare");
            int board_size = nw.m_128451_("board_size");
            boolean spawned = this.spawnBoard(level, player, te, te.m_58899_(), board_size, false);
            if (!spawned) {
                return;
            }
            Direction dir = this.getFacing(state);
            BlockPos zero = te.getZero();
            BlockState bstate = level.m_8055_(zero);
            if (bstate.m_155947_()) {
                t = level.m_7702_(zero);
                if (!(t instanceof BoardTE)) {
                    return;
                }
            } else {
                return;
            }
            BoardTE bte = (BoardTE)t;
            Direction facing = Direction.valueOf((String)nw.m_128461_("facing").toUpperCase());
            ArrayList<ShipSaveHelper> ssh = config.readShips(nw);
            for (ShipSaveHelper ship : ssh) {
                Block block = (Block)ForgeRegistries.BLOCKS.getValue(ship.getShip());
                if (block == null || !(block instanceof ShipBlock)) continue;
                ShipBlock ship_block = (ShipBlock)block;
                BlockPos ship_pos = bte.locateId(zero, ship.getPos(), dir).m_7494_();
                spawned = ship_block.summonShip(level, ship_pos, (BlockState)ship_block.m_49966_().m_61124_((Property)FACING, (Comparable)NWBasicMethods.rotateToMatch(facing, dir, ship.getDir())), true, false);
                if (!spawned) {
                    this.removeBoardAndShips(level, te);
                    te.clearRegistered();
                    NWBasicMethods.messagePlayerCustom(player, NWBasicMethods.getTranslation("message.naval_warfare.ship_spawn_failure").replace("MARKER1", ship_pos.m_123344_()));
                }
                te.register(ship_block.getRegistryName().toString());
            }
            te.setBoardSize(board_size);
            te.setHP(nw.m_128451_("hp"));
            String disname = itemstack.m_41611_().getString().replace("[", "").replace("]", "");
            te.setName(disname);
            NWBasicMethods.messagePlayerActionbarBack(player, "message.naval_warfare.config_loaded", ": " + disname);
        }
    }

    private ItemStack saveConfig(Level level, BlockState state, BlockPos pos, int board_size, String name, Player player) {
        BlockEntity tile;
        Direction dir = this.getFacing(state);
        BlockState bstate = level.m_8055_(pos);
        if (bstate.m_155947_() && (tile = level.m_7702_(pos)) instanceof BoardTE) {
            BoardTE te = (BoardTE)tile;
            ArrayList<ShipSaveHelper> ssh = te.collectShips(level, pos, dir, player);
            if (ssh != null) {
                if (this.validateController(level, te.getController())) {
                    GameControllerTE cte = (GameControllerTE)level.m_7702_(te.getController());
                    if (cte.getRegistered() == null) {
                        NWBasicMethods.messagePlayerActionbar(player, "message.naval_warfare.empty_config");
                        return null;
                    }
                    if (cte.getRegistered().size() != ssh.size()) {
                        NWBasicMethods.messagePlayerActionbar(player, "message.naval_warfare.missing_registered");
                        return null;
                    }
                }
            } else {
                return null;
            }
            ItemStack stack = new ItemStack((ItemLike)NWItems.SHIP_CONFIGURATION.get());
            ShipConfiguration sc = (ShipConfiguration)stack.m_41720_();
            sc.saveShipConfiguration(stack, board_size, ssh, dir);
            stack.m_41714_((Component)new TextComponent(name));
            return stack;
        }
        return null;
    }

    public boolean spawnBoard(Level level, Player player, GameControllerTE tile, BlockPos location, int amount, boolean redirect) {
        BlockEntity btile;
        int z;
        double floor;
        Direction dir = this.getFacing(tile.m_58900_());
        double root = Math.sqrt(amount);
        double diff = root - (floor = Math.floor(root));
        int zlength = diff == 0.0 ? (int)floor : (int)floor + 1;
        int xlength = diff >= 0.5 ? (int)floor + 1 : (int)floor;
        int current = 0;
        int center = xlength / 2;
        BlockPos cube_origin = this.nextPosToCheck(dir, location, -center, 1);
        if (!this.spaceChecker(level, player, dir, cube_origin, xlength, zlength)) {
            return false;
        }
        BlockState state = redirect ? ((Block)NWBlocks.BOARD_REDIRECT.get()).m_49966_() : ((Block)NWBlocks.BOARD.get()).m_49966_();
        BlockState filler = ((Block)NWBlocks.BOARD_FILLER.get()).m_49966_();
        for (z = 0; z < zlength; ++z) {
            for (int x = 0; x < xlength; ++x) {
                BlockPos next = this.nextPosToCheck(dir, cube_origin, x, z);
                if (current < amount) {
                    level.m_46597_(next, state);
                    ++current;
                    continue;
                }
                level.m_46597_(next, filler);
            }
        }
        for (int x = -1; x < xlength; ++x) {
            BlockPos next = this.nextPosToCheck(dir, cube_origin, x, -1);
            this.setFillerUnlessController(level, next);
            next = this.nextPosToCheck(dir, cube_origin, x, zlength);
            this.setFillerUnlessController(level, next);
        }
        for (z = -1; z < zlength; ++z) {
            BlockPos next = this.nextPosToCheck(dir, cube_origin, -1, z);
            this.setFillerUnlessController(level, next);
            next = this.nextPosToCheck(dir, cube_origin, xlength, z);
            this.setFillerUnlessController(level, next);
        }
        BlockPos next = this.nextPosToCheck(dir, cube_origin, xlength, zlength);
        this.setFillerUnlessController(level, next);
        BlockState board = level.m_8055_(cube_origin);
        if (board.m_155947_() && (btile = level.m_7702_(cube_origin)) instanceof BoardTE) {
            BoardTE bte = (BoardTE)btile;
            bte.setControllerAndId(tile.m_58899_(), 0, dir);
        }
        if (redirect) {
            tile.setOpponentZero(cube_origin);
        } else {
            tile.setZero(cube_origin);
            tile.setBoardSize(amount);
        }
        return true;
    }

    private void setFillerUnlessController(Level level, BlockPos pos) {
        if (!(level.m_8055_(pos).m_60734_() instanceof GameController)) {
            level.m_46597_(pos, ((Block)NWBlocks.BOARD_FILLER.get()).m_49966_());
        }
    }

    public Direction getFacing(BlockState state) {
        try {
            return (Direction)state.m_61143_((Property)FACING);
        }
        catch (IllegalArgumentException e) {
            return Direction.NORTH;
        }
    }

    public ControllerState getState(BlockState state) {
        try {
            return (ControllerState)((Object)state.m_61143_((Property)STATE));
        }
        catch (IllegalArgumentException e) {
            return ControllerState.INACTIVE;
        }
    }

    private BlockPos nextPosToCheck(Direction dir, BlockPos origin, int x, int z) {
        int y = origin.m_123342_();
        switch (dir) {
            case NORTH: {
                return new BlockPos(origin.m_123341_() - x, y, origin.m_123343_() - z);
            }
            case EAST: {
                return new BlockPos(origin.m_123341_() + z, y, origin.m_123343_() - x);
            }
            case SOUTH: {
                return new BlockPos(origin.m_123341_() + x, y, origin.m_123343_() + z);
            }
            case WEST: {
                return new BlockPos(origin.m_123341_() - z, y, origin.m_123343_() + x);
            }
        }
        return origin;
    }

    private boolean spaceChecker(Level level, Player player, Direction dir, BlockPos origin, int xdim, int zdim) {
        for (int z = -1; z < zdim + 1; ++z) {
            for (int x = -1; x < xdim + 1; ++x) {
                BlockPos pos = this.nextPosToCheck(dir, origin, x, z);
                Block block = level.m_8055_(pos).m_60734_();
                if (block.equals(Blocks.f_50016_) || block.equals(NWBlocks.GAME_CONTROLLER.get())) continue;
                if (player != null) {
                    String translation = NWBasicMethods.getTranslation("message.naval_warfare.board_size_not_clear");
                    translation = translation.replace("MARKER1", "" + pos.m_123341_()).replace("MARKER2", "" + pos.m_123342_()).replace("MARKER3", "" + pos.m_123343_()).replace("MARKER4", block.getRegistryName().toString());
                    NWBasicMethods.messagePlayerCustom(player, translation);
                }
                return false;
            }
        }
        return true;
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        if (level.m_5776_()) {
            return;
        }
        if (newState.m_60734_() instanceof GameController) {
            return;
        }
        Direction dir = this.getFacing(state);
        BlockPos board_pos = pos.m_142300_(dir);
        BlockState board = level.m_8055_(board_pos);
        if (CONTROLLERS.contains(pos)) {
            CONTROLLERS.remove(pos);
        }
        if (board.m_60734_() instanceof Board) {
            level.m_7471_(board_pos, false);
        }
        if (state.m_155947_()) {
            BlockEntity tile = level.m_7702_(pos);
            if (tile instanceof GameControllerTE) {
                GameControllerTE te = (GameControllerTE)tile;
                if (te.playing_game) {
                    String owner = te.getOwner();
                    Player player = null;
                    if (!owner.equals("dummy")) {
                        player = level.m_46003_(UUID.fromString(owner));
                    }
                    this.forfeitGame(level, player, te);
                    return;
                }
            }
            level.m_46747_(pos);
        }
    }

    public void m_6402_(Level level, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        BlockEntity tile;
        if (level.m_5776_()) {
            return;
        }
        if (state.m_155947_() && (tile = level.m_7702_(pos)) instanceof GameControllerTE) {
            GameControllerTE te = (GameControllerTE)tile;
            if (placer instanceof Player) {
                Player player = (Player)placer;
                te.setOwner(player.m_20149_());
            }
        }
    }

    public boolean ownsBlock(Player player, String owner) {
        String uuid = "dummy";
        if (player != null) {
            uuid = player.m_20149_();
        }
        return uuid.equals(owner) || owner.equals("dummy");
    }

    public BoardTE getOpponentBoardTile(Level level, GameControllerTE te, int id, boolean yours) {
        BlockEntity ztile;
        GameControllerTE ote;
        BlockPos zpos;
        BlockState zstate;
        BlockPos pos = te.getOpponent();
        if (this.validateController(level, pos) && (zstate = level.m_8055_(zpos = (ote = (GameControllerTE)level.m_7702_(pos)).getZero())).m_60734_() instanceof Board && zstate.m_155947_() && (ztile = level.m_7702_(zpos)) instanceof BoardTE) {
            BlockEntity itile;
            BoardTE zte = (BoardTE)ztile;
            GameController ocontroller = (GameController)ote.m_58900_().m_60734_();
            BlockPos ipos = zte.locateId(zpos, id, ocontroller.getFacing(ote.m_58900_()), yours);
            if (ipos == null) {
                return null;
            }
            BlockState istate = level.m_8055_(ipos);
            if (istate.m_60734_() instanceof Board && istate.m_155947_() && (itile = level.m_7702_(ipos)) instanceof BoardTE) {
                return (BoardTE)itile;
            }
        }
        return null;
    }

    public BoardTE getBoardTile(Level level, GameControllerTE te, int id) {
        BlockEntity tile = level.m_7702_(te.getZero());
        if (tile instanceof BoardTE) {
            BoardTE bte = (BoardTE)tile;
            BlockPos pos = bte.locateId(bte.m_58899_(), id, this.getFacing(te.m_58900_()));
            Board board = (Board)bte.m_58900_().m_60734_();
            if (board.validateBoard(level, pos)) {
                return (BoardTE)level.m_7702_(pos);
            }
        }
        return null;
    }
}

