/*
 * Decompiled with CFR 0.152.
 */
package slimeattack07.naval_warfare.objects.blocks;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import slimeattack07.naval_warfare.objects.blocks.ShipBlock;
import slimeattack07.naval_warfare.tileentity.ShipTE;
import slimeattack07.naval_warfare.util.ShipPart;
import slimeattack07.naval_warfare.util.abilities.Ability;
import slimeattack07.naval_warfare.util.properties.ShipPartProperty;

public class LargeLShip
extends ShipBlock {
    public static final ShipPartProperty SHIP_PART = ShipPartProperty.createFive();

    public LargeLShip(Ability active, Ability passive, int tier) {
        super(active, passive, tier);
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)SHIP_PART, (Comparable)((Object)ShipPart.TWO)));
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{SHIP_PART});
    }

    @Override
    public boolean canPlace(Level level, BlockPos pos, BlockState state, boolean include_base, boolean display) {
        Direction facing = LargeLShip.getFacing(state);
        boolean base_valid = !include_base || this.spaceValid(level, pos, facing, 0, 0, display);
        return base_valid && this.spaceValid(level, pos, facing, 0, 1, display) && this.spaceValid(level, pos, facing, -1, 0, display) && this.spaceValid(level, pos, facing, -2, 0, display) && this.spaceValid(level, pos, facing, -3, 0, display);
    }

    @Override
    public boolean summonShip(Level level, BlockPos pos, BlockState state, boolean include_base, boolean display) {
        boolean placeable = this.canPlace(level, pos, state, include_base, display);
        if (placeable) {
            Direction dir = LargeLShip.getFacing(state);
            if (include_base) {
                level.m_46597_(pos, state);
            }
            level.m_46597_(this.offset(dir, pos, 0, 1), (BlockState)state.m_61124_((Property)SHIP_PART, (Comparable)((Object)ShipPart.ONE)));
            level.m_46597_(this.offset(dir, pos, -1, 0), (BlockState)state.m_61124_((Property)SHIP_PART, (Comparable)((Object)ShipPart.THREE)));
            level.m_46597_(this.offset(dir, pos, -2, 0), (BlockState)state.m_61124_((Property)SHIP_PART, (Comparable)((Object)ShipPart.FOUR)));
            level.m_46597_(this.offset(dir, pos, -3, 0), (BlockState)state.m_61124_((Property)SHIP_PART, (Comparable)((Object)ShipPart.FIVE)));
        } else if (!include_base) {
            level.m_46597_(pos, Blocks.f_50016_.m_49966_());
        }
        return placeable;
    }

    @Override
    @Nullable
    public BlockPos getNext(ShipTE te) {
        BlockState state = te.m_58900_();
        ShipBlock ship = (ShipBlock)state.m_60734_();
        BlockPos pos = te.m_58899_();
        Direction dir = LargeLShip.getFacing(state);
        switch (ship.getShipPart(state, SHIP_PART)) {
            case ONE: {
                return this.offset(dir, pos, 0, -1);
            }
            case TWO: {
                return this.offset(dir, pos, -1, 0);
            }
            case THREE: {
                return this.offset(dir, pos, -1, 0);
            }
            case FOUR: {
                return this.offset(dir, pos, -1, 0);
            }
            case FIVE: {
                return this.offset(dir, pos, 3, 1);
            }
        }
        return null;
    }

    @Override
    public boolean isBase(BlockState state) {
        return this.getShipPart(state, SHIP_PART).equals((Object)ShipPart.TWO);
    }

    @Override
    public boolean isMiddle(BlockState state) {
        return this.getShipPart(state, SHIP_PART).equals((Object)ShipPart.THREE);
    }

    @Override
    public int getMaxHP() {
        return 5;
    }

    @Override
    public String getShapeTranslation() {
        return "large_l";
    }
}

