/*
 * Decompiled with CFR 0.152.
 */
package slimeattack07.naval_warfare.objects.blocks;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stat;
import net.minecraft.stats.StatFormatter;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.PickaxeItem;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.material.MaterialColor;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import slimeattack07.naval_warfare.NavalWarfare;
import slimeattack07.naval_warfare.config.NavalWarfareConfig;
import slimeattack07.naval_warfare.init.NWBlocks;
import slimeattack07.naval_warfare.init.NWItems;
import slimeattack07.naval_warfare.init.NWSounds;
import slimeattack07.naval_warfare.init.NWStats;
import slimeattack07.naval_warfare.init.NWTileEntityTypes;
import slimeattack07.naval_warfare.init.NWTriggers;
import slimeattack07.naval_warfare.objects.blocks.Board;
import slimeattack07.naval_warfare.objects.blocks.BoardRedirect;
import slimeattack07.naval_warfare.objects.blocks.DisappearingBlock;
import slimeattack07.naval_warfare.objects.blocks.GameController;
import slimeattack07.naval_warfare.tileentity.BoardTE;
import slimeattack07.naval_warfare.tileentity.GameControllerTE;
import slimeattack07.naval_warfare.tileentity.ShipTE;
import slimeattack07.naval_warfare.util.BoardState;
import slimeattack07.naval_warfare.util.ControllerState;
import slimeattack07.naval_warfare.util.NWBasicMethods;
import slimeattack07.naval_warfare.util.ShipPart;
import slimeattack07.naval_warfare.util.ShipState;
import slimeattack07.naval_warfare.util.abilities.Ability;
import slimeattack07.naval_warfare.util.abilities.PassiveType;
import slimeattack07.naval_warfare.util.abilities.Seaworthy;
import slimeattack07.naval_warfare.util.helpers.BattleLogHelper;
import slimeattack07.naval_warfare.util.helpers.ControllerActionHelper;
import slimeattack07.naval_warfare.util.helpers.ShipRevealHelper;
import slimeattack07.naval_warfare.util.properties.ShipPartProperty;
import slimeattack07.naval_warfare.util.properties.ShipStateProperty;

public abstract class ShipBlock
extends Block
implements EntityBlock {
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    public static final ShipStateProperty SHIP_STATE = ShipStateProperty.create();
    public final Ability ACTIVE_ABILITY;
    public final Ability PASSIVE_ABILITY;
    public final int TIER;

    public ShipBlock(Ability active_ability, Ability passive_ability, int tier) {
        super(BlockBehaviour.Properties.m_60939_((Material)Material.f_76278_).m_60978_(200.0f).m_155954_(1.0E8f).m_60993_().m_155949_(MaterialColor.f_76365_));
        this.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)SHIP_STATE, (Comparable)((Object)ShipState.UNDAMAGED)));
        this.ACTIVE_ABILITY = active_ability;
        this.PASSIVE_ABILITY = passive_ability;
        this.TIER = Math.min(Math.max(tier, 1), 6);
    }

    public boolean hasActiveAbility() {
        return this.ACTIVE_ABILITY != null;
    }

    public boolean hasPassiveAbility() {
        return this.PASSIVE_ABILITY != null;
    }

    public int getTier() {
        return this.TIER;
    }

    public void hit(Level level, BlockPos pos, BlockPos matching) {
        level.m_5594_(null, pos, (SoundEvent)NWSounds.HIT.get(), SoundSource.MASTER, 2.0f, 1.0f);
        level.m_5594_(null, matching, (SoundEvent)NWSounds.HIT.get(), SoundSource.MASTER, 2.0f, 1.0f);
    }

    public void destroy(Level level, BlockPos pos, BlockPos matching) {
        level.m_5594_(null, pos, (SoundEvent)NWSounds.DESTROY.get(), SoundSource.MASTER, 2.0f, 0.6f);
        level.m_5594_(null, matching, (SoundEvent)NWSounds.DESTROY.get(), SoundSource.MASTER, 2.0f, 0.6f);
    }

    public boolean losesHP() {
        return true;
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        ShipTE te = (ShipTE)((BlockEntityType)NWTileEntityTypes.SHIP.get()).m_155264_(pos, state);
        if (this.ACTIVE_ABILITY != null) {
            te.setActiveAmount(this.ACTIVE_ABILITY.getAmount());
        }
        te.setNext(this.getNext(te));
        return te;
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_());
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING});
        builder.m_61104_(new Property[]{SHIP_STATE});
    }

    public VoxelShape m_5940_(BlockState p_60555_, BlockGetter p_60556_, BlockPos p_60557_, CollisionContext p_60558_) {
        return Block.m_49796_((double)0.1, (double)0.0, (double)0.1, (double)15.9, (double)8.0, (double)15.9);
    }

    public void m_5871_(ItemStack stack, BlockGetter level, List<Component> tooltip, TooltipFlag flagIn) {
        String ability;
        tooltip.add((Component)NWBasicMethods.createGrayText("descriptions.naval_warfare.ship_shape", ": " + this.getShape()));
        tooltip.add((Component)NWBasicMethods.createGrayText("descriptions.naval_warfare.ship_hp", ": " + this.getMaxHP()));
        boolean header = false;
        if (this.hasActiveAbility()) {
            header = true;
            tooltip.add((Component)NWBasicMethods.createDGreenText("ability.naval_warfare.abilities"));
            String active = NWBasicMethods.getTranslation("ability.naval_warfare.active");
            ability = NWBasicMethods.getTranslation(this.ACTIVE_ABILITY.getTranslation());
            tooltip.add((Component)new TextComponent(ChatFormatting.AQUA + "(" + active + ") " + ability));
        }
        if (this.hasPassiveAbility()) {
            if (!header) {
                tooltip.add((Component)NWBasicMethods.createDGreenText("ability.naval_warfare.abilities"));
            }
            String passive = NWBasicMethods.getTranslation("ability.naval_warfare.passive");
            ability = NWBasicMethods.getTranslation(this.PASSIVE_ABILITY.getTranslation());
            tooltip.add((Component)new TextComponent(ChatFormatting.GREEN + "(" + passive + ") " + ability));
        }
        super.m_5871_(stack, level, tooltip, flagIn);
    }

    public static Direction getFacing(BlockState state) {
        try {
            return (Direction)state.m_61143_((Property)FACING);
        }
        catch (IllegalArgumentException e) {
            return Direction.NORTH;
        }
    }

    public static ShipState getState(BlockState state) {
        try {
            return (ShipState)((Object)state.m_61143_((Property)SHIP_STATE));
        }
        catch (IllegalArgumentException e) {
            return ShipState.UNDAMAGED;
        }
    }

    public boolean validateShip(Level level, BlockPos pos) {
        BlockState state = level.m_8055_(pos);
        if (!(state.m_60734_() instanceof ShipBlock)) {
            return false;
        }
        if (state.m_155947_()) {
            BlockEntity tile = level.m_7702_(pos);
            return tile instanceof ShipTE;
        }
        return false;
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult result) {
        if (level.m_5776_()) {
            return InteractionResult.SUCCESS;
        }
        ItemStack stack = player.m_21120_(handIn);
        Item item = stack.m_41720_();
        if (item instanceof PickaxeItem) {
            this.breakShip(level, pos, player);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void m_6402_(Level level, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        block12: {
            Player player;
            block11: {
                BlockState down;
                block13: {
                    block14: {
                        if (level.m_5776_()) {
                            return;
                        }
                        if (!(placer instanceof Player)) break block12;
                        player = (Player)placer;
                        BlockPos pdown = pos.m_7495_();
                        down = level.m_8055_(pdown);
                        String ship = stack.m_41720_().getRegistryName().toString();
                        if (!(down.m_60734_() instanceof Board) || down.m_60734_() instanceof BoardRedirect) break block13;
                        Board board = (Board)down.m_60734_();
                        if (!board.validateBoard(level, pdown)) break block14;
                        BoardTE te = (BoardTE)level.m_7702_(pdown);
                        if (te.isShipRegistered(ship)) {
                            if (te.canReceiveShip(ship)) {
                                if (!this.summonShip(level, pos, state, false, false)) {
                                    NWBasicMethods.messagePlayerActionbar(player, "message.naval_warfare.no_room_for_ship");
                                    break block11;
                                } else {
                                    if (player != null && !player.m_7500_()) {
                                        NWBasicMethods.addOrSpawn(player, stack, level, pos);
                                    }
                                    return;
                                }
                            }
                            NWBasicMethods.messagePlayerActionbar(player, "message.naval_warfare.cannot_place");
                            break block11;
                        } else {
                            NWBasicMethods.messagePlayerActionbar(player, "message.naval_warfare.not_registered");
                        }
                        break block11;
                    }
                    NWBasicMethods.messagePlayerActionbar(player, "message.naval_warfare.board_corrupt");
                    break block11;
                }
                if (down.m_60734_().equals(NWBlocks.SHIP_DISPLAY.get())) {
                    if (this.summonShip(level, pos, state, false, true)) {
                        this.propagateAbilityAmount(level, pos, 0);
                        return;
                    }
                    NWBasicMethods.messagePlayerActionbar(player, "message.naval_warfare.no_room_for_ship");
                } else {
                    NWBasicMethods.messagePlayerActionbar(player, "message.naval_warfare.only_place_on_board");
                }
            }
            level.m_46597_(pos, Blocks.f_50016_.m_49966_());
            if (!player.m_7500_()) {
                NWBasicMethods.addOrSpawn(player, stack, level, pos);
            }
        }
    }

    public abstract boolean isBase(BlockState var1);

    public abstract boolean isMiddle(BlockState var1);

    public abstract int getMaxHP();

    public abstract String getShapeTranslation();

    public abstract boolean summonShip(Level var1, BlockPos var2, BlockState var3, boolean var4, boolean var5);

    public abstract boolean canPlace(Level var1, BlockPos var2, BlockState var3, boolean var4, boolean var5);

    @Nullable
    public abstract BlockPos getNext(ShipTE var1);

    public String getShape() {
        return NWBasicMethods.getTranslation("shapes.naval_warfare." + this.getShapeTranslation());
    }

    public boolean isRegistered(Level level, BlockPos pos) {
        Board board;
        BlockState state = level.m_8055_(pos);
        if (state.m_60734_() instanceof Board && (board = (Board)state.m_60734_()).validateBoard(level, pos)) {
            BoardTE te = (BoardTE)level.m_7702_(pos);
            return te.isShipRegistered(this.getRegistryName().toString());
        }
        return false;
    }

    public void breakShip(Level level, BlockPos pos, @Nullable Player player) {
        BlockEntity tile = level.m_7702_(pos.m_7495_());
        if (tile instanceof BoardTE) {
            BoardTE bte = (BoardTE)tile;
            BlockPos c = bte.getController();
            if ((tile = level.m_7702_(c)) instanceof GameControllerTE) {
                GameControllerTE cte = (GameControllerTE)tile;
                GameController controller = (GameController)cte.m_58900_().m_60734_();
                if (controller.getState(cte.m_58900_()).equals((Object)ControllerState.SEARCHING) || cte.hasGame()) {
                    NWBasicMethods.messagePlayer(player, "message.naval_warfare.cant_remove");
                } else {
                    level.m_7471_(pos, false);
                }
            }
        } else {
            NWBasicMethods.addOrSpawn(player, new ItemStack((ItemLike)level.m_8055_(pos).m_60734_()), level, pos);
            level.m_7471_(pos, false);
        }
    }

    public void propagateAbilityAmount(Level level, BlockPos pos, int active) {
        ArrayList<BlockPos> parts = this.collectParts(level, pos, this.getRegistryName());
        for (BlockPos part : parts) {
            ShipTE block = (ShipTE)level.m_7702_(part);
            block.setActiveAmount(active);
            block.boardBelow();
        }
    }

    protected ShipPart getShipPart(BlockState state, ShipPartProperty prop) {
        try {
            return (ShipPart)((Object)state.m_61143_((Property)prop));
        }
        catch (IllegalArgumentException e) {
            return ShipPart.ONE;
        }
    }

    protected int getBelowBoard(Level level, BlockPos pos) {
        BlockEntity tile;
        BlockState state = level.m_8055_(pos.m_7495_());
        if (state.m_60734_() instanceof Board && state.m_155947_() && (tile = level.m_7702_(pos.m_7495_())) instanceof BoardTE) {
            return ((BoardTE)tile).getId();
        }
        return -1;
    }

    protected ShipRevealHelper getBaseState(Level level, BlockState state, BlockPos pos, ResourceLocation ship, Direction[] dirs, ArrayList<BlockPos> seen) {
        if (!state.m_60734_().getRegistryName().equals((Object)ship)) {
            return null;
        }
        if (this.isBase(state)) {
            return new ShipRevealHelper(state, this.getBelowBoard(level, pos), ShipBlock.getFacing(state));
        }
        if (seen.contains(pos)) {
            return null;
        }
        seen.add(pos);
        for (Direction dir : dirs) {
            BlockPos new_pos = pos.m_142300_(dir);
            BlockState new_state = level.m_8055_(new_pos);
            ShipRevealHelper end_state = this.getBaseState(level, new_state, new_pos, ship, dirs, seen);
            if (end_state == null) continue;
            return end_state;
        }
        return null;
    }

    protected ShipRevealHelper getBaseState(Level level, BlockPos pos) {
        return this.getBaseState(level, level.m_8055_(pos), pos, level.m_8055_(pos).m_60734_().getRegistryName(), new Direction[]{Direction.NORTH, Direction.EAST, Direction.SOUTH, Direction.WEST}, new ArrayList<BlockPos>());
    }

    protected BlockPos offset(Direction dir, BlockPos origin, int x, int z) {
        int y = origin.m_123342_();
        switch (dir) {
            case NORTH: {
                return new BlockPos(origin.m_123341_() - x, y, origin.m_123343_() - z);
            }
            case EAST: {
                return new BlockPos(origin.m_123341_() + z, y, origin.m_123343_() - x);
            }
            case SOUTH: {
                return new BlockPos(origin.m_123341_() + x, y, origin.m_123343_() + z);
            }
            case WEST: {
                return new BlockPos(origin.m_123341_() - z, y, origin.m_123343_() + x);
            }
        }
        return origin;
    }

    protected boolean spaceValid(Level level, BlockPos origin, Direction dir, int x, int z, boolean display) {
        Block offset = level.m_8055_(this.offset(dir, origin, x, z)).m_60734_();
        boolean clear = offset.equals(Blocks.f_50016_) || offset instanceof DisappearingBlock;
        BlockState board_state = level.m_8055_(this.offset(dir, origin, x, z).m_7495_());
        return display ? clear && level.m_8055_(this.offset(dir, origin, x, z).m_7495_()).m_60734_().equals(NWBlocks.SHIP_DISPLAY.get()) : clear && board_state.m_60734_() instanceof Board && (this.losesHP() || !((Board)board_state.m_60734_()).getBoardState(board_state).isKnown() || board_state.m_60734_() instanceof BoardRedirect);
    }

    public void removeShip(Player player, BlockState state, Level level, BlockPos pos, boolean remove_board, boolean shrink_board) {
        BlockState below;
        ShipTE te;
        BlockEntity tile;
        BlockPos board_pos = pos.m_7495_();
        BlockPos next = null;
        if (remove_board && level.m_8055_(board_pos).m_60734_() instanceof Board) {
            level.m_7471_(board_pos, false);
        }
        if ((tile = level.m_7702_(pos)) instanceof ShipTE && (te = (ShipTE)tile).hasNext()) {
            next = te.getNext();
        }
        level.m_7471_(pos, false);
        if (state.m_155947_()) {
            level.m_46747_(pos);
        }
        if (this.isBase(state) && !remove_board && (below = level.m_8055_(board_pos)).m_60734_().equals(NWBlocks.BOARD.get())) {
            Board board = (Board)below.m_60734_();
            boolean seaworthy = shrink_board && this.hasPassiveAbility() && this.PASSIVE_ABILITY instanceof Seaworthy;
            board.handleShipBroken(level, board_pos, this.getRegistryName().toString(), this.getMaxHP(), seaworthy);
        }
        if (next != null && level.m_8055_(next).m_60734_().getRegistryName().equals((Object)this.getRegistryName())) {
            level.m_7471_(next, false);
        }
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        if (level.m_5776_()) {
            return;
        }
        if (newState.m_60734_() instanceof ShipBlock) {
            return;
        }
        this.removeShip(null, state, level, pos, false, !isMoving);
    }

    protected ArrayList<BlockPos> collectParts(Level level, BlockPos current, ResourceLocation id) {
        ArrayList<BlockPos> known = new ArrayList<BlockPos>();
        known.add(current);
        return this.collectParts(level, known, current, id);
    }

    public ArrayList<BlockPos> collectUndamagedParts(Level level, BlockPos pos) {
        ArrayList<BlockPos> parts = new ArrayList<BlockPos>();
        ArrayList<BlockPos> undamaged = new ArrayList<BlockPos>();
        parts.add(pos);
        parts = this.collectParts(level, parts, pos, this.getRegistryName());
        for (BlockPos bp : parts) {
            BlockState state = level.m_8055_(bp);
            if (!(state.m_60734_() instanceof ShipBlock) || ShipBlock.getState(state).isHit()) continue;
            undamaged.add(bp);
        }
        return undamaged;
    }

    protected ArrayList<BlockPos> collectParts(Level level, ArrayList<BlockPos> known, BlockPos start, ResourceLocation id) {
        BlockPos pos = start;
        BlockEntity tile = null;
        ShipTE te = null;
        for (int i = 0; i < 20 && (tile = level.m_7702_(pos)) instanceof ShipTE && (pos = (te = (ShipTE)tile).getNext()) != null && !known.contains(pos) && te.m_58900_().m_60734_().getRegistryName().equals((Object)id); ++i) {
            known.add(pos);
        }
        return known;
    }

    protected boolean isDestroyed(Level level, ArrayList<BlockPos> parts) {
        for (BlockPos ship_part : parts) {
            BlockState state = level.m_8055_(ship_part);
            if (ShipBlock.getState(state).isHit()) continue;
            return false;
        }
        return true;
    }

    protected void destroyShip(Level level, BlockPos origin, ArrayList<BlockPos> parts, BlockPos matching, Player player) {
        BoardTE te = null;
        for (BlockPos part : parts) {
            BlockEntity tile;
            ShipBlock block;
            BlockState state = level.m_8055_(part);
            level.m_46597_(part, (BlockState)state.m_61124_((Property)SHIP_STATE, (Comparable)((Object)ShipState.DESTROYED)));
            if (!(state.m_60734_() instanceof ShipBlock) || !(block = (ShipBlock)state.m_60734_()).isMiddle(state) || !((tile = level.m_7702_(part.m_7495_())) instanceof BoardTE)) continue;
            te = (BoardTE)tile;
        }
        this.destroy(level, origin, matching);
        if (this.hasPassiveAbility() && this.PASSIVE_ABILITY.canBeDisabled() && te != null) {
            this.PASSIVE_ABILITY.detachPassive(level, te);
            NWBasicMethods.messagePlayerCustom(player, NWBasicMethods.getTranslation("ability.naval_warfare.passive_disabled") + ": " + ChatFormatting.GREEN + NWBasicMethods.getTranslation(this.PASSIVE_ABILITY.getTranslation()));
            this.notifyPassiveDown(player, this.PASSIVE_ABILITY.hoverableInfo(), te.getController(), level);
            level.m_5594_(null, origin, (SoundEvent)NWSounds.ENERGY_SHIELD.get(), SoundSource.MASTER, 1.0f, 1.5f);
            level.m_5594_(null, matching, (SoundEvent)NWSounds.ENERGY_SHIELD.get(), SoundSource.MASTER, 1.0f, 1.5f);
        }
        if (player != null && player instanceof ServerPlayer) {
            try {
                ServerPlayer sp = (ServerPlayer)player;
                sp.m_36220_(NWStats.SHIPS_DESTROYED);
                NWTriggers.DESTROY.trigger(sp);
                Stat stat = Stats.f_12988_.m_12899_((Object)new ResourceLocation("naval_warfare", "ships_destroyed"), StatFormatter.f_12873_);
                int val = sp.m_8951_().m_13015_(stat);
                if (val >= 50) {
                    NWTriggers.DESTROY_50.trigger(sp);
                }
                if (val >= 100) {
                    NWTriggers.DESTROY_100.trigger(sp);
                }
            }
            catch (NullPointerException e) {
                NavalWarfare.LOGGER.error("Naval Warfare: Failed to fetch the ships destroyed statistic.");
            }
        }
    }

    public boolean damageShip(Level level, Player player, BlockPos pos, int id, BlockPos controller, int damage, BlockPos matching, boolean multi_ability, boolean triggers_passives, int action) {
        ShipTE ste;
        BlockEntity stile;
        BlockEntity te;
        ArrayList<BlockPos> positions = this.collectParts(level, pos, this.getRegistryName());
        int done = 0;
        boolean destroyed = false;
        boolean passive = false;
        for (BlockPos shippos : positions) {
            BlockPos down;
            BlockState boardstate;
            Board board;
            if (done >= damage) break;
            BlockState state = level.m_8055_(shippos);
            if (!(state.m_60734_() instanceof ShipBlock) || !(board = (Board)(boardstate = level.m_8055_(down = shippos.m_7495_())).m_60734_()).validateBoard(level, down)) continue;
            te = (BoardTE)level.m_7702_(down);
            BoardTE otile = (BoardTE)level.m_7702_(matching);
            Direction dir = board.getControllerFacing(level, otile.m_58899_());
            BlockPos location = otile.locateId(matching, te.getId(), dir, true);
            int hitresult = this.hitShip(level, player, shippos, controller, state, te.getId(), location, multi_ability);
            if (hitresult >= 0 && triggers_passives && this.hasPassiveAbility() && (this.PASSIVE_ABILITY.getPassiveType().equals((Object)PassiveType.HIT) || hitresult > 0 && this.PASSIVE_ABILITY.getPassiveType().equals((Object)PassiveType.DESTROYED))) {
                passive = true;
            }
            if (hitresult > 0) {
                ++done;
                destroyed = true;
                break;
            }
            if (hitresult == 0) {
                ++done;
                continue;
            }
            board.deselectTile(level, te.m_58899_(), otile.m_58899_());
        }
        BlockEntity tile = level.m_7702_(matching);
        GameControllerTE gte = null;
        if (tile instanceof BoardTE) {
            BoardTE te2 = (BoardTE)tile;
            Board board = (Board)te2.m_58900_().m_60734_();
            gte = board.getController(level, te2.m_58899_());
        }
        if (gte != null && triggers_passives) {
            gte.increaseStreak(done);
            gte.streakSounds();
        }
        if (passive && (stile = level.m_7702_(pos)) instanceof ShipTE && action > (ste = (ShipTE)stile).getActionNumber()) {
            this.propagateActionNumber(level, pos, action);
            String owner = "dummy";
            BlockEntity own_tile = level.m_7702_(controller);
            if (own_tile instanceof GameControllerTE) {
                te = (GameControllerTE)own_tile;
                owner = te.getOwner();
            }
            if (gte != null) {
                String pname = player == null ? "dummy" : player.m_20149_();
                String translation = (Boolean)NavalWarfareConfig.reveal_on_hit_passives.get() == false && this.PASSIVE_ABILITY.getPassiveType().equals((Object)PassiveType.HIT) ? this.PASSIVE_ABILITY.getPassiveCategory() : this.PASSIVE_ABILITY.getTranslation();
                gte.addAction(ControllerActionHelper.createAnnounce(pname, owner, this.PASSIVE_ABILITY.getAnimationItem(), translation, Component.Serializer.m_130703_((Component)this.PASSIVE_ABILITY.hoverableInfo())));
                gte.addAction(ControllerActionHelper.createAbility(positions.get(0), positions.get(0).m_7495_(), gte.getOwner(), false));
                try {
                    ServerPlayer sp = (ServerPlayer)player;
                    sp.m_36220_(NWStats.PASSIVE_TRIGGERED);
                    NWTriggers.PASSIVE.trigger(sp);
                    Stat stat = Stats.f_12988_.m_12899_((Object)new ResourceLocation("naval_warfare", "passive_triggered"), StatFormatter.f_12873_);
                    int val = sp.m_8951_().m_13015_(stat);
                    if (val >= 50) {
                        NWTriggers.PASSIVE_50.trigger(sp);
                    }
                    if (val >= 100) {
                        NWTriggers.PASSIVE_100.trigger(sp);
                    }
                }
                catch (NullPointerException e) {
                    NavalWarfare.LOGGER.error("Naval Warfare: Failed to fetch the passives triggered statistic.");
                }
            }
        }
        return destroyed;
    }

    private void propagateActionNumber(Level level, BlockPos pos, int action) {
        ArrayList<BlockPos> parts = this.collectParts(level, pos, this.getRegistryName());
        for (BlockPos part : parts) {
            ShipTE block = (ShipTE)level.m_7702_(part);
            block.setActionNumber(action);
        }
    }

    private int posToId(Level level, BlockPos pos) {
        Board board;
        BlockState state = level.m_8055_(pos);
        if (state.m_60734_() instanceof Board && (board = (Board)state.m_60734_()).validateBoard(level, pos)) {
            BoardTE te = (BoardTE)level.m_7702_(pos);
            return te.getId();
        }
        return -1;
    }

    private int hitShip(Level level, Player player, BlockPos pos, BlockPos controller, BlockState state, int id, BlockPos matching, boolean multi_ability) {
        ShipState ship_state = ShipBlock.getState(state);
        if (!ship_state.isHit()) {
            String shipname = NWBasicMethods.getTranslation(state.m_60734_());
            ArrayList<BlockPos> parts = this.collectParts(level, pos, state.m_60734_().getRegistryName());
            level.m_46597_(pos, (BlockState)state.m_61124_((Property)SHIP_STATE, (Comparable)((Object)ShipState.DAMAGED)));
            level.m_46597_(pos.m_7495_(), (BlockState)level.m_8055_(pos.m_7495_()).m_61124_((Property)Board.STATE, (Comparable)((Object)BoardState.HIT)));
            level.m_46597_(matching, (BlockState)level.m_8055_(matching).m_61124_((Property)Board.STATE, (Comparable)((Object)BoardState.HIT)));
            level.m_46597_(pos.m_7494_(), Blocks.f_50016_.m_49966_());
            level.m_46597_(matching.m_6630_(2), Blocks.f_50016_.m_49966_());
            this.notifyOwnerOfHit(shipname, controller, level, id, multi_ability);
            if (!multi_ability) {
                String message = NWBasicMethods.getOpponentShipHitMessage(id);
                NWBasicMethods.messagePlayerCustom(player, message);
                this.recordOnRecorders(level, pos, controller, id, multi_ability, multi_ability);
                this.recordMessage(level, pos, controller, message, true);
            }
            if (this.isDestroyed(level, parts)) {
                this.destroyShip(level, pos, parts, matching, player);
                this.notifyOwnerOfDestruction(shipname, controller, level);
                for (BlockPos bp : parts) {
                    this.recordOnRecorders(level, bp, controller, this.posToId(level, bp.m_7495_()), true, bp.equals((Object)pos));
                }
                return 1;
            }
            this.hit(level, pos, matching);
            this.recordOnRecorders(level, pos, controller, id, false, true);
            return 0;
        }
        return -1;
    }

    private boolean causedByOpponent(Level level, BlockPos pos, GameControllerTE te) {
        BoardTE bte;
        BlockEntity tile = level.m_7702_(pos.m_7495_());
        boolean opponent = true;
        if (tile instanceof BoardTE && (tile = level.m_7702_((bte = (BoardTE)tile).getController())) instanceof GameControllerTE) {
            GameControllerTE cte = (GameControllerTE)tile;
            return ((Object)((Object)cte)).equals((Object)te);
        }
        return opponent;
    }

    private void recordOnRecorders(Level level, BlockPos pos, BlockPos controller, int id, boolean destroyed, boolean set_board) {
        BlockEntity tile = level.m_7702_(controller);
        if (tile instanceof GameControllerTE) {
            GameControllerTE te = (GameControllerTE)tile;
            boolean opponent = !this.causedByOpponent(level, pos, te);
            ShipState state = destroyed ? ShipState.DESTROYED : ShipState.DAMAGED;
            SoundEvent sound = destroyed ? (SoundEvent)NWSounds.DESTROY.get() : (SoundEvent)NWSounds.HIT.get();
            float pitch = destroyed ? 0.6f : 1.0f;
            te.recordOnRecorders(BattleLogHelper.createShipState(id, opponent, state));
            if (set_board) {
                te.recordOnRecorders(BattleLogHelper.createBoardState(id, opponent, BoardState.HIT));
                te.recordOnRecorders(BattleLogHelper.createSound(id, opponent, sound, 2.0f, pitch));
            }
        }
    }

    private void recordMessage(Level level, BlockPos pos, BlockPos controller, String message, boolean opponent) {
        BlockEntity tile = level.m_7702_(controller);
        if (tile instanceof GameControllerTE) {
            GameControllerTE te = (GameControllerTE)tile;
            BattleLogHelper blh = BattleLogHelper.createMessage(Component.Serializer.m_130703_((Component)new TextComponent(message)));
            if (opponent) {
                te.recordOnOppRecorder(blh);
            } else {
                te.recordOnRecorder(blh);
            }
        }
    }

    public void notifyOwnerOfHit(String ship, BlockPos pos, Level level, int id, boolean multi_ability) {
        BlockEntity tile;
        if (level.m_8055_(pos).m_155947_() && (tile = level.m_7702_(pos)) instanceof GameControllerTE) {
            GameControllerTE te = (GameControllerTE)tile;
            if (this.losesHP()) {
                te.reduceHP();
            }
            String owner = te.getOwner();
            if (!multi_ability && !owner.equals("dummy")) {
                Player player = level.m_46003_(UUID.fromString(owner));
                String message = NWBasicMethods.getOwnShipHitMessage(ship, id);
                NWBasicMethods.messagePlayerCustom(player, message);
                this.recordMessage(level, pos, pos, message, false);
            }
        }
    }

    public void notifyOwnerOfDestruction(String ship, BlockPos pos, Level level) {
        BlockEntity tile;
        if (level.m_8055_(pos).m_155947_() && (tile = level.m_7702_(pos)) instanceof GameControllerTE) {
            GameControllerTE te = (GameControllerTE)tile;
            String owner = te.getOwner();
            if (owner.equals("dummy")) {
                return;
            }
            Player player = level.m_46003_(UUID.fromString(owner));
            String message = NWBasicMethods.getOwnShipDestroyedMessage(ship);
            NWBasicMethods.messagePlayerCustom(player, message);
            this.recordMessage(level, pos, pos, message, false);
            NWBasicMethods.animateItemUse(player, (Item)NWItems.SHIP_SUNK_OWN.get());
        }
    }

    public void notifyPassiveDown(Player player1, MutableComponent ability, BlockPos pos, Level level) {
        BlockEntity tile;
        if (level.m_8055_(pos).m_155947_() && (tile = level.m_7702_(pos)) instanceof GameControllerTE) {
            String user;
            GameControllerTE te = (GameControllerTE)tile;
            String owner = te.getOwner();
            if (owner.equals("dummy")) {
                user = NWBasicMethods.getTranslation("misc.naval_warfare.dummy");
            } else {
                Player player2 = level.m_46003_(UUID.fromString(owner));
                user = player2.m_7755_().getString();
                NWBasicMethods.messagePlayerAbilityUsed(null, player2, "ability.naval_warfare.passive_disabled", user, ability);
            }
            if (player1 != null) {
                NWBasicMethods.messagePlayerAbilityUsed(te, player1, "ability.naval_warfare.passive_disabled", user, ability);
            }
        }
    }
}

