/*
 * Decompiled with CFR 0.152.
 */
package slimeattack07.naval_warfare.objects.items;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import slimeattack07.naval_warfare.NavalWarfare;
import slimeattack07.naval_warfare.objects.blocks.Board;
import slimeattack07.naval_warfare.objects.blocks.BoardRedirect;
import slimeattack07.naval_warfare.objects.blocks.GameController;
import slimeattack07.naval_warfare.objects.blocks.ShipBlock;
import slimeattack07.naval_warfare.tileentity.BoardTE;
import slimeattack07.naval_warfare.tileentity.GameControllerTE;
import slimeattack07.naval_warfare.tileentity.ShipTE;
import slimeattack07.naval_warfare.util.BoardState;
import slimeattack07.naval_warfare.util.NWBasicMethods;
import slimeattack07.naval_warfare.util.abilities.Ability;

public class AbilityWand
extends Item {
    public AbilityWand() {
        super(new Item.Properties().m_41491_(NavalWarfare.NAVAL_WARFARE).m_41487_(1));
    }

    public int getItemStackLimit(ItemStack stack) {
        return 1;
    }

    public void m_7373_(ItemStack stack, Level level, List<Component> tooltip, TooltipFlag flagIn) {
        this.prepare(stack);
        CompoundTag nbt = stack.m_41784_();
        CompoundTag nw = nbt.m_128469_("naval_warfare");
        tooltip.add((Component)NWBasicMethods.createGrayText(nw.m_128461_("ability")));
        super.m_7373_(stack, level, tooltip, flagIn);
    }

    private void prepare(ItemStack stack) {
        CompoundTag nbt = stack.m_41784_();
        if (!nbt.m_128441_("naval_warfare")) {
            CompoundTag nw = new CompoundTag();
            CompoundTag ship = new CompoundTag();
            ListTag highlighted = new ListTag();
            nw.m_128359_("ability", NWBasicMethods.getTranslation("abilities.naval_warfare.none_selected"));
            nw.m_128365_("ship", (Tag)ship);
            nw.m_128365_("highlighted", (Tag)highlighted);
            nbt.m_128365_("naval_warfare", (Tag)nw);
            stack.m_41751_(nbt);
        }
    }

    public InteractionResult m_6225_(UseOnContext context) {
        Level level = context.m_43725_();
        if (level.m_5776_()) {
            return InteractionResult.SUCCESS;
        }
        BlockPos pos = context.m_8083_();
        BlockState state = level.m_8055_(pos);
        ItemStack stack = context.m_43722_();
        Player player = context.m_43723_();
        if (state.m_60734_() instanceof ShipBlock) {
            ShipBlock ship = (ShipBlock)state.m_60734_();
            if (ship.validateShip(level, pos) && ship.hasActiveAbility()) {
                Ability ability = ship.ACTIVE_ABILITY;
                ShipTE te = (ShipTE)level.m_7702_(pos);
                if (!ShipBlock.getState(state).isAlive()) {
                    NWBasicMethods.messagePlayerActionbar(player, "message.naval_warfare.no_ability_allowed");
                } else if (te.getActiveAmount() > 0) {
                    this.deselect(level, stack);
                    this.setNBT(stack, ability.getTranslation(), pos);
                    NWBasicMethods.messagePlayerActionbarBack(player, "message.naval_warfare.selected", ": " + NWBasicMethods.getTranslation(ability.getTranslation()));
                    if (!ability.needsTarget()) {
                        ArrayList<BlockPos> list = new ArrayList<BlockPos>();
                        list.add(te.m_58899_().m_7495_());
                        this.setHighlighted(stack, te.m_58899_().m_7495_(), list);
                    }
                } else {
                    NWBasicMethods.messagePlayerActionbar(player, "message.naval_warfare.no_active_uses");
                }
            } else {
                NWBasicMethods.messagePlayerActionbar(player, "message.naval_warfare.no_active_ability");
            }
        } else if (state.m_60734_() instanceof Board) {
            this.deselect(level, stack);
            Board board = (Board)state.m_60734_();
            if (board.validateBoard(level, pos)) {
                BoardTE te = (BoardTE)level.m_7702_(pos);
                ArrayList<BlockPos> positions = new ArrayList<BlockPos>();
                Ability ability = this.getAbility(level, stack);
                if (ability != null) {
                    if (ability.targetDefensive() && state.m_60734_() instanceof BoardRedirect) {
                        NWBasicMethods.messagePlayerActionbar(player, "message.naval_warfare.target_defensive");
                    } else if (!ability.targetDefensive() && !(state.m_60734_() instanceof BoardRedirect)) {
                        NWBasicMethods.messagePlayerActionbar(player, "message.naval_warfare.target_offensive");
                    } else if (!board.ownsBlock(player, level, te.getController())) {
                        NWBasicMethods.messagePlayerActionbar(player, "message.naval_warfare.not_owner_b");
                    } else {
                        for (BoardTE bte : ability.getTiles(level, te)) {
                            positions.add(bte.m_58899_());
                        }
                        this.setHighlighted(stack, pos, positions);
                        this.select(level, stack);
                    }
                } else {
                    NWBasicMethods.messagePlayerActionbar(player, "abilities.naval_warfare.none_selected");
                }
            } else {
                NWBasicMethods.messagePlayerActionbar(player, "message.naval_warfare.board_corrupt");
            }
        } else if (state.m_60734_() instanceof GameController) {
            if (!this.verifyAbilityAllowed(level, player, stack, pos)) {
                return InteractionResult.SUCCESS;
            }
            GameController controller = (GameController)state.m_60734_();
            Ability ability = this.getAbility(level, stack);
            GameControllerTE cte = (GameControllerTE)level.m_7702_(pos);
            if (cte == null) {
                NWBasicMethods.messagePlayerActionbar(player, "message.naval_warfare.controller_corrupt");
                return InteractionResult.SUCCESS;
            }
            BlockPos origin = this.getOrigin(stack);
            Block block = level.m_8055_(origin).m_60734_();
            if (block instanceof Board) {
                Board board = (Board)block;
                if (board.validateBoard(level, origin)) {
                    BoardTE te = (BoardTE)level.m_7702_(origin);
                    if (ability != null) {
                        if (cte.getEnergy() >= ability.energyCost()) {
                            if (!controller.activateActiveAbility(level, player, pos, te, ability, stack, false)) {
                                NWBasicMethods.messagePlayerActionbar(player, "ability.naval_warfare.error");
                            }
                        } else {
                            NWBasicMethods.messagePlayerActionbar(player, "message.naval_warfare.not_enough_energy");
                        }
                    } else {
                        NWBasicMethods.messagePlayerActionbar(player, "abilities.naval_warfare.none_selected");
                    }
                    this.deselect(level, stack);
                    this.setNBT(stack, "abilities.naval_warfare.none_selected", pos);
                } else {
                    NWBasicMethods.messagePlayerActionbar(player, "abilities.naval_warfare.none_selected");
                }
            }
        }
        return InteractionResult.SUCCESS;
    }

    public boolean verifyAbilityAllowed(Level level, Player player, ItemStack stack, BlockPos controller) {
        BlockState state;
        BlockPos pos = this.getShip(stack);
        if (pos != null && (state = level.m_8055_(pos)).m_60734_() instanceof ShipBlock) {
            if (!ShipBlock.getState(state).isAlive()) {
                NWBasicMethods.messagePlayerActionbar(player, "message.naval_warfare.no_ability_allowed");
                this.deselect(level, stack);
                this.setNBT(stack, "abilities.naval_warfare.none_selected", pos);
                return false;
            }
            BlockEntity tile = level.m_7702_(pos.m_7495_());
            if (tile instanceof BoardTE) {
                BoardTE bte = (BoardTE)tile;
                if (!bte.getController().equals((Object)controller)) {
                    NWBasicMethods.messagePlayer(player, "message.naval_warfare.different_controller");
                    this.deselect(level, stack);
                    this.setNBT(stack, "abilities.naval_warfare.none_selected", pos);
                    return false;
                }
                tile = level.m_7702_(bte.getController());
                if (tile instanceof GameControllerTE) {
                    GameControllerTE gte = (GameControllerTE)tile;
                    if (!gte.getOwner().equals("dummy") && !gte.getOwner().equals(player.m_20149_())) {
                        NWBasicMethods.messagePlayer(player, "message.naval_warfare.not_owner_s");
                        this.deselect(level, stack);
                        this.setNBT(stack, "abilities.naval_warfare.none_selected", pos);
                        return false;
                    }
                    return true;
                }
            }
        }
        return false;
    }

    public Ability getAbility(Level level, ItemStack stack) {
        if (stack.m_41720_() instanceof AbilityWand) {
            ShipTE te;
            ShipBlock block;
            this.prepare(stack);
            CompoundTag nbt = stack.m_41784_();
            CompoundTag nw = nbt.m_128469_("naval_warfare");
            CompoundTag ship = nw.m_128469_("ship");
            BlockPos pos = new BlockPos(ship.m_128451_("x"), ship.m_128451_("y"), ship.m_128451_("z"));
            BlockState state = level.m_8055_(pos);
            if (state.m_60734_() instanceof ShipBlock && (block = (ShipBlock)state.m_60734_()).validateShip(level, pos) && (te = (ShipTE)level.m_7702_(pos)).getActiveAmount() > 0) {
                return block.ACTIVE_ABILITY;
            }
        }
        return null;
    }

    public void decreaseActiveAmount(Level level, ItemStack stack) {
        if (stack.m_41720_() instanceof AbilityWand) {
            ShipBlock block;
            this.prepare(stack);
            CompoundTag nbt = stack.m_41784_();
            CompoundTag nw = nbt.m_128469_("naval_warfare");
            CompoundTag ship = nw.m_128469_("ship");
            BlockPos pos = new BlockPos(ship.m_128451_("x"), ship.m_128451_("y"), ship.m_128451_("z"));
            BlockState state = level.m_8055_(pos);
            if (state.m_60734_() instanceof ShipBlock && (block = (ShipBlock)state.m_60734_()).validateShip(level, pos)) {
                ShipTE te = (ShipTE)level.m_7702_(pos);
                block.propagateAbilityAmount(level, pos, te.getActiveAmount() - 1);
            }
        }
    }

    public BlockPos getOrigin(ItemStack stack) {
        if (stack.m_41720_() instanceof AbilityWand) {
            this.prepare(stack);
            CompoundTag nbt = stack.m_41784_();
            CompoundTag nw = nbt.m_128469_("naval_warfare");
            CompoundTag origin = nw.m_128469_("origin");
            return new BlockPos(origin.m_128451_("x"), origin.m_128451_("y"), origin.m_128451_("z"));
        }
        return null;
    }

    public BlockPos getShip(ItemStack stack) {
        if (stack.m_41720_() instanceof AbilityWand) {
            this.prepare(stack);
            CompoundTag nbt = stack.m_41784_();
            CompoundTag nw = nbt.m_128469_("naval_warfare");
            CompoundTag ship = nw.m_128469_("ship");
            return new BlockPos(ship.m_128451_("x"), ship.m_128451_("y"), ship.m_128451_("z"));
        }
        return null;
    }

    public void select(Level level, ItemStack stack) {
        if (stack.m_41720_() instanceof AbilityWand) {
            this.prepare(stack);
            CompoundTag nbt = stack.m_41784_();
            CompoundTag nw = nbt.m_128469_("naval_warfare");
            ListTag list = nw.m_128437_("highlighted", 10);
            for (Tag inbt : list) {
                CompoundTag cnbt = (CompoundTag)inbt;
                BlockPos pos = new BlockPos(cnbt.m_128451_("x"), cnbt.m_128451_("y"), cnbt.m_128451_("z"));
                BlockState state = level.m_8055_(pos);
                if (!(state.m_60734_() instanceof Board)) continue;
                Board board = (Board)state.m_60734_();
                BoardState bstate = board.getBoardState(state);
                level.m_46597_(pos, (BlockState)state.m_61124_((Property)Board.STATE, (Comparable)((Object)bstate.select())));
            }
        }
    }

    public void deselect(Level level, ItemStack stack) {
        if (stack.m_41720_() instanceof AbilityWand) {
            this.prepare(stack);
            CompoundTag nbt = stack.m_41784_();
            CompoundTag nw = nbt.m_128469_("naval_warfare");
            ListTag list = nw.m_128437_("highlighted", 10);
            for (Tag inbt : list) {
                CompoundTag cnbt = (CompoundTag)inbt;
                BlockPos pos = new BlockPos(cnbt.m_128451_("x"), cnbt.m_128451_("y"), cnbt.m_128451_("z"));
                BlockState state = level.m_8055_(pos);
                if (!(state.m_60734_() instanceof Board)) continue;
                Board board = (Board)state.m_60734_();
                BoardState bstate = board.getBoardState(state);
                level.m_46597_(pos, (BlockState)state.m_61124_((Property)Board.STATE, (Comparable)((Object)bstate.deselect())));
            }
            this.setHighlighted(stack, null, new ArrayList<BlockPos>());
        }
    }

    public void setHighlighted(ItemStack stack, BlockPos origin, ArrayList<BlockPos> highlighted) {
        if (stack.m_41720_() instanceof AbilityWand) {
            this.prepare(stack);
            CompoundTag nbt = stack.m_41784_();
            CompoundTag nw = nbt.m_128469_("naval_warfare");
            nw.m_128473_("origin");
            nw.m_128473_("highlighted");
            if (origin != null) {
                CompoundTag originnbt = new CompoundTag();
                originnbt.m_128405_("x", origin.m_123341_());
                originnbt.m_128405_("y", origin.m_123342_());
                originnbt.m_128405_("z", origin.m_123343_());
                nw.m_128365_("origin", (Tag)originnbt);
            }
            ListTag ListTag2 = new ListTag();
            for (BlockPos pos : highlighted) {
                CompoundTag pnbt = new CompoundTag();
                pnbt.m_128405_("x", pos.m_123341_());
                pnbt.m_128405_("y", pos.m_123342_());
                pnbt.m_128405_("z", pos.m_123343_());
                ListTag2.add((Object)pnbt);
            }
            nw.m_128365_("highlighted", (Tag)ListTag2);
        }
    }

    public void setNBT(ItemStack stack, String ability, BlockPos ship) {
        if (stack.m_41720_() instanceof AbilityWand) {
            this.prepare(stack);
            CompoundTag nbt = stack.m_41784_();
            CompoundTag nw = nbt.m_128469_("naval_warfare");
            nw.m_128473_("ability");
            nw.m_128473_("ship");
            nw.m_128359_("ability", NWBasicMethods.getTranslation(ability));
            CompoundTag shipnbt = new CompoundTag();
            shipnbt.m_128405_("x", ship.m_123341_());
            shipnbt.m_128405_("y", ship.m_123342_());
            shipnbt.m_128405_("z", ship.m_123343_());
            nw.m_128365_("ship", (Tag)shipnbt);
        }
    }
}

