/*
 * Decompiled with CFR 0.152.
 */
package slimeattack07.naval_warfare.objects.items;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.PacketDistributor;
import slimeattack07.naval_warfare.NavalWarfare;
import slimeattack07.naval_warfare.network.NavalNetwork;
import slimeattack07.naval_warfare.network.message.BattleLogMessage;
import slimeattack07.naval_warfare.objects.blocks.BattleViewer;
import slimeattack07.naval_warfare.tileentity.BattleViewerTE;
import slimeattack07.naval_warfare.util.NWBasicMethods;
import slimeattack07.naval_warfare.util.helpers.NBTHelper;
import slimeattack07.naval_warfare.util.helpers.ShipSaveHelper;

public class BattleLog
extends Item {
    public BattleLog() {
        super(new Item.Properties().m_41491_(NavalWarfare.NAVAL_WARFARE).m_41487_(1));
    }

    public int getItemStackLimit(ItemStack stack) {
        return 1;
    }

    public void m_7373_(ItemStack stack, Level level, List<Component> tooltip, TooltipFlag flagIn) {
        this.prepare(stack);
        CompoundTag nbt = stack.m_41784_();
        CompoundTag nw = nbt.m_128469_("naval_warfare");
        if (nw.m_128456_()) {
            tooltip.add((Component)NWBasicMethods.createGrayText("message.naval_warfare.battle_log.no_log"));
        } else {
            tooltip.add((Component)NWBasicMethods.createGrayText("message.naval_warfare.battle_log.right_click"));
        }
        tooltip.add((Component)NWBasicMethods.createGrayText("message.naval_warfare.battle_log.shift_right_click"));
        super.m_7373_(stack, level, tooltip, flagIn);
    }

    private void prepare(ItemStack stack) {
        CompoundTag nbt = stack.m_41784_();
        if (!nbt.m_128441_("naval_warfare")) {
            CompoundTag nw = new CompoundTag();
            nbt.m_128365_("naval_warfare", (Tag)nw);
        }
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player playerIn, InteractionHand handIn) {
        ItemStack stack = playerIn.m_21120_(handIn);
        if (level.m_5776_() || !(playerIn instanceof ServerPlayer)) {
            return InteractionResultHolder.m_19090_((Object)stack);
        }
        boolean load = playerIn.m_6047_();
        CompoundTag nbt = this.getLog(stack);
        nbt.m_128359_("info", stack.m_41786_().getString());
        NavalNetwork.CHANNEL.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)playerIn), (Object)new BattleLogMessage(nbt, load));
        return InteractionResultHolder.m_19090_((Object)stack);
    }

    public InteractionResult m_6225_(UseOnContext context) {
        Level level = context.m_43725_();
        if (level.m_5776_()) {
            return InteractionResult.SUCCESS;
        }
        BlockPos pos = context.m_8083_();
        BlockEntity tile = level.m_7702_(pos);
        ItemStack stack = context.m_43722_();
        Player player = context.m_43723_();
        if (tile instanceof BattleViewerTE) {
            BattleViewerTE te = (BattleViewerTE)tile;
            CompoundTag log = this.getLog(stack);
            if (!this.validateLog(log)) {
                NWBasicMethods.messagePlayerActionbar(player, "message.naval_warfare.battle_log.load_fail");
                return InteractionResult.SUCCESS;
            }
            ListTag actions = log.m_128437_("actions", 10);
            te.setActions(actions);
            BattleViewer viewer = (BattleViewer)te.m_58900_().m_60734_();
            boolean spawned = viewer.spawnBoards(level, player, te, log.m_128451_("own_size"), log.m_128451_("opp_size"));
            if (spawned) {
                viewer.spawnShips(level, this.getDir(log, false), pos, this.getShips(log, false), viewer.getFacing(level.m_8055_(pos)), false);
                viewer.spawnShips(level, this.getDir(log, true), pos, this.getShips(log, true), viewer.getFacing(level.m_8055_(pos)), true);
                te.uuid = player == null ? null : player.m_142081_();
                te.playing = true;
                NWBasicMethods.messagePlayerActionbar(player, "message.naval_warfare.battle_log.load_success");
            }
        }
        return InteractionResult.SUCCESS;
    }

    private Direction getDir(CompoundTag log, boolean opponent) {
        return opponent ? Direction.valueOf((String)log.m_128461_("opp_dir").toUpperCase()) : Direction.valueOf((String)log.m_128461_("own_dir").toUpperCase());
    }

    private ArrayList<ShipSaveHelper> getShips(CompoundTag log, boolean opponent) {
        ArrayList<ShipSaveHelper> ships = new ArrayList<ShipSaveHelper>();
        ListTag list = opponent ? log.m_128437_("opp_ships", 10) : log.m_128437_("own_ships", 10);
        for (Tag tag : list) {
            CompoundTag ctag = (CompoundTag)tag;
            ShipSaveHelper ssh = NBTHelper.readSSH(ctag);
            if (ssh == null) continue;
            ships.add(ssh);
        }
        return ships;
    }

    private boolean validateLog(CompoundTag log) {
        if (log != null && !log.m_128456_()) {
            return log.m_128441_("own_size") && log.m_128441_("opp_size") && log.m_128441_("own_ships") && log.m_128441_("opp_ships") && log.m_128441_("actions");
        }
        return false;
    }

    public CompoundTag getLog(ItemStack stack) {
        if (stack.m_41720_() instanceof BattleLog) {
            this.prepare(stack);
            CompoundTag nbt = stack.m_41784_();
            CompoundTag nw = nbt.m_128469_("naval_warfare");
            return nw.m_128469_("log");
        }
        return null;
    }

    public void setLog(ItemStack stack, CompoundTag log) {
        if (stack.m_41720_() instanceof BattleLog) {
            this.prepare(stack);
            this.setName(stack, log.m_128461_("info"));
            log.m_128473_("info");
            CompoundTag nbt = stack.m_41784_();
            CompoundTag nw = nbt.m_128469_("naval_warfare");
            nw.m_128473_("log");
            nw.m_128365_("log", (Tag)log);
        }
    }

    public void setName(ItemStack stack, String name) {
        stack.m_41714_((Component)new TextComponent(name));
    }
}

