/*
 * Decompiled with CFR 0.152.
 */
package slimeattack07.naval_warfare.objects.items;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import slimeattack07.naval_warfare.NavalWarfare;
import slimeattack07.naval_warfare.objects.blocks.BoardRedirect;
import slimeattack07.naval_warfare.objects.blocks.GameController;
import slimeattack07.naval_warfare.objects.blocks.ShipBlock;
import slimeattack07.naval_warfare.util.InteractorMode;
import slimeattack07.naval_warfare.util.InteractorType;
import slimeattack07.naval_warfare.util.NWBasicMethods;

public class GameInteractor
extends Item {
    public final InteractorType type;

    public GameInteractor(InteractorType type) {
        super(new Item.Properties().m_41491_(NavalWarfare.NAVAL_WARFARE).m_41487_(1));
        this.type = type;
    }

    public InteractorType getType() {
        return this.type;
    }

    public InteractionResult m_6225_(UseOnContext context) {
        Level level = context.m_43725_();
        if (level.m_5776_()) {
            return InteractionResult.SUCCESS;
        }
        BlockPos pos = context.m_8083_();
        BlockState state = level.m_8055_(pos);
        ItemStack stack = context.m_43722_();
        Player player = context.m_43723_();
        if (((GameInteractor)stack.m_41720_()).getType().equals((Object)InteractorType.DUMMY)) {
            player = null;
        }
        if (state.m_60734_() instanceof GameController) {
            GameController controller = (GameController)state.m_60734_();
            controller.handleInteraction(state, level, pos, player, stack);
            return InteractionResult.SUCCESS;
        }
        if (state.m_60734_() instanceof ShipBlock) {
            pos = pos.m_7495_();
            state = level.m_8055_(pos);
        }
        if (state.m_60734_() instanceof BoardRedirect) {
            BoardRedirect board = (BoardRedirect)state.m_60734_();
            board.handleInteraction(state, level, pos, player, stack, pos);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.SUCCESS;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player playerIn, InteractionHand handIn) {
        ItemStack stack = playerIn.m_21120_(handIn);
        if (level.m_5776_()) {
            return InteractionResultHolder.m_19090_((Object)stack);
        }
        boolean backwards = playerIn == null ? false : playerIn.m_6047_();
        this.cycleMode(stack, backwards);
        NWBasicMethods.messagePlayerActionbarBack(playerIn, "descriptions.naval_warfare.tool_mode", ": " + this.getMode(stack).getName());
        return InteractionResultHolder.m_19090_((Object)stack);
    }

    public void m_7373_(ItemStack stack, Level level, List<Component> tooltip, TooltipFlag flagIn) {
        this.prepare(stack);
        CompoundTag nbt = stack.m_41784_();
        CompoundTag nw = nbt.m_128469_("naval_warfare");
        tooltip.add((Component)NWBasicMethods.createGrayText("descriptions.naval_warfare.tool_mode", ": " + InteractorMode.valueOf(nw.m_128461_("mode")).getName()));
        super.m_7373_(stack, level, tooltip, flagIn);
    }

    private void prepare(ItemStack stack) {
        CompoundTag nbt = stack.m_41784_();
        if (!nbt.m_128441_("naval_warfare")) {
            CompoundTag nw = new CompoundTag();
            nw.m_128359_("mode", InteractorMode.NEW_SHIP_CONFIG.toString());
            nbt.m_128365_("naval_warfare", (Tag)nw);
            stack.m_41751_(nbt);
        }
    }

    public InteractorMode getMode(ItemStack stack) {
        if (stack.m_41720_() instanceof GameInteractor) {
            this.prepare(stack);
            CompoundTag nbt = stack.m_41784_();
            CompoundTag nw = nbt.m_128469_("naval_warfare");
            return InteractorMode.valueOf(nw.m_128461_("mode"));
        }
        return InteractorMode.NEW_SHIP_CONFIG;
    }

    private void cycleMode(ItemStack stack, boolean backwards) {
        if (stack.m_41720_() instanceof GameInteractor) {
            this.prepare(stack);
            CompoundTag nbt = stack.m_41784_();
            CompoundTag nw = nbt.m_128469_("naval_warfare");
            String old_mode = nw.m_128461_("mode");
            InteractorMode mode = InteractorMode.valueOf(old_mode);
            if (mode != null) {
                mode = mode.cycle(backwards);
            }
            nw.m_128473_("mode");
            nw.m_128359_("mode", mode.toString());
        }
    }

    public void setMode(ItemStack stack, InteractorMode mode) {
        if (stack.m_41720_() instanceof GameInteractor) {
            this.prepare(stack);
            CompoundTag nbt = stack.m_41784_();
            CompoundTag nw = nbt.m_128469_("naval_warfare");
            nw.m_128473_("mode");
            nw.m_128359_("mode", mode.toString());
        }
    }
}

