/*
 * Decompiled with CFR 0.152.
 */
package slimeattack07.naval_warfare.objects.items;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.registries.ForgeRegistries;
import slimeattack07.naval_warfare.NavalWarfare;
import slimeattack07.naval_warfare.config.NavalWarfareConfig;
import slimeattack07.naval_warfare.objects.blocks.GameController;
import slimeattack07.naval_warfare.util.NWBasicMethods;
import slimeattack07.naval_warfare.util.helpers.ShipSaveHelper;

public class ShipConfiguration
extends Item {
    public static int MAX_HEALTH_ALLOWED = (Integer)NavalWarfareConfig.max_fleet_hp.get();

    public ShipConfiguration() {
        super(new Item.Properties().m_41491_(NavalWarfare.NAVAL_WARFARE).m_41487_(1));
    }

    public InteractionResult m_6225_(UseOnContext context) {
        Level level = context.m_43725_();
        if (level.m_5776_()) {
            return InteractionResult.SUCCESS;
        }
        BlockPos pos = context.m_8083_();
        BlockState state = level.m_8055_(pos);
        if (state.m_60734_() instanceof GameController) {
            GameController controller = (GameController)state.m_60734_();
            controller.handleShipConfig(state, level, pos, context.m_43723_(), context.m_43722_());
        }
        return InteractionResult.SUCCESS;
    }

    public void m_7373_(ItemStack stack, Level level, List<Component> tooltip, TooltipFlag flagIn) {
        this.prepare(stack);
        CompoundTag nbt = stack.m_41784_();
        CompoundTag nw = nbt.m_128469_("naval_warfare");
        tooltip.add((Component)NWBasicMethods.createGrayText("descriptions.naval_warfare.ship_config_name", ": " + stack.m_41611_().getString().replace("[", "").replace("]", "")));
        tooltip.add((Component)NWBasicMethods.createGrayText("descriptions.naval_warfare.ship_config_board_size", ": " + nw.m_128451_("board_size")));
        tooltip.add((Component)NWBasicMethods.createGrayText("descriptions.naval_warfare.ship_config_hp", ": " + nw.m_128451_("hp")));
        tooltip.add((Component)NWBasicMethods.createGrayText("descriptions.naval_warfare.ship_config_ships", ": "));
        for (String name : this.getShipNames(this.readShips(nw))) {
            tooltip.add((Component)NWBasicMethods.createGreenText(name));
        }
        super.m_7373_(stack, level, tooltip, flagIn);
    }

    public boolean prepare(ItemStack stack) {
        if (stack.m_41720_() instanceof ShipConfiguration) {
            CompoundTag nbt = stack.m_41784_();
            if (!nbt.m_128441_("naval_warfare")) {
                nbt.m_128365_("naval_warfare", (Tag)this.saveData(-1, new ArrayList<ShipSaveHelper>(), Direction.NORTH));
                stack.m_41751_(nbt);
            }
            return true;
        }
        return false;
    }

    public ArrayList<String> getShipNames(ArrayList<ShipSaveHelper> sshl) {
        ArrayList<String> names = new ArrayList<String>();
        for (ShipSaveHelper ssh : sshl) {
            Block block = (Block)ForgeRegistries.BLOCKS.getValue(ssh.getShip());
            if (block == null) continue;
            names.add(NWBasicMethods.getTranslation(block));
        }
        return names;
    }

    public ArrayList<ShipSaveHelper> readShips(CompoundTag nbt) {
        ListTag ships = nbt.m_128437_("ships", 10);
        ArrayList<ShipSaveHelper> ssh = new ArrayList<ShipSaveHelper>();
        for (Tag inbt : ships) {
            CompoundTag ship = (CompoundTag)inbt;
            ssh.add(new ShipSaveHelper(ship.m_128461_("ship"), ship.m_128451_("pos"), ship.m_128461_("facing"), ship.m_128451_("hp")));
        }
        return ssh;
    }

    public boolean isValid(ItemStack stack) {
        if (!this.prepare(stack)) {
            return false;
        }
        CompoundTag nbt = stack.m_41784_();
        CompoundTag nw = nbt.m_128469_("naval_warfare");
        return nw.m_128451_("board_size") >= 0;
    }

    public void saveShipConfiguration(ItemStack stack, int board_size, ArrayList<ShipSaveHelper> ships, Direction dir) {
        if (this.prepare(stack)) {
            stack.m_41751_(this.saveData(board_size, ships, dir));
        }
    }

    private CompoundTag saveData(int board_size, ArrayList<ShipSaveHelper> ships, Direction facing) {
        CompoundTag nbt = new CompoundTag();
        CompoundTag nw = new CompoundTag();
        ListTag ship_list = new ListTag();
        nw.m_128405_("board_size", board_size);
        int hp = ships.isEmpty() ? -1 : 0;
        for (ShipSaveHelper ssh : ships) {
            CompoundTag ship = new CompoundTag();
            ship.m_128359_("ship", ssh.getShip().toString());
            ship.m_128405_("pos", ssh.getPos());
            ship.m_128359_("facing", ssh.getDir().toString().toUpperCase());
            ship.m_128405_("hp", ssh.getHP());
            ship_list.add((Object)ship);
            hp += ssh.getHP();
        }
        nw.m_128405_("hp", hp);
        nw.m_128365_("ships", (Tag)ship_list);
        nw.m_128359_("facing", facing.name().toUpperCase());
        nbt.m_128365_("naval_warfare", (Tag)nw);
        return nbt;
    }
}

